/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.test;

import com.android.internal.telephony.ATParseEx;
import com.android.internal.telephony.DriverCall;

class CallInfo {
    boolean isMT;
    State state;
    boolean isMpty;
    String number;
    int TOA;

    CallInfo(boolean isMT, State state, boolean isMpty, String number) {
        this.isMT = isMT;
        this.state = state;
        this.isMpty = isMpty;
        this.number = number;
        this.TOA = number.length() > 0 && number.charAt(0) == '+' ? 145 : 129;
    }

    static CallInfo createOutgoingCall(String number) {
        return new CallInfo(false, State.DIALING, false, number);
    }

    static CallInfo createIncomingCall(String number) {
        return new CallInfo(true, State.INCOMING, false, number);
    }

    String toCLCCLine(int index) {
        return "+CLCC: " + index + "," + (this.isMT ? "1" : "0") + "," + this.state.value() + ",0," + (this.isMpty ? "1" : "0") + ",\"" + this.number + "\"," + this.TOA;
    }

    DriverCall toDriverCall(int index) {
        DriverCall ret = new DriverCall();
        ret.index = index;
        ret.isMT = this.isMT;
        try {
            ret.state = DriverCall.stateFromCLCC(this.state.value());
        }
        catch (ATParseEx ex) {
            throw new RuntimeException("should never happen", ex);
        }
        ret.isMpty = this.isMpty;
        ret.number = this.number;
        ret.TOA = this.TOA;
        ret.isVoice = true;
        ret.als = 0;
        return ret;
    }

    boolean isActiveOrHeld() {
        return this.state == State.ACTIVE || this.state == State.HOLDING;
    }

    boolean isConnecting() {
        return this.state == State.DIALING || this.state == State.ALERTING;
    }

    boolean isRinging() {
        return this.state == State.INCOMING || this.state == State.WAITING;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        ACTIVE(0),
        HOLDING(1),
        DIALING(2),
        ALERTING(3),
        INCOMING(4),
        WAITING(5);

        private final int value;

        private State(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

