/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.Message;
import android.util.Log;
import android.util.Patterns;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.gsm.ApnSetting;
import com.android.internal.telephony.gsm.GSMPhone;

public class GsmDataConnection
extends DataConnection {
    private static final String LOG_TAG = "GSM";
    private static final int PDP_FAIL_OPERATOR_BARRED = 8;
    private static final int PDP_FAIL_INSUFFICIENT_RESOURCES = 26;
    private static final int PDP_FAIL_MISSING_UKNOWN_APN = 27;
    private static final int PDP_FAIL_UNKNOWN_PDP_ADDRESS_TYPE = 28;
    private static final int PDP_FAIL_USER_AUTHENTICATION = 29;
    private static final int PDP_FAIL_ACTIVATION_REJECT_GGSN = 30;
    private static final int PDP_FAIL_ACTIVATION_REJECT_UNSPECIFIED = 31;
    private static final int PDP_FAIL_SERVICE_OPTION_NOT_SUPPORTED = 32;
    private static final int PDP_FAIL_SERVICE_OPTION_NOT_SUBSCRIBED = 33;
    private static final int PDP_FAIL_SERVICE_OPTION_OUT_OF_ORDER = 34;
    private static final int PDP_FAIL_NSAPI_IN_USE = 35;
    private static final int PDP_FAIL_PROTOCOL_ERRORS = 111;
    private static final int PDP_FAIL_ERROR_UNSPECIFIED = 65535;
    private static final int PDP_FAIL_REGISTRATION_FAIL = -1;
    private static final int PDP_FAIL_GPRS_REGISTRATION_FAIL = -2;
    private ApnSetting apn;

    private GsmDataConnection(GSMPhone phone, String name) {
        super(phone, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GsmDataConnection makeDataConnection(GSMPhone phone) {
        Object object = mCountLock;
        synchronized (object) {
        }
        GsmDataConnection gsmDc = new GsmDataConnection(phone, "GsmDataConnection-" + ++mCount);
        gsmDc.start();
        gsmDc.log("Made " + gsmDc.getName());
        return gsmDc;
    }

    protected void onConnect(DataConnection.ConnectionParams cp) {
        this.apn = cp.apn;
        this.log("Connecting to carrier: '" + this.apn.carrier + "' APN: '" + this.apn.apn + "' proxy: '" + this.apn.proxy + "' port: '" + this.apn.port);
        this.setHttpProxy(this.apn.proxy, this.apn.port);
        this.createTime = -1L;
        this.lastFailTime = -1L;
        this.lastFailCause = DataConnection.FailCause.NONE;
        Message msg = this.obtainMessage(3, cp);
        msg.obj = cp;
        int authType = this.apn.authType;
        if (authType == -1) {
            authType = this.apn.user != null ? 3 : 0;
        }
        String protocol = this.phone.getServiceState().getRoaming() ? this.apn.roamingProtocol : this.apn.protocol;
        this.phone.mCM.setupDataCall(Integer.toString(1), Integer.toString(0), this.apn.apn, this.apn.user, this.apn.password, Integer.toString(authType), protocol, msg);
    }

    protected void clearSettings() {
        super.clearSettings();
        this.apn = null;
    }

    public String toString() {
        return "State=" + this.getCurrentState().getName() + " Apn=" + this.apn + " create=" + this.createTime + " lastFail=" + this.lastFailTime + " lastFailCause=" + (Object)((Object)this.lastFailCause);
    }

    protected DataConnection.FailCause getFailCauseFromRequest(int rilCause) {
        DataConnection.FailCause cause;
        switch (rilCause) {
            case 8: {
                cause = DataConnection.FailCause.OPERATOR_BARRED;
                break;
            }
            case 26: {
                cause = DataConnection.FailCause.INSUFFICIENT_RESOURCES;
                break;
            }
            case 27: {
                cause = DataConnection.FailCause.MISSING_UNKNOWN_APN;
                break;
            }
            case 28: {
                cause = DataConnection.FailCause.UNKNOWN_PDP_ADDRESS;
                break;
            }
            case 29: {
                cause = DataConnection.FailCause.USER_AUTHENTICATION;
                break;
            }
            case 30: {
                cause = DataConnection.FailCause.ACTIVATION_REJECT_GGSN;
                break;
            }
            case 31: {
                cause = DataConnection.FailCause.ACTIVATION_REJECT_UNSPECIFIED;
                break;
            }
            case 34: {
                cause = DataConnection.FailCause.SERVICE_OPTION_OUT_OF_ORDER;
                break;
            }
            case 32: {
                cause = DataConnection.FailCause.SERVICE_OPTION_NOT_SUPPORTED;
                break;
            }
            case 33: {
                cause = DataConnection.FailCause.SERVICE_OPTION_NOT_SUBSCRIBED;
                break;
            }
            case 35: {
                cause = DataConnection.FailCause.NSAPI_IN_USE;
                break;
            }
            case 111: {
                cause = DataConnection.FailCause.PROTOCOL_ERRORS;
                break;
            }
            case 65535: {
                cause = DataConnection.FailCause.UNKNOWN;
                break;
            }
            case -1: {
                cause = DataConnection.FailCause.REGISTRATION_FAIL;
                break;
            }
            case -2: {
                cause = DataConnection.FailCause.GPRS_REGISTRATION_FAIL;
                break;
            }
            default: {
                cause = DataConnection.FailCause.UNKNOWN;
            }
        }
        return cause;
    }

    protected boolean isDnsOk(String[] domainNameServers) {
        return !"0.0.0.0".equals(this.dnsServers[0]) || !"0.0.0.0".equals(this.dnsServers[1]) || ((GSMPhone)this.phone).isDnsCheckDisabled() || this.apn.types[0].equals("mms") && this.isIpAddress(this.apn.mmsProxy);
    }

    protected void log(String s) {
        Log.d(LOG_TAG, "[" + this.getName() + "] " + s);
    }

    public ApnSetting getApn() {
        return this.apn;
    }

    private void setHttpProxy(String httpProxy, String httpPort) {
        if (httpProxy == null || httpProxy.length() == 0) {
            this.phone.setSystemProperty("net.gprs.http-proxy", null);
            return;
        }
        if (httpPort == null || httpPort.length() == 0) {
            httpPort = "8080";
        }
        this.phone.setSystemProperty("net.gprs.http-proxy", "http://" + httpProxy + ":" + httpPort + "/");
    }

    private boolean isIpAddress(String address) {
        if (address == null) {
            return false;
        }
        return Patterns.IP_ADDRESS.matcher(this.apn.mmsProxy).matches();
    }
}

