/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.database.AbstractCursor;
import android.database.CursorWindow;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArrayListCursor
extends AbstractCursor {
    private String[] mColumnNames;
    private ArrayList<Object>[] mRows;

    public ArrayListCursor(String[] columnNames, ArrayList<ArrayList> rows) {
        int colCount = columnNames.length;
        boolean foundID = false;
        for (int i = 0; i < colCount; ++i) {
            if (columnNames[i].compareToIgnoreCase("_id") != 0) continue;
            this.mColumnNames = columnNames;
            foundID = true;
            break;
        }
        if (!foundID) {
            this.mColumnNames = new String[colCount + 1];
            System.arraycopy(columnNames, 0, this.mColumnNames, 0, columnNames.length);
            this.mColumnNames[colCount] = "_id";
        }
        int rowCount = rows.size();
        this.mRows = new ArrayList[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            this.mRows[i] = rows.get(i);
            if (foundID) continue;
            this.mRows[i].add(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void fillWindow(int position, CursorWindow window) {
        if (position < 0) return;
        if (position > this.getCount()) {
            return;
        }
        window.acquireReference();
        try {
            try {
                int oldpos = this.mPos;
                this.mPos = position - 1;
                window.clear();
                window.setStartPosition(position);
                int columnNum = this.getColumnCount();
                window.setNumColumns(columnNum);
                block4: while (this.moveToNext() && window.allocRow()) {
                    for (int i = 0; i < columnNum; ++i) {
                        Object data = this.mRows[this.mPos].get(i);
                        if (data != null) {
                            Object field;
                            if (data instanceof byte[]) {
                                field = (byte[])data;
                                if (window.putBlob((byte[])field, this.mPos, i)) continue;
                                window.freeLastRow();
                                continue block4;
                            }
                            field = data.toString();
                            if (window.putString((String)field, this.mPos, i)) continue;
                            window.freeLastRow();
                            continue block4;
                        }
                        if (window.putNull(this.mPos, i)) continue;
                        window.freeLastRow();
                        continue block4;
                    }
                }
                this.mPos = oldpos;
            }
            catch (IllegalStateException illegalStateException) {
                Object var9_10 = null;
                window.releaseReference();
                return;
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            window.releaseReference();
            throw throwable;
        }
        window.releaseReference();
    }

    @Override
    public int getCount() {
        return this.mRows.length;
    }

    @Override
    public String[] getColumnNames() {
        return this.mColumnNames;
    }

    @Override
    public byte[] getBlob(int columnIndex) {
        return (byte[])this.mRows[this.mPos].get(columnIndex);
    }

    @Override
    public String getString(int columnIndex) {
        Object cell = this.mRows[this.mPos].get(columnIndex);
        return cell == null ? null : cell.toString();
    }

    @Override
    public short getShort(int columnIndex) {
        Number num = (Number)this.mRows[this.mPos].get(columnIndex);
        return num.shortValue();
    }

    @Override
    public int getInt(int columnIndex) {
        Number num = (Number)this.mRows[this.mPos].get(columnIndex);
        return num.intValue();
    }

    @Override
    public long getLong(int columnIndex) {
        Number num = (Number)this.mRows[this.mPos].get(columnIndex);
        return num.longValue();
    }

    @Override
    public float getFloat(int columnIndex) {
        Number num = (Number)this.mRows[this.mPos].get(columnIndex);
        return num.floatValue();
    }

    @Override
    public double getDouble(int columnIndex) {
        Number num = (Number)this.mRows[this.mPos].get(columnIndex);
        return num.doubleValue();
    }

    @Override
    public boolean isNull(int columnIndex) {
        return this.mRows[this.mPos].get(columnIndex) == null;
    }
}

