/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.nfc;

import android.nfc.IP2pInitiator;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.nfc.P2pDevice;
import java.io.IOException;

public class P2pInitiator
extends P2pDevice {
    private static final String TAG = "P2pInitiator";
    private final IP2pInitiator mService;

    P2pInitiator(IP2pInitiator service, int handle) {
        this.mService = service;
        this.mHandle = handle;
    }

    public byte[] receive() throws IOException {
        try {
            byte[] result = this.mService.receive(this.mHandle);
            if (result == null) {
                throw new IOException("Tag has been lost");
            }
            return result;
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in receive(): ", e);
            return null;
        }
    }

    public void send(byte[] data) throws IOException {
        try {
            boolean isSuccess = this.mService.send(this.mHandle, data);
            if (!isSuccess) {
                throw new IOException("Tag has been lost");
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in send(): ", e);
        }
    }

    public byte[] getGeneralBytes() {
        try {
            return this.mService.getGeneralBytes(this.mHandle);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in getGeneralBytes(): ", e);
            return null;
        }
    }

    public int getMode() {
        return 1;
    }
}

