/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pool;
import android.util.Poolable;
import android.util.PoolableManager;
import android.util.Pools;
import android.util.SparseArray;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;

@RemoteViews.RemoteView
public class RelativeLayout
extends ViewGroup {
    private static final String LOG_TAG = "RelativeLayout";
    private static final boolean DEBUG_GRAPH = false;
    public static final int TRUE = -1;
    public static final int LEFT_OF = 0;
    public static final int RIGHT_OF = 1;
    public static final int ABOVE = 2;
    public static final int BELOW = 3;
    public static final int ALIGN_BASELINE = 4;
    public static final int ALIGN_LEFT = 5;
    public static final int ALIGN_TOP = 6;
    public static final int ALIGN_RIGHT = 7;
    public static final int ALIGN_BOTTOM = 8;
    public static final int ALIGN_PARENT_LEFT = 9;
    public static final int ALIGN_PARENT_TOP = 10;
    public static final int ALIGN_PARENT_RIGHT = 11;
    public static final int ALIGN_PARENT_BOTTOM = 12;
    public static final int CENTER_IN_PARENT = 13;
    public static final int CENTER_HORIZONTAL = 14;
    public static final int CENTER_VERTICAL = 15;
    private static final int VERB_COUNT = 16;
    private View mBaselineView = null;
    private boolean mHasBaselineAlignedChild;
    private int mGravity = 51;
    private final Rect mContentBounds = new Rect();
    private final Rect mSelfBounds = new Rect();
    private int mIgnoreGravity;
    private SortedSet<View> mTopToBottomLeftToRightSet = null;
    private boolean mDirtyHierarchy;
    private View[] mSortedHorizontalChildren = new View[0];
    private View[] mSortedVerticalChildren = new View[0];
    private final DependencyGraph mGraph = new DependencyGraph();

    public RelativeLayout(Context context) {
        super(context);
    }

    public RelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initFromAttributes(context, attrs);
    }

    public RelativeLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initFromAttributes(context, attrs);
    }

    private void initFromAttributes(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RelativeLayout);
        this.mIgnoreGravity = a.getResourceId(1, -1);
        this.mGravity = a.getInt(0, this.mGravity);
        a.recycle();
    }

    @RemotableViewMethod
    public void setIgnoreGravity(int viewId) {
        this.mIgnoreGravity = viewId;
    }

    @RemotableViewMethod
    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if ((gravity & 7) == 0) {
                gravity |= 3;
            }
            if ((gravity & 0x70) == 0) {
                gravity |= 0x30;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    public void setHorizontalGravity(int horizontalGravity) {
        int gravity = horizontalGravity & 7;
        if ((this.mGravity & 7) != gravity) {
            this.mGravity = this.mGravity & 0xFFFFFFF8 | gravity;
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    public void setVerticalGravity(int verticalGravity) {
        int gravity = verticalGravity & 0x70;
        if ((this.mGravity & 0x70) != gravity) {
            this.mGravity = this.mGravity & 0xFFFFFF8F | gravity;
            this.requestLayout();
        }
    }

    public int getBaseline() {
        return this.mBaselineView != null ? this.mBaselineView.getBaseline() : super.getBaseline();
    }

    public void requestLayout() {
        super.requestLayout();
        this.mDirtyHierarchy = true;
    }

    private void sortChildren() {
        int count = this.getChildCount();
        if (this.mSortedVerticalChildren.length != count) {
            this.mSortedVerticalChildren = new View[count];
        }
        if (this.mSortedHorizontalChildren.length != count) {
            this.mSortedHorizontalChildren = new View[count];
        }
        DependencyGraph graph = this.mGraph;
        graph.clear();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            graph.add(child);
        }
        graph.getSortedViews(this.mSortedVerticalChildren, 2, 3, 4, 6, 8);
        graph.getSortedViews(this.mSortedHorizontalChildren, 0, 1, 5, 7);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int[] rules;
        int i;
        LayoutParams params;
        View child2;
        if (this.mDirtyHierarchy) {
            this.mDirtyHierarchy = false;
            this.sortChildren();
        }
        int myWidth = -1;
        int myHeight = -1;
        int width = 0;
        int height = 0;
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        if (widthMode != 0) {
            myWidth = widthSize;
        }
        if (heightMode != 0) {
            myHeight = heightSize;
        }
        if (widthMode == 0x40000000) {
            width = myWidth;
        }
        if (heightMode == 0x40000000) {
            height = myHeight;
        }
        this.mHasBaselineAlignedChild = false;
        View ignore = null;
        int gravity = this.mGravity & 7;
        boolean horizontalGravity = gravity != 3 && gravity != 0;
        gravity = this.mGravity & 0x70;
        boolean verticalGravity = gravity != 48 && gravity != 0;
        int left = Integer.MAX_VALUE;
        int top = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        int bottom = Integer.MIN_VALUE;
        boolean offsetHorizontalAxis = false;
        boolean offsetVerticalAxis = false;
        if ((horizontalGravity || verticalGravity) && this.mIgnoreGravity != -1) {
            ignore = this.findViewById(this.mIgnoreGravity);
        }
        boolean isWrapContentWidth = widthMode != 0x40000000;
        boolean isWrapContentHeight = heightMode != 0x40000000;
        for (View child2 : this.mSortedHorizontalChildren) {
            if (child2.getVisibility() == 8) continue;
            params = (LayoutParams)child2.getLayoutParams();
            this.applyHorizontalSizeRules(params, myWidth);
            this.measureChildHorizontal(child2, params, myWidth, myHeight);
            if (!this.positionChildHorizontal(child2, params, myWidth, isWrapContentWidth)) continue;
            offsetHorizontalAxis = true;
        }
        View[] views = this.mSortedVerticalChildren;
        int count = views.length;
        for (i = 0; i < count; ++i) {
            child2 = views[i];
            if (child2.getVisibility() == 8) continue;
            params = (LayoutParams)child2.getLayoutParams();
            this.applyVerticalSizeRules(params, myHeight);
            this.measureChild(child2, params, myWidth, myHeight);
            if (this.positionChildVertical(child2, params, myHeight, isWrapContentHeight)) {
                offsetVerticalAxis = true;
            }
            if (isWrapContentWidth) {
                width = Math.max(width, params.mRight);
            }
            if (isWrapContentHeight) {
                height = Math.max(height, params.mBottom);
            }
            if (child2 != ignore || verticalGravity) {
                left = Math.min(left, params.mLeft - params.leftMargin);
                top = Math.min(top, params.mTop - params.topMargin);
            }
            if (child2 == ignore && !horizontalGravity) continue;
            right = Math.max(right, params.mRight + params.rightMargin);
            bottom = Math.max(bottom, params.mBottom + params.bottomMargin);
        }
        if (this.mHasBaselineAlignedChild) {
            for (i = 0; i < count; ++i) {
                child2 = this.getChildAt(i);
                if (child2.getVisibility() == 8) continue;
                params = (LayoutParams)child2.getLayoutParams();
                this.alignBaseline(child2, params);
                if (child2 != ignore || verticalGravity) {
                    left = Math.min(left, params.mLeft - params.leftMargin);
                    top = Math.min(top, params.mTop - params.topMargin);
                }
                if (child2 == ignore && !horizontalGravity) continue;
                right = Math.max(right, params.mRight + params.rightMargin);
                bottom = Math.max(bottom, params.mBottom + params.bottomMargin);
            }
        }
        if (isWrapContentWidth) {
            width += this.mPaddingRight;
            if (this.mLayoutParams.width >= 0) {
                width = Math.max(width, this.mLayoutParams.width);
            }
            width = Math.max(width, this.getSuggestedMinimumWidth());
            width = RelativeLayout.resolveSize(width, widthMeasureSpec);
            if (offsetHorizontalAxis) {
                for (i = 0; i < count; ++i) {
                    child2 = this.getChildAt(i);
                    if (child2.getVisibility() == 8) continue;
                    params = (LayoutParams)child2.getLayoutParams();
                    rules = params.getRules();
                    if (rules[13] != 0 || rules[14] != 0) {
                        this.centerHorizontal(child2, params, width);
                        continue;
                    }
                    if (rules[11] == 0) continue;
                    int childWidth = child2.getMeasuredWidth();
                    params.mLeft = width - this.mPaddingRight - childWidth;
                    params.mRight = params.mLeft + childWidth;
                }
            }
        }
        if (isWrapContentHeight) {
            height += this.mPaddingBottom;
            if (this.mLayoutParams.height >= 0) {
                height = Math.max(height, this.mLayoutParams.height);
            }
            height = Math.max(height, this.getSuggestedMinimumHeight());
            height = RelativeLayout.resolveSize(height, heightMeasureSpec);
            if (offsetVerticalAxis) {
                for (i = 0; i < count; ++i) {
                    child2 = this.getChildAt(i);
                    if (child2.getVisibility() == 8) continue;
                    params = (LayoutParams)child2.getLayoutParams();
                    rules = params.getRules();
                    if (rules[13] != 0 || rules[15] != 0) {
                        this.centerVertical(child2, params, height);
                        continue;
                    }
                    if (rules[12] == 0) continue;
                    int childHeight = child2.getMeasuredHeight();
                    params.mTop = height - this.mPaddingBottom - childHeight;
                    params.mBottom = params.mTop + childHeight;
                }
            }
        }
        if (horizontalGravity || verticalGravity) {
            Rect selfBounds = this.mSelfBounds;
            selfBounds.set(this.mPaddingLeft, this.mPaddingTop, width - this.mPaddingRight, height - this.mPaddingBottom);
            Rect contentBounds = this.mContentBounds;
            Gravity.apply(this.mGravity, right - left, bottom - top, selfBounds, contentBounds);
            int horizontalOffset = contentBounds.left - left;
            int verticalOffset = contentBounds.top - top;
            if (horizontalOffset != 0 || verticalOffset != 0) {
                for (int i2 = 0; i2 < count; ++i2) {
                    View child3 = this.getChildAt(i2);
                    if (child3.getVisibility() == 8 || child3 == ignore) continue;
                    LayoutParams params2 = (LayoutParams)child3.getLayoutParams();
                    if (horizontalGravity) {
                        params2.mLeft += horizontalOffset;
                        params2.mRight += horizontalOffset;
                    }
                    if (!verticalGravity) continue;
                    params2.mTop += verticalOffset;
                    params2.mBottom += verticalOffset;
                }
            }
        }
        this.setMeasuredDimension(width, height);
    }

    private void alignBaseline(View child, LayoutParams params) {
        LayoutParams anchorParams;
        int[] rules = params.getRules();
        int anchorBaseline = this.getRelatedViewBaseline(rules, 4);
        if (anchorBaseline != -1 && (anchorParams = this.getRelatedViewParams(rules, 4)) != null) {
            int offset = anchorParams.mTop + anchorBaseline;
            int baseline = child.getBaseline();
            if (baseline != -1) {
                offset -= baseline;
            }
            int height = params.mBottom - params.mTop;
            params.mTop = offset;
            params.mBottom = params.mTop + height;
        }
        if (this.mBaselineView == null) {
            this.mBaselineView = child;
        } else {
            LayoutParams lp = (LayoutParams)this.mBaselineView.getLayoutParams();
            if (params.mTop < lp.mTop || params.mTop == lp.mTop && params.mLeft < lp.mLeft) {
                this.mBaselineView = child;
            }
        }
    }

    private void measureChild(View child, LayoutParams params, int myWidth, int myHeight) {
        int childWidthMeasureSpec = this.getChildMeasureSpec(params.mLeft, params.mRight, params.width, params.leftMargin, params.rightMargin, this.mPaddingLeft, this.mPaddingRight, myWidth);
        int childHeightMeasureSpec = this.getChildMeasureSpec(params.mTop, params.mBottom, params.height, params.topMargin, params.bottomMargin, this.mPaddingTop, this.mPaddingBottom, myHeight);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    private void measureChildHorizontal(View child, LayoutParams params, int myWidth, int myHeight) {
        int childWidthMeasureSpec = this.getChildMeasureSpec(params.mLeft, params.mRight, params.width, params.leftMargin, params.rightMargin, this.mPaddingLeft, this.mPaddingRight, myWidth);
        int childHeightMeasureSpec = params.width == -1 ? View.MeasureSpec.makeMeasureSpec(myHeight, 0x40000000) : View.MeasureSpec.makeMeasureSpec(myHeight, Integer.MIN_VALUE);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    private int getChildMeasureSpec(int childStart, int childEnd, int childSize, int startMargin, int endMargin, int startPadding, int endPadding, int mySize) {
        int childSpecMode = 0;
        int childSpecSize = 0;
        int tempStart = childStart;
        int tempEnd = childEnd;
        if (tempStart < 0) {
            tempStart = startPadding + startMargin;
        }
        if (tempEnd < 0) {
            tempEnd = mySize - endPadding - endMargin;
        }
        int maxAvailable = tempEnd - tempStart;
        if (childStart >= 0 && childEnd >= 0) {
            childSpecMode = 0x40000000;
            childSpecSize = maxAvailable;
        } else if (childSize >= 0) {
            childSpecMode = 0x40000000;
            childSpecSize = maxAvailable >= 0 ? Math.min(maxAvailable, childSize) : childSize;
        } else if (childSize == -1) {
            childSpecMode = 0x40000000;
            childSpecSize = maxAvailable;
        } else if (childSize == -2) {
            if (maxAvailable >= 0) {
                childSpecMode = Integer.MIN_VALUE;
                childSpecSize = maxAvailable;
            } else {
                childSpecMode = 0;
                childSpecSize = 0;
            }
        }
        return View.MeasureSpec.makeMeasureSpec(childSpecSize, childSpecMode);
    }

    private boolean positionChildHorizontal(View child, LayoutParams params, int myWidth, boolean wrapContent) {
        int[] rules = params.getRules();
        if (params.mLeft < 0 && params.mRight >= 0) {
            params.mLeft = params.mRight - child.getMeasuredWidth();
        } else if (params.mLeft >= 0 && params.mRight < 0) {
            params.mRight = params.mLeft + child.getMeasuredWidth();
        } else if (params.mLeft < 0 && params.mRight < 0) {
            if (rules[13] != 0 || rules[14] != 0) {
                if (!wrapContent) {
                    this.centerHorizontal(child, params, myWidth);
                } else {
                    params.mLeft = this.mPaddingLeft + params.leftMargin;
                    params.mRight = params.mLeft + child.getMeasuredWidth();
                }
                return true;
            }
            params.mLeft = this.mPaddingLeft + params.leftMargin;
            params.mRight = params.mLeft + child.getMeasuredWidth();
        }
        return rules[11] != 0;
    }

    private boolean positionChildVertical(View child, LayoutParams params, int myHeight, boolean wrapContent) {
        int[] rules = params.getRules();
        if (params.mTop < 0 && params.mBottom >= 0) {
            params.mTop = params.mBottom - child.getMeasuredHeight();
        } else if (params.mTop >= 0 && params.mBottom < 0) {
            params.mBottom = params.mTop + child.getMeasuredHeight();
        } else if (params.mTop < 0 && params.mBottom < 0) {
            if (rules[13] != 0 || rules[15] != 0) {
                if (!wrapContent) {
                    this.centerVertical(child, params, myHeight);
                } else {
                    params.mTop = this.mPaddingTop + params.topMargin;
                    params.mBottom = params.mTop + child.getMeasuredHeight();
                }
                return true;
            }
            params.mTop = this.mPaddingTop + params.topMargin;
            params.mBottom = params.mTop + child.getMeasuredHeight();
        }
        return rules[12] != 0;
    }

    private void applyHorizontalSizeRules(LayoutParams childParams, int myWidth) {
        int[] rules = childParams.getRules();
        childParams.mLeft = -1;
        childParams.mRight = -1;
        LayoutParams anchorParams = this.getRelatedViewParams(rules, 0);
        if (anchorParams != null) {
            childParams.mRight = anchorParams.mLeft - (anchorParams.leftMargin + childParams.rightMargin);
        } else if (childParams.alignWithParent && rules[0] != 0 && myWidth >= 0) {
            childParams.mRight = myWidth - this.mPaddingRight - childParams.rightMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 1);
        if (anchorParams != null) {
            childParams.mLeft = anchorParams.mRight + (anchorParams.rightMargin + childParams.leftMargin);
        } else if (childParams.alignWithParent && rules[1] != 0) {
            childParams.mLeft = this.mPaddingLeft + childParams.leftMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 5);
        if (anchorParams != null) {
            childParams.mLeft = anchorParams.mLeft + childParams.leftMargin;
        } else if (childParams.alignWithParent && rules[5] != 0) {
            childParams.mLeft = this.mPaddingLeft + childParams.leftMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 7);
        if (anchorParams != null) {
            childParams.mRight = anchorParams.mRight - childParams.rightMargin;
        } else if (childParams.alignWithParent && rules[7] != 0 && myWidth >= 0) {
            childParams.mRight = myWidth - this.mPaddingRight - childParams.rightMargin;
        }
        if (0 != rules[9]) {
            childParams.mLeft = this.mPaddingLeft + childParams.leftMargin;
        }
        if (0 != rules[11] && myWidth >= 0) {
            childParams.mRight = myWidth - this.mPaddingRight - childParams.rightMargin;
        }
    }

    private void applyVerticalSizeRules(LayoutParams childParams, int myHeight) {
        int[] rules = childParams.getRules();
        childParams.mTop = -1;
        childParams.mBottom = -1;
        LayoutParams anchorParams = this.getRelatedViewParams(rules, 2);
        if (anchorParams != null) {
            childParams.mBottom = anchorParams.mTop - (anchorParams.topMargin + childParams.bottomMargin);
        } else if (childParams.alignWithParent && rules[2] != 0 && myHeight >= 0) {
            childParams.mBottom = myHeight - this.mPaddingBottom - childParams.bottomMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 3);
        if (anchorParams != null) {
            childParams.mTop = anchorParams.mBottom + (anchorParams.bottomMargin + childParams.topMargin);
        } else if (childParams.alignWithParent && rules[3] != 0) {
            childParams.mTop = this.mPaddingTop + childParams.topMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 6);
        if (anchorParams != null) {
            childParams.mTop = anchorParams.mTop + childParams.topMargin;
        } else if (childParams.alignWithParent && rules[6] != 0) {
            childParams.mTop = this.mPaddingTop + childParams.topMargin;
        }
        anchorParams = this.getRelatedViewParams(rules, 8);
        if (anchorParams != null) {
            childParams.mBottom = anchorParams.mBottom - childParams.bottomMargin;
        } else if (childParams.alignWithParent && rules[8] != 0 && myHeight >= 0) {
            childParams.mBottom = myHeight - this.mPaddingBottom - childParams.bottomMargin;
        }
        if (0 != rules[10]) {
            childParams.mTop = this.mPaddingTop + childParams.topMargin;
        }
        if (0 != rules[12] && myHeight >= 0) {
            childParams.mBottom = myHeight - this.mPaddingBottom - childParams.bottomMargin;
        }
        if (rules[4] != 0) {
            this.mHasBaselineAlignedChild = true;
        }
    }

    private View getRelatedView(int[] rules, int relation) {
        int id2 = rules[relation];
        if (id2 != 0) {
            DependencyGraph.Node node = (DependencyGraph.Node)this.mGraph.mKeyNodes.get(id2);
            if (node == null) {
                return null;
            }
            View v = node.view;
            while (v.getVisibility() == 8) {
                rules = ((LayoutParams)v.getLayoutParams()).getRules();
                node = (DependencyGraph.Node)this.mGraph.mKeyNodes.get(rules[relation]);
                if (node == null) {
                    return null;
                }
                v = node.view;
            }
            return v;
        }
        return null;
    }

    private LayoutParams getRelatedViewParams(int[] rules, int relation) {
        ViewGroup.LayoutParams params;
        View v = this.getRelatedView(rules, relation);
        if (v != null && (params = v.getLayoutParams()) instanceof LayoutParams) {
            return (LayoutParams)v.getLayoutParams();
        }
        return null;
    }

    private int getRelatedViewBaseline(int[] rules, int relation) {
        View v = this.getRelatedView(rules, relation);
        if (v != null) {
            return v.getBaseline();
        }
        return -1;
    }

    private void centerHorizontal(View child, LayoutParams params, int myWidth) {
        int childWidth = child.getMeasuredWidth();
        int left = (myWidth - childWidth) / 2;
        params.mLeft = left;
        params.mRight = left + childWidth;
    }

    private void centerVertical(View child, LayoutParams params, int myHeight) {
        int childHeight = child.getMeasuredHeight();
        int top = (myHeight - childHeight) / 2;
        params.mTop = top;
        params.mBottom = top + childHeight;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams st = (LayoutParams)child.getLayoutParams();
            child.layout(st.mLeft, st.mTop, st.mRight, st.mBottom);
        }
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        if (this.mTopToBottomLeftToRightSet == null) {
            this.mTopToBottomLeftToRightSet = new TreeSet<View>(new TopToBottomLeftToRightComparator());
        }
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.mTopToBottomLeftToRightSet.add(this.getChildAt(i));
        }
        for (View view : this.mTopToBottomLeftToRightSet) {
            if (!view.dispatchPopulateAccessibilityEvent(event)) continue;
            this.mTopToBottomLeftToRightSet.clear();
            return true;
        }
        this.mTopToBottomLeftToRightSet.clear();
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DependencyGraph {
        private ArrayList<Node> mNodes = new ArrayList();
        private SparseArray<Node> mKeyNodes = new SparseArray();
        private LinkedList<Node> mRoots = new LinkedList();

        private DependencyGraph() {
        }

        void clear() {
            ArrayList<Node> nodes = this.mNodes;
            int count = nodes.size();
            for (int i = 0; i < count; ++i) {
                nodes.get(i).release();
            }
            nodes.clear();
            this.mKeyNodes.clear();
            this.mRoots.clear();
        }

        void add(View view) {
            int id2 = view.getId();
            Node node = Node.acquire(view);
            if (id2 != -1) {
                this.mKeyNodes.put(id2, node);
            }
            this.mNodes.add(node);
        }

        void getSortedViews(View[] sorted, int ... rules) {
            LinkedList<Node> roots = this.findRoots(rules);
            int index = 0;
            while (roots.size() > 0) {
                Node node = roots.removeFirst();
                View view = node.view;
                int key = view.getId();
                sorted[index++] = view;
                HashSet<Node> dependents = node.dependents;
                for (Node dependent : dependents) {
                    SparseArray<Node> dependencies = dependent.dependencies;
                    dependencies.remove(key);
                    if (dependencies.size() != 0) continue;
                    roots.add(dependent);
                }
            }
            if (index < sorted.length) {
                throw new IllegalStateException("Circular dependencies cannot exist in RelativeLayout");
            }
        }

        private LinkedList<Node> findRoots(int[] rulesFilter) {
            Node node;
            int i;
            SparseArray<Node> keyNodes = this.mKeyNodes;
            ArrayList<Node> nodes = this.mNodes;
            int count = nodes.size();
            for (i = 0; i < count; ++i) {
                node = nodes.get(i);
                node.dependents.clear();
                node.dependencies.clear();
            }
            for (i = 0; i < count; ++i) {
                node = nodes.get(i);
                LayoutParams layoutParams = (LayoutParams)node.view.getLayoutParams();
                int[] rules = layoutParams.mRules;
                int rulesCount = rulesFilter.length;
                for (int j = 0; j < rulesCount; ++j) {
                    Node dependency;
                    int rule = rules[rulesFilter[j]];
                    if (rule <= 0 || (dependency = keyNodes.get(rule)) == null || dependency == node) continue;
                    dependency.dependents.add(node);
                    node.dependencies.put(rule, dependency);
                }
            }
            LinkedList<Node> roots = this.mRoots;
            roots.clear();
            for (int i2 = 0; i2 < count; ++i2) {
                Node node2 = nodes.get(i2);
                if (node2.dependencies.size() != 0) continue;
                roots.add(node2);
            }
            return roots;
        }

        void log(Resources resources, int ... rules) {
            LinkedList<Node> roots = this.findRoots(rules);
            for (Node node : roots) {
                DependencyGraph.printNode(resources, node);
            }
        }

        static void printViewId(Resources resources, View view) {
            if (view.getId() != -1) {
                Log.d(RelativeLayout.LOG_TAG, resources.getResourceEntryName(view.getId()));
            } else {
                Log.d(RelativeLayout.LOG_TAG, "NO_ID");
            }
        }

        private static void appendViewId(Resources resources, Node node, StringBuilder buffer) {
            if (node.view.getId() != -1) {
                buffer.append(resources.getResourceEntryName(node.view.getId()));
            } else {
                buffer.append("NO_ID");
            }
        }

        private static void printNode(Resources resources, Node node) {
            if (node.dependents.size() == 0) {
                DependencyGraph.printViewId(resources, node.view);
            } else {
                for (Node dependent : node.dependents) {
                    StringBuilder buffer = new StringBuilder();
                    DependencyGraph.appendViewId(resources, node, buffer);
                    DependencyGraph.printdependents(resources, dependent, buffer);
                }
            }
        }

        private static void printdependents(Resources resources, Node node, StringBuilder buffer) {
            buffer.append(" -> ");
            DependencyGraph.appendViewId(resources, node, buffer);
            if (node.dependents.size() == 0) {
                Log.d(RelativeLayout.LOG_TAG, buffer.toString());
            } else {
                for (Node dependent : node.dependents) {
                    StringBuilder subBuffer = new StringBuilder(buffer);
                    DependencyGraph.printdependents(resources, dependent, subBuffer);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class Node
        implements Poolable<Node> {
            View view;
            final HashSet<Node> dependents = new HashSet();
            final SparseArray<Node> dependencies = new SparseArray();
            private static final int POOL_LIMIT = 100;
            private static final Pool<Node> sPool = Pools.synchronizedPool(Pools.finitePool(new PoolableManager<Node>(){

                @Override
                public Node newInstance() {
                    return new Node();
                }

                @Override
                public void onAcquired(Node element) {
                }

                @Override
                public void onReleased(Node element) {
                }
            }, 100));
            private Node mNext;

            Node() {
            }

            @Override
            public void setNextPoolable(Node element) {
                this.mNext = element;
            }

            @Override
            public Node getNextPoolable() {
                return this.mNext;
            }

            static Node acquire(View view) {
                Node node = sPool.acquire();
                node.view = view;
                return node;
            }

            void release() {
                this.view = null;
                this.dependents.clear();
                this.dependencies.clear();
                sPool.release(this);
            }
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        @ViewDebug.ExportedProperty(category="layout", resolveId=true, indexMapping={@ViewDebug.IntToString(from=2, to="above"), @ViewDebug.IntToString(from=4, to="alignBaseline"), @ViewDebug.IntToString(from=8, to="alignBottom"), @ViewDebug.IntToString(from=5, to="alignLeft"), @ViewDebug.IntToString(from=12, to="alignParentBottom"), @ViewDebug.IntToString(from=9, to="alignParentLeft"), @ViewDebug.IntToString(from=11, to="alignParentRight"), @ViewDebug.IntToString(from=10, to="alignParentTop"), @ViewDebug.IntToString(from=7, to="alignRight"), @ViewDebug.IntToString(from=6, to="alignTop"), @ViewDebug.IntToString(from=3, to="below"), @ViewDebug.IntToString(from=14, to="centerHorizontal"), @ViewDebug.IntToString(from=13, to="center"), @ViewDebug.IntToString(from=15, to="centerVertical"), @ViewDebug.IntToString(from=0, to="leftOf"), @ViewDebug.IntToString(from=1, to="rightOf")}, mapping={@ViewDebug.IntToString(from=-1, to="true"), @ViewDebug.IntToString(from=0, to="false/NO_ID")})
        private int[] mRules = new int[16];
        private int mLeft;
        private int mTop;
        private int mRight;
        private int mBottom;
        @ViewDebug.ExportedProperty(category="layout")
        public boolean alignWithParent;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.RelativeLayout_Layout);
            int[] rules = this.mRules;
            int N = a.getIndexCount();
            block19: for (int i = 0; i < N; ++i) {
                int attr2 = a.getIndex(i);
                switch (attr2) {
                    case 16: {
                        this.alignWithParent = a.getBoolean(attr2, false);
                        continue block19;
                    }
                    case 0: {
                        rules[0] = a.getResourceId(attr2, 0);
                        continue block19;
                    }
                    case 1: {
                        rules[1] = a.getResourceId(attr2, 0);
                        continue block19;
                    }
                    case 2: {
                        rules[2] = a.getResourceId(attr2, 0);
                        continue block19;
                    }
                    case 3: {
                        rules[3] = a.getResourceId(attr2, 0);
                        continue block19;
                    }
                    case 4: {
                        rules[4] = a.getResourceId(attr2, 0);
                        continue block19;
                    }
                    case 5: {
                        rules[5] = a.getResourceId(attr2, 0);
                        continue block19;
                    }
                    case 6: {
                        rules[6] = a.getResourceId(attr2, 0);
                        continue block19;
                    }
                    case 7: {
                        rules[7] = a.getResourceId(attr2, 0);
                        continue block19;
                    }
                    case 8: {
                        rules[8] = a.getResourceId(attr2, 0);
                        continue block19;
                    }
                    case 9: {
                        rules[9] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block19;
                    }
                    case 10: {
                        rules[10] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block19;
                    }
                    case 11: {
                        rules[11] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block19;
                    }
                    case 12: {
                        rules[12] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block19;
                    }
                    case 13: {
                        rules[13] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block19;
                    }
                    case 14: {
                        rules[14] = a.getBoolean(attr2, false) ? -1 : 0;
                        continue block19;
                    }
                    case 15: {
                        rules[15] = a.getBoolean(attr2, false) ? -1 : 0;
                    }
                }
            }
            a.recycle();
        }

        public LayoutParams(int w, int h) {
            super(w, h);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public String debug(String output) {
            return output + "ViewGroup.LayoutParams={ width=" + LayoutParams.sizeToString(this.width) + ", height=" + LayoutParams.sizeToString(this.height) + " }";
        }

        public void addRule(int verb) {
            this.mRules[verb] = -1;
        }

        public void addRule(int verb, int anchor) {
            this.mRules[verb] = anchor;
        }

        public int[] getRules() {
            return this.mRules;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TopToBottomLeftToRightComparator
    implements Comparator<View> {
        private TopToBottomLeftToRightComparator() {
        }

        @Override
        public int compare(View first, View second) {
            int topDifference = first.getTop() - second.getTop();
            if (topDifference != 0) {
                return topDifference;
            }
            int leftDifference = first.getLeft() - second.getLeft();
            if (leftDifference != 0) {
                return leftDifference;
            }
            int heightDiference = first.getHeight() - second.getHeight();
            if (heightDiference != 0) {
                return heightDiference;
            }
            int widthDiference = first.getWidth() - second.getWidth();
            if (widthDiference != 0) {
                return widthDiference;
            }
            return 0;
        }
    }
}

