/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.util.FloatMath;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.Scroller;

public class OverScroller {
    private int mMode;
    private MagneticOverScroller mScrollerX;
    private MagneticOverScroller mScrollerY;
    private final Interpolator mInterpolator;
    private static final int DEFAULT_DURATION = 250;
    private static final int SCROLL_MODE = 0;
    private static final int FLING_MODE = 1;

    public OverScroller(Context context) {
        this(context, null);
    }

    public OverScroller(Context context, Interpolator interpolator) {
        this(context, interpolator, 0.16f, 0.16f);
    }

    public OverScroller(Context context, Interpolator interpolator, float bounceCoefficientX, float bounceCoefficientY) {
        this.mInterpolator = interpolator;
        this.mScrollerX = new MagneticOverScroller();
        this.mScrollerY = new MagneticOverScroller();
        MagneticOverScroller.initializeFromContext(context);
        this.mScrollerX.setBounceCoefficient(bounceCoefficientX);
        this.mScrollerY.setBounceCoefficient(bounceCoefficientY);
    }

    public final boolean isFinished() {
        return this.mScrollerX.mFinished && this.mScrollerY.mFinished;
    }

    public final void forceFinished(boolean finished) {
        this.mScrollerX.mFinished = this.mScrollerY.mFinished = finished;
    }

    public final int getCurrX() {
        return this.mScrollerX.mCurrentPosition;
    }

    public final int getCurrY() {
        return this.mScrollerY.mCurrentPosition;
    }

    public float getCurrVelocity() {
        float squaredNorm = this.mScrollerX.mCurrVelocity * this.mScrollerX.mCurrVelocity;
        return FloatMath.sqrt(squaredNorm += this.mScrollerY.mCurrVelocity * this.mScrollerY.mCurrVelocity);
    }

    public final int getStartX() {
        return this.mScrollerX.mStart;
    }

    public final int getStartY() {
        return this.mScrollerY.mStart;
    }

    public final int getFinalX() {
        return this.mScrollerX.mFinal;
    }

    public final int getFinalY() {
        return this.mScrollerY.mFinal;
    }

    public final int getDuration() {
        return Math.max(this.mScrollerX.mDuration, this.mScrollerY.mDuration);
    }

    public void extendDuration(int extend) {
        this.mScrollerX.extendDuration(extend);
        this.mScrollerY.extendDuration(extend);
    }

    public void setFinalX(int newX) {
        this.mScrollerX.setFinalPosition(newX);
    }

    public void setFinalY(int newY) {
        this.mScrollerY.setFinalPosition(newY);
    }

    public boolean computeScrollOffset() {
        if (this.isFinished()) {
            return false;
        }
        switch (this.mMode) {
            case 0: {
                long time = AnimationUtils.currentAnimationTimeMillis();
                long elapsedTime = time - this.mScrollerX.mStartTime;
                int duration = this.mScrollerX.mDuration;
                if (elapsedTime < (long)duration) {
                    float q = (float)elapsedTime / (float)duration;
                    q = this.mInterpolator == null ? Scroller.viscousFluid(q) : this.mInterpolator.getInterpolation(q);
                    this.mScrollerX.updateScroll(q);
                    this.mScrollerY.updateScroll(q);
                    break;
                }
                this.abortAnimation();
                break;
            }
            case 1: {
                if (!(this.mScrollerX.mFinished || this.mScrollerX.update() || this.mScrollerX.continueWhenFinished())) {
                    this.mScrollerX.finish();
                }
                if (this.mScrollerY.mFinished || this.mScrollerY.update() || this.mScrollerY.continueWhenFinished()) break;
                this.mScrollerY.finish();
            }
        }
        return true;
    }

    public void startScroll(int startX, int startY, int dx, int dy) {
        this.startScroll(startX, startY, dx, dy, 250);
    }

    public void startScroll(int startX, int startY, int dx, int dy, int duration) {
        this.mMode = 0;
        this.mScrollerX.startScroll(startX, dx, duration);
        this.mScrollerY.startScroll(startY, dy, duration);
    }

    public boolean springBack(int startX, int startY, int minX, int maxX, int minY, int maxY) {
        this.mMode = 1;
        boolean spingbackX = this.mScrollerX.springback(startX, minX, maxX);
        boolean spingbackY = this.mScrollerY.springback(startY, minY, maxY);
        return spingbackX || spingbackY;
    }

    public void fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY) {
        this.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY, 0, 0);
    }

    public void fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY, int overX, int overY) {
        this.mMode = 1;
        this.mScrollerX.fling(startX, velocityX, minX, maxX, overX);
        this.mScrollerY.fling(startY, velocityY, minY, maxY, overY);
    }

    public void notifyHorizontalEdgeReached(int startX, int finalX, int overX) {
        this.mScrollerX.notifyEdgeReached(startX, finalX, overX);
    }

    public void notifyVerticalEdgeReached(int startY, int finalY, int overY) {
        this.mScrollerY.notifyEdgeReached(startY, finalY, overY);
    }

    public boolean isOverScrolled() {
        return !this.mScrollerX.mFinished && this.mScrollerX.mState != 0 || !this.mScrollerY.mFinished && this.mScrollerY.mState != 0;
    }

    public void abortAnimation() {
        this.mScrollerX.finish();
        this.mScrollerY.finish();
    }

    public int timePassed() {
        long time = AnimationUtils.currentAnimationTimeMillis();
        long startTime = Math.min(this.mScrollerX.mStartTime, this.mScrollerY.mStartTime);
        return (int)(time - startTime);
    }

    static class MagneticOverScroller {
        int mStart;
        int mCurrentPosition;
        int mFinal;
        int mVelocity;
        float mCurrVelocity;
        float mDeceleration;
        long mStartTime;
        int mDuration;
        boolean mFinished = true;
        static float GRAVITY;
        private static final int TO_EDGE = 0;
        private static final int TO_BOUNDARY = 1;
        private static final int TO_BOUNCE = 2;
        private int mState = 0;
        private int mOver;
        private static final int OVERSCROLL_SPRINGBACK_DURATION = 200;
        private static final float TIME_COEF = (float)Math.PI * 5;
        private static final float MINIMUM_VELOCITY_FOR_BOUNCE = Float.MAX_VALUE;
        private static final float DEFAULT_BOUNCE_COEFFICIENT = 0.16f;
        private float mBounceCoefficient = 0.16f;

        static void initializeFromContext(Context context) {
            float ppi = context.getResources().getDisplayMetrics().density * 160.0f;
            GRAVITY = 386.0878f * ppi * ViewConfiguration.getScrollFriction();
        }

        MagneticOverScroller() {
        }

        void updateScroll(float q) {
            this.mCurrentPosition = this.mStart + Math.round(q * (float)(this.mFinal - this.mStart));
        }

        static float getDeceleration(int velocity) {
            return velocity > 0 ? -GRAVITY : GRAVITY;
        }

        static int computeDuration(int start, int end, float initialVelocity, float deceleration) {
            int distance = start - end;
            float discriminant = initialVelocity * initialVelocity - 2.0f * deceleration * (float)distance;
            if (discriminant >= 0.0f) {
                float delta = (float)Math.sqrt(discriminant);
                if (deceleration < 0.0f) {
                    delta = -delta;
                }
                return (int)(1000.0f * (-initialVelocity - delta) / deceleration);
            }
            return 0;
        }

        void startScroll(int start, int distance, int duration) {
            this.mFinished = false;
            this.mStart = start;
            this.mFinal = start + distance;
            this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
            this.mDuration = duration;
            this.mDeceleration = 0.0f;
            this.mVelocity = 0;
        }

        void fling(int start, int velocity, int min, int max) {
            this.mFinished = false;
            this.mStart = start;
            this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
            this.mVelocity = velocity;
            this.mDeceleration = MagneticOverScroller.getDeceleration(velocity);
            if (this.mStart < min) {
                this.mDuration = 0;
                this.mFinal = min;
                return;
            }
            if (this.mStart > max) {
                this.mDuration = 0;
                this.mFinal = max;
                return;
            }
            this.mDuration = (int)(-1000.0f * (float)velocity / this.mDeceleration);
            this.mFinal = start - Math.round((float)(velocity * velocity) / (2.0f * this.mDeceleration));
            if (this.mFinal < min) {
                this.mFinal = min;
                this.mDuration = MagneticOverScroller.computeDuration(this.mStart, min, this.mVelocity, this.mDeceleration);
            }
            if (this.mFinal > max) {
                this.mFinal = max;
                this.mDuration = MagneticOverScroller.computeDuration(this.mStart, max, this.mVelocity, this.mDeceleration);
            }
        }

        void finish() {
            this.mCurrentPosition = this.mFinal;
            this.mFinished = true;
        }

        void setFinalPosition(int position) {
            this.mFinal = position;
            this.mFinished = false;
        }

        void extendDuration(int extend) {
            long time = AnimationUtils.currentAnimationTimeMillis();
            int elapsedTime = (int)(time - this.mStartTime);
            this.mDuration = elapsedTime + extend;
            this.mFinished = false;
        }

        void setBounceCoefficient(float coefficient) {
            this.mBounceCoefficient = coefficient;
        }

        boolean springback(int start, int min, int max) {
            this.mFinished = true;
            this.mStart = start;
            this.mVelocity = 0;
            this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
            this.mDuration = 0;
            if (start < min) {
                this.startSpringback(start, min, false);
            } else if (start > max) {
                this.startSpringback(start, max, true);
            }
            return !this.mFinished;
        }

        private void startSpringback(int start, int end, boolean positive) {
            this.mFinished = false;
            this.mState = 2;
            this.mStart = this.mFinal = end;
            this.mDuration = 200;
            this.mStartTime -= 100L;
            this.mVelocity = (int)((double)((float)Math.abs(end - start) * ((float)Math.PI * 5)) * (positive ? 1.0 : -1.0));
        }

        void fling(int start, int velocity, int min, int max, int over) {
            this.mState = 0;
            this.mOver = over;
            this.mFinished = false;
            this.mStart = start;
            this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
            this.mVelocity = velocity;
            this.mDeceleration = MagneticOverScroller.getDeceleration(velocity);
            this.mDuration = (int)(-1000.0f * (float)velocity / this.mDeceleration);
            this.mFinal = start - Math.round((float)(velocity * velocity) / (2.0f * this.mDeceleration));
            if (this.mFinal < min) {
                this.mFinal = min;
                this.mDuration = MagneticOverScroller.computeDuration(this.mStart, min, this.mVelocity, this.mDeceleration);
            }
            if (this.mFinal > max) {
                this.mFinal = max;
                this.mDuration = MagneticOverScroller.computeDuration(this.mStart, max, this.mVelocity, this.mDeceleration);
            }
            if (start > max) {
                if (start >= max + over) {
                    this.springback(max + over, min, max);
                } else if (velocity <= 0) {
                    this.springback(start, min, max);
                } else {
                    long time = AnimationUtils.currentAnimationTimeMillis();
                    double durationSinceEdge = Math.atan((float)(start - max) * ((float)Math.PI * 5) / (float)velocity) / 15.707963943481445;
                    this.mStartTime = (int)((double)time - 1000.0 * durationSinceEdge);
                    this.mStart = max;
                    this.mVelocity = (int)((double)velocity / Math.cos(durationSinceEdge * 15.707963943481445));
                    this.onEdgeReached();
                }
            } else if (start < min) {
                if (start <= min - over) {
                    this.springback(min - over, min, max);
                } else if (velocity >= 0) {
                    this.springback(start, min, max);
                } else {
                    long time = AnimationUtils.currentAnimationTimeMillis();
                    double durationSinceEdge = Math.atan((float)(start - min) * ((float)Math.PI * 5) / (float)velocity) / 15.707963943481445;
                    this.mStartTime = (int)((double)time - 1000.0 * durationSinceEdge);
                    this.mStart = min;
                    this.mVelocity = (int)((double)velocity / Math.cos(durationSinceEdge * 15.707963943481445));
                    this.onEdgeReached();
                }
            }
        }

        void notifyEdgeReached(int start, int end, int over) {
            this.mDeceleration = MagneticOverScroller.getDeceleration(this.mVelocity);
            float timeCurrent = this.mCurrVelocity / this.mDeceleration;
            int distance = end - start;
            float timeEdge = -((float)Math.sqrt(2.0f * (float)distance / this.mDeceleration + timeCurrent * timeCurrent));
            this.mVelocity = (int)(this.mDeceleration * timeEdge);
            this.mStart = end;
            this.mOver = over;
            long time = AnimationUtils.currentAnimationTimeMillis();
            this.mStartTime = (int)((float)time - 1000.0f * (timeCurrent - timeEdge));
            this.onEdgeReached();
        }

        private void onEdgeReached() {
            float distance = (float)this.mVelocity / ((float)Math.PI * 5);
            if (Math.abs(distance) < (float)this.mOver) {
                this.mState = 2;
                this.mFinal = this.mStart;
                this.mDuration = 200;
            } else {
                this.mState = 1;
                int over = this.mVelocity > 0 ? this.mOver : -this.mOver;
                this.mFinal = this.mStart + over;
                this.mDuration = (int)(1000.0 * Math.asin((float)over / distance) / 15.707963943481445);
            }
        }

        boolean continueWhenFinished() {
            switch (this.mState) {
                case 0: {
                    int duration = (int)(-1000.0f * (float)this.mVelocity / this.mDeceleration);
                    if (this.mDuration < duration) {
                        this.mStart = this.mFinal;
                        this.mVelocity = (int)((float)this.mVelocity + this.mDeceleration * (float)this.mDuration / 1000.0f);
                        this.mStartTime += (long)this.mDuration;
                        this.onEdgeReached();
                        break;
                    }
                    return false;
                }
                case 1: {
                    this.mStartTime += (long)this.mDuration;
                    this.startSpringback(this.mFinal, this.mFinal - (this.mVelocity > 0 ? this.mOver : -this.mOver), this.mVelocity > 0);
                    break;
                }
                case 2: {
                    this.mVelocity = (int)((float)this.mVelocity * this.mBounceCoefficient);
                    if ((float)Math.abs(this.mVelocity) < Float.MAX_VALUE) {
                        return false;
                    }
                    this.mStartTime += (long)this.mDuration;
                }
            }
            this.update();
            return true;
        }

        boolean update() {
            double distance;
            long time = AnimationUtils.currentAnimationTimeMillis();
            long duration = time - this.mStartTime;
            if (duration > (long)this.mDuration) {
                return false;
            }
            float t = (float)duration / 1000.0f;
            if (this.mState == 0) {
                this.mCurrVelocity = (float)this.mVelocity + this.mDeceleration * t;
                distance = (float)this.mVelocity * t + this.mDeceleration * t * t / 2.0f;
            } else {
                float d = t * ((float)Math.PI * 5);
                this.mCurrVelocity = (float)this.mVelocity * (float)Math.cos(d);
                distance = (double)((float)this.mVelocity / ((float)Math.PI * 5)) * Math.sin(d);
            }
            this.mCurrentPosition = this.mStart + (int)distance;
            return true;
        }
    }
}

