/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.DataSetObserver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Interpolator;
import android.graphics.Paint;
import android.graphics.Picture;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.net.http.SslCertificate;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.text.Editable;
import android.text.IClipboard;
import android.text.Selection;
import android.util.AttributeSet;
import android.util.EventLog;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AlphaAnimation;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.webkit.CallbackProxy;
import android.webkit.DownloadListener;
import android.webkit.JWebCoreJavaBridge;
import android.webkit.Network;
import android.webkit.PluginFullScreenHolder;
import android.webkit.PluginList;
import android.webkit.URLUtil;
import android.webkit.ViewManager;
import android.webkit.WebBackForwardList;
import android.webkit.WebBackForwardListClient;
import android.webkit.WebChromeClient;
import android.webkit.WebHistoryItem;
import android.webkit.WebSettings;
import android.webkit.WebTextView;
import android.webkit.WebViewClient;
import android.webkit.WebViewCore;
import android.webkit.WebViewDatabase;
import android.widget.AbsoluteLayout;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckedTextView;
import android.widget.EdgeGlow;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.OverScroller;
import android.widget.Toast;
import android.widget.ZoomButtonsController;
import android.widget.ZoomControls;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebView
extends AbsoluteLayout
implements ViewTreeObserver.OnGlobalFocusChangeListener,
ViewGroup.OnHierarchyChangeListener {
    private static final boolean DEBUG_DRAG_TRACKER = false;
    private static final boolean AUTO_REDRAW_HACK = false;
    private boolean mAutoRedraw;
    static final String LOGTAG = "webview";
    private final CallbackProxy mCallbackProxy;
    private final WebViewDatabase mDatabase;
    private SslCertificate mCertificate;
    private int mNativeClass;
    private WebViewCore mWebViewCore;
    final Handler mPrivateHandler = new PrivateHandler();
    private WebTextView mWebTextView;
    private int mTextGeneration;
    final ViewManager mViewManager;
    PluginFullScreenHolder mFullScreenHolder;
    private float mLastTouchX;
    private float mLastTouchY;
    private long mLastTouchTime;
    private long mLastSentTouchTime;
    private static final int TOUCH_SENT_INTERVAL = 50;
    private int mCurrentTouchInterval = 50;
    VelocityTracker mVelocityTracker;
    private int mMaximumFling;
    private float mLastVelocity;
    private float mLastVelX;
    private float mLastVelY;
    private int mTouchMode = 7;
    private static final int TOUCH_INIT_MODE = 1;
    private static final int TOUCH_DRAG_START_MODE = 2;
    private static final int TOUCH_DRAG_MODE = 3;
    private static final int TOUCH_SHORTPRESS_START_MODE = 4;
    private static final int TOUCH_SHORTPRESS_MODE = 5;
    private static final int TOUCH_DOUBLE_TAP_MODE = 6;
    private static final int TOUCH_DONE_MODE = 7;
    private static final int TOUCH_PINCH_DRAG = 8;
    private boolean mAllowPanAndScale;
    private boolean mForwardTouchEvents = false;
    private static final int PREVENT_DEFAULT_NO = 0;
    private static final int PREVENT_DEFAULT_MAYBE_YES = 1;
    private static final int PREVENT_DEFAULT_NO_FROM_TOUCH_DOWN = 2;
    private static final int PREVENT_DEFAULT_YES = 3;
    private static final int PREVENT_DEFAULT_IGNORE = 4;
    private int mPreventDefault = 4;
    private boolean mConfirmMove;
    private boolean mDeferTouchProcess;
    private int mDeferTouchMode = 7;
    private float mLastDeferTouchX;
    private float mLastDeferTouchY;
    boolean mDragFromTextInput;
    private boolean mDrawCursorRing = true;
    private boolean mIsPaused;
    private boolean mDelayedDeleteRootLayer;
    private int mTouchSlopSquare;
    private int mDoubleTapSlopSquare;
    private int mNavSlop;
    private static final int TAP_TIMEOUT = 200;
    private static final int LONG_PRESS_TIMEOUT = 1000;
    private static final int MIN_FLING_TIME = 250;
    private static final int MOTIONLESS_TIME = 100;
    private static final long ZOOM_CONTROLS_TIMEOUT = ViewConfiguration.getZoomControlsTimeout();
    private static final int PAGE_SCROLL_OVERLAP = 24;
    boolean mWidthCanMeasure;
    boolean mHeightCanMeasure;
    int mLastWidthSent;
    int mLastHeightSent;
    private int mContentWidth;
    private int mContentHeight;
    private boolean mOverlayHorizontalScrollbar = true;
    private boolean mOverlayVerticalScrollbar = false;
    private static final int STD_SPEED = 480;
    private static final int MAX_DURATION = 750;
    private static final int SLIDE_TITLE_DURATION = 500;
    private OverScroller mScroller;
    private boolean mInOverScrollMode = false;
    private static Paint mOverScrollBackground;
    private static Paint mOverScrollBorder;
    private boolean mWrapContent;
    private static final int MOTIONLESS_FALSE = 0;
    private static final int MOTIONLESS_PENDING = 1;
    private static final int MOTIONLESS_TRUE = 2;
    private static final int MOTIONLESS_IGNORE = 3;
    private int mHeldMotionless;
    private boolean mSupportMultiTouch;
    private ScaleGestureDetector mScaleDetector;
    private int mAnchorX;
    private int mAnchorY;
    private static final int REMEMBER_PASSWORD = 1;
    private static final int NEVER_REMEMBER_PASSWORD = 2;
    private static final int SWITCH_TO_SHORTPRESS = 3;
    private static final int SWITCH_TO_LONGPRESS = 4;
    private static final int RELEASE_SINGLE_TAP = 5;
    private static final int REQUEST_FORM_DATA = 6;
    private static final int RESUME_WEBCORE_PRIORITY = 7;
    private static final int DRAG_HELD_MOTIONLESS = 8;
    private static final int AWAKEN_SCROLL_BARS = 9;
    private static final int PREVENT_DEFAULT_TIMEOUT = 10;
    private static final int FIRST_PRIVATE_MSG_ID = 1;
    private static final int LAST_PRIVATE_MSG_ID = 10;
    static final int SCROLL_TO_MSG_ID = 101;
    static final int SCROLL_BY_MSG_ID = 102;
    static final int SPAWN_SCROLL_TO_MSG_ID = 103;
    static final int SYNC_SCROLL_TO_MSG_ID = 104;
    static final int NEW_PICTURE_MSG_ID = 105;
    static final int UPDATE_TEXT_ENTRY_MSG_ID = 106;
    static final int WEBCORE_INITIALIZED_MSG_ID = 107;
    static final int UPDATE_TEXTFIELD_TEXT_MSG_ID = 108;
    static final int UPDATE_ZOOM_RANGE = 109;
    static final int MOVE_OUT_OF_PLUGIN = 110;
    static final int CLEAR_TEXT_ENTRY = 111;
    static final int UPDATE_TEXT_SELECTION_MSG_ID = 112;
    static final int SHOW_RECT_MSG_ID = 113;
    static final int LONG_PRESS_CENTER = 114;
    static final int PREVENT_TOUCH_ID = 115;
    static final int WEBCORE_NEED_TOUCH_EVENTS = 116;
    static final int INVAL_RECT_MSG_ID = 117;
    static final int REQUEST_KEYBOARD = 118;
    static final int DO_MOTION_UP = 119;
    static final int SHOW_FULLSCREEN = 120;
    static final int HIDE_FULLSCREEN = 121;
    static final int DOM_FOCUS_CHANGED = 122;
    static final int IMMEDIATE_REPAINT_MSG_ID = 123;
    static final int SET_ROOT_LAYER_MSG_ID = 124;
    static final int RETURN_LABEL = 125;
    static final int FIND_AGAIN = 126;
    static final int CENTER_FIT_RECT = 127;
    static final int REQUEST_KEYBOARD_WITH_SELECTION_MSG_ID = 128;
    static final int SET_SCROLLBAR_MODES = 129;
    private static final int FIRST_PACKAGE_MSG_ID = 101;
    private static final int LAST_PACKAGE_MSG_ID = 129;
    static final String[] HandlerPrivateDebugString;
    static final String[] HandlerPackageDebugString;
    static final int DEFAULT_VIEWPORT_WIDTH = 800;
    static int sMaxViewportWidth;
    private static float DEFAULT_MAX_ZOOM_SCALE;
    private static float DEFAULT_MIN_ZOOM_SCALE;
    private float mMaxZoomScale;
    private float mMinZoomScale;
    private boolean mMinZoomScaleFixed = true;
    private int mInitialScaleInPercent = 0;
    boolean mInZoomOverview = false;
    int mZoomOverviewWidth = 800;
    float mTextWrapScale;
    static int DEFAULT_SCALE_PERCENT;
    private float mDefaultScale;
    private static float MINIMUM_SCALE_INCREMENT;
    private boolean mPreviewZoomOnly = false;
    private float mActualScale;
    private float mInvActualScale;
    private float mZoomScale;
    private float mInvInitialZoomScale;
    private float mInvFinalZoomScale;
    private int mInitialScrollX;
    private int mInitialScrollY;
    private long mZoomStart;
    private static final int ZOOM_ANIMATION_LENGTH = 500;
    private boolean mUserScroll = false;
    private int mSnapScrollMode = 0;
    private static final int SNAP_NONE = 0;
    private static final int SNAP_LOCK = 1;
    private static final int SNAP_X = 2;
    private static final int SNAP_Y = 4;
    private boolean mSnapPositive;
    private static final int DRAW_EXTRAS_NONE = 0;
    private static final int DRAW_EXTRAS_FIND = 1;
    private static final int DRAW_EXTRAS_SELECTION = 2;
    private static final int DRAW_EXTRAS_CURSOR_RING = 3;
    private static final int SCROLLBAR_AUTO = 0;
    private static final int SCROLLBAR_ALWAYSOFF = 1;
    private static final int SCROLLBAR_ALWAYSON = 2;
    private int mHorizontalScrollBarMode = 0;
    private int mVerticalScrollBarMode = 0;
    private int mOverscrollDistance;
    private int mOverflingDistance;
    private EdgeGlow mEdgeGlowTop;
    private EdgeGlow mEdgeGlowBottom;
    private EdgeGlow mEdgeGlowLeft;
    private EdgeGlow mEdgeGlowRight;
    private int mOverscrollDeltaX;
    private int mOverscrollDeltaY;
    private boolean mGotKeyDown;
    static boolean mLogEvent;
    private long mLastTouchUpTime = 0L;
    public static final String SCHEME_TEL = "tel:";
    public static final String SCHEME_MAILTO = "mailto:";
    public static final String SCHEME_GEO = "geo:0,0?q=";
    private int mBackgroundColor = -1;
    private PictureListener mPictureListener;
    private ExtendedZoomControls mZoomControls;
    private Runnable mZoomControlRunnable;
    private ZoomButtonsController mZoomButtonsController;
    private float mZoomCenterX;
    private float mZoomCenterY;
    private ZoomButtonsController.OnZoomListener mZoomListener = new ZoomButtonsController.OnZoomListener(){

        public void onVisibilityChanged(boolean visible) {
            if (visible) {
                WebView.this.switchOutDrawHistory();
                WebView.this.mZoomButtonsController.getZoomControls().setVisibility(0);
                WebView.this.updateZoomButtonsEnabled();
            }
        }

        public void onZoom(boolean zoomIn) {
            if (zoomIn) {
                WebView.this.zoomIn();
            } else {
                WebView.this.zoomOut();
            }
            WebView.this.updateZoomButtonsEnabled();
        }
    };
    private View mTitleBar;
    private Drawable mTitleShadow;
    private Rect mLastVisibleRectSent;
    private Rect mLastGlobalRect;
    private boolean mFindIsUp;
    private int mFindHeight;
    private String mLastFind;
    private String mPageThatNeedsToSlideTitleBarOffScreen;
    private int mYDistanceToSlideTitleOffScreen;
    private boolean mNeedToAdjustWebTextView;
    private boolean mDrawHistory = false;
    private Picture mHistoryPicture = null;
    private int mHistoryWidth = 0;
    private int mHistoryHeight = 0;
    private boolean mGotCenterDown = false;
    private int mMinLockSnapReverseDistance;
    private static final float MAX_SLOPE_FOR_DIAG = 1.5f;
    private static final int MIN_BREAK_SNAP_CROSS_DISTANCE = 80;
    private static final int MIN_SCROLL_AMOUNT_TO_DISABLE_DRAG_TRACKER = 4;
    private DragTracker mDragTracker;
    private DragTrackerHandler mDragTrackerHandler;
    private long mTrackballFirstTime = 0L;
    private long mTrackballLastTime = 0L;
    private float mTrackballRemainsX = 0.0f;
    private float mTrackballRemainsY = 0.0f;
    private int mTrackballXMove = 0;
    private int mTrackballYMove = 0;
    private boolean mSelectingText = false;
    private boolean mSelectionStarted = false;
    private boolean mExtendSelection = false;
    private boolean mDrawSelectionPointer = false;
    private static final int TRACKBALL_KEY_TIMEOUT = 1000;
    private static final int TRACKBALL_TIMEOUT = 200;
    private static final int TRACKBALL_WAIT = 100;
    private static final int TRACKBALL_SCALE = 400;
    private static final int TRACKBALL_SCROLL_COUNT = 5;
    private static final int TRACKBALL_MOVE_COUNT = 10;
    private static final int TRACKBALL_MULTIPLIER = 3;
    private static final int SELECT_CURSOR_OFFSET = 16;
    private int mSelectX = 0;
    private int mSelectY = 0;
    private boolean mFocusSizeChanged = false;
    private boolean mShiftIsPressed = false;
    private boolean mTrackballDown = false;
    private long mTrackballUpTime = 0L;
    private long mLastCursorTime = 0L;
    private Rect mLastCursorBounds;
    private boolean mMapTrackballToArrowKeys = true;
    private static final int NO_LEFTEDGE = -1;

    public WebView(Context context) {
        this(context, null);
    }

    public WebView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842885);
    }

    public WebView(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, null);
    }

    protected WebView(Context context, AttributeSet attrs, int defStyle, Map<String, Object> javascriptInterfaces) {
        super(context, attrs, defStyle);
        this.init();
        this.mCallbackProxy = new CallbackProxy(context, this);
        this.mViewManager = new ViewManager(this);
        this.mWebViewCore = new WebViewCore(context, this, this.mCallbackProxy, javascriptInterfaces);
        this.mDatabase = WebViewDatabase.getInstance(context);
        this.mScroller = new OverScroller(context);
        this.updateMultiTouchSupport(context);
    }

    void updateMultiTouchSupport(Context context) {
        WebSettings settings = this.getSettings();
        PackageManager pm = context.getPackageManager();
        this.mSupportMultiTouch = pm.hasSystemFeature("android.hardware.touchscreen.multitouch") && settings.supportZoom() && settings.getBuiltInZoomControls();
        this.mAllowPanAndScale = pm.hasSystemFeature("android.hardware.touchscreen.multitouch.distinct");
        if (this.mSupportMultiTouch && this.mScaleDetector == null) {
            this.mScaleDetector = new ScaleGestureDetector(context, new ScaleDetectorListener());
        } else if (!this.mSupportMultiTouch && this.mScaleDetector != null) {
            this.mScaleDetector = null;
        }
    }

    private void updateZoomButtonsEnabled() {
        boolean canZoomOut;
        if (this.mZoomButtonsController == null) {
            return;
        }
        boolean canZoomIn = this.mActualScale < this.mMaxZoomScale;
        boolean bl = canZoomOut = this.mActualScale > this.mMinZoomScale && !this.mInZoomOverview;
        if (!canZoomIn && !canZoomOut) {
            this.mZoomButtonsController.getZoomControls().setVisibility(8);
        } else {
            this.mZoomButtonsController.setZoomInEnabled(canZoomIn);
            this.mZoomButtonsController.setZoomOutEnabled(canZoomOut);
        }
    }

    private void init() {
        this.setWillNotDraw(false);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setClickable(true);
        this.setLongClickable(true);
        ViewConfiguration configuration = ViewConfiguration.get(this.getContext());
        int slop = configuration.getScaledTouchSlop();
        this.mTouchSlopSquare = slop * slop;
        this.mMinLockSnapReverseDistance = slop;
        slop = configuration.getScaledDoubleTapSlop();
        this.mDoubleTapSlopSquare = slop * slop;
        float density = this.getContext().getResources().getDisplayMetrics().density;
        this.mNavSlop = (int)(16.0f * density);
        DEFAULT_SCALE_PERCENT = (int)(100.0f * density);
        this.mDefaultScale = density;
        this.mActualScale = density;
        this.mInvActualScale = 1.0f / density;
        this.mTextWrapScale = density;
        DEFAULT_MAX_ZOOM_SCALE = 4.0f * density;
        DEFAULT_MIN_ZOOM_SCALE = 0.25f * density;
        this.mMaxZoomScale = DEFAULT_MAX_ZOOM_SCALE;
        this.mMinZoomScale = DEFAULT_MIN_ZOOM_SCALE;
        this.mMaximumFling = configuration.getScaledMaximumFlingVelocity();
        this.mOverscrollDistance = configuration.getScaledOverscrollDistance();
        this.mOverflingDistance = configuration.getScaledOverflingDistance();
    }

    @Override
    public void setOverScrollMode(int mode) {
        super.setOverScrollMode(mode);
        if (mode != 2) {
            if (this.mEdgeGlowTop == null) {
                Resources res = this.getContext().getResources();
                Drawable edge = res.getDrawable(17302072);
                Drawable glow = res.getDrawable(17302073);
                this.mEdgeGlowTop = new EdgeGlow(edge, glow);
                this.mEdgeGlowBottom = new EdgeGlow(edge, glow);
                this.mEdgeGlowLeft = new EdgeGlow(edge, glow);
                this.mEdgeGlowRight = new EdgeGlow(edge, glow);
            }
        } else {
            this.mEdgeGlowTop = null;
            this.mEdgeGlowBottom = null;
            this.mEdgeGlowLeft = null;
            this.mEdgeGlowRight = null;
        }
    }

    void updateDefaultZoomDensity(int zoomDensity) {
        float density = this.getContext().getResources().getDisplayMetrics().density * 100.0f / (float)zoomDensity;
        if ((double)Math.abs(density - this.mDefaultScale) > 0.01) {
            float scaleFactor = density / this.mDefaultScale;
            this.mNavSlop = (int)(16.0f * density);
            DEFAULT_SCALE_PERCENT = (int)(100.0f * density);
            DEFAULT_MAX_ZOOM_SCALE = 4.0f * density;
            DEFAULT_MIN_ZOOM_SCALE = 0.25f * density;
            this.mDefaultScale = density;
            this.mMaxZoomScale *= scaleFactor;
            this.mMinZoomScale *= scaleFactor;
            this.setNewZoomScale(this.mActualScale * scaleFactor, true, false);
        }
    }

    boolean onSavePassword(String schemePlusHost, String username, String password, final Message resumeMsg) {
        boolean rVal = false;
        if (resumeMsg == null) {
            this.mDatabase.setUsernamePassword(schemePlusHost, username, password);
        } else {
            final Message remember = this.mPrivateHandler.obtainMessage(1);
            remember.getData().putString("host", schemePlusHost);
            remember.getData().putString("username", username);
            remember.getData().putString("password", password);
            remember.obj = resumeMsg;
            final Message neverRemember = this.mPrivateHandler.obtainMessage(2);
            neverRemember.getData().putString("host", schemePlusHost);
            neverRemember.getData().putString("username", username);
            neverRemember.getData().putString("password", password);
            neverRemember.obj = resumeMsg;
            new AlertDialog.Builder(this.getContext()).setTitle(17040061).setMessage(17040071).setPositiveButton(17040072, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    resumeMsg.sendToTarget();
                }
            }).setNeutralButton(17040073, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    remember.sendToTarget();
                }
            }).setNegativeButton(17040074, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    neverRemember.sendToTarget();
                }
            }).setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    resumeMsg.sendToTarget();
                }
            }).show();
            rVal = true;
        }
        return rVal;
    }

    @Override
    public void setScrollBarStyle(int style2) {
        if (style2 == 0x1000000 || style2 == 0x3000000) {
            this.mOverlayVerticalScrollbar = false;
            this.mOverlayHorizontalScrollbar = false;
        } else {
            this.mOverlayVerticalScrollbar = true;
            this.mOverlayHorizontalScrollbar = true;
        }
        super.setScrollBarStyle(style2);
    }

    public void setHorizontalScrollbarOverlay(boolean overlay) {
        this.mOverlayHorizontalScrollbar = overlay;
    }

    public void setVerticalScrollbarOverlay(boolean overlay) {
        this.mOverlayVerticalScrollbar = overlay;
    }

    public boolean overlayHorizontalScrollbar() {
        return this.mOverlayHorizontalScrollbar;
    }

    public boolean overlayVerticalScrollbar() {
        return this.mOverlayVerticalScrollbar;
    }

    int getViewWidth() {
        if (!this.isVerticalScrollBarEnabled() || this.mOverlayVerticalScrollbar) {
            return this.getWidth();
        }
        return this.getWidth() - this.getVerticalScrollbarWidth();
    }

    private int getTitleHeight() {
        return this.mTitleBar != null ? this.mTitleBar.getHeight() : 0;
    }

    private int getVisibleTitleHeight() {
        return Math.max(this.getTitleHeight() - Math.max(0, this.mScrollY), 0);
    }

    int getViewHeight() {
        return this.getViewHeightWithTitle() - this.getVisibleTitleHeight();
    }

    private int getViewHeightWithTitle() {
        int height = this.getHeight();
        if (this.isHorizontalScrollBarEnabled() && !this.mOverlayHorizontalScrollbar) {
            height -= this.getHorizontalScrollbarHeight();
        }
        return height;
    }

    public SslCertificate getCertificate() {
        return this.mCertificate;
    }

    public void setCertificate(SslCertificate certificate) {
        this.mCertificate = certificate;
    }

    public void savePassword(String host, String username, String password) {
        this.mDatabase.setUsernamePassword(host, username, password);
    }

    public void setHttpAuthUsernamePassword(String host, String realm, String username, String password) {
        this.mDatabase.setHttpAuthUsernamePassword(host, realm, username, password);
    }

    public String[] getHttpAuthUsernamePassword(String host, String realm) {
        return this.mDatabase.getHttpAuthUsernamePassword(host, realm);
    }

    private void clearHelpers() {
        this.clearTextEntry(false);
        this.selectionDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.clearHelpers();
        if (this.mWebViewCore != null) {
            this.mCallbackProxy.setWebViewClient(null);
            this.mCallbackProxy.setWebChromeClient(null);
            Object object = this;
            synchronized (object) {
                WebViewCore webViewCore = this.mWebViewCore;
                this.mWebViewCore = null;
                webViewCore.destroy();
            }
            this.mPrivateHandler.removeCallbacksAndMessages(null);
            this.mCallbackProxy.removeCallbacksAndMessages(null);
            object = this.mCallbackProxy;
            synchronized (object) {
                this.mCallbackProxy.notify();
            }
        }
        if (this.mNativeClass != 0) {
            this.nativeDestroy();
            this.mNativeClass = 0;
        }
    }

    public static void enablePlatformNotifications() {
        Network.enablePlatformNotifications();
    }

    public static void disablePlatformNotifications() {
        Network.disablePlatformNotifications();
    }

    public void setJsFlags(String flags) {
        this.mWebViewCore.sendMessage(174, flags);
    }

    public void setNetworkAvailable(boolean networkUp) {
        this.mWebViewCore.sendMessage(119, networkUp ? 1 : 0, 0);
    }

    public void setNetworkType(String type, String subtype) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", type);
        map.put("subtype", subtype);
        this.mWebViewCore.sendMessage(183, map);
    }

    public WebBackForwardList saveState(Bundle outState) {
        if (outState == null) {
            return null;
        }
        WebBackForwardList list = this.copyBackForwardList();
        int currentIndex = list.getCurrentIndex();
        int size = list.getSize();
        if (currentIndex < 0 || currentIndex >= size || size == 0) {
            return null;
        }
        outState.putInt("index", currentIndex);
        ArrayList<byte[]> history = new ArrayList<byte[]>(size);
        for (int i = 0; i < size; ++i) {
            WebHistoryItem item = list.getItemAtIndex(i);
            if (null == item) {
                Log.w(LOGTAG, "saveState: Unexpected null history item.");
                return null;
            }
            byte[] data = item.getFlattenedData();
            if (data == null) {
                return null;
            }
            history.add(data);
        }
        outState.putSerializable("history", history);
        if (this.mCertificate != null) {
            outState.putBundle("certificate", SslCertificate.saveState(this.mCertificate));
        }
        return list;
    }

    public boolean savePicture(Bundle b, final File dest) {
        if (dest == null || b == null) {
            return false;
        }
        final Picture p = this.capturePicture();
        final File temp = new File(dest.getPath() + ".writing");
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block11: {
                    FileOutputStream out;
                    block10: {
                        out = null;
                        out = new FileOutputStream(temp);
                        p.writeToStream(out);
                        temp.renameTo(dest);
                        Object var4_2 = null;
                        if (out == null) break block10;
                        try {
                            out.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    temp.delete();
                    {
                        break block11;
                        catch (Exception exception) {
                            Object var4_3 = null;
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            temp.delete();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        temp.delete();
                        throw throwable;
                    }
                }
            }
        }).start();
        b.putInt("scrollX", this.mScrollX);
        b.putInt("scrollY", this.mScrollY);
        b.putFloat("scale", this.mActualScale);
        b.putFloat("textwrapScale", this.mTextWrapScale);
        b.putBoolean("overview", this.mInZoomOverview);
        return true;
    }

    private void restoreHistoryPictureFields(Picture p, Bundle b) {
        int sx = b.getInt("scrollX", 0);
        int sy = b.getInt("scrollY", 0);
        float scale = b.getFloat("scale", 1.0f);
        this.mDrawHistory = true;
        this.mHistoryPicture = p;
        this.mScrollX = sx;
        this.mScrollY = sy;
        this.mHistoryWidth = Math.round((float)p.getWidth() * scale);
        this.mHistoryHeight = Math.round((float)p.getHeight() * scale);
        this.mActualScale = scale;
        this.mInvActualScale = 1.0f / scale;
        this.mTextWrapScale = b.getFloat("textwrapScale", scale);
        this.mInZoomOverview = b.getBoolean("overview");
        this.invalidate();
    }

    public boolean restorePicture(Bundle b, File src) {
        if (src == null || b == null) {
            return false;
        }
        if (!src.exists()) {
            return false;
        }
        try {
            final FileInputStream in = new FileInputStream(src);
            final Bundle copy = new Bundle(b);
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        final Picture p = Picture.createFromStream(in);
                        if (p != null) {
                            WebView.this.mPrivateHandler.post(new Runnable(){

                                public void run() {
                                    WebView.this.restoreHistoryPictureFields(p, copy);
                                }
                            });
                        }
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        try {
                            in.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            }).start();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebBackForwardList restoreState(Bundle inState) {
        WebBackForwardList returnList = null;
        if (inState == null) {
            return returnList;
        }
        if (inState.containsKey("index") && inState.containsKey("history")) {
            this.mCertificate = SslCertificate.restoreState(inState.getBundle("certificate"));
            WebBackForwardList list = this.mCallbackProxy.getBackForwardList();
            int index = inState.getInt("index");
            WebBackForwardList webBackForwardList = list;
            synchronized (webBackForwardList) {
                List history = (List)((Object)inState.getSerializable("history"));
                int size = history.size();
                if (index < 0 || index >= size) {
                    return null;
                }
                for (int i = 0; i < size; ++i) {
                    byte[] data = (byte[])history.remove(0);
                    if (data == null) {
                        return null;
                    }
                    WebHistoryItem item = new WebHistoryItem(data);
                    list.addHistoryItem(item);
                }
                returnList = this.copyBackForwardList();
                returnList.setCurrentIndex(index);
            }
            this.mWebViewCore.removeMessages();
            this.mWebViewCore.sendMessage(108, index);
        }
        return returnList;
    }

    public void loadUrl(String url, Map<String, String> extraHeaders) {
        this.switchOutDrawHistory();
        WebViewCore.GetUrlData arg = new WebViewCore.GetUrlData();
        arg.mUrl = url;
        arg.mExtraHeaders = extraHeaders;
        this.mWebViewCore.sendMessage(100, arg);
        this.clearHelpers();
    }

    public void loadUrl(String url) {
        if (url == null) {
            return;
        }
        this.loadUrl(url, null);
    }

    public void postUrl(String url, byte[] postData) {
        if (URLUtil.isNetworkUrl(url)) {
            this.switchOutDrawHistory();
            WebViewCore.PostUrlData arg = new WebViewCore.PostUrlData();
            arg.mUrl = url;
            arg.mPostData = postData;
            this.mWebViewCore.sendMessage(132, arg);
            this.clearHelpers();
        } else {
            this.loadUrl(url);
        }
    }

    public void loadData(String data, String mimeType, String encoding) {
        this.loadUrl("data:" + mimeType + ";" + encoding + "," + data);
    }

    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        if (baseUrl != null && baseUrl.toLowerCase().startsWith("data:")) {
            this.loadData(data, mimeType, encoding);
            return;
        }
        this.switchOutDrawHistory();
        WebViewCore.BaseUrlData arg = new WebViewCore.BaseUrlData();
        arg.mBaseUrl = baseUrl;
        arg.mData = data;
        arg.mMimeType = mimeType;
        arg.mEncoding = encoding;
        arg.mHistoryUrl = historyUrl;
        this.mWebViewCore.sendMessage(139, arg);
        this.clearHelpers();
    }

    public void stopLoading() {
        this.switchOutDrawHistory();
        this.mWebViewCore.sendMessage(101);
    }

    public void reload() {
        this.clearHelpers();
        this.switchOutDrawHistory();
        this.mWebViewCore.sendMessage(102);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canGoBack() {
        WebBackForwardList l;
        WebBackForwardList webBackForwardList = l = this.mCallbackProxy.getBackForwardList();
        synchronized (webBackForwardList) {
            if (l.getClearPending()) {
                return false;
            }
            return l.getCurrentIndex() > 0;
        }
    }

    public void goBack() {
        this.goBackOrForward(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canGoForward() {
        WebBackForwardList l;
        WebBackForwardList webBackForwardList = l = this.mCallbackProxy.getBackForwardList();
        synchronized (webBackForwardList) {
            if (l.getClearPending()) {
                return false;
            }
            return l.getCurrentIndex() < l.getSize() - 1;
        }
    }

    public void goForward() {
        this.goBackOrForward(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canGoBackOrForward(int steps) {
        WebBackForwardList l;
        WebBackForwardList webBackForwardList = l = this.mCallbackProxy.getBackForwardList();
        synchronized (webBackForwardList) {
            if (l.getClearPending()) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
            int newIndex = l.getCurrentIndex() + steps;
            return newIndex >= 0 && newIndex < l.getSize();
        }
    }

    public void goBackOrForward(int steps) {
        this.goBackOrForward(steps, false);
    }

    private void goBackOrForward(int steps, boolean ignoreSnapshot) {
        if (steps != 0) {
            this.clearHelpers();
            this.mWebViewCore.sendMessage(106, steps, ignoreSnapshot ? 1 : 0);
        }
    }

    private boolean extendScroll(int y) {
        int finalY = this.mScroller.getFinalY();
        int newY = this.pinLocY(finalY + y);
        if (newY == finalY) {
            return false;
        }
        this.mScroller.setFinalY(newY);
        this.mScroller.extendDuration(WebView.computeDuration(0, y));
        return true;
    }

    public boolean pageUp(boolean top) {
        if (this.mNativeClass == 0) {
            return false;
        }
        this.nativeClearCursor();
        if (top) {
            return this.pinScrollTo(this.mScrollX, 0, true, 0);
        }
        int h = this.getHeight();
        int y = h > 48 ? -h + 24 : -h / 2;
        this.mUserScroll = true;
        return this.mScroller.isFinished() ? this.pinScrollBy(0, y, true, 0) : this.extendScroll(y);
    }

    public boolean pageDown(boolean bottom) {
        if (this.mNativeClass == 0) {
            return false;
        }
        this.nativeClearCursor();
        if (bottom) {
            return this.pinScrollTo(this.mScrollX, this.computeRealVerticalScrollRange(), true, 0);
        }
        int h = this.getHeight();
        int y = h > 48 ? h - 24 : h / 2;
        this.mUserScroll = true;
        return this.mScroller.isFinished() ? this.pinScrollBy(0, y, true, 0) : this.extendScroll(y);
    }

    public void clearView() {
        this.mContentWidth = 0;
        this.mContentHeight = 0;
        this.mWebViewCore.sendMessage(134);
    }

    public Picture capturePicture() {
        if (null == this.mWebViewCore) {
            return null;
        }
        return this.mWebViewCore.copyContentPicture();
    }

    private boolean inEditingMode() {
        return this.mWebTextView != null && this.mWebTextView.getParent() != null;
    }

    private void clearTextEntry(boolean disableFocusController) {
        if (this.inEditingMode()) {
            this.mWebTextView.remove();
            if (disableFocusController) {
                this.setFocusControllerInactive();
            }
        }
    }

    public float getScale() {
        return this.mActualScale;
    }

    public void setInitialScale(int scaleInPercent) {
        this.mInitialScaleInPercent = scaleInPercent;
    }

    public void invokeZoomPicker() {
        if (!this.getSettings().supportZoom()) {
            Log.w(LOGTAG, "This WebView doesn't support zoom.");
            return;
        }
        this.clearTextEntry(false);
        if (this.getSettings().getBuiltInZoomControls()) {
            this.getZoomButtonsController().setVisible(true);
        } else {
            this.mPrivateHandler.removeCallbacks(this.mZoomControlRunnable);
            this.mPrivateHandler.postDelayed(this.mZoomControlRunnable, ZOOM_CONTROLS_TIMEOUT);
        }
    }

    public HitTestResult getHitTestResult() {
        int contentY;
        int contentX;
        String text;
        int type;
        if (this.mNativeClass == 0) {
            return null;
        }
        HitTestResult result = new HitTestResult();
        if (this.nativeHasCursorNode()) {
            if (this.nativeCursorIsTextInput()) {
                result.setType(9);
            } else {
                String text2 = this.nativeCursorText();
                if (text2 != null) {
                    if (text2.startsWith(SCHEME_TEL)) {
                        result.setType(2);
                        result.setExtra(text2.substring(SCHEME_TEL.length()));
                    } else if (text2.startsWith(SCHEME_MAILTO)) {
                        result.setType(4);
                        result.setExtra(text2.substring(SCHEME_MAILTO.length()));
                    } else if (text2.startsWith(SCHEME_GEO)) {
                        result.setType(3);
                        result.setExtra(URLDecoder.decode(text2.substring(SCHEME_GEO.length())));
                    } else if (this.nativeCursorIsAnchor()) {
                        result.setType(7);
                        result.setExtra(text2);
                    }
                }
            }
        }
        if (((type = result.getType()) == 0 || type == 7) && (text = this.nativeImageURI(contentX = this.viewToContentX((int)this.mLastTouchX + this.mScrollX), contentY = this.viewToContentY((int)this.mLastTouchY + this.mScrollY))) != null) {
            result.setType(type == 0 ? 5 : 8);
            result.setExtra(text);
        }
        return result;
    }

    private void domChangedFocus() {
        if (this.inEditingMode()) {
            this.mPrivateHandler.obtainMessage(122).sendToTarget();
        }
    }

    public void requestFocusNodeHref(Message hrefMsg) {
        if (hrefMsg == null || this.mNativeClass == 0) {
            return;
        }
        if (this.nativeCursorIsAnchor()) {
            this.mWebViewCore.sendMessage(137, this.nativeCursorFramePointer(), this.nativeCursorNodePointer(), hrefMsg);
        }
    }

    public void requestImageRef(Message msg) {
        if (0 == this.mNativeClass) {
            return;
        }
        int contentX = this.viewToContentX((int)this.mLastTouchX + this.mScrollX);
        int contentY = this.viewToContentY((int)this.mLastTouchY + this.mScrollY);
        String ref = this.nativeImageURI(contentX, contentY);
        Bundle data = msg.getData();
        data.putString("url", ref);
        msg.setData(data);
        msg.sendToTarget();
    }

    private static int pinLoc(int x, int viewMax, int docMax) {
        if (docMax < viewMax) {
            x = 0;
        } else if (x < 0) {
            x = 0;
        } else if (x + viewMax > docMax) {
            x = docMax - viewMax;
        }
        return x;
    }

    private int pinLocX(int x) {
        if (this.mInOverScrollMode) {
            return x;
        }
        return WebView.pinLoc(x, this.getViewWidth(), this.computeRealHorizontalScrollRange());
    }

    private int pinLocY(int y) {
        if (this.mInOverScrollMode) {
            return y;
        }
        return WebView.pinLoc(y, this.getViewHeightWithTitle(), this.computeRealVerticalScrollRange() + this.getTitleHeight());
    }

    public void setEmbeddedTitleBar(View v) {
        if (this.mTitleBar == v) {
            return;
        }
        if (this.mTitleBar != null) {
            this.removeView(this.mTitleBar);
        }
        if (null != v) {
            this.addView(v, new AbsoluteLayout.LayoutParams(-1, -2, 0, 0));
            if (this.mTitleShadow == null) {
                this.mTitleShadow = this.mContext.getResources().getDrawable(17302329);
            }
        }
        this.mTitleBar = v;
    }

    private int viewToContentDimension(int d) {
        return Math.round((float)d * this.mInvActualScale);
    }

    int viewToContentX(int x) {
        return this.viewToContentDimension(x);
    }

    int viewToContentY(int y) {
        return this.viewToContentDimension(y - this.getTitleHeight());
    }

    private float viewToContentXf(int x) {
        return (float)x * this.mInvActualScale;
    }

    private float viewToContentYf(int y) {
        return (float)(y - this.getTitleHeight()) * this.mInvActualScale;
    }

    int contentToViewDimension(int d) {
        return Math.round((float)d * this.mActualScale);
    }

    int contentToViewX(int x) {
        return this.contentToViewDimension(x);
    }

    int contentToViewY(int y) {
        return this.contentToViewDimension(y) + this.getTitleHeight();
    }

    private Rect contentToViewRect(Rect x) {
        return new Rect(this.contentToViewX(x.left), this.contentToViewY(x.top), this.contentToViewX(x.right), this.contentToViewY(x.bottom));
    }

    private void viewInvalidate(int l, int t, int r, int b) {
        float scale = this.mActualScale;
        int dy = this.getTitleHeight();
        this.invalidate((int)Math.floor((float)l * scale), (int)Math.floor((float)t * scale) + dy, (int)Math.ceil((float)r * scale), (int)Math.ceil((float)b * scale) + dy);
    }

    private void viewInvalidateDelayed(long delay, int l, int t, int r, int b) {
        float scale = this.mActualScale;
        int dy = this.getTitleHeight();
        this.postInvalidateDelayed(delay, (int)Math.floor((float)l * scale), (int)Math.floor((float)t * scale) + dy, (int)Math.ceil((float)r * scale), (int)Math.ceil((float)b * scale) + dy);
    }

    private void invalidateContentRect(Rect r) {
        this.viewInvalidate(r.left, r.top, r.right, r.bottom);
    }

    private void abortAnimation() {
        this.mScroller.abortAnimation();
        this.mLastVelocity = 0.0f;
    }

    private void recordNewContentSize(int w, int h, boolean updateLayout) {
        if ((w | h) == 0) {
            return;
        }
        if (this.mContentWidth != w || this.mContentHeight != h) {
            this.mContentWidth = w;
            this.mContentHeight = h;
            if (!this.mDrawHistory) {
                int oldX = this.mScrollX;
                int oldY = this.mScrollY;
                this.mScrollX = this.pinLocX(this.mScrollX);
                this.mScrollY = this.pinLocY(this.mScrollY);
                if (oldX != this.mScrollX || oldY != this.mScrollY) {
                    this.onScrollChanged(this.mScrollX, this.mScrollY, oldX, oldY);
                }
                if (!this.mScroller.isFinished()) {
                    this.mScroller.setFinalX(this.pinLocX(this.mScroller.getFinalX()));
                    this.mScroller.setFinalY(this.pinLocY(this.mScroller.getFinalY()));
                }
            }
        }
        this.contentSizeChanged(updateLayout);
    }

    private void setNewZoomScale(float scale, boolean updateTextWrapScale, boolean force) {
        if (scale < this.mMinZoomScale) {
            scale = this.mMinZoomScale;
            if (scale < this.mDefaultScale) {
                this.mInZoomOverview = true;
            }
        } else if (scale > this.mMaxZoomScale) {
            scale = this.mMaxZoomScale;
        }
        if (updateTextWrapScale) {
            this.mTextWrapScale = scale;
            this.mLastHeightSent = 0;
        }
        if (scale != this.mActualScale || force) {
            if (this.mDrawHistory) {
                if (scale != this.mActualScale && !this.mPreviewZoomOnly) {
                    this.mCallbackProxy.onScaleChanged(this.mActualScale, scale);
                }
                this.mActualScale = scale;
                this.mInvActualScale = 1.0f / scale;
                this.sendViewSizeZoom();
            } else {
                int oldX = this.mScrollX;
                int oldY = this.mScrollY;
                float ratio = scale * this.mInvActualScale;
                float sx = ratio * (float)oldX + (ratio - 1.0f) * this.mZoomCenterX;
                float sy = ratio * (float)oldY + (ratio - 1.0f) * (this.mZoomCenterY - (float)this.getTitleHeight());
                if (scale != this.mActualScale && !this.mPreviewZoomOnly) {
                    this.mCallbackProxy.onScaleChanged(this.mActualScale, scale);
                }
                this.mActualScale = scale;
                this.mInvActualScale = 1.0f / scale;
                this.mViewManager.scaleAll();
                this.mScrollX = this.pinLocX(Math.round(sx));
                this.mScrollY = this.pinLocY(Math.round(sy));
                if (oldX != this.mScrollX || oldY != this.mScrollY) {
                    this.onScrollChanged(this.mScrollX, this.mScrollY, oldX, oldY);
                } else {
                    this.sendOurVisibleRect();
                }
                this.sendViewSizeZoom();
            }
        }
    }

    private Rect sendOurVisibleRect() {
        Rect globalRect;
        if (this.mPreviewZoomOnly) {
            return this.mLastVisibleRectSent;
        }
        Rect rect = new Rect();
        this.calcOurContentVisibleRect(rect);
        if (!rect.equals(this.mLastVisibleRectSent)) {
            Point pos = new Point(rect.left, rect.top);
            this.mWebViewCore.sendMessage(107, this.nativeMoveGeneration(), 0, pos);
            this.mLastVisibleRectSent = rect;
        }
        if (this.getGlobalVisibleRect(globalRect = new Rect()) && !globalRect.equals(this.mLastGlobalRect)) {
            this.mWebViewCore.sendMessage(116, globalRect);
            this.mLastGlobalRect = globalRect;
        }
        return rect;
    }

    private void calcOurVisibleRect(Rect r) {
        Point p = new Point();
        this.getGlobalVisibleRect(r, p);
        r.offset(-p.x, -p.y);
        if (this.mFindIsUp) {
            r.bottom -= this.mFindHeight;
        }
    }

    private void calcOurContentVisibleRect(Rect r) {
        this.calcOurVisibleRect(r);
        r.left = Math.max(this.viewToContentX(r.left), 0);
        r.top = Math.max(this.viewToContentY(r.top + this.getVisibleTitleHeight()), 0);
        r.right = Math.min(this.viewToContentX(r.right), this.mContentWidth);
        r.bottom = Math.min(this.viewToContentY(r.bottom), this.mContentHeight);
    }

    private void calcOurContentVisibleRectF(RectF r) {
        Rect ri = new Rect(0, 0, 0, 0);
        this.calcOurVisibleRect(ri);
        r.left = Math.max(this.viewToContentXf(ri.left), 0.0f);
        r.top = Math.max(this.viewToContentYf(ri.top + this.getVisibleTitleHeight()), 0.0f);
        r.right = Math.min(this.viewToContentXf(ri.right), (float)this.mContentWidth);
        r.bottom = Math.min(this.viewToContentYf(ri.bottom), (float)this.mContentHeight);
    }

    private boolean sendViewSizeZoom() {
        if (this.mPreviewZoomOnly) {
            return false;
        }
        int viewWidth = this.getViewWidth();
        int newWidth = Math.round((float)viewWidth * this.mInvActualScale);
        int newHeight = Math.round((float)this.getViewHeight() * this.mInvActualScale);
        if (newWidth > this.mLastWidthSent && this.mWrapContent) {
            newHeight = 0;
        }
        if (newWidth != this.mLastWidthSent || newHeight != this.mLastHeightSent) {
            ViewSizeData data = new ViewSizeData();
            data.mWidth = newWidth;
            data.mHeight = newHeight;
            data.mTextWrapWidth = Math.round((float)viewWidth / this.mTextWrapScale);
            data.mScale = this.mActualScale;
            data.mIgnoreHeight = this.mZoomScale != 0.0f && !this.mHeightCanMeasure;
            data.mAnchorX = this.mAnchorX;
            data.mAnchorY = this.mAnchorY;
            this.mWebViewCore.sendMessage(105, data);
            this.mLastWidthSent = newWidth;
            this.mLastHeightSent = newHeight;
            this.mAnchorY = 0;
            this.mAnchorX = 0;
            return true;
        }
        return false;
    }

    private int computeRealHorizontalScrollRange() {
        if (this.mDrawHistory) {
            return this.mHistoryWidth;
        }
        if (this.mHorizontalScrollBarMode == 1 && this.mActualScale - this.mMinZoomScale <= MINIMUM_SCALE_INCREMENT) {
            return this.computeHorizontalScrollExtent();
        }
        return (int)Math.floor((float)this.mContentWidth * this.mActualScale);
    }

    @Override
    protected int computeHorizontalScrollRange() {
        int range = this.computeRealHorizontalScrollRange();
        int scrollX = this.mScrollX;
        int overscrollRight = this.computeMaxScrollX();
        if (scrollX < 0) {
            range -= scrollX;
        } else if (scrollX > overscrollRight) {
            range += scrollX - overscrollRight;
        }
        return range;
    }

    @Override
    protected int computeHorizontalScrollOffset() {
        return Math.max(this.mScrollX, 0);
    }

    private int computeRealVerticalScrollRange() {
        if (this.mDrawHistory) {
            return this.mHistoryHeight;
        }
        if (this.mVerticalScrollBarMode == 1 && this.mActualScale - this.mMinZoomScale <= MINIMUM_SCALE_INCREMENT) {
            return this.computeVerticalScrollExtent();
        }
        return (int)Math.floor((float)this.mContentHeight * this.mActualScale);
    }

    @Override
    protected int computeVerticalScrollRange() {
        int range = this.computeRealVerticalScrollRange();
        int scrollY = this.mScrollY;
        int overscrollBottom = this.computeMaxScrollY();
        if (scrollY < 0) {
            range -= scrollY;
        } else if (scrollY > overscrollBottom) {
            range += scrollY - overscrollBottom;
        }
        return range;
    }

    @Override
    protected int computeVerticalScrollOffset() {
        return Math.max(this.mScrollY - this.getTitleHeight(), 0);
    }

    @Override
    protected int computeVerticalScrollExtent() {
        return this.getViewHeight();
    }

    @Override
    protected void onDrawVerticalScrollBar(Canvas canvas, Drawable scrollBar, int l, int t, int r, int b) {
        if (this.mScrollY < 0) {
            t -= this.mScrollY;
        }
        scrollBar.setBounds(l, t + this.getVisibleTitleHeight(), r, b);
        scrollBar.draw(canvas);
    }

    @Override
    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        this.mInOverScrollMode = false;
        int maxX = this.computeMaxScrollX();
        int maxY = this.computeMaxScrollY();
        if (maxX == 0) {
            scrollX = this.pinLocX(scrollX);
        } else if (scrollX < 0 || scrollX > maxX) {
            this.mInOverScrollMode = true;
        }
        if (scrollY < 0 || scrollY > maxY) {
            this.mInOverScrollMode = true;
        }
        int oldX = this.mScrollX;
        int oldY = this.mScrollY;
        super.scrollTo(scrollX, scrollY);
        if (this.mEdgeGlowTop != null && oldY == this.mScrollY && oldX == this.mScrollX) {
            if (maxX > 0) {
                int pulledToX = oldX + this.mOverscrollDeltaX;
                if (pulledToX < 0) {
                    this.mEdgeGlowLeft.onPull((float)this.mOverscrollDeltaX / (float)this.getWidth());
                    if (!this.mEdgeGlowRight.isFinished()) {
                        this.mEdgeGlowRight.onRelease();
                    }
                } else if (pulledToX > maxX) {
                    this.mEdgeGlowRight.onPull((float)this.mOverscrollDeltaX / (float)this.getWidth());
                    if (!this.mEdgeGlowLeft.isFinished()) {
                        this.mEdgeGlowLeft.onRelease();
                    }
                }
                this.mOverscrollDeltaX = 0;
            }
            if (maxY > 0 || this.getOverScrollMode() == 0) {
                int pulledToY = oldY + this.mOverscrollDeltaY;
                if (pulledToY < 0) {
                    this.mEdgeGlowTop.onPull((float)this.mOverscrollDeltaY / (float)this.getHeight());
                    if (!this.mEdgeGlowBottom.isFinished()) {
                        this.mEdgeGlowBottom.onRelease();
                    }
                } else if (pulledToY > maxY) {
                    this.mEdgeGlowBottom.onPull((float)this.mOverscrollDeltaY / (float)this.getHeight());
                    if (!this.mEdgeGlowTop.isFinished()) {
                        this.mEdgeGlowTop.onRelease();
                    }
                }
                this.mOverscrollDeltaY = 0;
            }
        }
    }

    public String getUrl() {
        WebHistoryItem h = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        return h != null ? h.getUrl() : null;
    }

    public String getOriginalUrl() {
        WebHistoryItem h = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        return h != null ? h.getOriginalUrl() : null;
    }

    public String getTitle() {
        WebHistoryItem h = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        return h != null ? h.getTitle() : null;
    }

    public Bitmap getFavicon() {
        WebHistoryItem h = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        return h != null ? h.getFavicon() : null;
    }

    public String getTouchIconUrl() {
        WebHistoryItem h = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        return h != null ? h.getTouchIconUrl() : null;
    }

    public int getProgress() {
        return this.mCallbackProxy.getProgress();
    }

    public int getContentHeight() {
        return this.mContentHeight;
    }

    public int getContentWidth() {
        return this.mContentWidth;
    }

    public void pauseTimers() {
        this.mWebViewCore.sendMessage(109);
    }

    public void resumeTimers() {
        this.mWebViewCore.sendMessage(110);
    }

    public void onPause() {
        if (!this.mIsPaused) {
            this.mIsPaused = true;
            this.mWebViewCore.sendMessage(143);
        }
    }

    public void onResume() {
        if (this.mIsPaused) {
            this.mIsPaused = false;
            this.mWebViewCore.sendMessage(144);
        }
    }

    public boolean isPaused() {
        return this.mIsPaused;
    }

    public void freeMemory() {
        this.mWebViewCore.sendMessage(145);
    }

    public void clearCache(boolean includeDiskFiles) {
        this.mWebViewCore.sendMessage(111, includeDiskFiles ? 1 : 0, 0);
    }

    public void clearFormData() {
        if (this.inEditingMode()) {
            WebTextView.AutoCompleteAdapter adapter = null;
            this.mWebTextView.setAdapterCustom(adapter);
        }
    }

    public void clearHistory() {
        this.mCallbackProxy.getBackForwardList().setClearPending();
        this.mWebViewCore.sendMessage(112);
    }

    public void clearSslPreferences() {
        this.mWebViewCore.sendMessage(150);
    }

    public WebBackForwardList copyBackForwardList() {
        return this.mCallbackProxy.getBackForwardList().clone();
    }

    public void findNext(boolean forward) {
        if (0 == this.mNativeClass) {
            return;
        }
        this.nativeFindNext(forward);
    }

    public int findAll(String find) {
        if (0 == this.mNativeClass) {
            return 0;
        }
        int result = find != null ? this.nativeFindAll(find.toLowerCase(), find.toUpperCase()) : 0;
        this.invalidate();
        this.mLastFind = find;
        return result;
    }

    public void setFindIsUp(boolean isUp) {
        this.mFindIsUp = isUp;
        if (isUp) {
            this.recordNewContentSize(this.mContentWidth, this.mContentHeight + this.mFindHeight, false);
        }
        if (0 == this.mNativeClass) {
            return;
        }
        this.nativeSetFindIsUp(isUp);
    }

    public int findIndex() {
        if (0 == this.mNativeClass) {
            return -1;
        }
        return this.nativeFindIndex();
    }

    public static String findAddress(String addr) {
        return WebView.findAddress(addr, false);
    }

    public static String findAddress(String addr, boolean caseInsensitive) {
        return WebViewCore.nativeFindAddress(addr, caseInsensitive);
    }

    public void clearMatches() {
        this.mLastFind = "";
        if (this.mNativeClass == 0) {
            return;
        }
        this.nativeSetFindIsEmpty();
        this.invalidate();
    }

    public void notifyFindDialogDismissed() {
        if (this.mWebViewCore == null) {
            return;
        }
        this.clearMatches();
        this.setFindIsUp(false);
        this.recordNewContentSize(this.mContentWidth, this.mContentHeight - this.mFindHeight, false);
        this.pinScrollTo(this.mScrollX, this.mScrollY, false, 0);
        this.invalidate();
    }

    public void setFindDialogHeight(int height) {
        this.mFindHeight = height;
    }

    public void documentHasImages(Message response) {
        if (response == null) {
            return;
        }
        this.mWebViewCore.sendMessage(120, response);
    }

    @Override
    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            int oldX = this.mScrollX;
            int oldY = this.mScrollY;
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            this.invalidate();
            if (oldX != x || oldY != y) {
                int rangeX = this.computeMaxScrollX();
                int rangeY = this.computeMaxScrollY();
                this.overScrollBy(x - oldX, y - oldY, oldX, oldY, rangeX, rangeY, this.mOverflingDistance, this.mOverflingDistance, false);
                if (this.mEdgeGlowTop != null) {
                    if (rangeY > 0 || this.getOverScrollMode() == 0) {
                        if (y < 0 && oldY >= 0) {
                            this.mEdgeGlowTop.onAbsorb((int)this.mScroller.getCurrVelocity());
                            if (!this.mEdgeGlowBottom.isFinished()) {
                                this.mEdgeGlowBottom.onRelease();
                            }
                        } else if (y > rangeY && oldY <= rangeY) {
                            this.mEdgeGlowBottom.onAbsorb((int)this.mScroller.getCurrVelocity());
                            if (!this.mEdgeGlowTop.isFinished()) {
                                this.mEdgeGlowTop.onRelease();
                            }
                        }
                    }
                    if (rangeX > 0) {
                        if (x < 0 && oldX >= 0) {
                            this.mEdgeGlowLeft.onAbsorb((int)this.mScroller.getCurrVelocity());
                            if (!this.mEdgeGlowRight.isFinished()) {
                                this.mEdgeGlowRight.onRelease();
                            }
                        } else if (x > rangeX && oldX <= rangeX) {
                            this.mEdgeGlowRight.onAbsorb((int)this.mScroller.getCurrVelocity());
                            if (!this.mEdgeGlowLeft.isFinished()) {
                                this.mEdgeGlowLeft.onRelease();
                            }
                        }
                    }
                }
            }
            if (this.mScroller.isFinished()) {
                this.mPrivateHandler.sendEmptyMessage(7);
            }
        } else {
            super.computeScroll();
        }
    }

    private static int computeDuration(int dx, int dy) {
        int distance = Math.max(Math.abs(dx), Math.abs(dy));
        int duration = distance * 1000 / 480;
        return Math.min(duration, 750);
    }

    private boolean pinScrollBy(int dx, int dy, boolean animate, int animationDuration) {
        return this.pinScrollTo(this.mScrollX + dx, this.mScrollY + dy, animate, animationDuration);
    }

    private boolean pinScrollTo(int x, int y, boolean animate, int animationDuration) {
        int dy;
        int dx = (x = this.pinLocX(x)) - this.mScrollX;
        if ((dx | (dy = (y = this.pinLocY(y)) - this.mScrollY)) == 0) {
            return false;
        }
        if (animate) {
            this.mScroller.startScroll(this.mScrollX, this.mScrollY, dx, dy, animationDuration > 0 ? animationDuration : WebView.computeDuration(dx, dy));
            this.awakenScrollBars(this.mScroller.getDuration());
            this.invalidate();
        } else {
            this.abortAnimation();
            this.scrollTo(x, y);
        }
        return true;
    }

    private boolean setContentScrollBy(int cx, int cy, boolean animate) {
        if (this.mDrawHistory) {
            return false;
        }
        cx = this.contentToViewDimension(cx);
        cy = this.contentToViewDimension(cy);
        if (this.mHeightCanMeasure) {
            if (cy != 0) {
                Rect tempRect = new Rect();
                this.calcOurVisibleRect(tempRect);
                tempRect.offset(cx, cy);
                this.requestRectangleOnScreen(tempRect);
            }
            return cy == 0 && cx != 0 && this.pinScrollBy(cx, 0, animate, 0);
        }
        return this.pinScrollBy(cx, cy, animate, 0);
    }

    void onPageFinished(String url) {
        if (this.mPageThatNeedsToSlideTitleBarOffScreen != null) {
            if (this.mPageThatNeedsToSlideTitleBarOffScreen.equals(url) && this.mScrollX == 0 && this.mScrollY == 0) {
                this.pinScrollTo(0, this.mYDistanceToSlideTitleOffScreen, true, 500);
            }
            this.mPageThatNeedsToSlideTitleBarOffScreen = null;
        }
    }

    private boolean setContentScrollTo(int cx, int cy) {
        int vy;
        int vx;
        if (this.mDrawHistory) {
            return false;
        }
        if ((cx | cy) == 0) {
            vx = 0;
            vy = 0;
        } else {
            vx = this.contentToViewX(cx);
            vy = this.contentToViewY(cy);
        }
        if (cx == 0 && cy == 1 && this.mScrollX == 0 && this.mScrollY == 0 && this.mTitleBar != null) {
            if (this.getProgress() < 100) {
                this.mPageThatNeedsToSlideTitleBarOffScreen = this.getUrl();
                this.mYDistanceToSlideTitleOffScreen = vy;
            } else {
                this.pinScrollTo(vx, vy, true, 500);
            }
            return false;
        }
        this.pinScrollTo(vx, vy, false, 0);
        return this.mScrollX != vx && cx >= 0 || this.mScrollY != vy && cy >= 0;
    }

    private void spawnContentScrollTo(int cx, int cy) {
        if (this.mDrawHistory) {
            return;
        }
        int vx = this.contentToViewX(cx);
        int vy = this.contentToViewY(cy);
        this.pinScrollTo(vx, vy, true, 0);
    }

    private void contentSizeChanged(boolean updateLayout) {
        if ((this.mContentWidth | this.mContentHeight) == 0) {
            return;
        }
        if (this.mHeightCanMeasure) {
            if (this.getMeasuredHeight() != this.contentToViewDimension(this.mContentHeight) || updateLayout) {
                this.requestLayout();
            }
        } else if (this.mWidthCanMeasure) {
            if (this.getMeasuredWidth() != this.contentToViewDimension(this.mContentWidth) || updateLayout) {
                this.requestLayout();
            }
        } else {
            this.sendViewSizeZoom();
        }
    }

    public void setWebViewClient(WebViewClient client) {
        this.mCallbackProxy.setWebViewClient(client);
    }

    public WebViewClient getWebViewClient() {
        return this.mCallbackProxy.getWebViewClient();
    }

    public void setDownloadListener(DownloadListener listener) {
        this.mCallbackProxy.setDownloadListener(listener);
    }

    public void setWebChromeClient(WebChromeClient client) {
        this.mCallbackProxy.setWebChromeClient(client);
    }

    public WebChromeClient getWebChromeClient() {
        return this.mCallbackProxy.getWebChromeClient();
    }

    public void setWebBackForwardListClient(WebBackForwardListClient client) {
        this.mCallbackProxy.setWebBackForwardListClient(client);
    }

    public WebBackForwardListClient getWebBackForwardListClient() {
        return this.mCallbackProxy.getWebBackForwardListClient();
    }

    public void setPictureListener(PictureListener listener) {
        this.mPictureListener = listener;
    }

    public void externalRepresentation(Message callback) {
        this.mWebViewCore.sendMessage(160, callback);
    }

    public void documentAsText(Message callback) {
        this.mWebViewCore.sendMessage(161, callback);
    }

    public void addJavascriptInterface(Object obj, String interfaceName) {
        WebViewCore.JSInterfaceData arg = new WebViewCore.JSInterfaceData();
        arg.mObject = obj;
        arg.mInterfaceName = interfaceName;
        this.mWebViewCore.sendMessage(138, arg);
    }

    public WebSettings getSettings() {
        return this.mWebViewCore.getSettings();
    }

    public void addPackageNames(Set<String> packageNames) {
        this.mWebViewCore.sendMessage(184, packageNames);
    }

    public void addPackageName(String packageName) {
        this.mWebViewCore.sendMessage(185, packageName);
    }

    public void removePackageName(String packageName) {
        this.mWebViewCore.sendMessage(186, packageName);
    }

    @Deprecated
    public static synchronized PluginList getPluginList() {
        return new PluginList();
    }

    @Deprecated
    public void refreshPlugins(boolean reloadOpenPages) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destroy();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    @Override
    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        if (child == this.mTitleBar) {
            this.mTitleBar.offsetLeftAndRight(this.mScrollX - this.mTitleBar.getLeft());
        }
        return super.drawChild(canvas, child, drawingTime);
    }

    private void drawContent(Canvas canvas) {
        this.nativeRecordButtons(this.hasFocus() && this.hasWindowFocus(), this.mTouchMode == 4 || this.mTrackballDown || this.mGotCenterDown, false);
        this.drawCoreAndCursorRing(canvas, this.mBackgroundColor, this.mDrawCursorRing);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (this.mNativeClass == 0) {
            return;
        }
        if ((this.mContentWidth | this.mContentHeight) == 0 && this.mHistoryPicture == null) {
            canvas.drawColor(this.mBackgroundColor);
            return;
        }
        int saveCount = canvas.save();
        if (this.mInOverScrollMode && !this.getSettings().getUseWebViewBackgroundForOverscrollBackground()) {
            if (mOverScrollBackground == null) {
                mOverScrollBackground = new Paint();
                Bitmap bm = BitmapFactory.decodeResource(this.mContext.getResources(), 17302240);
                mOverScrollBackground.setShader(new BitmapShader(bm, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT));
                mOverScrollBorder = new Paint();
                mOverScrollBorder.setStyle(Paint.Style.STROKE);
                mOverScrollBorder.setStrokeWidth(0.0f);
                mOverScrollBorder.setColor(-4473925);
            }
            int top = 0;
            int right = this.computeRealHorizontalScrollRange();
            int bottom = top + this.computeRealVerticalScrollRange();
            canvas.save();
            canvas.translate(this.mScrollX, this.mScrollY);
            canvas.clipRect(-this.mScrollX, top - this.mScrollY, right - this.mScrollX, bottom - this.mScrollY, Region.Op.DIFFERENCE);
            canvas.drawPaint(mOverScrollBackground);
            canvas.restore();
            canvas.drawRect(-1.0f, top - 1, right, bottom, mOverScrollBorder);
            canvas.clipRect(0, top, right, bottom);
        }
        if (this.mTitleBar != null) {
            canvas.translate(0.0f, this.mTitleBar.getHeight());
        }
        if (this.mDragTrackerHandler == null) {
            this.drawContent(canvas);
        } else {
            if (!this.mDragTrackerHandler.draw(canvas)) {
                this.drawContent(canvas);
            }
            if (this.mDragTrackerHandler.isFinished()) {
                this.mDragTrackerHandler = null;
            }
        }
        canvas.restoreToCount(saveCount);
        int titleH = this.getVisibleTitleHeight();
        if (this.mTitleBar != null && titleH == 0) {
            int height = (int)(5.0f * this.getContext().getResources().getDisplayMetrics().density);
            this.mTitleShadow.setBounds(this.mScrollX, this.mScrollY, this.mScrollX + this.getWidth(), this.mScrollY + height);
            this.mTitleShadow.draw(canvas);
        }
        if (this.inEditingMode()) {
            this.mWebTextView.onDrawSubstitute();
        }
        this.mWebViewCore.signalRepaintDone();
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mEdgeGlowTop != null && this.drawEdgeGlows(canvas)) {
            this.invalidate();
        }
    }

    private boolean drawEdgeGlows(Canvas canvas) {
        int restoreCount;
        int scrollX = this.mScrollX;
        int scrollY = this.mScrollY;
        int width = this.getWidth();
        int height = this.getHeight();
        boolean invalidateForGlow = false;
        if (!this.mEdgeGlowTop.isFinished()) {
            restoreCount = canvas.save();
            canvas.translate(-width / 2 + scrollX, Math.min(0, scrollY));
            this.mEdgeGlowTop.setSize(width * 2, height);
            invalidateForGlow |= this.mEdgeGlowTop.draw(canvas);
            canvas.restoreToCount(restoreCount);
        }
        if (!this.mEdgeGlowBottom.isFinished()) {
            restoreCount = canvas.save();
            canvas.translate(-width / 2 + scrollX, Math.max(this.computeMaxScrollY(), scrollY) + height);
            canvas.rotate(180.0f, width, 0.0f);
            this.mEdgeGlowBottom.setSize(width * 2, height);
            invalidateForGlow |= this.mEdgeGlowBottom.draw(canvas);
            canvas.restoreToCount(restoreCount);
        }
        if (!this.mEdgeGlowLeft.isFinished()) {
            restoreCount = canvas.save();
            canvas.rotate(270.0f);
            canvas.translate((float)(-height) * 1.5f - (float)scrollY, Math.min(0, scrollX));
            this.mEdgeGlowLeft.setSize(height * 2, width);
            invalidateForGlow |= this.mEdgeGlowLeft.draw(canvas);
            canvas.restoreToCount(restoreCount);
        }
        if (!this.mEdgeGlowRight.isFinished()) {
            restoreCount = canvas.save();
            canvas.rotate(90.0f);
            canvas.translate(-height / 2 + scrollY, -(Math.max(this.computeMaxScrollX(), scrollX) + width));
            this.mEdgeGlowRight.setSize(height * 2, width);
            invalidateForGlow |= this.mEdgeGlowRight.draw(canvas);
            canvas.restoreToCount(restoreCount);
        }
        return invalidateForGlow;
    }

    @Override
    public void setLayoutParams(ViewGroup.LayoutParams params) {
        if (params.height == -2) {
            this.mWrapContent = true;
        }
        super.setLayoutParams(params);
    }

    @Override
    public boolean performLongClick() {
        if (this.getParent() == null) {
            return false;
        }
        if (this.mNativeClass != 0 && this.nativeCursorIsTextInput()) {
            this.centerKeyPressOnTextField();
            this.rebuildWebTextView();
        } else {
            this.clearTextEntry(true);
        }
        if (this.inEditingMode()) {
            return this.mWebTextView.performLongClick();
        }
        if (super.performLongClick()) {
            return true;
        }
        if (this.mSelectingText) {
            return false;
        }
        int x = this.viewToContentX((int)this.mLastTouchX + this.mScrollX);
        int y = this.viewToContentY((int)this.mLastTouchY + this.mScrollY);
        this.setUpSelect();
        if (this.mNativeClass != 0 && this.nativeWordSelection(x, y)) {
            this.nativeSetExtendSelection();
            WebChromeClient client = this.getWebChromeClient();
            if (client != null) {
                client.onSelectionStart(this);
            }
            return true;
        }
        this.notifySelectDialogDismissed();
        return false;
    }

    boolean inAnimateZoom() {
        return this.mZoomScale != 0.0f;
    }

    private boolean didUpdateTextViewBounds(boolean allowIntersect) {
        Rect contentBounds = this.nativeFocusCandidateNodeBounds();
        Rect vBox = this.contentToViewRect(contentBounds);
        Rect visibleRect = new Rect();
        this.calcOurVisibleRect(visibleRect);
        if (allowIntersect ? Rect.intersects(visibleRect, vBox) : visibleRect.contains(vBox)) {
            this.mWebTextView.setRect(vBox.left, vBox.top, vBox.width(), vBox.height());
            this.mWebTextView.setTextSize(0, this.contentToViewDimension(this.nativeFocusCandidateTextSize()));
            return true;
        }
        this.mWebTextView.remove();
        return false;
    }

    private void drawExtras(Canvas canvas, int extras, boolean animationsRunning) {
        if (animationsRunning) {
            canvas.setDrawFilter(this.mWebViewCore.mZoomFilter);
        }
        this.nativeDrawExtras(canvas, extras);
        canvas.setDrawFilter(null);
    }

    private void drawCoreAndCursorRing(Canvas canvas, int color2, boolean drawCursorRing) {
        boolean animateScroll;
        if (this.mDrawHistory) {
            canvas.scale(this.mActualScale, this.mActualScale);
            canvas.drawPicture(this.mHistoryPicture);
            return;
        }
        boolean animateZoom = this.mZoomScale != 0.0f;
        boolean bl = animateScroll = (!this.mScroller.isFinished() || this.mVelocityTracker != null) && (this.mTouchMode != 3 || this.mHeldMotionless != 2) || this.mDeferTouchMode == 3;
        if (this.mTouchMode == 3) {
            if (this.mHeldMotionless == 1) {
                this.mPrivateHandler.removeMessages(8);
                this.mPrivateHandler.removeMessages(9);
                this.mHeldMotionless = 0;
            }
            if (this.mHeldMotionless == 0) {
                this.mPrivateHandler.sendMessageDelayed(this.mPrivateHandler.obtainMessage(8), 100L);
                this.mHeldMotionless = 1;
            }
        }
        if (animateZoom) {
            float zoomScale;
            int interval = (int)(SystemClock.uptimeMillis() - this.mZoomStart);
            if (interval < 500) {
                float ratio = (float)interval / 500.0f;
                zoomScale = 1.0f / (this.mInvInitialZoomScale + (this.mInvFinalZoomScale - this.mInvInitialZoomScale) * ratio);
                this.invalidate();
            } else {
                zoomScale = this.mZoomScale;
                this.mZoomScale = 0.0f;
                WebViewCore.resumeUpdatePicture(this.mWebViewCore);
                this.invalidate();
                if (this.mNeedToAdjustWebTextView) {
                    this.mNeedToAdjustWebTextView = false;
                    if (this.didUpdateTextViewBounds(false) && this.nativeFocusCandidateIsPassword()) {
                        this.mWebTextView.setInPassword(true);
                    }
                }
            }
            float scale = zoomScale * this.mInvInitialZoomScale;
            int tx = Math.round(scale * ((float)this.mInitialScrollX + this.mZoomCenterX) - this.mZoomCenterX);
            tx = -WebView.pinLoc(tx, this.getViewWidth(), Math.round((float)this.mContentWidth * zoomScale)) + this.mScrollX;
            int titleHeight = this.getTitleHeight();
            int ty = Math.round(scale * ((float)this.mInitialScrollY + this.mZoomCenterY - (float)titleHeight) - (this.mZoomCenterY - (float)titleHeight));
            ty = -(ty <= titleHeight ? Math.max(ty, 0) : WebView.pinLoc(ty - titleHeight, this.getViewHeight(), Math.round((float)this.mContentHeight * zoomScale)) + titleHeight) + this.mScrollY;
            canvas.translate(tx, ty);
            canvas.scale(zoomScale, zoomScale);
            if (this.inEditingMode() && !this.mNeedToAdjustWebTextView && this.mZoomScale != 0.0f) {
                this.mNeedToAdjustWebTextView = true;
                if (this.nativeFocusCandidateIsPassword()) {
                    this.mWebTextView.setInPassword(false);
                }
            }
        } else {
            canvas.scale(this.mActualScale, this.mActualScale);
        }
        boolean UIAnimationsRunning = false;
        if (this.mNativeClass != 0 && this.nativeEvaluateLayersAnimations()) {
            UIAnimationsRunning = true;
            this.invalidate();
        }
        this.mWebViewCore.drawContentPicture(canvas, color2, animateZoom || this.mPreviewZoomOnly || UIAnimationsRunning, animateScroll);
        if (this.mNativeClass == 0) {
            return;
        }
        int extras = 0;
        if (this.mFindIsUp) {
            extras = 1;
        } else if (this.mSelectingText) {
            extras = 2;
            this.nativeSetSelectionPointer(this.mDrawSelectionPointer, this.mInvActualScale, this.mSelectX, this.mSelectY - this.getTitleHeight());
        } else if (drawCursorRing) {
            extras = 3;
        }
        this.drawExtras(canvas, extras, UIAnimationsRunning);
        if (extras == 3 && this.mTouchMode == 4) {
            this.mTouchMode = 5;
        }
        if (this.mFocusSizeChanged) {
            this.mFocusSizeChanged = false;
            if (!animateZoom && this.inEditingMode()) {
                this.didUpdateTextViewBounds(true);
            }
        }
    }

    boolean drawHistory() {
        return this.mDrawHistory;
    }

    void switchOutDrawHistory() {
        if (null == this.mWebViewCore) {
            return;
        }
        if (this.mDrawHistory && this.mWebViewCore.pictureReady()) {
            this.mDrawHistory = false;
            this.mHistoryPicture = null;
            this.invalidate();
            int oldScrollX = this.mScrollX;
            int oldScrollY = this.mScrollY;
            this.mScrollX = this.pinLocX(this.mScrollX);
            this.mScrollY = this.pinLocY(this.mScrollY);
            if (oldScrollX != this.mScrollX || oldScrollY != this.mScrollY) {
                this.mUserScroll = false;
                this.mWebViewCore.sendMessage(131, oldScrollX, oldScrollY);
                this.onScrollChanged(this.mScrollX, this.mScrollY, oldScrollX, oldScrollY);
            } else {
                this.sendOurVisibleRect();
            }
        }
    }

    WebViewCore.CursorData cursorData() {
        WebViewCore.CursorData result = new WebViewCore.CursorData();
        result.mMoveGeneration = this.nativeMoveGeneration();
        result.mFrame = this.nativeCursorFramePointer();
        Point position = this.nativeCursorPosition();
        result.mX = position.x;
        result.mY = position.y;
        return result;
    }

    void deleteSelection(int start, int end) {
        ++this.mTextGeneration;
        WebViewCore.TextSelectionData data = new WebViewCore.TextSelectionData(start, end);
        this.mWebViewCore.sendMessage(122, this.mTextGeneration, 0, data);
    }

    void setSelection(int start, int end) {
        this.mWebViewCore.sendMessage(113, start, end);
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        InputConnection connection = super.onCreateInputConnection(outAttrs);
        outAttrs.imeOptions |= Integer.MIN_VALUE;
        return connection;
    }

    private void displaySoftKeyboard(boolean isTextView) {
        boolean zoom;
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        boolean bl = zoom = this.mActualScale < this.mDefaultScale;
        if (zoom) {
            this.mInZoomOverview = false;
            this.mZoomCenterX = this.mLastTouchX;
            this.mZoomCenterY = this.mLastTouchY;
            this.setNewZoomScale(this.mDefaultScale, false, false);
        }
        if (isTextView) {
            this.rebuildWebTextView();
            if (this.inEditingMode()) {
                imm.showSoftInput(this.mWebTextView, 0);
                if (zoom) {
                    this.didUpdateTextViewBounds(true);
                }
                return;
            }
        }
        imm.showSoftInput(this, 0);
    }

    private void hideSoftKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
    }

    void rebuildWebTextView() {
        if (!(this.hasFocus() || null != this.mWebTextView && this.mWebTextView.hasFocus())) {
            return;
        }
        boolean alreadyThere = this.inEditingMode();
        if (0 == this.mNativeClass || !this.nativeFocusCandidateIsTextInput()) {
            if (alreadyThere) {
                this.mWebTextView.remove();
            }
            return;
        }
        if (this.mWebTextView == null) {
            this.mWebTextView = new WebTextView(this.mContext, this);
            this.mTextGeneration = 0;
        }
        this.mWebTextView.setTextSize(0, this.contentToViewDimension(this.nativeFocusCandidateTextSize()));
        Rect visibleRect = new Rect();
        this.calcOurContentVisibleRect(visibleRect);
        Rect bounds = this.nativeFocusCandidateNodeBounds();
        Rect vBox = this.contentToViewRect(bounds);
        this.mWebTextView.setRect(vBox.left, vBox.top, vBox.width(), vBox.height());
        if (!Rect.intersects(bounds, visibleRect)) {
            this.mWebTextView.bringIntoView();
        }
        String text = this.nativeFocusCandidateText();
        int nodePointer = this.nativeFocusCandidatePointer();
        if (alreadyThere && this.mWebTextView.isSameTextField(nodePointer)) {
            if (text != null && !text.equals(this.mWebTextView.getText().toString()) && this.nativeTextGeneration() == this.mTextGeneration) {
                this.mWebTextView.setTextAndKeepSelection(text);
            }
        } else {
            this.mWebTextView.setGravity(this.nativeFocusCandidateIsRtlText() ? 5 : 0);
            this.mWebTextView.setNodePointer(nodePointer);
            this.mWebTextView.setType(this.nativeFocusCandidateType());
            Rect paddingRect = this.nativeFocusCandidatePaddingRect();
            if (paddingRect != null) {
                this.mWebTextView.setPadding(this.contentToViewDimension(paddingRect.left), this.contentToViewDimension(paddingRect.top), this.contentToViewDimension(paddingRect.right), this.contentToViewDimension(paddingRect.bottom));
            }
            if (null == text) {
                text = "";
            }
            this.mWebTextView.setTextAndKeepSelection(text);
            InputMethodManager imm = InputMethodManager.peekInstance();
            if (imm != null && imm.isActive(this.mWebTextView)) {
                imm.restartInput(this.mWebTextView);
            }
        }
        this.mWebTextView.requestFocus();
    }

    void requestFormData(String name, int nodePointer) {
        if (this.mWebViewCore.getSettings().getSaveFormData()) {
            Message update = this.mPrivateHandler.obtainMessage(6);
            update.arg1 = nodePointer;
            RequestFormData updater = new RequestFormData(name, this.getUrl(), update);
            Thread t = new Thread(updater);
            t.start();
        }
    }

    void requestLabel(int framePointer, int nodePointer) {
        this.mWebViewCore.sendMessage(97, framePointer, nodePointer);
    }

    public void dumpDisplayTree() {
        this.nativeDumpDisplayTree(this.getUrl());
    }

    public void dumpDomTree(boolean toFile) {
        this.mWebViewCore.sendMessage(170, toFile ? 1 : 0, 0);
    }

    public void dumpRenderTree(boolean toFile) {
        this.mWebViewCore.sendMessage(171, toFile ? 1 : 0, 0);
    }

    public void dumpV8Counters() {
        this.mWebViewCore.sendMessage(173);
    }

    @Override
    public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        if (keyCode == 0 && event.getCharacters() != null) {
            this.mWebViewCore.sendMessage(103, event);
            this.mWebViewCore.sendMessage(104, event);
            return true;
        }
        return false;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mNativeClass == 0) {
            return false;
        }
        if (event.isSystem() || this.mCallbackProxy.uiOverrideKeyEvent(event)) {
            return false;
        }
        if (keyCode == 59 || keyCode == 60) {
            if (this.nativeFocusIsPlugin()) {
                this.mShiftIsPressed = true;
            } else if (!this.nativeCursorWantsKeyEvents() && !this.mSelectingText) {
                this.setUpSelect();
            }
        }
        if (keyCode >= 19 && keyCode <= 22) {
            this.switchOutDrawHistory();
            if (this.nativeFocusIsPlugin()) {
                this.letPluginHandleNavKey(keyCode, event.getEventTime(), true);
                return true;
            }
            if (this.mSelectingText) {
                int xRate;
                int n = keyCode == 21 ? -1 : (xRate = keyCode == 22 ? 1 : 0);
                int yRate = keyCode == 19 ? -1 : (keyCode == 20 ? 1 : 0);
                int multiplier = event.getRepeatCount() + 1;
                this.moveSelection(xRate * multiplier, yRate * multiplier);
                return true;
            }
            if (this.navHandledKey(keyCode, 1, false, event.getEventTime())) {
                this.playSoundEffect(this.keyCodeToSoundsEffect(keyCode));
                return true;
            }
            return false;
        }
        if (keyCode == 23) {
            this.switchOutDrawHistory();
            if (event.getRepeatCount() == 0) {
                if (this.mSelectingText) {
                    return true;
                }
                this.mGotCenterDown = true;
                this.mPrivateHandler.sendMessageDelayed(this.mPrivateHandler.obtainMessage(114), 1000L);
                this.nativeRecordButtons(this.hasFocus() && this.hasWindowFocus(), true, true);
                return true;
            }
            return false;
        }
        if (keyCode != 59 && keyCode != 60) {
            this.selectionDone();
            this.mShiftIsPressed = false;
        }
        if (this.getSettings().getNavDump()) {
            switch (keyCode) {
                case 11: {
                    this.dumpDisplayTree();
                    break;
                }
                case 12: 
                case 13: {
                    this.dumpDomTree(keyCode == 12);
                    break;
                }
                case 14: 
                case 15: {
                    this.dumpRenderTree(keyCode == 14);
                    break;
                }
                case 16: {
                    this.nativeInstrumentReport();
                    return true;
                }
            }
        }
        if (this.nativeCursorIsTextInput()) {
            this.mWebViewCore.sendMessage(118, this.nativeCursorFramePointer(), this.nativeCursorNodePointer());
            this.rebuildWebTextView();
            if (this.inEditingMode()) {
                this.mWebTextView.setDefaultSelection();
                return this.mWebTextView.dispatchKeyEvent(event);
            }
        } else if (this.nativeHasFocusNode()) {
            this.rebuildWebTextView();
            if (this.inEditingMode()) {
                this.mWebTextView.setDefaultSelection();
                return this.mWebTextView.dispatchKeyEvent(event);
            }
        }
        if (!this.nativeCursorWantsKeyEvents()) {
            // empty if block
        }
        this.mWebViewCore.sendMessage(103, event);
        return true;
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.mNativeClass == 0) {
            return false;
        }
        if (keyCode == 5 && this.nativeHasCursorNode()) {
            String text = this.nativeCursorText();
            if (!this.nativeCursorIsTextInput() && text != null && text.startsWith(SCHEME_TEL)) {
                Intent intent = new Intent("android.intent.action.DIAL", Uri.parse(text));
                this.getContext().startActivity(intent);
                return true;
            }
        }
        if (event.isSystem() || this.mCallbackProxy.uiOverrideKeyEvent(event)) {
            return false;
        }
        if (keyCode == 59 || keyCode == 60) {
            if (this.nativeFocusIsPlugin()) {
                this.mShiftIsPressed = false;
            } else if (this.copySelection()) {
                this.selectionDone();
                return true;
            }
        }
        if (keyCode >= 19 && keyCode <= 22) {
            if (this.nativeFocusIsPlugin()) {
                this.letPluginHandleNavKey(keyCode, event.getEventTime(), false);
                return true;
            }
            return false;
        }
        if (keyCode == 23) {
            this.mPrivateHandler.removeMessages(114);
            this.mGotCenterDown = false;
            if (this.mSelectingText) {
                if (this.mExtendSelection) {
                    this.copySelection();
                    this.selectionDone();
                } else {
                    this.mExtendSelection = true;
                    this.nativeSetExtendSelection();
                    this.invalidate();
                }
                return true;
            }
            Rect visibleRect = this.sendOurVisibleRect();
            if (!this.nativeCursorIntersects(visibleRect)) {
                return false;
            }
            WebViewCore.CursorData data = this.cursorData();
            this.mWebViewCore.sendMessage(135, data);
            this.playSoundEffect(0);
            if (this.nativeCursorIsTextInput()) {
                this.rebuildWebTextView();
                this.centerKeyPressOnTextField();
                if (this.inEditingMode()) {
                    this.mWebTextView.setDefaultSelection();
                }
                return true;
            }
            this.clearTextEntry(true);
            this.nativeSetFollowedLink(true);
            if (!this.mCallbackProxy.uiOverrideUrlLoading(this.nativeCursorText())) {
                this.mWebViewCore.sendMessage(118, data.mFrame, this.nativeCursorNodePointer());
            }
            return true;
        }
        if (!this.nativeCursorWantsKeyEvents()) {
            // empty if block
        }
        this.mWebViewCore.sendMessage(104, event);
        return true;
    }

    public void setUpSelect() {
        if (0 == this.mNativeClass) {
            return;
        }
        if (this.inFullScreenMode()) {
            return;
        }
        if (this.mSelectingText) {
            return;
        }
        this.mExtendSelection = false;
        this.mDrawSelectionPointer = true;
        this.mSelectingText = true;
        WebViewCore.pauseUpdatePicture(this.mWebViewCore);
        this.nativeResetSelection();
        if (this.nativeHasCursorNode()) {
            Rect rect = this.nativeCursorNodeBounds();
            this.mSelectX = this.contentToViewX(rect.left);
            this.mSelectY = this.contentToViewY(rect.top);
        } else if (this.mLastTouchY > (float)this.getVisibleTitleHeight()) {
            this.mSelectX = this.mScrollX + (int)this.mLastTouchX;
            this.mSelectY = this.mScrollY + (int)this.mLastTouchY;
        } else {
            this.mSelectX = this.mScrollX + this.getViewWidth() / 2;
            this.mSelectY = this.mScrollY + this.getViewHeightWithTitle() / 2;
        }
        this.nativeHideCursor();
    }

    public void emulateShiftHeld() {
        this.setUpSelect();
    }

    public void selectAll() {
        if (0 == this.mNativeClass) {
            return;
        }
        if (this.inFullScreenMode()) {
            return;
        }
        if (!this.mSelectingText) {
            this.setUpSelect();
        }
        this.nativeSelectAll();
        this.mDrawSelectionPointer = false;
        this.mExtendSelection = true;
        this.invalidate();
    }

    public boolean selectDialogIsUp() {
        return this.mSelectingText;
    }

    public void notifySelectDialogDismissed() {
        this.mSelectingText = false;
        WebViewCore.resumeUpdatePicture(this.mWebViewCore);
    }

    public void selectionDone() {
        if (this.mSelectingText) {
            WebChromeClient client = this.getWebChromeClient();
            if (client != null) {
                client.onSelectionDone(this);
            }
            this.invalidate();
            this.notifySelectDialogDismissed();
        }
    }

    public boolean copySelection() {
        boolean copiedSomething = false;
        String selection = this.getSelection();
        if (selection != "") {
            Toast.makeText(this.mContext, 17040076, 0).show();
            copiedSomething = true;
            try {
                IClipboard clip = IClipboard.Stub.asInterface(ServiceManager.getService("clipboard"));
                clip.setClipboardText(selection);
            }
            catch (RemoteException e) {
                Log.e(LOGTAG, "Clipboard failed", e);
            }
        }
        this.invalidate();
        return copiedSomething;
    }

    public String getSelection() {
        if (this.mNativeClass == 0) {
            return "";
        }
        return this.nativeGetSelection();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.hasWindowFocus()) {
            this.setActive(true);
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        this.clearHelpers();
        this.dismissZoomControl();
        if (this.hasWindowFocus()) {
            this.setActive(false);
        }
        super.onDetachedFromWindow();
    }

    @Override
    @Deprecated
    public void onChildViewAdded(View parent, View child) {
    }

    @Override
    @Deprecated
    public void onChildViewRemoved(View p, View child) {
    }

    @Override
    @Deprecated
    public void onGlobalFocusChanged(View oldFocus, View newFocus) {
    }

    private void setActive(boolean active) {
        if (active) {
            if (this.hasFocus()) {
                this.mDrawCursorRing = true;
                if (this.mNativeClass != 0) {
                    this.nativeRecordButtons(true, false, true);
                    if (this.inEditingMode()) {
                        this.mWebViewCore.sendMessage(142, 1, 0);
                    }
                }
            } else {
                this.mDrawCursorRing = false;
            }
        } else {
            if (this.mWebViewCore != null && this.getSettings().getBuiltInZoomControls() && (this.mZoomButtonsController == null || !this.mZoomButtonsController.isVisible())) {
                this.mDrawCursorRing = false;
            }
            this.mGotKeyDown = false;
            this.mShiftIsPressed = false;
            this.mPrivateHandler.removeMessages(4);
            this.mTouchMode = 7;
            if (this.mNativeClass != 0) {
                this.nativeRecordButtons(false, false, true);
            }
            this.setFocusControllerInactive();
        }
        this.invalidate();
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        this.setActive(hasWindowFocus);
        if (hasWindowFocus) {
            JWebCoreJavaBridge.setActiveWebView(this);
        } else {
            JWebCoreJavaBridge.removeActiveWebView(this);
        }
        super.onWindowFocusChanged(hasWindowFocus);
    }

    void setFocusControllerInactive() {
        if (this.mNativeClass == 0) {
            return;
        }
        this.mWebViewCore.sendMessage(142, 0, 0);
    }

    @Override
    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        if (focused) {
            if (this.hasWindowFocus()) {
                this.mDrawCursorRing = true;
                if (this.mNativeClass != 0) {
                    this.nativeRecordButtons(true, false, true);
                }
            }
        } else {
            if (!this.inEditingMode()) {
                this.mDrawCursorRing = false;
                if (this.mNativeClass != 0) {
                    this.nativeRecordButtons(false, false, true);
                }
                this.setFocusControllerInactive();
            }
            this.mGotKeyDown = false;
        }
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
    }

    @Override
    protected boolean setFrame(int left, int top, int right, int bottom) {
        boolean changed = super.setFrame(left, top, right, bottom);
        if (!changed && this.mHeightCanMeasure) {
            this.sendViewSizeZoom();
        }
        return changed;
    }

    @Override
    protected void onSizeChanged(int w, int h, int ow, int oh) {
        int newMaxViewportWidth;
        super.onSizeChanged(w, h, ow, oh);
        if (this.mZoomScale == 0.0f) {
            this.mZoomCenterX = 0.0f;
            this.mZoomCenterY = this.getVisibleTitleHeight();
            this.mAnchorX = this.viewToContentX((int)this.mZoomCenterX + this.mScrollX);
            this.mAnchorY = this.viewToContentY((int)this.mZoomCenterY + this.mScrollY);
        }
        if ((newMaxViewportWidth = (int)((float)Math.max(w, h) / DEFAULT_MIN_ZOOM_SCALE)) > sMaxViewportWidth) {
            sMaxViewportWidth = newMaxViewportWidth;
        }
        if (!this.mMinZoomScaleFixed) {
            float initialScale;
            this.mMinZoomScale = Math.min(1.0f, (float)this.getViewWidth() / (float)(this.mDrawHistory ? this.mHistoryPicture.getWidth() : this.mZoomOverviewWidth));
            if (this.mInitialScaleInPercent > 0 && this.mMinZoomScale > (initialScale = (float)this.mInitialScaleInPercent / 100.0f)) {
                this.mMinZoomScale = initialScale;
            }
        }
        this.dismissZoomControl();
        this.post(new PostScale(this, w != ow));
    }

    @Override
    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (!this.mInOverScrollMode) {
            this.sendOurVisibleRect();
            int titleHeight = this.getTitleHeight();
            if (Math.max(titleHeight - t, 0) != Math.max(titleHeight - oldt, 0)) {
                this.sendViewSizeZoom();
            }
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean dispatch = true;
        if (!(this.inEditingMode() || this.mNativeClass != 0 && this.nativeFocusIsPlugin())) {
            if (event.getAction() == 0) {
                this.mGotKeyDown = true;
            } else {
                if (!this.mGotKeyDown) {
                    dispatch = false;
                }
                this.mGotKeyDown = false;
            }
        }
        if (dispatch) {
            return super.dispatchKeyEvent(event);
        }
        return false;
    }

    private static int sign(float x) {
        return x > 0.0f ? 1 : (x < 0.0f ? -1 : 0);
    }

    public DragTracker getDragTracker() {
        return this.mDragTracker;
    }

    public void setDragTracker(DragTracker tracker) {
        this.mDragTracker = tracker;
    }

    private boolean hitFocusedPlugin(int contentX, int contentY) {
        return this.nativeFocusIsPlugin() && this.nativeFocusNodeBounds().contains(contentX, contentY);
    }

    private boolean shouldForwardTouchEvent() {
        return this.mFullScreenHolder != null || this.mForwardTouchEvents && !this.mSelectingText && this.mPreventDefault != 4;
    }

    private boolean inFullScreenMode() {
        return this.mFullScreenHolder != null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mNativeClass == 0 || !this.isClickable() && !this.isLongClickable()) {
            return false;
        }
        eventTime = ev.getEventTime();
        if (!this.mSupportMultiTouch || ev.getPointerCount() <= 1) ** GOTO lbl29
        if (this.mAllowPanAndScale || this.mMinZoomScale < this.mMaxZoomScale) {
            this.mScaleDetector.onTouchEvent(ev);
            if (this.mScaleDetector.isInProgress()) {
                this.mLastTouchTime = eventTime;
                if (!this.mAllowPanAndScale) {
                    return true;
                }
                this.mPrivateHandler.removeMessages(3);
                this.mPrivateHandler.removeMessages(4);
            }
            x = this.mScaleDetector.getFocusX();
            y = this.mScaleDetector.getFocusY();
            action = ev.getAction() & 255;
            if (action == 5) {
                this.cancelTouch();
                action = 0;
            } else if (action == 6) {
                this.mLastTouchX = x;
                this.mLastTouchY = y;
            } else if (action == 2 && (x < 0.0f || y < 0.0f)) {
                return true;
            }
        } else {
            return true;
lbl29:
            // 1 sources

            action = ev.getAction();
            x = ev.getX();
            y = ev.getY();
        }
        if (x > (float)(this.getViewWidth() - 1)) {
            x = this.getViewWidth() - 1;
        }
        if (y > (float)(this.getViewHeightWithTitle() - 1)) {
            y = this.getViewHeightWithTitle() - 1;
        }
        fDeltaX = this.mLastTouchX - x;
        fDeltaY = this.mLastTouchY - y;
        deltaX = (int)fDeltaX;
        deltaY = (int)fDeltaY;
        contentX = this.viewToContentX((int)x + this.mScrollX);
        contentY = this.viewToContentY((int)y + this.mScrollY);
        switch (action) {
            case 0: {
                this.mPreventDefault = 0;
                this.mConfirmMove = false;
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                    this.mTouchMode = 2;
                    this.mConfirmMove = true;
                    this.mPrivateHandler.removeMessages(7);
                } else if (this.mPrivateHandler.hasMessages(5)) {
                    this.mPrivateHandler.removeMessages(5);
                    if (deltaX * deltaX + deltaY * deltaY < this.mDoubleTapSlopSquare) {
                        this.mTouchMode = 6;
                    } else {
                        this.doShortPress();
                        this.mTouchMode = 1;
                        this.mDeferTouchProcess = this.inFullScreenMode() == false && this.mForwardTouchEvents != false ? this.hitFocusedPlugin(contentX, contentY) : false;
                    }
                } else {
                    this.mPreviewZoomOnly = false;
                    this.mTouchMode = 1;
                    this.mDeferTouchProcess = this.inFullScreenMode() == false && this.mForwardTouchEvents != false ? this.hitFocusedPlugin(contentX, contentY) : false;
                    this.mWebViewCore.sendMessage(98);
                    if (WebView.mLogEvent && eventTime - this.mLastTouchUpTime < 1000L) {
                        EventLog.writeEvent(70102, new Object[]{eventTime - this.mLastTouchUpTime, eventTime});
                    }
                    if (this.mSelectingText) {
                        this.mDrawSelectionPointer = false;
                        this.mSelectionStarted = this.nativeStartSelection(contentX, contentY);
                        this.invalidate();
                    }
                }
                if (this.mTouchMode == 1 || this.mTouchMode == 6) {
                    this.mPrivateHandler.sendEmptyMessageDelayed(3, 200L);
                    this.mPrivateHandler.sendEmptyMessageDelayed(4, 1000L);
                    this.mPreventDefault = this.inFullScreenMode() != false || this.mDeferTouchProcess != false ? 3 : (this.mForwardTouchEvents != false ? 1 : 0);
                    if (this.shouldForwardTouchEvent()) {
                        ted = new WebViewCore.TouchEventData();
                        ted.mAction = action;
                        ted.mX = contentX;
                        ted.mY = contentY;
                        ted.mMetaState = ev.getMetaState();
                        ted.mReprocess = this.mDeferTouchProcess;
                        if (this.mDeferTouchProcess) {
                            this.mLastTouchX = x;
                            this.mLastTouchY = y;
                            ted.mViewX = x;
                            ted.mViewY = y;
                            this.mWebViewCore.sendMessage(141, ted);
                            break;
                        }
                        this.mWebViewCore.sendMessage(141, ted);
                        if (!this.inFullScreenMode()) {
                            this.mPrivateHandler.sendMessageDelayed(this.mPrivateHandler.obtainMessage(10, action, 0), 200L);
                        }
                    }
                }
                this.startTouch(x, y, eventTime);
                break;
            }
            case 2: {
                firstMove = false;
                if (!this.mConfirmMove && deltaX * deltaX + deltaY * deltaY >= this.mTouchSlopSquare) {
                    this.mPrivateHandler.removeMessages(3);
                    this.mPrivateHandler.removeMessages(4);
                    this.mConfirmMove = true;
                    firstMove = true;
                    if (this.mTouchMode == 6) {
                        this.mTouchMode = 1;
                    }
                }
                if (this.shouldForwardTouchEvent() && this.mConfirmMove && (firstMove || eventTime - this.mLastSentTouchTime > (long)this.mCurrentTouchInterval)) {
                    this.mLastSentTouchTime = eventTime;
                    ted = new WebViewCore.TouchEventData();
                    ted.mAction = action;
                    ted.mX = contentX;
                    ted.mY = contentY;
                    ted.mMetaState = ev.getMetaState();
                    ted.mReprocess = this.mDeferTouchProcess;
                    if (this.mDeferTouchProcess) {
                        ted.mViewX = x;
                        ted.mViewY = y;
                        this.mWebViewCore.sendMessage(141, ted);
                        break;
                    }
                    this.mWebViewCore.sendMessage(141, ted);
                    if (firstMove && !this.inFullScreenMode()) {
                        this.mPrivateHandler.sendMessageDelayed(this.mPrivateHandler.obtainMessage(10, action, 0), 200L);
                    }
                }
                if (this.mTouchMode == 7 || this.mPreventDefault == 3) break;
                if (this.mVelocityTracker == null) {
                    Log.e("webview", "Got null mVelocityTracker when mPreventDefault = " + this.mPreventDefault + " mDeferTouchProcess = " + this.mDeferTouchProcess + " mTouchMode = " + this.mTouchMode);
                }
                this.mVelocityTracker.addMovement(ev);
                if (this.mSelectingText && this.mSelectionStarted) {
                    this.nativeExtendSelection(contentX, contentY);
                    this.invalidate();
                    break;
                }
                if (this.mTouchMode != 3) {
                    if (!this.mConfirmMove) break;
                    if (this.mPreventDefault == 1 || this.mPreventDefault == 2) {
                        this.mLastTouchTime = eventTime;
                        break;
                    }
                    if (this.mScaleDetector != null && !this.mScaleDetector.isInProgress()) {
                        ax = Math.abs(deltaX);
                        if ((float)ax > 1.5f * (float)(ay = Math.abs(deltaY))) {
                            this.mSnapScrollMode = 2;
                            this.mSnapPositive = deltaX > 0;
                        } else if ((float)ay > 1.5f * (float)ax) {
                            this.mSnapScrollMode = 4;
                            this.mSnapPositive = deltaY > 0;
                        }
                    }
                    this.mTouchMode = 3;
                    this.mLastTouchX = x;
                    this.mLastTouchY = y;
                    fDeltaX = 0.0f;
                    fDeltaY = 0.0f;
                    deltaX = 0;
                    deltaY = 0;
                    this.startDrag();
                }
                if (this.mDragTrackerHandler != null) {
                    this.mDragTrackerHandler.dragTo(x, y);
                }
                done = false;
                keepScrollBarsVisible = false;
                if (Math.abs(fDeltaX) < 1.0f && Math.abs(fDeltaY) < 1.0f) {
                    this.mLastTouchX = x;
                    this.mLastTouchY = y;
                    done = true;
                    keepScrollBarsVisible = true;
                } else {
                    if (this.mSnapScrollMode == 2 || this.mSnapScrollMode == 4) {
                        ax = Math.abs(deltaX);
                        ay = Math.abs(deltaY);
                        if (this.mSnapScrollMode == 2) {
                            if ((float)ay > 1.5f * (float)ax && ay > 80) {
                                this.mSnapScrollMode = 0;
                            }
                            if ((float)ax > 1.5f * (float)ay && (this.mSnapPositive != false ? deltaX < -this.mMinLockSnapReverseDistance : deltaX > this.mMinLockSnapReverseDistance)) {
                                this.mSnapScrollMode |= 1;
                            }
                        } else {
                            if ((float)ax > 1.5f * (float)ay && ax > 80) {
                                this.mSnapScrollMode = 0;
                            }
                            if ((float)ay > 1.5f * (float)ax && (this.mSnapPositive != false ? deltaY < -this.mMinLockSnapReverseDistance : deltaY > this.mMinLockSnapReverseDistance)) {
                                this.mSnapScrollMode |= 1;
                            }
                        }
                    }
                    if (this.mSnapScrollMode != 0) {
                        if ((this.mSnapScrollMode & 2) == 2) {
                            deltaY = 0;
                        } else {
                            deltaX = 0;
                        }
                    }
                    if ((deltaX | deltaY) != 0) {
                        if (deltaX != 0) {
                            this.mLastTouchX = x;
                        }
                        if (deltaY != 0) {
                            this.mLastTouchY = y;
                        }
                        this.mHeldMotionless = 0;
                    } else {
                        this.mLastTouchX = x;
                        this.mLastTouchY = y;
                        keepScrollBarsVisible = true;
                    }
                    this.mLastTouchTime = eventTime;
                    this.mUserScroll = true;
                }
                this.doDrag(deltaX, deltaY);
                if (!keepScrollBarsVisible) break;
                if (this.mHeldMotionless != 2) {
                    this.mHeldMotionless = 2;
                    this.invalidate();
                }
                this.awakenScrollBars(ViewConfiguration.getScrollDefaultDelay(), false);
                return done == false;
            }
            case 1: {
                if (this.shouldForwardTouchEvent()) {
                    ted = new WebViewCore.TouchEventData();
                    ted.mAction = action;
                    ted.mX = contentX;
                    ted.mY = contentY;
                    ted.mMetaState = ev.getMetaState();
                    ted.mReprocess = this.mDeferTouchProcess;
                    if (this.mDeferTouchProcess) {
                        ted.mViewX = x;
                        ted.mViewY = y;
                    }
                    this.mWebViewCore.sendMessage(141, ted);
                }
                this.mLastTouchUpTime = eventTime;
                switch (this.mTouchMode) {
                    case 6: {
                        this.mPrivateHandler.removeMessages(3);
                        this.mPrivateHandler.removeMessages(4);
                        if (this.inFullScreenMode() || this.mDeferTouchProcess) {
                            ted = new WebViewCore.TouchEventData();
                            ted.mAction = 512;
                            ted.mX = contentX;
                            ted.mY = contentY;
                            ted.mMetaState = ev.getMetaState();
                            ted.mReprocess = this.mDeferTouchProcess;
                            if (this.mDeferTouchProcess) {
                                ted.mViewX = x;
                                ted.mViewY = y;
                            }
                            this.mWebViewCore.sendMessage(141, ted);
                            break;
                        }
                        if (this.mPreventDefault == 3) break;
                        this.doDoubleTap();
                        this.mTouchMode = 7;
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        this.mPrivateHandler.removeMessages(3);
                        this.mPrivateHandler.removeMessages(4);
                        if (!this.mConfirmMove) ** GOTO lbl249
                        Log.w("webview", "Miss a drag as we are waiting for WebCore's response for touch down.");
                        if (this.mPreventDefault != 3 && (this.computeMaxScrollX() > 0 || this.computeMaxScrollY() > 0)) {
                            this.cancelWebCoreTouchEvent(contentX, contentY, true);
                            WebViewCore.reducePriority();
                            WebViewCore.pauseUpdatePicture(this.mWebViewCore);
                        } else {
                            this.invalidate();
                            break;
lbl249:
                            // 1 sources

                            if (this.mSelectingText) {
                                if (this.nativeHitSelection(contentX, contentY)) {
                                    this.copySelection();
                                }
                                this.selectionDone();
                                break;
                            }
                            if (this.mTouchMode == 1) {
                                this.mPrivateHandler.sendEmptyMessageDelayed(5, ViewConfiguration.getDoubleTapTimeout());
                                break;
                            }
                            this.doShortPress();
                            break;
                        }
                    }
                    case 3: {
                        this.mPrivateHandler.removeMessages(8);
                        this.mPrivateHandler.removeMessages(9);
                        if (eventTime - this.mLastTouchTime <= 250L) {
                            if (this.mVelocityTracker == null) {
                                Log.e("webview", "Got null mVelocityTracker when mPreventDefault = " + this.mPreventDefault + " mDeferTouchProcess = " + this.mDeferTouchProcess);
                            }
                            this.mVelocityTracker.addMovement(ev);
                            this.mHeldMotionless = 3;
                            this.doFling();
                            break;
                        }
                        if (this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, this.computeMaxScrollX(), 0, this.computeMaxScrollY())) {
                            this.invalidate();
                        }
                        this.mHeldMotionless = 2;
                        this.invalidate();
                    }
                    case 2: {
                        this.mLastVelocity = 0.0f;
                        WebViewCore.resumePriority();
                        WebViewCore.resumeUpdatePicture(this.mWebViewCore);
                    }
                }
                this.stopTouch();
                break;
            }
            case 3: {
                if (this.mTouchMode == 3) {
                    this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, this.computeMaxScrollX(), 0, this.computeMaxScrollY());
                    this.invalidate();
                }
                this.cancelWebCoreTouchEvent(contentX, contentY, false);
                this.cancelTouch();
            }
        }
        return true;
    }

    private void cancelWebCoreTouchEvent(int x, int y, boolean removeEvents) {
        if (this.shouldForwardTouchEvent()) {
            if (removeEvents) {
                this.mWebViewCore.removeMessages(141);
            }
            WebViewCore.TouchEventData ted = new WebViewCore.TouchEventData();
            ted.mX = x;
            ted.mY = y;
            ted.mAction = 3;
            this.mWebViewCore.sendMessage(141, ted);
            this.mPreventDefault = 4;
        }
    }

    private void startTouch(float x, float y, long eventTime) {
        this.mLastTouchX = x;
        this.mLastTouchY = y;
        this.mLastTouchTime = eventTime;
        this.mVelocityTracker = VelocityTracker.obtain();
        this.mSnapScrollMode = 0;
        if (this.mDragTracker != null) {
            this.mDragTrackerHandler = new DragTrackerHandler(x, y, this.mDragTracker);
        }
    }

    private void startDrag() {
        WebSettings settings;
        WebViewCore.reducePriority();
        WebViewCore.pauseUpdatePicture(this.mWebViewCore);
        if (!this.mDragFromTextInput) {
            this.nativeHideCursor();
        }
        if ((settings = this.getSettings()).supportZoom() && settings.getBuiltInZoomControls() && !this.getZoomButtonsController().isVisible() && this.mMinZoomScale < this.mMaxZoomScale && (this.mHorizontalScrollBarMode != 1 || this.mVerticalScrollBarMode != 1)) {
            this.mZoomButtonsController.setVisible(true);
            int count = settings.getDoubleTapToastCount();
            if (this.mInZoomOverview && count > 0) {
                settings.setDoubleTapToastCount(--count);
                Toast.makeText(this.mContext, 17040062, 1).show();
            }
        }
    }

    private void doDrag(int deltaX, int deltaY) {
        if ((deltaX | deltaY) != 0) {
            int oldX = this.mScrollX;
            int oldY = this.mScrollY;
            int rangeX = this.computeMaxScrollX();
            int rangeY = this.computeMaxScrollY();
            if (this.mEdgeGlowTop != null) {
                this.mOverscrollDeltaX = deltaX;
                this.mOverscrollDeltaY = deltaY;
            }
            this.overScrollBy(deltaX, deltaY, oldX, oldY, rangeX, rangeY, this.mOverscrollDistance, this.mOverscrollDistance, true);
            if (!(this.mEdgeGlowTop == null || this.mEdgeGlowTop.isFinished() && this.mEdgeGlowBottom.isFinished() && this.mEdgeGlowLeft.isFinished() && this.mEdgeGlowRight.isFinished())) {
                this.invalidate();
            }
        }
        if (!this.getSettings().getBuiltInZoomControls()) {
            boolean showPlusMinus;
            boolean bl = showPlusMinus = this.mMinZoomScale < this.mMaxZoomScale;
            if (this.mZoomControls != null && showPlusMinus) {
                if (this.mZoomControls.getVisibility() == 0) {
                    this.mPrivateHandler.removeCallbacks(this.mZoomControlRunnable);
                } else {
                    this.mZoomControls.show(showPlusMinus, false);
                }
                this.mPrivateHandler.postDelayed(this.mZoomControlRunnable, ZOOM_CONTROLS_TIMEOUT);
            }
        }
    }

    private void stopTouch() {
        if (this.mDragTrackerHandler != null) {
            this.mDragTrackerHandler.stopDrag();
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        if (this.mEdgeGlowTop != null) {
            this.mEdgeGlowTop.onRelease();
            this.mEdgeGlowBottom.onRelease();
            this.mEdgeGlowLeft.onRelease();
            this.mEdgeGlowRight.onRelease();
        }
    }

    private void cancelTouch() {
        if (this.mDragTrackerHandler != null) {
            this.mDragTrackerHandler.stopDrag();
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        if (this.mEdgeGlowTop != null) {
            this.mEdgeGlowTop.onRelease();
            this.mEdgeGlowBottom.onRelease();
            this.mEdgeGlowLeft.onRelease();
            this.mEdgeGlowRight.onRelease();
        }
        if (this.mTouchMode == 3) {
            WebViewCore.resumePriority();
            WebViewCore.resumeUpdatePicture(this.mWebViewCore);
        }
        this.mPrivateHandler.removeMessages(3);
        this.mPrivateHandler.removeMessages(4);
        this.mPrivateHandler.removeMessages(8);
        this.mPrivateHandler.removeMessages(9);
        this.mHeldMotionless = 2;
        this.mTouchMode = 7;
        this.nativeHideCursor();
    }

    public void setMapTrackballToArrowKeys(boolean setMap) {
        this.mMapTrackballToArrowKeys = setMap;
    }

    void resetTrackballTime() {
        this.mTrackballLastTime = 0L;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent ev) {
        long time = ev.getEventTime();
        if ((ev.getMetaState() & 2) != 0) {
            if (ev.getY() > 0.0f) {
                this.pageDown(true);
            }
            if (ev.getY() < 0.0f) {
                this.pageUp(true);
            }
            return true;
        }
        if (ev.getAction() == 0) {
            if (this.mSelectingText) {
                return true;
            }
            this.mTrackballDown = true;
            if (this.mNativeClass == 0) {
                return false;
            }
            this.nativeRecordButtons(this.hasFocus() && this.hasWindowFocus(), true, true);
            if (time - this.mLastCursorTime <= 200L && !this.mLastCursorBounds.equals(this.nativeGetCursorRingBounds())) {
                this.nativeSelectBestAt(this.mLastCursorBounds);
            }
            if (this.isInTouchMode()) {
                this.requestFocusFromTouch();
            }
            return false;
        }
        if (ev.getAction() == 1) {
            this.mPrivateHandler.removeMessages(114);
            this.mTrackballDown = false;
            this.mTrackballUpTime = time;
            if (this.mSelectingText) {
                if (this.mExtendSelection) {
                    this.copySelection();
                    this.selectionDone();
                } else {
                    this.mExtendSelection = true;
                    this.nativeSetExtendSelection();
                    this.invalidate();
                }
                return true;
            }
            return false;
        }
        if (this.mMapTrackballToArrowKeys && !this.mShiftIsPressed) {
            return false;
        }
        if (this.mTrackballDown) {
            return true;
        }
        if (time - this.mTrackballUpTime < 200L) {
            return true;
        }
        this.switchOutDrawHistory();
        if (time - this.mTrackballLastTime > 200L) {
            this.mTrackballFirstTime = time;
            this.mTrackballYMove = 0;
            this.mTrackballXMove = 0;
        }
        this.mTrackballLastTime = time;
        this.mTrackballRemainsX += ev.getX();
        this.mTrackballRemainsY += ev.getY();
        this.doTrackball(time);
        return true;
    }

    void moveSelection(float xRate, float yRate) {
        int scrollX;
        if (this.mNativeClass == 0) {
            return;
        }
        int width = this.getViewWidth();
        int height = this.getViewHeight();
        this.mSelectX = (int)((float)this.mSelectX + xRate);
        this.mSelectY = (int)((float)this.mSelectY + yRate);
        int maxX = width + this.mScrollX;
        int maxY = height + this.mScrollY;
        this.mSelectX = Math.min(maxX, Math.max(this.mScrollX - 16, this.mSelectX));
        this.mSelectY = Math.min(maxY, Math.max(this.mScrollY - 16, this.mSelectY));
        this.nativeMoveSelection(this.viewToContentX(this.mSelectX), this.viewToContentY(this.mSelectY));
        int n = this.mSelectX < this.mScrollX ? -16 : (scrollX = this.mSelectX > maxX - 16 ? 16 : 0);
        int scrollY = this.mSelectY < this.mScrollY ? -16 : (this.mSelectY > maxY - 16 ? 16 : 0);
        this.pinScrollBy(scrollX, scrollY, true, 0);
        Rect select = new Rect(this.mSelectX, this.mSelectY, this.mSelectX + 1, this.mSelectY + 1);
        this.requestRectangleOnScreen(select);
        this.invalidate();
    }

    private int scaleTrackballX(float xRate, int width) {
        int xMove;
        int nextXMove = xMove = (int)(xRate / 400.0f * (float)width);
        if (xMove > 0) {
            if (xMove > this.mTrackballXMove) {
                xMove -= this.mTrackballXMove;
            }
        } else if (xMove < this.mTrackballXMove) {
            xMove -= this.mTrackballXMove;
        }
        this.mTrackballXMove = nextXMove;
        return xMove;
    }

    private int scaleTrackballY(float yRate, int height) {
        int yMove;
        int nextYMove = yMove = (int)(yRate / 400.0f * (float)height);
        if (yMove > 0) {
            if (yMove > this.mTrackballYMove) {
                yMove -= this.mTrackballYMove;
            }
        } else if (yMove < this.mTrackballYMove) {
            yMove -= this.mTrackballYMove;
        }
        this.mTrackballYMove = nextYMove;
        return yMove;
    }

    private int keyCodeToSoundsEffect(int keyCode) {
        switch (keyCode) {
            case 19: {
                return 2;
            }
            case 22: {
                return 3;
            }
            case 20: {
                return 4;
            }
            case 21: {
                return 1;
            }
        }
        throw new IllegalArgumentException("keyCode must be one of {KEYCODE_DPAD_UP, KEYCODE_DPAD_RIGHT, KEYCODE_DPAD_DOWN, KEYCODE_DPAD_LEFT}.");
    }

    private void doTrackball(long time) {
        int elapsed = (int)(this.mTrackballLastTime - this.mTrackballFirstTime);
        if (elapsed == 0) {
            elapsed = 200;
        }
        float xRate = this.mTrackballRemainsX * 1000.0f / (float)elapsed;
        float yRate = this.mTrackballRemainsY * 1000.0f / (float)elapsed;
        int viewWidth = this.getViewWidth();
        int viewHeight = this.getViewHeight();
        if (this.mSelectingText) {
            if (!this.mDrawSelectionPointer) {
                this.mSelectX = this.contentToViewX(this.nativeSelectionX());
                this.mSelectY = this.contentToViewY(this.nativeSelectionY());
                this.mExtendSelection = true;
                this.mDrawSelectionPointer = true;
                this.nativeSetExtendSelection();
            }
            this.moveSelection(this.scaleTrackballX(xRate, viewWidth), this.scaleTrackballY(yRate, viewHeight));
            this.mTrackballRemainsY = 0.0f;
            this.mTrackballRemainsX = 0.0f;
            return;
        }
        float ax = Math.abs(xRate);
        float ay = Math.abs(yRate);
        float maxA = Math.max(ax, ay);
        int width = this.mContentWidth - viewWidth;
        int height = this.mContentHeight - viewHeight;
        if (width < 0) {
            width = 0;
        }
        if (height < 0) {
            height = 0;
        }
        ax = Math.abs(this.mTrackballRemainsX * 3.0f);
        ay = Math.abs(this.mTrackballRemainsY * 3.0f);
        maxA = Math.max(ax, ay);
        int count = Math.max(0, (int)maxA);
        int oldScrollX = this.mScrollX;
        int oldScrollY = this.mScrollY;
        if (count > 0) {
            int selectKeyCode = ax < ay ? (this.mTrackballRemainsY < 0.0f ? 19 : 20) : (this.mTrackballRemainsX < 0.0f ? 21 : 22);
            count = Math.min(count, 10);
            if (this.mNativeClass != 0 && this.nativeFocusIsPlugin()) {
                for (int i = 0; i < count; ++i) {
                    this.letPluginHandleNavKey(selectKeyCode, time, true);
                }
                this.letPluginHandleNavKey(selectKeyCode, time, false);
            } else if (this.navHandledKey(selectKeyCode, count, false, time)) {
                this.playSoundEffect(this.keyCodeToSoundsEffect(selectKeyCode));
            }
            this.mTrackballRemainsY = 0.0f;
            this.mTrackballRemainsX = 0.0f;
        }
        if (count >= 5) {
            int xMove = this.scaleTrackballX(xRate, width);
            int yMove = this.scaleTrackballY(yRate, height);
            if (Math.abs(this.mScrollX - oldScrollX) > Math.abs(xMove)) {
                xMove = 0;
            }
            if (Math.abs(this.mScrollY - oldScrollY) > Math.abs(yMove)) {
                yMove = 0;
            }
            if (xMove != 0 || yMove != 0) {
                this.pinScrollBy(xMove, yMove, true, 0);
            }
            this.mUserScroll = true;
        }
    }

    private int computeMaxScrollX() {
        return Math.max(this.computeRealHorizontalScrollRange() - this.getViewWidth(), 0);
    }

    private int computeMaxScrollY() {
        return Math.max(this.computeRealVerticalScrollRange() + this.getTitleHeight() - this.getViewHeightWithTitle(), 0);
    }

    public void flingScroll(int vx, int vy) {
        this.mScroller.fling(this.mScrollX, this.mScrollY, vx, vy, 0, this.computeMaxScrollX(), 0, this.computeMaxScrollY(), this.mOverflingDistance, this.mOverflingDistance);
        this.invalidate();
    }

    private void doFling() {
        if (this.mVelocityTracker == null) {
            return;
        }
        int maxX = this.computeMaxScrollX();
        int maxY = this.computeMaxScrollY();
        this.mVelocityTracker.computeCurrentVelocity(1000, this.mMaximumFling);
        int vx = (int)this.mVelocityTracker.getXVelocity();
        int vy = (int)this.mVelocityTracker.getYVelocity();
        if (this.mSnapScrollMode != 0) {
            if ((this.mSnapScrollMode & 2) == 2) {
                vy = 0;
            } else {
                vx = 0;
            }
        }
        vx = vx * 3 / 4;
        vy = vy * 3 / 4;
        if (maxX == 0 && vy == 0 || maxY == 0 && vx == 0) {
            WebViewCore.resumePriority();
            WebViewCore.resumeUpdatePicture(this.mWebViewCore);
            if (this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, this.computeMaxScrollX(), 0, this.computeMaxScrollY())) {
                this.invalidate();
            }
            return;
        }
        float currentVelocity = this.mScroller.getCurrVelocity();
        if (this.mLastVelocity > 0.0f && currentVelocity > 0.0f) {
            float deltaR = (float)Math.abs(Math.atan2(this.mLastVelY, this.mLastVelX) - Math.atan2(vy, vx));
            float circle = (float)Math.PI * 2;
            if (deltaR > 5.6548667f || deltaR < 0.62831855f) {
                vx = (int)((float)vx + currentVelocity * this.mLastVelX / this.mLastVelocity);
                vy = (int)((float)vy + currentVelocity * this.mLastVelY / this.mLastVelocity);
            }
        }
        if ((this.mScrollX == 0 || this.mScrollX == maxX) && Math.abs(vx) < Math.abs(vy)) {
            vx = 0;
        }
        if ((this.mScrollY == 0 || this.mScrollY == maxY) && Math.abs(vy) < Math.abs(vx)) {
            vy = 0;
        }
        if (this.mOverscrollDistance < this.mOverflingDistance) {
            if (this.mScrollX == -this.mOverscrollDistance || this.mScrollX == maxX + this.mOverscrollDistance) {
                vx = 0;
            }
            if (this.mScrollY == -this.mOverscrollDistance || this.mScrollY == maxY + this.mOverscrollDistance) {
                vy = 0;
            }
        }
        this.mLastVelX = vx;
        this.mLastVelY = vy;
        this.mLastVelocity = (float)Math.hypot(vx, vy);
        this.mScroller.fling(this.mScrollX, this.mScrollY, -vx, -vy, 0, maxX, 0, maxY, maxX == 0 ? 0 : this.mOverflingDistance, this.mOverflingDistance);
        int time = this.mScroller.getDuration();
        this.awakenScrollBars(time);
        this.invalidate();
    }

    private boolean zoomWithPreview(float scale, boolean updateTextWrapScale) {
        float oldScale = this.mActualScale;
        this.mInitialScrollX = this.mScrollX;
        this.mInitialScrollY = this.mScrollY;
        if (Math.abs(scale - this.mDefaultScale) < MINIMUM_SCALE_INCREMENT) {
            scale = this.mDefaultScale;
        }
        this.setNewZoomScale(scale, updateTextWrapScale, false);
        if (oldScale != this.mActualScale) {
            this.mZoomStart = SystemClock.uptimeMillis();
            this.mInvInitialZoomScale = 1.0f / oldScale;
            this.mInvFinalZoomScale = 1.0f / this.mActualScale;
            this.mZoomScale = this.mActualScale;
            WebViewCore.pauseUpdatePicture(this.mWebViewCore);
            this.invalidate();
            return true;
        }
        return false;
    }

    @Deprecated
    public View getZoomControls() {
        if (!this.getSettings().supportZoom()) {
            Log.w(LOGTAG, "This WebView doesn't support zoom.");
            return null;
        }
        if (this.mZoomControls == null) {
            this.mZoomControls = this.createZoomControls();
            this.mZoomControls.setVisibility(0);
            this.mZoomControlRunnable = new Runnable(){

                public void run() {
                    if (!WebView.this.mZoomControls.hasFocus()) {
                        WebView.this.mZoomControls.hide();
                    } else {
                        WebView.this.mPrivateHandler.removeCallbacks(WebView.this.mZoomControlRunnable);
                        WebView.this.mPrivateHandler.postDelayed(WebView.this.mZoomControlRunnable, ZOOM_CONTROLS_TIMEOUT);
                    }
                }
            };
        }
        return this.mZoomControls;
    }

    private ExtendedZoomControls createZoomControls() {
        ExtendedZoomControls zoomControls = new ExtendedZoomControls(this.mContext, null);
        zoomControls.setOnZoomInClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WebView.this.mPrivateHandler.removeCallbacks(WebView.this.mZoomControlRunnable);
                WebView.this.mPrivateHandler.postDelayed(WebView.this.mZoomControlRunnable, ZOOM_CONTROLS_TIMEOUT);
                WebView.this.zoomIn();
            }
        });
        zoomControls.setOnZoomOutClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WebView.this.mPrivateHandler.removeCallbacks(WebView.this.mZoomControlRunnable);
                WebView.this.mPrivateHandler.postDelayed(WebView.this.mZoomControlRunnable, ZOOM_CONTROLS_TIMEOUT);
                WebView.this.zoomOut();
            }
        });
        return zoomControls;
    }

    public ZoomButtonsController getZoomButtonsController() {
        if (this.mZoomButtonsController == null) {
            this.mZoomButtonsController = new ZoomButtonsController(this);
            this.mZoomButtonsController.setOnZoomListener(this.mZoomListener);
            View controls = this.mZoomButtonsController.getZoomControls();
            ViewGroup.LayoutParams params = controls.getLayoutParams();
            if (params instanceof FrameLayout.LayoutParams) {
                FrameLayout.LayoutParams frameParams = (FrameLayout.LayoutParams)params;
                frameParams.gravity = 5;
            }
        }
        return this.mZoomButtonsController;
    }

    public boolean zoomIn() {
        this.switchOutDrawHistory();
        this.mInZoomOverview = false;
        this.mZoomCenterX = (float)this.getViewWidth() * 0.5f;
        this.mZoomCenterY = (float)this.getViewHeight() * 0.5f;
        this.mAnchorX = this.viewToContentX((int)this.mZoomCenterX + this.mScrollX);
        this.mAnchorY = this.viewToContentY((int)this.mZoomCenterY + this.mScrollY);
        return this.zoomWithPreview(this.mActualScale * 1.25f, true);
    }

    public boolean zoomOut() {
        this.switchOutDrawHistory();
        this.mZoomCenterX = (float)this.getViewWidth() * 0.5f;
        this.mZoomCenterY = (float)this.getViewHeight() * 0.5f;
        this.mAnchorX = this.viewToContentX((int)this.mZoomCenterX + this.mScrollX);
        this.mAnchorY = this.viewToContentY((int)this.mZoomCenterY + this.mScrollY);
        return this.zoomWithPreview(this.mActualScale * 0.8f, true);
    }

    private void updateSelection() {
        if (this.mNativeClass == 0) {
            return;
        }
        int contentX = this.viewToContentX((int)this.mLastTouchX + this.mScrollX);
        int contentY = this.viewToContentY((int)this.mLastTouchY + this.mScrollY);
        Rect rect = new Rect(contentX - this.mNavSlop, contentY - this.mNavSlop, contentX + this.mNavSlop, contentY + this.mNavSlop);
        this.nativeSelectBestAt(rect);
    }

    void scrollFocusedTextInput(float xPercent, int y) {
        if (!this.inEditingMode() || this.mWebViewCore == null) {
            return;
        }
        this.mWebViewCore.sendMessage(99, this.viewToContentDimension(y), new Float(xPercent));
    }

    void initiateTextFieldDrag(float x, float y, long eventTime) {
        if (!this.inEditingMode()) {
            return;
        }
        this.mLastTouchX = x + (float)(this.mWebTextView.getLeft() - this.mScrollX);
        this.mLastTouchY = y + (float)(this.mWebTextView.getTop() - this.mScrollY);
        this.mLastTouchTime = eventTime;
        if (!this.mScroller.isFinished()) {
            this.abortAnimation();
            this.mPrivateHandler.removeMessages(7);
        }
        this.mSnapScrollMode = 0;
        this.mVelocityTracker = VelocityTracker.obtain();
        this.mTouchMode = 2;
    }

    boolean textFieldDrag(MotionEvent event) {
        if (!this.inEditingMode()) {
            return false;
        }
        this.mDragFromTextInput = true;
        event.offsetLocation(this.mWebTextView.getLeft() - this.mScrollX, this.mWebTextView.getTop() - this.mScrollY);
        boolean result = this.onTouchEvent(event);
        this.mDragFromTextInput = false;
        return result;
    }

    void touchUpOnTextField(MotionEvent event) {
        if (!this.inEditingMode()) {
            return;
        }
        int x = this.viewToContentX((int)event.getX() + this.mWebTextView.getLeft());
        int y = this.viewToContentY((int)event.getY() + this.mWebTextView.getTop());
        this.nativeMotionUp(x, y, this.mNavSlop);
    }

    void centerKeyPressOnTextField() {
        this.mWebViewCore.sendMessage(118, this.nativeCursorFramePointer(), this.nativeCursorNodePointer());
    }

    private void doShortPress() {
        if (this.mNativeClass == 0) {
            return;
        }
        if (this.mPreventDefault == 3) {
            return;
        }
        this.mTouchMode = 7;
        this.switchOutDrawHistory();
        int contentX = this.viewToContentX((int)this.mLastTouchX + this.mScrollX);
        int contentY = this.viewToContentY((int)this.mLastTouchY + this.mScrollY);
        if (this.nativePointInNavCache(contentX, contentY, this.mNavSlop)) {
            WebViewCore.MotionUpData motionUpData = new WebViewCore.MotionUpData();
            motionUpData.mFrame = this.nativeCacheHitFramePointer();
            motionUpData.mNode = this.nativeCacheHitNodePointer();
            motionUpData.mBounds = this.nativeCacheHitNodeBounds();
            motionUpData.mX = contentX;
            motionUpData.mY = contentY;
            this.mWebViewCore.sendMessageAtFrontOfQueue(146, motionUpData);
        } else {
            this.doMotionUp(contentX, contentY);
        }
    }

    private void doMotionUp(int contentX, int contentY) {
        if (mLogEvent && this.nativeMotionUp(contentX, contentY, this.mNavSlop)) {
            EventLog.writeEvent(70150, new Object[0]);
        }
        if (this.nativeHasCursorNode() && !this.nativeCursorIsTextInput()) {
            this.playSoundEffect(0);
        }
    }

    private boolean isPluginFitOnScreen(ViewManager.ChildView view) {
        int viewHeight;
        int viewWidth = this.getViewWidth();
        float scale = Math.min((float)viewWidth / (float)view.width, (float)(viewHeight = this.getViewHeightWithTitle()) / (float)view.height);
        if (scale < this.mMinZoomScale) {
            scale = this.mMinZoomScale;
        } else if (scale > this.mMaxZoomScale) {
            scale = this.mMaxZoomScale;
        }
        return Math.abs(scale - this.mActualScale) < MINIMUM_SCALE_INCREMENT && this.contentToViewX(view.x) >= this.mScrollX && this.contentToViewX(view.x + view.width) <= this.mScrollX + viewWidth && this.contentToViewY(view.y) >= this.mScrollY && this.contentToViewY(view.y + view.height) <= this.mScrollY + viewHeight;
    }

    private void centerFitRect(int docX, int docY, int docWidth, int docHeight) {
        int viewHeight;
        int viewWidth = this.getViewWidth();
        float scale = Math.min((float)viewWidth / (float)docWidth, (float)(viewHeight = this.getViewHeightWithTitle()) / (float)docHeight);
        if (scale < this.mMinZoomScale) {
            scale = this.mMinZoomScale;
        } else if (scale > this.mMaxZoomScale) {
            scale = this.mMaxZoomScale;
        }
        if (Math.abs(scale - this.mActualScale) < MINIMUM_SCALE_INCREMENT) {
            this.pinScrollTo(this.contentToViewX(docX + docWidth / 2) - viewWidth / 2, this.contentToViewY(docY + docHeight / 2) - viewHeight / 2, true, 0);
        } else {
            float oldScreenX = (float)docX * this.mActualScale - (float)this.mScrollX;
            float rectViewX = (float)docX * scale;
            float rectViewWidth = (float)docWidth * scale;
            float newMaxWidth = (float)this.mContentWidth * scale;
            float newScreenX = ((float)viewWidth - rectViewWidth) / 2.0f;
            if (newScreenX > rectViewX) {
                newScreenX = rectViewX;
            } else if (newScreenX > newMaxWidth - rectViewX - rectViewWidth) {
                newScreenX = (float)viewWidth - (newMaxWidth - rectViewX);
            }
            this.mZoomCenterX = (oldScreenX * scale - newScreenX * this.mActualScale) / (scale - this.mActualScale);
            float oldScreenY = (float)docY * this.mActualScale + (float)this.getTitleHeight() - (float)this.mScrollY;
            float rectViewY = (float)docY * scale + (float)this.getTitleHeight();
            float rectViewHeight = (float)docHeight * scale;
            float newMaxHeight = (float)this.mContentHeight * scale + (float)this.getTitleHeight();
            float newScreenY = ((float)viewHeight - rectViewHeight) / 2.0f;
            if (newScreenY > rectViewY) {
                newScreenY = rectViewY;
            } else if (newScreenY > newMaxHeight - rectViewY - rectViewHeight) {
                newScreenY = (float)viewHeight - (newMaxHeight - rectViewY);
            }
            this.mZoomCenterY = (oldScreenY * scale - newScreenY * this.mActualScale) / (scale - this.mActualScale);
            this.zoomWithPreview(scale, false);
        }
    }

    void dismissZoomControl() {
        if (this.mWebViewCore == null) {
            if (this.mZoomButtonsController != null) {
                this.mZoomButtonsController.setVisible(false);
            }
            if (this.mZoomControls != null) {
                this.mZoomControls.hide();
            }
            return;
        }
        WebSettings settings = this.getSettings();
        if (settings.getBuiltInZoomControls()) {
            if (this.mZoomButtonsController != null) {
                this.mZoomButtonsController.setVisible(false);
            }
        } else {
            if (this.mZoomControlRunnable != null) {
                this.mPrivateHandler.removeCallbacks(this.mZoomControlRunnable);
            }
            if (this.mZoomControls != null) {
                this.mZoomControls.hide();
            }
        }
    }

    private void doDoubleTap() {
        if (!this.mWebViewCore.getSettings().getUseWideViewPort()) {
            return;
        }
        this.mZoomCenterX = this.mLastTouchX;
        this.mZoomCenterY = this.mLastTouchY;
        this.mAnchorX = this.viewToContentX((int)this.mZoomCenterX + this.mScrollX);
        this.mAnchorY = this.viewToContentY((int)this.mZoomCenterY + this.mScrollY);
        WebSettings settings = this.getSettings();
        settings.setDoubleTapToastCount(0);
        this.dismissZoomControl();
        ViewManager.ChildView plugin = this.mViewManager.hitTest(this.mAnchorX, this.mAnchorY);
        if (plugin != null) {
            if (this.isPluginFitOnScreen(plugin)) {
                this.mInZoomOverview = true;
                if (this.mScrollY < this.getTitleHeight()) {
                    this.mScrollY = 0;
                }
                this.zoomWithPreview((float)this.getViewWidth() / (float)this.mZoomOverviewWidth, true);
            } else {
                this.mInZoomOverview = false;
                this.centerFitRect(plugin.x, plugin.y, plugin.width, plugin.height);
            }
            return;
        }
        boolean zoomToDefault = false;
        if (settings.getLayoutAlgorithm() == WebSettings.LayoutAlgorithm.NARROW_COLUMNS && Math.abs(this.mActualScale - this.mTextWrapScale) >= MINIMUM_SCALE_INCREMENT) {
            this.setNewZoomScale(this.mActualScale, true, true);
            float overviewScale = (float)this.getViewWidth() / (float)this.mZoomOverviewWidth;
            if (Math.abs(this.mActualScale - overviewScale) < MINIMUM_SCALE_INCREMENT) {
                this.mInZoomOverview = true;
            }
        } else if (!this.mInZoomOverview) {
            float newScale = (float)this.getViewWidth() / (float)this.mZoomOverviewWidth;
            if (Math.abs(this.mActualScale - newScale) >= MINIMUM_SCALE_INCREMENT) {
                this.mInZoomOverview = true;
                if (this.mScrollY < this.getTitleHeight()) {
                    this.mScrollY = 0;
                }
                this.zoomWithPreview(newScale, true);
            } else if (Math.abs(this.mActualScale - this.mDefaultScale) >= MINIMUM_SCALE_INCREMENT) {
                zoomToDefault = true;
            }
        } else {
            zoomToDefault = true;
        }
        if (zoomToDefault) {
            this.mInZoomOverview = false;
            int left = this.nativeGetBlockLeftEdge(this.mAnchorX, this.mAnchorY, this.mActualScale);
            if (left != -1) {
                int viewLeft = this.contentToViewX(left < 5 ? 0 : left - 5) - this.mScrollX;
                if (viewLeft > 0) {
                    this.mZoomCenterX = (float)viewLeft * this.mDefaultScale / (this.mDefaultScale - this.mActualScale);
                } else {
                    this.scrollBy(viewLeft, 0);
                    this.mZoomCenterX = 0.0f;
                }
            }
            this.zoomWithPreview(this.mDefaultScale, true);
        }
    }

    private void overrideLoading(String url) {
        this.mCallbackProxy.uiOverrideUrlLoading(url);
    }

    @Override
    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        boolean result = false;
        if (this.inEditingMode()) {
            result = this.mWebTextView.requestFocus(direction, previouslyFocusedRect);
        } else {
            result = super.requestFocus(direction, previouslyFocusedRect);
            if (this.mWebViewCore.getSettings().getNeedInitialFocus()) {
                int fakeKeyDirection = 0;
                switch (direction) {
                    case 33: {
                        fakeKeyDirection = 19;
                        break;
                    }
                    case 130: {
                        fakeKeyDirection = 20;
                        break;
                    }
                    case 17: {
                        fakeKeyDirection = 21;
                        break;
                    }
                    case 66: {
                        fakeKeyDirection = 22;
                        break;
                    }
                    default: {
                        return result;
                    }
                }
                if (this.mNativeClass != 0 && !this.nativeHasCursorNode()) {
                    this.navHandledKey(fakeKeyDirection, 1, true, 0L);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int measuredHeight = heightSize;
        int measuredWidth = widthSize;
        int contentHeight = this.contentToViewDimension(this.mContentHeight);
        int contentWidth = this.contentToViewDimension(this.mContentWidth);
        if (heightMode != 0x40000000) {
            this.mHeightCanMeasure = true;
            measuredHeight = contentHeight;
            if (heightMode == Integer.MIN_VALUE && measuredHeight > heightSize) {
                measuredHeight = heightSize;
                this.mHeightCanMeasure = false;
            }
        } else {
            this.mHeightCanMeasure = false;
        }
        if (this.mNativeClass != 0) {
            this.nativeSetHeightCanMeasure(this.mHeightCanMeasure);
        }
        if (widthMode == 0) {
            this.mWidthCanMeasure = true;
            measuredWidth = contentWidth;
        } else {
            this.mWidthCanMeasure = false;
        }
        WebView webView = this;
        synchronized (webView) {
            this.setMeasuredDimension(measuredWidth, measuredHeight);
        }
    }

    @Override
    public boolean requestChildRectangleOnScreen(View child, Rect rect, boolean immediate) {
        rect.offset(child.getLeft() - child.getScrollX(), child.getTop() - child.getScrollY());
        Rect content = new Rect(this.viewToContentX(this.mScrollX), this.viewToContentY(this.mScrollY), this.viewToContentX(this.mScrollX + this.getWidth() - this.getVerticalScrollbarWidth()), this.viewToContentY(this.mScrollY + this.getViewHeightWithTitle()));
        content = this.nativeSubtractLayers(content);
        int screenTop = this.contentToViewY(content.top);
        int screenBottom = this.contentToViewY(content.bottom);
        int height = screenBottom - screenTop;
        int scrollYDelta = 0;
        if (rect.bottom > screenBottom) {
            int oneThirdOfScreenHeight = height / 3;
            scrollYDelta = rect.height() > 2 * oneThirdOfScreenHeight ? rect.top - screenTop : rect.top - (screenTop + oneThirdOfScreenHeight);
        } else if (rect.top < screenTop) {
            scrollYDelta = rect.top - screenTop;
        }
        int screenLeft = this.contentToViewX(content.left);
        int screenRight = this.contentToViewX(content.right);
        int width = screenRight - screenLeft;
        int scrollXDelta = 0;
        if (rect.right > screenRight && rect.left > screenLeft) {
            scrollXDelta = rect.width() > width ? (scrollXDelta += rect.left - screenLeft) : (scrollXDelta += rect.right - screenRight);
        } else if (rect.left < screenLeft) {
            scrollXDelta -= screenLeft - rect.left;
        }
        if ((scrollYDelta | scrollXDelta) != 0) {
            return this.pinScrollBy(scrollXDelta, scrollYDelta, !immediate, 0);
        }
        return false;
    }

    void replaceTextfieldText(int oldStart, int oldEnd, String replace, int newStart, int newEnd) {
        WebViewCore.ReplaceTextData arg = new WebViewCore.ReplaceTextData();
        arg.mReplace = replace;
        arg.mNewStart = newStart;
        arg.mNewEnd = newEnd;
        ++this.mTextGeneration;
        arg.mTextGeneration = this.mTextGeneration;
        this.mWebViewCore.sendMessage(114, oldStart, oldEnd, arg);
    }

    void passToJavaScript(String currentText, KeyEvent event) {
        WebViewCore.JSKeyData arg = new WebViewCore.JSKeyData();
        arg.mEvent = event;
        arg.mCurrentText = currentText;
        ++this.mTextGeneration;
        this.mWebViewCore.sendMessage(115, this.mTextGeneration, 0, arg);
        this.mWebViewCore.removeMessages(128);
        this.mWebViewCore.sendMessageDelayed(128, this.cursorData(), 1000L);
    }

    synchronized WebViewCore getWebViewCore() {
        return this.mWebViewCore;
    }

    private void updateTextSelectionFromMessage(int nodePointer, int textGeneration, WebViewCore.TextSelectionData data) {
        if (this.inEditingMode() && this.mWebTextView.isSameTextField(nodePointer) && textGeneration == this.mTextGeneration) {
            this.mWebTextView.setSelectionFromWebKit(data.mStart, data.mEnd);
        }
    }

    void requestListBox(String[] array2, int[] enabledArray, int[] selectedArray) {
        this.mPrivateHandler.post(new InvokeListBox(array2, enabledArray, selectedArray));
    }

    private void updateZoomRange(WebViewCore.RestoreState restoreState, int viewWidth, int minPrefWidth, boolean updateZoomOverview) {
        if (restoreState.mMinScale == 0.0f) {
            if (restoreState.mMobileSite) {
                if (minPrefWidth > Math.max(0, viewWidth)) {
                    this.mMinZoomScale = (float)viewWidth / (float)minPrefWidth;
                    this.mMinZoomScaleFixed = false;
                    if (updateZoomOverview) {
                        WebSettings settings = this.getSettings();
                        this.mInZoomOverview = settings.getUseWideViewPort() && settings.getLoadWithOverviewMode();
                    }
                } else {
                    this.mMinZoomScale = restoreState.mDefaultScale;
                    this.mMinZoomScaleFixed = true;
                }
            } else {
                this.mMinZoomScale = DEFAULT_MIN_ZOOM_SCALE;
                this.mMinZoomScaleFixed = false;
            }
        } else {
            this.mMinZoomScale = restoreState.mMinScale;
            this.mMinZoomScaleFixed = true;
        }
        this.mMaxZoomScale = restoreState.mMaxScale == 0.0f ? DEFAULT_MAX_ZOOM_SCALE : restoreState.mMaxScale;
    }

    void requestListBox(String[] array2, int[] enabledArray, int selection) {
        this.mPrivateHandler.post(new InvokeListBox(array2, enabledArray, selection));
    }

    private void sendMoveFocus(int frame, int node) {
        this.mWebViewCore.sendMessage(127, new WebViewCore.CursorData(frame, node, 0, 0));
    }

    private void sendMoveMouse(int frame, int node, int x, int y) {
        this.mWebViewCore.sendMessage(135, new WebViewCore.CursorData(frame, node, x, y));
    }

    private void sendMoveMouseIfLatest(boolean removeFocus) {
        if (removeFocus) {
            this.clearTextEntry(true);
        }
        this.mWebViewCore.sendMessage(136, this.cursorData());
    }

    private void sendMotionUp(int touchGeneration, int frame, int node, int x, int y) {
        WebViewCore.TouchUpData touchUpData = new WebViewCore.TouchUpData();
        touchUpData.mMoveGeneration = touchGeneration;
        touchUpData.mFrame = frame;
        touchUpData.mNode = node;
        touchUpData.mX = x;
        touchUpData.mY = y;
        this.mWebViewCore.sendMessage(140, touchUpData);
    }

    private int getScaledMaxXScroll() {
        int width;
        if (!this.mHeightCanMeasure) {
            width = this.getViewWidth() / 4;
        } else {
            Rect visRect = new Rect();
            this.calcOurVisibleRect(visRect);
            width = visRect.width() / 2;
        }
        return this.viewToContentX(width);
    }

    private int getScaledMaxYScroll() {
        int height;
        if (!this.mHeightCanMeasure) {
            height = this.getViewHeight() / 4;
        } else {
            Rect visRect = new Rect();
            this.calcOurVisibleRect(visRect);
            height = visRect.height() / 2;
        }
        return Math.round((float)height * this.mInvActualScale);
    }

    private void viewInvalidate() {
        this.invalidate();
    }

    private void letPluginHandleNavKey(int keyCode, long time, boolean down) {
        int eventHubAction;
        int keyEventAction;
        if (down) {
            keyEventAction = 0;
            eventHubAction = 103;
            this.playSoundEffect(this.keyCodeToSoundsEffect(keyCode));
        } else {
            keyEventAction = 1;
            eventHubAction = 104;
        }
        KeyEvent event = new KeyEvent(time, time, keyEventAction, keyCode, 1, this.mShiftIsPressed | false | 0, 0, 0, 0);
        this.mWebViewCore.sendMessage(eventHubAction, event);
    }

    private boolean navHandledKey(int keyCode, int count, boolean noScroll, long time) {
        boolean keyHandled;
        if (this.mNativeClass == 0) {
            return false;
        }
        this.mLastCursorTime = time;
        this.mLastCursorBounds = this.nativeGetCursorRingBounds();
        boolean bl = keyHandled = !this.nativeMoveCursor(keyCode, count, noScroll);
        if (!keyHandled || !this.mHeightCanMeasure) {
            return keyHandled;
        }
        Rect contentCursorRingBounds = this.nativeGetCursorRingBounds();
        if (contentCursorRingBounds.isEmpty()) {
            return keyHandled;
        }
        Rect viewCursorRingBounds = this.contentToViewRect(contentCursorRingBounds);
        Rect visRect = new Rect();
        this.calcOurVisibleRect(visRect);
        Rect outset = new Rect(visRect);
        int maxXScroll = visRect.width() / 2;
        int maxYScroll = visRect.height() / 2;
        outset.inset(-maxXScroll, -maxYScroll);
        if (!Rect.intersects(outset, viewCursorRingBounds)) {
            return keyHandled;
        }
        int maxH = Math.min(viewCursorRingBounds.right - visRect.right, maxXScroll);
        if (maxH > 0) {
            this.pinScrollBy(maxH, 0, true, 0);
        } else {
            maxH = Math.max(viewCursorRingBounds.left - visRect.left, -maxXScroll);
            if (maxH < 0) {
                this.pinScrollBy(maxH, 0, true, 0);
            }
        }
        if (this.mLastCursorBounds.isEmpty()) {
            return keyHandled;
        }
        if (this.mLastCursorBounds.equals(contentCursorRingBounds)) {
            return keyHandled;
        }
        this.requestRectangleOnScreen(viewCursorRingBounds);
        this.mUserScroll = true;
        return keyHandled;
    }

    @Override
    public void setBackgroundColor(int color2) {
        this.mBackgroundColor = color2;
        this.mWebViewCore.sendMessage(126, color2);
    }

    public void debugDump() {
        this.nativeDebugDump();
        this.mWebViewCore.sendMessage(172);
    }

    public void drawPage(Canvas canvas) {
        this.mWebViewCore.drawContentPicture(canvas, 0, false, false);
    }

    public void setTouchInterval(int interval) {
        this.mCurrentTouchInterval = interval;
    }

    void updateCachedTextfield(String updatedText) {
        this.nativeUpdateCachedTextfield(updatedText, this.mTextGeneration);
    }

    ViewManager getViewManager() {
        return this.mViewManager;
    }

    private native int nativeCacheHitFramePointer();

    private native Rect nativeCacheHitNodeBounds();

    private native int nativeCacheHitNodePointer();

    native void nativeClearCursor();

    private native void nativeCreate(int var1);

    private native int nativeCursorFramePointer();

    private native Rect nativeCursorNodeBounds();

    private native int nativeCursorNodePointer();

    native boolean nativeCursorMatchesFocus();

    private native boolean nativeCursorIntersects(Rect var1);

    private native boolean nativeCursorIsAnchor();

    private native boolean nativeCursorIsTextInput();

    private native Point nativeCursorPosition();

    private native String nativeCursorText();

    private native boolean nativeCursorWantsKeyEvents();

    private native void nativeDebugDump();

    private native void nativeDestroy();

    private native boolean nativeEvaluateLayersAnimations();

    private native void nativeExtendSelection(int var1, int var2);

    private native void nativeDrawExtras(Canvas var1, int var2);

    private native void nativeDumpDisplayTree(String var1);

    private native int nativeFindAll(String var1, String var2);

    private native void nativeFindNext(boolean var1);

    native int nativeFocusCandidateFramePointer();

    native boolean nativeFocusCandidateHasNextTextfield();

    native boolean nativeFocusCandidateIsPassword();

    private native boolean nativeFocusCandidateIsRtlText();

    private native boolean nativeFocusCandidateIsTextInput();

    native int nativeFocusCandidateMaxLength();

    native String nativeFocusCandidateName();

    private native Rect nativeFocusCandidateNodeBounds();

    private native Rect nativeFocusCandidatePaddingRect();

    native int nativeFocusCandidatePointer();

    private native String nativeFocusCandidateText();

    private native int nativeFocusCandidateTextSize();

    private native int nativeFocusCandidateType();

    private native boolean nativeFocusIsPlugin();

    private native Rect nativeFocusNodeBounds();

    native int nativeFocusNodePointer();

    private native Rect nativeGetCursorRingBounds();

    private native String nativeGetSelection();

    private native boolean nativeHasCursorNode();

    private native boolean nativeHasFocusNode();

    private native void nativeHideCursor();

    private native boolean nativeHitSelection(int var1, int var2);

    private native String nativeImageURI(int var1, int var2);

    private native void nativeInstrumentReport();

    native boolean nativeMoveCursorToNextTextInput();

    private native boolean nativeMotionUp(int var1, int var2, int var3);

    private native boolean nativeMoveCursor(int var1, int var2, boolean var3);

    private native int nativeMoveGeneration();

    private native void nativeMoveSelection(int var1, int var2);

    private native boolean nativePointInNavCache(int var1, int var2, int var3);

    private native void nativeRecordButtons(boolean var1, boolean var2, boolean var3);

    private native void nativeResetSelection();

    private native void nativeSelectAll();

    private native void nativeSelectBestAt(Rect var1);

    private native int nativeSelectionX();

    private native int nativeSelectionY();

    private native int nativeFindIndex();

    private native void nativeSetExtendSelection();

    private native void nativeSetFindIsEmpty();

    private native void nativeSetFindIsUp(boolean var1);

    private native void nativeSetFollowedLink(boolean var1);

    private native void nativeSetHeightCanMeasure(boolean var1);

    private native void nativeSetRootLayer(int var1);

    private native void nativeSetSelectionPointer(boolean var1, float var2, int var3, int var4);

    private native boolean nativeStartSelection(int var1, int var2);

    private native void nativeSetSelectionRegion(boolean var1);

    private native Rect nativeSubtractLayers(Rect var1);

    private native int nativeTextGeneration();

    private native void nativeUpdateCachedTextfield(String var1, int var2);

    private native boolean nativeWordSelection(int var1, int var2);

    private native int nativeGetBlockLeftEdge(int var1, int var2, float var3);

    static {
        HandlerPrivateDebugString = new String[]{"REMEMBER_PASSWORD", "NEVER_REMEMBER_PASSWORD", "SWITCH_TO_SHORTPRESS", "SWITCH_TO_LONGPRESS", "RELEASE_SINGLE_TAP", "REQUEST_FORM_DATA", "RESUME_WEBCORE_PRIORITY", "DRAG_HELD_MOTIONLESS", "AWAKEN_SCROLL_BARS", "PREVENT_DEFAULT_TIMEOUT"};
        HandlerPackageDebugString = new String[]{"SCROLL_TO_MSG_ID", "SCROLL_BY_MSG_ID", "SPAWN_SCROLL_TO_MSG_ID", "SYNC_SCROLL_TO_MSG_ID", "NEW_PICTURE_MSG_ID", "UPDATE_TEXT_ENTRY_MSG_ID", "WEBCORE_INITIALIZED_MSG_ID", "UPDATE_TEXTFIELD_TEXT_MSG_ID", "UPDATE_ZOOM_RANGE", "MOVE_OUT_OF_PLUGIN", "CLEAR_TEXT_ENTRY", "UPDATE_TEXT_SELECTION_MSG_ID", "SHOW_RECT_MSG_ID", "LONG_PRESS_CENTER", "PREVENT_TOUCH_ID", "WEBCORE_NEED_TOUCH_EVENTS", "INVAL_RECT_MSG_ID", "REQUEST_KEYBOARD", "DO_MOTION_UP", "SHOW_FULLSCREEN", "HIDE_FULLSCREEN", "DOM_FOCUS_CHANGED", "IMMEDIATE_REPAINT_MSG_ID", "SET_ROOT_LAYER_MSG_ID", "RETURN_LABEL", "FIND_AGAIN", "CENTER_FIT_RECT", "REQUEST_KEYBOARD_WITH_SELECTION_MSG_ID", "SET_SCROLLBAR_MODES"};
        sMaxViewportWidth = 800;
        MINIMUM_SCALE_INCREMENT = 0.01f;
        mLogEvent = true;
    }

    private class InvokeListBox
    implements Runnable {
        private boolean mMultiple;
        private int[] mSelectedArray;
        private int mSelection;
        private Container[] mContainers;

        private InvokeListBox(String[] array2, int[] enabled, int[] selected) {
            this.mMultiple = true;
            this.mSelectedArray = selected;
            int length = array2.length;
            this.mContainers = new Container[length];
            for (int i = 0; i < length; ++i) {
                this.mContainers[i] = new Container();
                this.mContainers[i].mString = array2[i];
                this.mContainers[i].mEnabled = enabled[i];
                this.mContainers[i].mId = i;
            }
        }

        private InvokeListBox(String[] array2, int[] enabled, int selection) {
            this.mSelection = selection;
            this.mMultiple = false;
            int length = array2.length;
            this.mContainers = new Container[length];
            for (int i = 0; i < length; ++i) {
                this.mContainers[i] = new Container();
                this.mContainers[i].mString = array2[i];
                this.mContainers[i].mEnabled = enabled[i];
                this.mContainers[i].mId = i;
            }
        }

        public void run() {
            final ListView listView = (ListView)LayoutInflater.from(WebView.this.mContext).inflate(17367134, null);
            final MyArrayListAdapter adapter = new MyArrayListAdapter(WebView.this.mContext, this.mContainers, this.mMultiple);
            AlertDialog.Builder b = new AlertDialog.Builder(WebView.this.mContext).setView(listView).setCancelable(true).setInverseBackgroundForced(true);
            if (this.mMultiple) {
                b.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        WebView.this.mWebViewCore.sendMessage(123, adapter.getCount(), 0, listView.getCheckedItemPositions());
                    }
                });
                b.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        WebView.this.mWebViewCore.sendMessage(124, -2, 0);
                    }
                });
            }
            final AlertDialog dialog = b.create();
            listView.setAdapter(adapter);
            listView.setFocusableInTouchMode(true);
            listView.setTextFilterEnabled(!this.mMultiple);
            if (this.mMultiple) {
                listView.setChoiceMode(2);
                int length = this.mSelectedArray.length;
                for (int i = 0; i < length; ++i) {
                    listView.setItemChecked(this.mSelectedArray[i], true);
                }
            } else {
                listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView parent, View v, int position, long id2) {
                        WebView.this.mWebViewCore.sendMessage(124, (int)id2, 0);
                        dialog.dismiss();
                    }
                });
                if (this.mSelection != -1) {
                    listView.setSelection(this.mSelection);
                    listView.setChoiceMode(1);
                    listView.setItemChecked(this.mSelection, true);
                    SingleDataSetObserver observer = new SingleDataSetObserver(adapter.getItemId(this.mSelection), listView, adapter);
                    adapter.registerDataSetObserver(observer);
                }
            }
            dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    WebView.this.mWebViewCore.sendMessage(124, -2, 0);
                }
            });
            dialog.show();
        }

        private class SingleDataSetObserver
        extends DataSetObserver {
            private long mCheckedId;
            private ListView mListView;
            private Adapter mAdapter;

            public SingleDataSetObserver(long id2, ListView l, Adapter a) {
                this.mCheckedId = id2;
                this.mListView = l;
                this.mAdapter = a;
            }

            public void onChanged() {
                int position = this.mListView.getCheckedItemPosition();
                long id2 = this.mAdapter.getItemId(position);
                if (this.mCheckedId != id2) {
                    this.mListView.clearChoices();
                    int count = this.mAdapter.getCount();
                    for (int i = 0; i < count; ++i) {
                        if (this.mAdapter.getItemId(i) != this.mCheckedId) continue;
                        this.mListView.setItemChecked(i, true);
                        break;
                    }
                }
            }

            public void onInvalidate() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class MyArrayListAdapter
        extends ArrayAdapter<Container> {
            public MyArrayListAdapter(Context context, Container[] objects, boolean multiple) {
                super(context, multiple ? 17367059 : 17367058, objects);
            }

            @Override
            public View getView(int position, View convertView, ViewGroup parent) {
                convertView = super.getView(position, null, parent);
                Container c = this.item(position);
                if (c != null && 1 != c.mEnabled) {
                    LinearLayout layout2 = new LinearLayout(WebView.this.mContext);
                    layout2.setOrientation(1);
                    if (position > 0) {
                        View dividerTop = new View(WebView.this.mContext);
                        dividerTop.setBackgroundResource(17301522);
                        layout2.addView(dividerTop);
                    }
                    if (-1 == c.mEnabled) {
                        Assert.assertTrue((boolean)(convertView instanceof CheckedTextView));
                        ((CheckedTextView)convertView).setCheckMarkDrawable(null);
                    } else {
                        convertView.setEnabled(false);
                    }
                    layout2.addView(convertView);
                    if (position < this.getCount() - 1) {
                        View dividerBottom = new View(WebView.this.mContext);
                        dividerBottom.setBackgroundResource(17301522);
                        layout2.addView(dividerBottom);
                    }
                    return layout2;
                }
                return convertView;
            }

            @Override
            public boolean hasStableIds() {
                return false;
            }

            private Container item(int position) {
                if (position < 0 || position >= this.getCount()) {
                    return null;
                }
                return (Container)this.getItem(position);
            }

            @Override
            public long getItemId(int position) {
                Container item = this.item(position);
                if (item == null) {
                    return -1L;
                }
                return item.mId;
            }

            @Override
            public boolean areAllItemsEnabled() {
                return false;
            }

            @Override
            public boolean isEnabled(int position) {
                Container item = this.item(position);
                if (item == null) {
                    return false;
                }
                return 1 == item.mEnabled;
            }
        }

        private class Container {
            static final int OPTGROUP = -1;
            static final int OPTION_DISABLED = 0;
            static final int OPTION_ENABLED = 1;
            String mString;
            int mEnabled;
            int mId;

            private Container() {
            }

            public String toString() {
                return this.mString;
            }
        }
    }

    class PrivateHandler
    extends Handler {
        PrivateHandler() {
        }

        public void handleMessage(Message msg) {
            if (WebView.this.mWebViewCore == null) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    WebView.this.mDatabase.setUsernamePassword(msg.getData().getString("host"), msg.getData().getString("username"), msg.getData().getString("password"));
                    ((Message)msg.obj).sendToTarget();
                    break;
                }
                case 2: {
                    WebView.this.mDatabase.setUsernamePassword(msg.getData().getString("host"), null, null);
                    ((Message)msg.obj).sendToTarget();
                    break;
                }
                case 10: {
                    if ((msg.arg1 != 0 || WebView.this.mPreventDefault != 1) && (msg.arg1 != 2 || WebView.this.mPreventDefault != 2)) break;
                    WebView.this.cancelWebCoreTouchEvent(WebView.this.viewToContentX((int)WebView.this.mLastTouchX + WebView.this.mScrollX), WebView.this.viewToContentY((int)WebView.this.mLastTouchY + WebView.this.mScrollY), true);
                    break;
                }
                case 3: {
                    if (WebView.this.mTouchMode == 1) {
                        if (WebView.this.mPreventDefault != 3) {
                            WebView.this.mTouchMode = 4;
                            WebView.this.updateSelection();
                            break;
                        }
                        WebView.this.mTouchMode = 5;
                        break;
                    }
                    if (WebView.this.mTouchMode != 6) break;
                    WebView.this.mTouchMode = 7;
                    break;
                }
                case 4: {
                    if (WebView.this.inFullScreenMode() || WebView.this.mDeferTouchProcess) {
                        WebViewCore.TouchEventData ted = new WebViewCore.TouchEventData();
                        ted.mAction = 256;
                        ted.mX = WebView.this.viewToContentX((int)WebView.this.mLastTouchX + WebView.this.mScrollX);
                        ted.mY = WebView.this.viewToContentY((int)WebView.this.mLastTouchY + WebView.this.mScrollY);
                        ted.mMetaState = 0;
                        ted.mReprocess = WebView.this.mDeferTouchProcess;
                        if (WebView.this.mDeferTouchProcess) {
                            ted.mViewX = WebView.this.mLastTouchX;
                            ted.mViewY = WebView.this.mLastTouchY;
                        }
                        WebView.this.mWebViewCore.sendMessage(141, ted);
                        break;
                    }
                    if (WebView.this.mPreventDefault == 3) break;
                    WebView.this.mTouchMode = 7;
                    WebView.this.performLongClick();
                    WebView.this.rebuildWebTextView();
                    break;
                }
                case 5: {
                    WebView.this.doShortPress();
                    break;
                }
                case 102: {
                    WebView.this.setContentScrollBy(msg.arg1, msg.arg2, (Boolean)msg.obj);
                    break;
                }
                case 104: {
                    if (WebView.this.mUserScroll) {
                        WebView.this.mUserScroll = false;
                        break;
                    }
                }
                case 101: {
                    if (!WebView.this.setContentScrollTo(msg.arg1, msg.arg2)) break;
                    WebView.this.mUserScroll = false;
                    WebView.this.mWebViewCore.sendMessage(131, msg.arg1, msg.arg2);
                    break;
                }
                case 103: {
                    WebView.this.spawnContentScrollTo(msg.arg1, msg.arg2);
                    break;
                }
                case 109: {
                    WebViewCore.RestoreState restoreState = (WebViewCore.RestoreState)msg.obj;
                    WebView.this.updateZoomRange(restoreState, WebView.this.getViewWidth(), restoreState.mScrollX, false);
                    break;
                }
                case 105: {
                    boolean hasRestoreState;
                    if (WebView.this.mDelayedDeleteRootLayer) {
                        WebView.this.mDelayedDeleteRootLayer = false;
                        WebView.this.nativeSetRootLayer(0);
                    }
                    WebSettings settings = WebView.this.mWebViewCore.getSettings();
                    int viewWidth = WebView.this.getViewWidth();
                    WebViewCore.DrawData draw = (WebViewCore.DrawData)msg.obj;
                    Point viewSize = draw.mViewPoint;
                    boolean useWideViewport = settings.getUseWideViewPort();
                    WebViewCore.RestoreState restoreState = draw.mRestoreState;
                    boolean bl = hasRestoreState = restoreState != null;
                    if (hasRestoreState) {
                        WebView.this.updateZoomRange(restoreState, viewSize.x, draw.mMinPrefWidth, true);
                        if (!WebView.this.mDrawHistory) {
                            WebView.this.mInZoomOverview = false;
                            if (WebView.this.mInitialScaleInPercent > 0) {
                                WebView.this.setNewZoomScale((float)WebView.this.mInitialScaleInPercent / 100.0f, (float)WebView.this.mInitialScaleInPercent != WebView.this.mTextWrapScale * 100.0f, false);
                            } else if (restoreState.mViewScale > 0.0f) {
                                WebView.this.mTextWrapScale = restoreState.mTextWrapScale;
                                WebView.this.setNewZoomScale(restoreState.mViewScale, false, false);
                            } else {
                                WebView.this.mInZoomOverview = useWideViewport && settings.getLoadWithOverviewMode();
                                float scale = WebView.this.mInZoomOverview ? (float)viewWidth / 800.0f : restoreState.mTextWrapScale;
                                WebView.this.setNewZoomScale(scale, Math.abs(scale - WebView.this.mTextWrapScale) >= MINIMUM_SCALE_INCREMENT, false);
                            }
                            WebView.this.setContentScrollTo(restoreState.mScrollX, restoreState.mScrollY);
                            WebView.this.clearTextEntry(false);
                            if (WebView.this.getSettings().getBuiltInZoomControls()) {
                                WebView.this.updateZoomButtonsEnabled();
                            }
                        }
                    }
                    boolean updateLayout = viewSize.x == WebView.this.mLastWidthSent && viewSize.y == WebView.this.mLastHeightSent;
                    WebView.this.recordNewContentSize(draw.mWidthHeight.x, draw.mWidthHeight.y + (WebView.this.mFindIsUp ? WebView.this.mFindHeight : 0), updateLayout);
                    WebView.this.invalidateContentRect(draw.mInvalRegion.getBounds());
                    if (WebView.this.mPictureListener != null) {
                        WebView.this.mPictureListener.onNewPicture(WebView.this, WebView.this.capturePicture());
                    }
                    if (useWideViewport) {
                        WebView.this.mZoomOverviewWidth = Math.min(sMaxViewportWidth, Math.max((int)((float)viewWidth / WebView.this.mDefaultScale), Math.max(draw.mMinPrefWidth, draw.mViewPoint.x)));
                    }
                    if (!WebView.this.mMinZoomScaleFixed) {
                        WebView.this.mMinZoomScale = (float)viewWidth / (float)WebView.this.mZoomOverviewWidth;
                    }
                    if (!WebView.this.mDrawHistory && WebView.this.mInZoomOverview && Math.abs((float)viewWidth * WebView.this.mInvActualScale - (float)WebView.this.mZoomOverviewWidth) > 1.0f) {
                        WebView.this.setNewZoomScale((float)viewWidth / (float)WebView.this.mZoomOverviewWidth, Math.abs(WebView.this.mActualScale - WebView.this.mTextWrapScale) < MINIMUM_SCALE_INCREMENT, false);
                    }
                    if (draw.mFocusSizeChanged && WebView.this.inEditingMode()) {
                        WebView.this.mFocusSizeChanged = true;
                    }
                    if (!hasRestoreState) break;
                    WebView.this.mViewManager.postReadyToDrawAll();
                    break;
                }
                case 107: {
                    WebView.this.nativeCreate(msg.arg1);
                    break;
                }
                case 108: {
                    if (!WebView.this.inEditingMode() || !WebView.this.mWebTextView.isSameTextField(msg.arg1)) break;
                    if (msg.getData().getBoolean("password")) {
                        Editable text = WebView.this.mWebTextView.getText();
                        int start = Selection.getSelectionStart(text);
                        int end = Selection.getSelectionEnd(text);
                        WebView.this.mWebTextView.setInPassword(true);
                        Editable pword = WebView.this.mWebTextView.getText();
                        Selection.setSelection(pword, start, end);
                        break;
                    }
                    if (msg.arg2 != WebView.this.mTextGeneration) break;
                    WebView.this.mWebTextView.setTextAndKeepSelection((String)msg.obj);
                    break;
                }
                case 128: {
                    WebView.this.displaySoftKeyboard(true);
                    WebView.this.updateTextSelectionFromMessage(msg.arg1, msg.arg2, (WebViewCore.TextSelectionData)msg.obj);
                    break;
                }
                case 112: {
                    WebView.this.rebuildWebTextView();
                    WebView.this.updateTextSelectionFromMessage(msg.arg1, msg.arg2, (WebViewCore.TextSelectionData)msg.obj);
                    break;
                }
                case 125: {
                    if (!WebView.this.inEditingMode() || !WebView.this.mWebTextView.isSameTextField(msg.arg1)) break;
                    WebView.this.mWebTextView.setHint((String)msg.obj);
                    InputMethodManager imm = InputMethodManager.peekInstance();
                    if (imm == null || !imm.isActive(WebView.this.mWebTextView)) break;
                    imm.restartInput(WebView.this.mWebTextView);
                    break;
                }
                case 110: {
                    WebView.this.navHandledKey(msg.arg1, 1, false, 0L);
                    break;
                }
                case 106: {
                    WebView.this.selectionDone();
                    if (!WebView.this.inEditingMode() || !WebView.this.nativeCursorIsTextInput()) break;
                    WebView.this.mWebTextView.bringIntoView();
                    WebView.this.rebuildWebTextView();
                    break;
                }
                case 111: {
                    WebView.this.clearTextEntry(false);
                    break;
                }
                case 117: {
                    Rect r = (Rect)msg.obj;
                    if (r == null) {
                        WebView.this.invalidate();
                        break;
                    }
                    WebView.this.viewInvalidate(r.left, r.top, r.right, r.bottom);
                    break;
                }
                case 123: {
                    WebView.this.invalidate();
                    break;
                }
                case 124: {
                    if (0 == msg.arg1) {
                        WebView.this.mDelayedDeleteRootLayer = true;
                        break;
                    }
                    WebView.this.mDelayedDeleteRootLayer = false;
                    WebView.this.nativeSetRootLayer(msg.arg1);
                    WebView.this.invalidate();
                    break;
                }
                case 6: {
                    WebTextView.AutoCompleteAdapter adapter = (WebTextView.AutoCompleteAdapter)msg.obj;
                    if (!WebView.this.mWebTextView.isSameTextField(msg.arg1)) break;
                    WebView.this.mWebTextView.setAdapterCustom(adapter);
                    break;
                }
                case 7: {
                    WebViewCore.resumePriority();
                    WebViewCore.resumeUpdatePicture(WebView.this.mWebViewCore);
                    break;
                }
                case 114: {
                    WebView.this.mGotCenterDown = false;
                    WebView.this.mTrackballDown = false;
                    WebView.this.performLongClick();
                    break;
                }
                case 116: {
                    WebView.this.mForwardTouchEvents = msg.arg1 != 0;
                    break;
                }
                case 115: {
                    if (WebView.this.inFullScreenMode()) break;
                    if (msg.obj == null) {
                        if (msg.arg1 == 0 && WebView.this.mPreventDefault == 1) {
                            WebView.this.mPreventDefault = msg.arg2 == 1 ? 3 : 2;
                            break;
                        }
                        if (msg.arg1 != 2 || WebView.this.mPreventDefault != 2) break;
                        WebView.this.mPreventDefault = msg.arg2 == 1 ? 3 : 0;
                        break;
                    }
                    if (msg.arg2 != 0) break;
                    WebViewCore.TouchEventData ted = (WebViewCore.TouchEventData)msg.obj;
                    switch (ted.mAction) {
                        case 0: {
                            WebView.this.mLastDeferTouchX = ted.mViewX;
                            WebView.this.mLastDeferTouchY = ted.mViewY;
                            WebView.this.mDeferTouchMode = 1;
                            break;
                        }
                        case 2: {
                            if (WebView.this.mDeferTouchMode != 3) {
                                WebView.this.mDeferTouchMode = 3;
                                WebView.this.mLastDeferTouchX = ted.mViewX;
                                WebView.this.mLastDeferTouchY = ted.mViewY;
                                WebView.this.startDrag();
                            }
                            int deltaX = WebView.this.pinLocX((int)((float)WebView.this.mScrollX + WebView.this.mLastDeferTouchX - ted.mViewX)) - WebView.this.mScrollX;
                            int deltaY = WebView.this.pinLocY((int)((float)WebView.this.mScrollY + WebView.this.mLastDeferTouchY - ted.mViewY)) - WebView.this.mScrollY;
                            WebView.this.doDrag(deltaX, deltaY);
                            if (deltaX != 0) {
                                WebView.this.mLastDeferTouchX = ted.mViewX;
                            }
                            if (deltaY == 0) break;
                            WebView.this.mLastDeferTouchY = ted.mViewY;
                            break;
                        }
                        case 1: 
                        case 3: {
                            if (WebView.this.mDeferTouchMode == 3) {
                                WebView.this.mScroller.springBack(WebView.this.mScrollX, WebView.this.mScrollY, 0, WebView.this.computeMaxScrollX(), 0, WebView.this.computeMaxScrollY());
                                WebView.this.invalidate();
                                WebViewCore.resumePriority();
                                WebViewCore.resumeUpdatePicture(WebView.this.mWebViewCore);
                            }
                            WebView.this.mDeferTouchMode = 7;
                            break;
                        }
                        case 512: {
                            WebView.this.mLastTouchX = ted.mViewX;
                            WebView.this.mLastTouchY = ted.mViewY;
                            WebView.this.doDoubleTap();
                            WebView.this.mDeferTouchMode = 7;
                            break;
                        }
                        case 256: {
                            HitTestResult hitTest = WebView.this.getHitTestResult();
                            if (hitTest != null && hitTest.mType != 0) {
                                WebView.this.performLongClick();
                                WebView.this.rebuildWebTextView();
                            }
                            WebView.this.mDeferTouchMode = 7;
                        }
                    }
                    break;
                }
                case 118: {
                    if (msg.arg1 == 0) {
                        WebView.this.hideSoftKeyboard();
                        break;
                    }
                    WebView.this.displaySoftKeyboard(false);
                    break;
                }
                case 126: {
                    if (!WebView.this.mFindIsUp) break;
                    WebView.this.findAll(WebView.this.mLastFind);
                    break;
                }
                case 8: {
                    WebView.this.mHeldMotionless = 2;
                    WebView.this.invalidate();
                }
                case 9: {
                    if (WebView.this.mTouchMode != 3 || WebView.this.mHeldMotionless != 2) break;
                    WebView.this.awakenScrollBars(ViewConfiguration.getScrollDefaultDelay(), false);
                    WebView.this.mPrivateHandler.sendMessageDelayed(WebView.this.mPrivateHandler.obtainMessage(9), ViewConfiguration.getScrollDefaultDelay());
                    break;
                }
                case 119: {
                    WebView.this.doMotionUp(msg.arg1, msg.arg2);
                    break;
                }
                case 120: {
                    View view = (View)msg.obj;
                    int npp = msg.arg1;
                    if (WebView.this.mFullScreenHolder != null) {
                        Log.w(WebView.LOGTAG, "Should not have another full screen.");
                        WebView.this.mFullScreenHolder.dismiss();
                    }
                    WebView.this.mFullScreenHolder = new PluginFullScreenHolder(WebView.this, npp);
                    WebView.this.mFullScreenHolder.setContentView(view);
                    WebView.this.mFullScreenHolder.setCancelable(false);
                    WebView.this.mFullScreenHolder.setCanceledOnTouchOutside(false);
                    WebView.this.mFullScreenHolder.show();
                    break;
                }
                case 121: {
                    if (!WebView.this.inFullScreenMode()) break;
                    WebView.this.mFullScreenHolder.dismiss();
                    WebView.this.mFullScreenHolder = null;
                    break;
                }
                case 122: {
                    if (!WebView.this.inEditingMode()) break;
                    WebView.this.nativeClearCursor();
                    WebView.this.rebuildWebTextView();
                    break;
                }
                case 113: {
                    WebViewCore.ShowRectData data = (WebViewCore.ShowRectData)msg.obj;
                    int x = WebView.this.mScrollX;
                    int left = WebView.this.contentToViewX(data.mLeft);
                    int width = WebView.this.contentToViewDimension(data.mWidth);
                    int maxWidth = WebView.this.contentToViewDimension(data.mContentWidth);
                    int viewWidth = WebView.this.getViewWidth();
                    x = width < viewWidth ? (x += left + width / 2 - WebView.this.mScrollX - viewWidth / 2) : (x += (int)((float)left + data.mXPercentInDoc * (float)width - (float)WebView.this.mScrollX - data.mXPercentInView * (float)viewWidth));
                    x = Math.max(0, Math.min(maxWidth, x + viewWidth) - viewWidth);
                    int top = WebView.this.contentToViewY(data.mTop);
                    int height = WebView.this.contentToViewDimension(data.mHeight);
                    int maxHeight = WebView.this.contentToViewDimension(data.mContentHeight);
                    int viewHeight = WebView.this.getViewHeight();
                    int y = (int)((float)top + data.mYPercentInDoc * (float)height - data.mYPercentInView * (float)viewHeight);
                    y = Math.max(0, Math.min(maxHeight, y + viewHeight) - viewHeight);
                    y = Math.max(0, y - WebView.this.getVisibleTitleHeight());
                    WebView.this.scrollTo(x, y);
                    break;
                }
                case 127: {
                    Rect r = (Rect)msg.obj;
                    WebView.this.mInZoomOverview = false;
                    WebView.this.centerFitRect(r.left, r.top, r.width(), r.height());
                    break;
                }
                case 129: {
                    WebView.this.mHorizontalScrollBarMode = msg.arg1;
                    WebView.this.mVerticalScrollBarMode = msg.arg2;
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }

    private class ScaleDetectorListener
    implements ScaleGestureDetector.OnScaleGestureListener {
        private ScaleDetectorListener() {
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            WebView.this.cancelTouch();
            WebView.this.dismissZoomControl();
            WebView.this.mInZoomOverview = false;
            if (WebView.this.inEditingMode() && WebView.this.nativeFocusCandidateIsPassword()) {
                WebView.this.mWebTextView.setInPassword(false);
            }
            WebView.this.mViewManager.startZoom();
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            if (WebView.this.mPreviewZoomOnly) {
                WebView.this.mPreviewZoomOnly = false;
                WebView.this.mAnchorX = WebView.this.viewToContentX((int)WebView.this.mZoomCenterX + WebView.this.mScrollX);
                WebView.this.mAnchorY = WebView.this.viewToContentY((int)WebView.this.mZoomCenterY + WebView.this.mScrollY);
                boolean reflowNow = WebView.this.mActualScale - WebView.this.mMinZoomScale <= MINIMUM_SCALE_INCREMENT || (double)WebView.this.mActualScale <= 0.8 * (double)WebView.this.mTextWrapScale;
                WebView.this.setNewZoomScale(WebView.this.mActualScale, reflowNow, true);
                WebView.this.invalidate();
            }
            if (WebView.this.inEditingMode() && WebView.this.didUpdateTextViewBounds(false) && WebView.this.nativeFocusCandidateIsPassword()) {
                WebView.this.mWebTextView.setInPassword(true);
            }
            WebView.this.mTouchMode = 8;
            WebView.this.mConfirmMove = true;
            WebView.this.startTouch(detector.getFocusX(), detector.getFocusY(), WebView.this.mLastTouchTime);
            WebView.this.mViewManager.endZoom();
        }

        public boolean onScale(ScaleGestureDetector detector) {
            float scale = (float)((double)Math.round(detector.getScaleFactor() * WebView.this.mActualScale * 100.0f) / 100.0);
            if (Math.abs(scale - WebView.this.mActualScale) >= MINIMUM_SCALE_INCREMENT) {
                WebView.this.mPreviewZoomOnly = true;
                scale = scale > WebView.this.mActualScale ? Math.min(scale, WebView.this.mActualScale * 1.25f) : Math.max(scale, WebView.this.mActualScale * 0.8f);
                WebView.this.mZoomCenterX = detector.getFocusX();
                WebView.this.mZoomCenterY = detector.getFocusY();
                WebView.this.setNewZoomScale(scale, false, false);
                WebView.this.invalidate();
                return true;
            }
            return false;
        }
    }

    public static class DragTracker {
        public void onStartDrag(float x, float y) {
        }

        public boolean onStretchChange(float sx, float sy) {
            return false;
        }

        public void onStopDrag() {
        }

        public void onBitmapChange(Bitmap bm) {
        }

        public void onDraw(Canvas canvas) {
        }
    }

    private class DragTrackerHandler {
        private final DragTracker mProxy;
        private final float mStartY;
        private final float mStartX;
        private final float mMinDY;
        private final float mMinDX;
        private final float mMaxDY;
        private final float mMaxDX;
        private float mCurrStretchY;
        private float mCurrStretchX;
        private int mSX;
        private int mSY;
        private Interpolator mInterp;
        private float[] mXY = new float[2];
        private static final int DRAGGING_STATE = 0;
        private static final int ANIMATING_STATE = 1;
        private static final int FINISHED_STATE = 2;
        private int mState;

        public DragTrackerHandler(float x, float y, DragTracker proxy) {
            this.mProxy = proxy;
            int docBottom = WebView.this.computeRealVerticalScrollRange() + WebView.this.getTitleHeight();
            int viewTop = WebView.this.getScrollY();
            int viewBottom = viewTop + WebView.this.getHeight();
            this.mStartY = y;
            this.mMinDY = -viewTop;
            this.mMaxDY = docBottom - viewBottom;
            int docRight = WebView.this.computeRealHorizontalScrollRange();
            int viewLeft = WebView.this.getScrollX();
            int viewRight = viewLeft + WebView.this.getWidth();
            this.mStartX = x;
            this.mMinDX = -viewLeft;
            this.mMaxDX = docRight - viewRight;
            this.mState = 0;
            this.mProxy.onStartDrag(x, y);
            this.mSX = -99999;
        }

        private float computeStretch(float delta, float min, float max) {
            float stretch = 0.0f;
            if (max - min > 4.0f) {
                if (delta < min) {
                    stretch = delta - min;
                } else if (delta > max) {
                    stretch = delta - max;
                }
            }
            return stretch;
        }

        public void dragTo(float x, float y) {
            float sy = this.computeStretch(this.mStartY - y, this.mMinDY, this.mMaxDY);
            float sx = this.computeStretch(this.mStartX - x, this.mMinDX, this.mMaxDX);
            if ((WebView.this.mSnapScrollMode & 2) != 0) {
                sy = 0.0f;
            } else if ((WebView.this.mSnapScrollMode & 4) != 0) {
                sx = 0.0f;
            }
            if (this.mCurrStretchX != sx || this.mCurrStretchY != sy) {
                this.mCurrStretchX = sx;
                this.mCurrStretchY = sy;
                if (this.mProxy.onStretchChange(sx, sy)) {
                    WebView.this.invalidate();
                }
            }
        }

        public void stopDrag() {
            int DURATION = 200;
            int now = (int)SystemClock.uptimeMillis();
            this.mInterp = new Interpolator(2);
            this.mXY[0] = this.mCurrStretchX;
            this.mXY[1] = this.mCurrStretchY;
            float[] blend = new float[]{0.0f, 0.5f, 0.75f, 1.0f};
            this.mInterp.setKeyFrame(0, now, this.mXY, blend);
            float[] zerozero = new float[]{0.0f, 0.0f};
            this.mInterp.setKeyFrame(1, now + 200, zerozero, null);
            this.mState = 1;
        }

        public boolean isFinished() {
            return this.mState == 2;
        }

        private int hiddenHeightOfTitleBar() {
            return WebView.this.getTitleHeight() - WebView.this.getVisibleTitleHeight();
        }

        private Bitmap.Config offscreenBitmapConfig() {
            return Bitmap.Config.RGB_565;
        }

        public boolean draw(Canvas canvas) {
            if (this.mCurrStretchX != 0.0f || this.mCurrStretchY != 0.0f) {
                int sx = WebView.this.getScrollX();
                int sy = WebView.this.getScrollY() - this.hiddenHeightOfTitleBar();
                if (this.mSX != sx || this.mSY != sy) {
                    this.buildBitmap(sx, sy);
                    this.mSX = sx;
                    this.mSY = sy;
                }
                if (this.mState == 1) {
                    Interpolator.Result result = this.mInterp.timeToValues(this.mXY);
                    if (result == Interpolator.Result.FREEZE_END) {
                        this.mState = 2;
                        return false;
                    }
                    this.mProxy.onStretchChange(this.mXY[0], this.mXY[1]);
                    WebView.this.invalidate();
                }
                int count = canvas.save(1);
                canvas.translate(sx, sy);
                this.mProxy.onDraw(canvas);
                canvas.restoreToCount(count);
                return true;
            }
            return false;
        }

        private void buildBitmap(int sx, int sy) {
            int w = WebView.this.getWidth();
            int h = WebView.this.getViewHeight();
            Bitmap bm = Bitmap.createBitmap(w, h, this.offscreenBitmapConfig());
            Canvas canvas = new Canvas(bm);
            canvas.translate(-sx, -sy);
            WebView.this.drawContent(canvas);
            this.mProxy.onBitmapChange(bm);
        }
    }

    private static class PostScale
    implements Runnable {
        final WebView mWebView;
        final boolean mUpdateTextWrap;

        public PostScale(WebView webView, boolean updateTextWrap) {
            this.mWebView = webView;
            this.mUpdateTextWrap = updateTextWrap;
        }

        public void run() {
            if (this.mWebView.mWebViewCore != null) {
                this.mWebView.setNewZoomScale(this.mWebView.mActualScale, this.mUpdateTextWrap, true);
                if (this.mWebView.getSettings().getBuiltInZoomControls()) {
                    this.mWebView.updateZoomButtonsEnabled();
                }
            }
        }
    }

    private class RequestFormData
    implements Runnable {
        private String mName;
        private String mUrl;
        private Message mUpdateMessage;

        public RequestFormData(String name, String url, Message msg) {
            this.mName = name;
            this.mUrl = url;
            this.mUpdateMessage = msg;
        }

        public void run() {
            ArrayList<String> pastEntries = WebView.this.mDatabase.getFormData(this.mUrl, this.mName);
            if (pastEntries.size() > 0) {
                WebTextView.AutoCompleteAdapter adapter = new WebTextView.AutoCompleteAdapter(WebView.this.mContext, pastEntries);
                this.mUpdateMessage.obj = adapter;
                this.mUpdateMessage.sendToTarget();
            }
        }
    }

    static class ViewSizeData {
        int mWidth;
        int mHeight;
        int mTextWrapWidth;
        int mAnchorX;
        int mAnchorY;
        float mScale;
        boolean mIgnoreHeight;

        ViewSizeData() {
        }
    }

    public class HitTestResult {
        public static final int UNKNOWN_TYPE = 0;
        public static final int ANCHOR_TYPE = 1;
        public static final int PHONE_TYPE = 2;
        public static final int GEO_TYPE = 3;
        public static final int EMAIL_TYPE = 4;
        public static final int IMAGE_TYPE = 5;
        public static final int IMAGE_ANCHOR_TYPE = 6;
        public static final int SRC_ANCHOR_TYPE = 7;
        public static final int SRC_IMAGE_ANCHOR_TYPE = 8;
        public static final int EDIT_TEXT_TYPE = 9;
        private int mType = 0;
        private String mExtra;

        HitTestResult() {
        }

        private void setType(int type) {
            this.mType = type;
        }

        private void setExtra(String extra) {
            this.mExtra = extra;
        }

        public int getType() {
            return this.mType;
        }

        public String getExtra() {
            return this.mExtra;
        }
    }

    public static interface PictureListener {
        public void onNewPicture(WebView var1, Picture var2);
    }

    public class WebViewTransport {
        private WebView mWebview;

        public synchronized void setWebView(WebView webview) {
            this.mWebview = webview;
        }

        public synchronized WebView getWebView() {
            return this.mWebview;
        }
    }

    private static class ExtendedZoomControls
    extends FrameLayout {
        ZoomControls mPlusMinusZoomControls;

        public ExtendedZoomControls(Context context, AttributeSet attrs) {
            super(context, attrs);
            LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
            inflater.inflate(17367151, (ViewGroup)this, true);
            this.mPlusMinusZoomControls = (ZoomControls)this.findViewById(16908847);
            this.findViewById(16908850).setVisibility(8);
        }

        public void show(boolean showZoom, boolean canZoomOut) {
            this.mPlusMinusZoomControls.setVisibility(showZoom ? 0 : 8);
            this.fade(0, 0.0f, 1.0f);
        }

        public void hide() {
            this.fade(8, 1.0f, 0.0f);
        }

        private void fade(int visibility, float startAlpha, float endAlpha) {
            AlphaAnimation anim2 = new AlphaAnimation(startAlpha, endAlpha);
            anim2.setDuration(500L);
            this.startAnimation(anim2);
            this.setVisibility(visibility);
        }

        public boolean hasFocus() {
            return this.mPlusMinusZoomControls.hasFocus();
        }

        public void setOnZoomInClickListener(View.OnClickListener listener) {
            this.mPlusMinusZoomControls.setOnZoomInClickListener(listener);
        }

        public void setOnZoomOutClickListener(View.OnClickListener listener) {
            this.mPlusMinusZoomControls.setOnZoomOutClickListener(listener);
        }
    }
}

