/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.media.MediaPlayer;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

class HTML5Audio
extends Handler
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnSeekCompleteListener {
    private static final String LOGTAG = "HTML5Audio";
    private MediaPlayer mMediaPlayer;
    private int mNativePointer;
    private static int IDLE = 0;
    private static int INITIALIZED = 1;
    private static int PREPARED = 2;
    private static int STARTED = 4;
    private static int COMPLETE = 5;
    private static int PAUSED = 6;
    private static int STOPPED = -2;
    private static int ERROR = -1;
    private int mState = IDLE;
    private String mUrl;
    private boolean mAskToPlay = false;
    private static final int TIMEUPDATE = 100;
    private static final int TIMEUPDATE_PERIOD = 250;
    private Timer mTimer;

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                try {
                    if (this.mState == ERROR || !this.mMediaPlayer.isPlaying()) break;
                    int position = this.mMediaPlayer.getCurrentPosition();
                    this.nativeOnTimeupdate(position, this.mNativePointer);
                    break;
                }
                catch (IllegalStateException e) {
                    this.mState = ERROR;
                }
            }
        }
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
        this.nativeOnBuffering(percent, this.mNativePointer);
    }

    public void onCompletion(MediaPlayer mp) {
        this.resetMediaPlayer();
        this.mState = IDLE;
        this.nativeOnEnded(this.mNativePointer);
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        this.mState = ERROR;
        this.resetMediaPlayer();
        this.mState = IDLE;
        return false;
    }

    public void onPrepared(MediaPlayer mp) {
        this.mState = PREPARED;
        if (this.mTimer != null) {
            this.mTimer.schedule((TimerTask)new TimeupdateTask(), 250L, 250L);
        }
        this.nativeOnPrepared(mp.getDuration(), 0, 0, this.mNativePointer);
        if (this.mAskToPlay) {
            this.mAskToPlay = false;
            this.play();
        }
    }

    public void onSeekComplete(MediaPlayer mp) {
        this.nativeOnTimeupdate(mp.getCurrentPosition(), this.mNativePointer);
    }

    public HTML5Audio(int nativePtr) {
        this.mNativePointer = nativePtr;
        this.resetMediaPlayer();
    }

    private void resetMediaPlayer() {
        if (this.mMediaPlayer == null) {
            this.mMediaPlayer = new MediaPlayer();
        } else {
            this.mMediaPlayer.reset();
        }
        this.mMediaPlayer.setOnBufferingUpdateListener(this);
        this.mMediaPlayer.setOnCompletionListener(this);
        this.mMediaPlayer.setOnErrorListener(this);
        this.mMediaPlayer.setOnPreparedListener(this);
        this.mMediaPlayer.setOnSeekCompleteListener(this);
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        this.mTimer = new Timer();
        this.mState = IDLE;
    }

    private void setDataSource(String url) {
        this.mUrl = url;
        try {
            if (this.mState != IDLE) {
                this.resetMediaPlayer();
            }
            this.mMediaPlayer.setDataSource(url);
            this.mState = INITIALIZED;
            this.mMediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            Log.e(LOGTAG, "couldn't load the resource: " + url + " exc: " + e);
            this.resetMediaPlayer();
        }
    }

    private void play() {
        if ((this.mState == ERROR || this.mState == IDLE) && this.mUrl != null) {
            this.resetMediaPlayer();
            this.setDataSource(this.mUrl);
            this.mAskToPlay = true;
        }
        if (this.mState >= PREPARED) {
            this.mMediaPlayer.start();
            this.mState = STARTED;
        }
    }

    private void pause() {
        if (this.mState == STARTED) {
            if (this.mTimer != null) {
                this.mTimer.purge();
            }
            this.mMediaPlayer.pause();
            this.mState = PAUSED;
        }
    }

    private void seek(int msec) {
        if (this.mState >= PREPARED) {
            this.mMediaPlayer.seekTo(msec);
        }
    }

    private void teardown() {
        this.mMediaPlayer.release();
        this.mState = ERROR;
        this.mNativePointer = 0;
    }

    private float getMaxTimeSeekable() {
        return (float)this.mMediaPlayer.getDuration() / 1000.0f;
    }

    private native void nativeOnBuffering(int var1, int var2);

    private native void nativeOnEnded(int var1);

    private native void nativeOnPrepared(int var1, int var2, int var3, int var4);

    private native void nativeOnTimeupdate(int var1, int var2);

    private final class TimeupdateTask
    extends TimerTask {
        private TimeupdateTask() {
        }

        public void run() {
            HTML5Audio.this.obtainMessage(100).sendToTarget();
        }
    }
}

