/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.view.Display;
import android.view.InputQueue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.WindowManagerImpl;
import android.view.accessibility.AccessibilityEvent;
import com.android.internal.R;

public abstract class Window {
    public static final int FEATURE_OPTIONS_PANEL = 0;
    public static final int FEATURE_NO_TITLE = 1;
    public static final int FEATURE_PROGRESS = 2;
    public static final int FEATURE_LEFT_ICON = 3;
    public static final int FEATURE_RIGHT_ICON = 4;
    public static final int FEATURE_INDETERMINATE_PROGRESS = 5;
    public static final int FEATURE_CONTEXT_MENU = 6;
    public static final int FEATURE_CUSTOM_TITLE = 7;
    public static final int FEATURE_OPENGL = 8;
    public static final int PROGRESS_VISIBILITY_ON = -1;
    public static final int PROGRESS_VISIBILITY_OFF = -2;
    public static final int PROGRESS_INDETERMINATE_ON = -3;
    public static final int PROGRESS_INDETERMINATE_OFF = -4;
    public static final int PROGRESS_START = 0;
    public static final int PROGRESS_END = 10000;
    public static final int PROGRESS_SECONDARY_START = 20000;
    public static final int PROGRESS_SECONDARY_END = 30000;
    protected static final int DEFAULT_FEATURES = 65;
    public static final int ID_ANDROID_CONTENT = 0x1020002;
    private final Context mContext;
    private TypedArray mWindowStyle;
    private Callback mCallback;
    private WindowManager mWindowManager;
    private IBinder mAppToken;
    private String mAppName;
    private Window mContainer;
    private Window mActiveChild;
    private boolean mIsActive = false;
    private boolean mHasChildren = false;
    private int mForcedWindowFlags = 0;
    private int mFeatures = 65;
    private int mLocalFeatures = 65;
    private boolean mHaveWindowFormat = false;
    private int mDefaultWindowFormat = -1;
    private boolean mHasSoftInputMode = false;
    private final WindowManager.LayoutParams mWindowAttributes = new WindowManager.LayoutParams();

    public Window(Context context) {
        this.mContext = context;
    }

    public final Context getContext() {
        return this.mContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TypedArray getWindowStyle() {
        Window window = this;
        synchronized (window) {
            if (this.mWindowStyle == null) {
                this.mWindowStyle = this.mContext.obtainStyledAttributes(R.styleable.Window);
            }
            return this.mWindowStyle;
        }
    }

    public void setContainer(Window container) {
        this.mContainer = container;
        if (container != null) {
            this.mFeatures |= 2;
            this.mLocalFeatures |= 2;
            container.mHasChildren = true;
        }
    }

    public final Window getContainer() {
        return this.mContainer;
    }

    public final boolean hasChildren() {
        return this.mHasChildren;
    }

    public void setWindowManager(WindowManager wm, IBinder appToken, String appName) {
        this.mAppToken = appToken;
        this.mAppName = appName;
        if (wm == null) {
            wm = WindowManagerImpl.getDefault();
        }
        this.mWindowManager = new LocalWindowManager(wm);
    }

    public WindowManager getWindowManager() {
        return this.mWindowManager;
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public final Callback getCallback() {
        return this.mCallback;
    }

    public abstract void takeSurface(SurfaceHolder.Callback2 var1);

    public abstract void takeInputQueue(InputQueue.Callback var1);

    public abstract boolean isFloating();

    public void setLayout(int width, int height) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.width = width;
        attrs.height = height;
        if (this.mCallback != null) {
            this.mCallback.onWindowAttributesChanged(attrs);
        }
    }

    public void setGravity(int gravity) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.gravity = gravity;
        if (this.mCallback != null) {
            this.mCallback.onWindowAttributesChanged(attrs);
        }
    }

    public void setType(int type) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.type = type;
        if (this.mCallback != null) {
            this.mCallback.onWindowAttributesChanged(attrs);
        }
    }

    public void setFormat(int format) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        if (format != 0) {
            attrs.format = format;
            this.mHaveWindowFormat = true;
        } else {
            attrs.format = this.mDefaultWindowFormat;
            this.mHaveWindowFormat = false;
        }
        if (this.mCallback != null) {
            this.mCallback.onWindowAttributesChanged(attrs);
        }
    }

    public void setWindowAnimations(int resId) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.windowAnimations = resId;
        if (this.mCallback != null) {
            this.mCallback.onWindowAttributesChanged(attrs);
        }
    }

    public void setSoftInputMode(int mode) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        if (mode != 0) {
            attrs.softInputMode = mode;
            this.mHasSoftInputMode = true;
        } else {
            this.mHasSoftInputMode = false;
        }
        if (this.mCallback != null) {
            this.mCallback.onWindowAttributesChanged(attrs);
        }
    }

    public void addFlags(int flags) {
        this.setFlags(flags, flags);
    }

    public void clearFlags(int flags) {
        this.setFlags(0, flags);
    }

    public void setFlags(int flags, int mask) {
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.flags = attrs.flags & ~mask | flags & mask;
        this.mForcedWindowFlags |= mask;
        if (this.mCallback != null) {
            this.mCallback.onWindowAttributesChanged(attrs);
        }
    }

    public void setAttributes(WindowManager.LayoutParams a) {
        this.mWindowAttributes.copyFrom(a);
        if (this.mCallback != null) {
            this.mCallback.onWindowAttributesChanged(this.mWindowAttributes);
        }
    }

    public final WindowManager.LayoutParams getAttributes() {
        return this.mWindowAttributes;
    }

    protected final int getForcedWindowFlags() {
        return this.mForcedWindowFlags;
    }

    protected final boolean hasSoftInputMode() {
        return this.mHasSoftInputMode;
    }

    public boolean requestFeature(int featureId) {
        int flag = 1 << featureId;
        this.mFeatures |= flag;
        this.mLocalFeatures |= this.mContainer != null ? flag & ~this.mContainer.mFeatures : flag;
        return (this.mFeatures & flag) != 0;
    }

    public final void makeActive() {
        if (this.mContainer != null) {
            if (this.mContainer.mActiveChild != null) {
                this.mContainer.mActiveChild.mIsActive = false;
            }
            this.mContainer.mActiveChild = this;
        }
        this.mIsActive = true;
        this.onActive();
    }

    public final boolean isActive() {
        return this.mIsActive;
    }

    public View findViewById(int id2) {
        return this.getDecorView().findViewById(id2);
    }

    public abstract void setContentView(int var1);

    public abstract void setContentView(View var1);

    public abstract void setContentView(View var1, ViewGroup.LayoutParams var2);

    public abstract void addContentView(View var1, ViewGroup.LayoutParams var2);

    public abstract View getCurrentFocus();

    public abstract LayoutInflater getLayoutInflater();

    public abstract void setTitle(CharSequence var1);

    public abstract void setTitleColor(int var1);

    public abstract void openPanel(int var1, KeyEvent var2);

    public abstract void closePanel(int var1);

    public abstract void togglePanel(int var1, KeyEvent var2);

    public abstract boolean performPanelShortcut(int var1, int var2, KeyEvent var3, int var4);

    public abstract boolean performPanelIdentifierAction(int var1, int var2, int var3);

    public abstract void closeAllPanels();

    public abstract boolean performContextMenuIdentifierAction(int var1, int var2);

    public abstract void onConfigurationChanged(Configuration var1);

    public void setBackgroundDrawableResource(int resid) {
        this.setBackgroundDrawable(this.mContext.getResources().getDrawable(resid));
    }

    public abstract void setBackgroundDrawable(Drawable var1);

    public abstract void setFeatureDrawableResource(int var1, int var2);

    public abstract void setFeatureDrawableUri(int var1, Uri var2);

    public abstract void setFeatureDrawable(int var1, Drawable var2);

    public abstract void setFeatureDrawableAlpha(int var1, int var2);

    public abstract void setFeatureInt(int var1, int var2);

    public abstract void takeKeyEvents(boolean var1);

    public abstract boolean superDispatchKeyEvent(KeyEvent var1);

    public abstract boolean superDispatchTouchEvent(MotionEvent var1);

    public abstract boolean superDispatchTrackballEvent(MotionEvent var1);

    public abstract View getDecorView();

    public abstract View peekDecorView();

    public abstract Bundle saveHierarchyState();

    public abstract void restoreHierarchyState(Bundle var1);

    protected abstract void onActive();

    protected final int getFeatures() {
        return this.mFeatures;
    }

    protected final int getLocalFeatures() {
        return this.mLocalFeatures;
    }

    protected void setDefaultWindowFormat(int format) {
        this.mDefaultWindowFormat = format;
        if (!this.mHaveWindowFormat) {
            WindowManager.LayoutParams attrs = this.getAttributes();
            attrs.format = format;
            if (this.mCallback != null) {
                this.mCallback.onWindowAttributesChanged(attrs);
            }
        }
    }

    public abstract void setChildDrawable(int var1, Drawable var2);

    public abstract void setChildInt(int var1, int var2);

    public abstract boolean isShortcutKey(int var1, KeyEvent var2);

    public abstract void setVolumeControlStream(int var1);

    public abstract int getVolumeControlStream();

    private class LocalWindowManager
    implements WindowManager {
        private final WindowManager mWindowManager;
        private final Display mDefaultDisplay;

        LocalWindowManager(WindowManager wm) {
            this.mWindowManager = wm;
            this.mDefaultDisplay = Window.this.mContext.getResources().getDefaultDisplay(this.mWindowManager.getDefaultDisplay());
        }

        public final void addView(View view, ViewGroup.LayoutParams params) {
            WindowManager.LayoutParams wp = (WindowManager.LayoutParams)params;
            CharSequence curTitle = wp.getTitle();
            if (wp.type >= 1000 && wp.type <= 1999) {
                View decor;
                if (wp.token == null && (decor = Window.this.peekDecorView()) != null) {
                    wp.token = decor.getWindowToken();
                }
                if (curTitle == null || curTitle.length() == 0) {
                    String title = wp.type == 1001 ? "Media" : (wp.type == 1004 ? "MediaOvr" : (wp.type == 1000 ? "Panel" : (wp.type == 1002 ? "SubPanel" : (wp.type == 1003 ? "AtchDlg" : Integer.toString(wp.type)))));
                    if (Window.this.mAppName != null) {
                        title = title + ":" + Window.this.mAppName;
                    }
                    wp.setTitle(title);
                }
            } else {
                if (wp.token == null) {
                    IBinder iBinder = wp.token = Window.this.mContainer == null ? Window.this.mAppToken : Window.this.mContainer.mAppToken;
                }
                if ((curTitle == null || curTitle.length() == 0) && Window.this.mAppName != null) {
                    wp.setTitle(Window.this.mAppName);
                }
            }
            if (wp.packageName == null) {
                wp.packageName = Window.this.mContext.getPackageName();
            }
            this.mWindowManager.addView(view, params);
        }

        public void updateViewLayout(View view, ViewGroup.LayoutParams params) {
            this.mWindowManager.updateViewLayout(view, params);
        }

        public final void removeView(View view) {
            this.mWindowManager.removeView(view);
        }

        public final void removeViewImmediate(View view) {
            this.mWindowManager.removeViewImmediate(view);
        }

        public Display getDefaultDisplay() {
            return this.mDefaultDisplay;
        }
    }

    public static interface Callback {
        public boolean dispatchKeyEvent(KeyEvent var1);

        public boolean dispatchTouchEvent(MotionEvent var1);

        public boolean dispatchTrackballEvent(MotionEvent var1);

        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent var1);

        public View onCreatePanelView(int var1);

        public boolean onCreatePanelMenu(int var1, Menu var2);

        public boolean onPreparePanel(int var1, View var2, Menu var3);

        public boolean onMenuOpened(int var1, Menu var2);

        public boolean onMenuItemSelected(int var1, MenuItem var2);

        public void onWindowAttributesChanged(WindowManager.LayoutParams var1);

        public void onContentChanged();

        public void onWindowFocusChanged(boolean var1);

        public void onAttachedToWindow();

        public void onDetachedFromWindow();

        public void onPanelClosed(int var1, Menu var2);

        public boolean onSearchRequested();
    }
}

