/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.provider.Calendar;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.text.format.Time;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Locale;

public class CalendarUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = "CalendarUtils";

    public static void setSharedPreference(SharedPreferences prefs, String key, String value) {
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(key, value);
        editor.apply();
    }

    public static void setSharedPreference(SharedPreferences prefs, String key, boolean value) {
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean(key, value);
        editor.apply();
    }

    public static SharedPreferences getSharedPreferences(Context context, String prefsName) {
        return context.getSharedPreferences(prefsName, 0);
    }

    public static class TimeZoneUtils {
        private static final String[] TIMEZONE_TYPE_ARGS = new String[]{"timezoneType"};
        private static final String[] TIMEZONE_INSTANCES_ARGS = new String[]{"timezoneInstances"};
        private static StringBuilder mSB = new StringBuilder(50);
        private static Formatter mF = new Formatter(mSB, Locale.getDefault());
        private static volatile boolean mFirstTZRequest = true;
        private static volatile boolean mTZQueryInProgress = false;
        private static volatile boolean mUseHomeTZ = false;
        private static volatile String mHomeTZ = Time.getCurrentTimezone();
        private static HashSet<Runnable> mTZCallbacks = new HashSet();
        private static int mToken = 1;
        private static AsyncTZHandler mHandler;
        private final String mPrefsName;
        public static final String KEY_HOME_TZ_ENABLED = "preferences_home_tz_enabled";
        public static final String KEY_HOME_TZ = "preferences_home_tz";

        public TimeZoneUtils(String prefsName) {
            this.mPrefsName = prefsName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String formatDateRange(Context context, long startMillis, long endMillis, int flags) {
            String date;
            String tz = (flags & 0x2000) != 0 ? "UTC" : this.getTimeZone(context, null);
            StringBuilder stringBuilder = mSB;
            synchronized (stringBuilder) {
                mSB.setLength(0);
                date = DateUtils.formatDateRange(context, mF, startMillis, endMillis, flags, tz).toString();
            }
            return date;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTimeZone(Context context, String timeZone) {
            if (TextUtils.isEmpty(timeZone)) {
                return;
            }
            boolean updatePrefs = false;
            HashSet<Runnable> hashSet = mTZCallbacks;
            synchronized (hashSet) {
                if ("auto".equals(timeZone)) {
                    if (mUseHomeTZ) {
                        updatePrefs = true;
                    }
                    mUseHomeTZ = false;
                } else {
                    if (!mUseHomeTZ || !TextUtils.equals(mHomeTZ, timeZone)) {
                        updatePrefs = true;
                    }
                    mUseHomeTZ = true;
                    mHomeTZ = timeZone;
                }
            }
            if (updatePrefs) {
                SharedPreferences prefs = CalendarUtils.getSharedPreferences(context, this.mPrefsName);
                CalendarUtils.setSharedPreference(prefs, KEY_HOME_TZ_ENABLED, mUseHomeTZ);
                CalendarUtils.setSharedPreference(prefs, KEY_HOME_TZ, mHomeTZ);
                ContentValues values = new ContentValues();
                if (mHandler != null) {
                    mHandler.cancelOperation(mToken);
                }
                mHandler = new AsyncTZHandler(context.getContentResolver());
                if (++mToken == 0) {
                    mToken = 1;
                }
                values.put("value", mUseHomeTZ ? "home" : "auto");
                mHandler.startUpdate(mToken, null, Calendar.CalendarCache.URI, values, "key=?", TIMEZONE_TYPE_ARGS);
                if (mUseHomeTZ) {
                    ContentValues values2 = new ContentValues();
                    values2.put("value", mHomeTZ);
                    mHandler.startUpdate(mToken, null, Calendar.CalendarCache.URI, values2, "key=?", TIMEZONE_INSTANCES_ARGS);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getTimeZone(Context context, Runnable callback) {
            HashSet<Runnable> hashSet = mTZCallbacks;
            synchronized (hashSet) {
                if (mFirstTZRequest) {
                    mTZQueryInProgress = true;
                    mFirstTZRequest = false;
                    SharedPreferences prefs = CalendarUtils.getSharedPreferences(context, this.mPrefsName);
                    mUseHomeTZ = prefs.getBoolean(KEY_HOME_TZ_ENABLED, false);
                    mHomeTZ = prefs.getString(KEY_HOME_TZ, Time.getCurrentTimezone());
                    if (mHandler == null) {
                        mHandler = new AsyncTZHandler(context.getContentResolver());
                    }
                    mHandler.startQuery(0, context, Calendar.CalendarCache.URI, Calendar.CalendarCache.POJECTION, null, null, null);
                }
                if (mTZQueryInProgress) {
                    mTZCallbacks.add(callback);
                }
            }
            return mUseHomeTZ ? mHomeTZ : Time.getCurrentTimezone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forceDBRequery(Context context, Runnable callback) {
            HashSet<Runnable> hashSet = mTZCallbacks;
            synchronized (hashSet) {
                if (mTZQueryInProgress) {
                    mTZCallbacks.add(callback);
                    return;
                }
                mFirstTZRequest = true;
                this.getTimeZone(context, callback);
            }
        }

        private class AsyncTZHandler
        extends AsyncQueryHandler {
            public AsyncTZHandler(ContentResolver cr) {
                super(cr);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onQueryComplete(int token, Object cookie, Cursor cursor) {
                HashSet hashSet = mTZCallbacks;
                synchronized (hashSet) {
                    boolean writePrefs = false;
                    int keyColumn = cursor.getColumnIndexOrThrow("key");
                    int valueColumn = cursor.getColumnIndexOrThrow("value");
                    while (cursor.moveToNext()) {
                        String key = cursor.getString(keyColumn);
                        String value = cursor.getString(valueColumn);
                        if (TextUtils.equals(key, "timezoneType")) {
                            boolean useHomeTZ = !TextUtils.equals(value, "auto");
                            if (useHomeTZ == mUseHomeTZ) continue;
                            writePrefs = true;
                            mUseHomeTZ = useHomeTZ;
                            continue;
                        }
                        if (!TextUtils.equals(key, "timezoneInstancesPrevious") || TextUtils.isEmpty(value) || TextUtils.equals(mHomeTZ, value)) continue;
                        writePrefs = true;
                        mHomeTZ = value;
                    }
                    cursor.close();
                    if (writePrefs) {
                        SharedPreferences prefs = CalendarUtils.getSharedPreferences((Context)cookie, TimeZoneUtils.this.mPrefsName);
                        CalendarUtils.setSharedPreference(prefs, TimeZoneUtils.KEY_HOME_TZ_ENABLED, mUseHomeTZ);
                        CalendarUtils.setSharedPreference(prefs, TimeZoneUtils.KEY_HOME_TZ, mHomeTZ);
                    }
                    mTZQueryInProgress = false;
                    for (Runnable callback : mTZCallbacks) {
                        if (callback == null) continue;
                        callback.run();
                    }
                    mTZCallbacks.clear();
                }
            }
        }
    }
}

