/*
 * Decompiled with CFR 0.152.
 */
package android.service.wallpaper;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.service.wallpaper.IWallpaperConnection;
import android.service.wallpaper.IWallpaperEngine;
import android.service.wallpaper.IWallpaperService;
import android.util.Log;
import android.view.IWindowSession;
import android.view.InputChannel;
import android.view.InputHandler;
import android.view.InputQueue;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.ViewRoot;
import android.view.WindowManager;
import com.android.internal.os.HandlerCaller;
import com.android.internal.view.BaseIWindow;
import com.android.internal.view.BaseInputHandler;
import com.android.internal.view.BaseSurfaceHolder;
import java.util.ArrayList;

public abstract class WallpaperService
extends Service {
    public static final String SERVICE_INTERFACE = "android.service.wallpaper.WallpaperService";
    public static final String SERVICE_META_DATA = "android.service.wallpaper";
    static final String TAG = "WallpaperService";
    static final boolean DEBUG = false;
    private static final int DO_ATTACH = 10;
    private static final int DO_DETACH = 20;
    private static final int DO_SET_DESIRED_SIZE = 30;
    private static final int MSG_UPDATE_SURFACE = 10000;
    private static final int MSG_VISIBILITY_CHANGED = 10010;
    private static final int MSG_WALLPAPER_OFFSETS = 10020;
    private static final int MSG_WALLPAPER_COMMAND = 10025;
    private static final int MSG_WINDOW_RESIZED = 10030;
    private static final int MSG_TOUCH_EVENT = 10040;
    private Looper mCallbackLooper;
    private final ArrayList<Engine> mActiveEngines = new ArrayList();

    public void onCreate() {
        super.onCreate();
    }

    public void onDestroy() {
        super.onDestroy();
        for (int i = 0; i < this.mActiveEngines.size(); ++i) {
            this.mActiveEngines.get(i).detach();
        }
        this.mActiveEngines.clear();
    }

    public final IBinder onBind(Intent intent) {
        return new IWallpaperServiceWrapper(this);
    }

    public void setCallbackLooper(Looper looper) {
        this.mCallbackLooper = looper;
    }

    public abstract Engine onCreateEngine();

    class IWallpaperServiceWrapper
    extends IWallpaperService.Stub {
        private final WallpaperService mTarget;

        public IWallpaperServiceWrapper(WallpaperService context) {
            this.mTarget = context;
        }

        public void attach(IWallpaperConnection conn, IBinder windowToken, int windowType, boolean isPreview, int reqWidth, int reqHeight) {
            new IWallpaperEngineWrapper(this.mTarget, conn, windowToken, windowType, isPreview, reqWidth, reqHeight);
        }
    }

    class IWallpaperEngineWrapper
    extends IWallpaperEngine.Stub
    implements HandlerCaller.Callback {
        private final HandlerCaller mCaller;
        final IWallpaperConnection mConnection;
        final IBinder mWindowToken;
        final int mWindowType;
        final boolean mIsPreview;
        int mReqWidth;
        int mReqHeight;
        Engine mEngine;

        IWallpaperEngineWrapper(WallpaperService context, IWallpaperConnection conn, IBinder windowToken, int windowType, boolean isPreview, int reqWidth, int reqHeight) {
            this.mCaller = new HandlerCaller(context, WallpaperService.this.mCallbackLooper != null ? WallpaperService.this.mCallbackLooper : context.getMainLooper(), this);
            this.mConnection = conn;
            this.mWindowToken = windowToken;
            this.mWindowType = windowType;
            this.mIsPreview = isPreview;
            this.mReqWidth = reqWidth;
            this.mReqHeight = reqHeight;
            Message msg = this.mCaller.obtainMessage(10);
            this.mCaller.sendMessage(msg);
        }

        public void setDesiredSize(int width, int height) {
            Message msg = this.mCaller.obtainMessageII(30, width, height);
            this.mCaller.sendMessage(msg);
        }

        public void setVisibility(boolean visible) {
            Message msg = this.mCaller.obtainMessageI(10010, visible ? 1 : 0);
            this.mCaller.sendMessage(msg);
        }

        public void dispatchPointer(MotionEvent event) {
            if (this.mEngine != null) {
                this.mEngine.dispatchPointer(event);
            }
        }

        public void destroy() {
            Message msg = this.mCaller.obtainMessage(20);
            this.mCaller.sendMessage(msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeMessage(Message message) {
            switch (message.what) {
                case 10: {
                    Engine engine;
                    try {
                        this.mConnection.attachEngine(this);
                    }
                    catch (RemoteException e) {
                        Log.w(WallpaperService.TAG, "Wallpaper host disappeared", e);
                        return;
                    }
                    this.mEngine = engine = WallpaperService.this.onCreateEngine();
                    WallpaperService.this.mActiveEngines.add(engine);
                    engine.attach(this);
                    return;
                }
                case 20: {
                    WallpaperService.this.mActiveEngines.remove(this.mEngine);
                    this.mEngine.detach();
                    return;
                }
                case 30: {
                    this.mEngine.doDesiredSizeChanged(message.arg1, message.arg2);
                    return;
                }
                case 10000: {
                    this.mEngine.updateSurface(true, false, false);
                    break;
                }
                case 10010: {
                    this.mEngine.doVisibilityChanged(message.arg1 != 0);
                    break;
                }
                case 10020: {
                    this.mEngine.doOffsetsChanged();
                    break;
                }
                case 10025: {
                    WallpaperCommand cmd = (WallpaperCommand)message.obj;
                    this.mEngine.doCommand(cmd);
                    break;
                }
                case 10030: {
                    boolean reportDraw = message.arg1 != 0;
                    this.mEngine.updateSurface(true, false, reportDraw);
                    this.mEngine.doOffsetsChanged();
                    break;
                }
                case 10040: {
                    boolean skip = false;
                    MotionEvent ev = (MotionEvent)message.obj;
                    if (ev.getAction() == 2) {
                        Object object = this.mEngine.mLock;
                        synchronized (object) {
                            if (this.mEngine.mPendingMove == ev) {
                                this.mEngine.mPendingMove = null;
                            } else {
                                skip = true;
                            }
                        }
                    }
                    if (!skip) {
                        this.mEngine.onTouchEvent(ev);
                    }
                    ev.recycle();
                    break;
                }
                default: {
                    Log.w(WallpaperService.TAG, "Unknown message type " + message.what);
                }
            }
        }
    }

    public class Engine {
        IWallpaperEngineWrapper mIWallpaperEngine;
        HandlerCaller mCaller;
        IWallpaperConnection mConnection;
        IBinder mWindowToken;
        boolean mInitializing = true;
        boolean mVisible;
        boolean mScreenOn = true;
        boolean mReportedVisible;
        boolean mDestroyed;
        boolean mCreated;
        boolean mSurfaceCreated;
        boolean mIsCreating;
        boolean mDrawingAllowed;
        int mWidth;
        int mHeight;
        int mFormat;
        int mType;
        int mCurWidth;
        int mCurHeight;
        int mWindowFlags;
        int mCurWindowFlags = this.mWindowFlags = 16;
        final Rect mVisibleInsets = new Rect();
        final Rect mWinFrame = new Rect();
        final Rect mContentInsets = new Rect();
        final Configuration mConfiguration = new Configuration();
        final WindowManager.LayoutParams mLayout = new WindowManager.LayoutParams();
        IWindowSession mSession;
        InputChannel mInputChannel;
        final Object mLock = new Object();
        boolean mOffsetMessageEnqueued;
        float mPendingXOffset;
        float mPendingYOffset;
        float mPendingXOffsetStep;
        float mPendingYOffsetStep;
        boolean mPendingSync;
        MotionEvent mPendingMove;
        final BroadcastReceiver mReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if ("android.intent.action.SCREEN_ON".equals(intent.getAction())) {
                    Engine.this.mScreenOn = true;
                    Engine.this.reportVisibility();
                } else if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                    Engine.this.mScreenOn = false;
                    Engine.this.reportVisibility();
                }
            }
        };
        final BaseSurfaceHolder mSurfaceHolder = new BaseSurfaceHolder(){
            {
                this.mRequestedFormat = 4;
            }

            public boolean onAllowLockCanvas() {
                return Engine.this.mDrawingAllowed;
            }

            public void onRelayoutContainer() {
                Message msg = Engine.this.mCaller.obtainMessage(10000);
                Engine.this.mCaller.sendMessage(msg);
            }

            public void onUpdateSurface() {
                Message msg = Engine.this.mCaller.obtainMessage(10000);
                Engine.this.mCaller.sendMessage(msg);
            }

            public boolean isCreating() {
                return Engine.this.mIsCreating;
            }

            public void setFixedSize(int width, int height) {
                throw new UnsupportedOperationException("Wallpapers currently only support sizing from layout");
            }

            public void setKeepScreenOn(boolean screenOn) {
                throw new UnsupportedOperationException("Wallpapers do not support keep screen on");
            }
        };
        final InputHandler mInputHandler = new BaseInputHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMotion(MotionEvent event, Runnable finishedCallback) {
                try {
                    int source = event.getSource();
                    if ((source & 2) != 0) {
                        Engine.this.dispatchPointer(event);
                    }
                    Object var5_4 = null;
                    finishedCallback.run();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    finishedCallback.run();
                    throw throwable;
                }
            }
        };
        final BaseIWindow mWindow = new BaseIWindow(){

            public void resized(int w, int h, Rect coveredInsets, Rect visibleInsets, boolean reportDraw, Configuration newConfig) {
                Message msg = Engine.this.mCaller.obtainMessageI(10030, reportDraw ? 1 : 0);
                Engine.this.mCaller.sendMessage(msg);
            }

            public void dispatchAppVisibility(boolean visible) {
                if (!Engine.this.mIWallpaperEngine.mIsPreview) {
                    Message msg = Engine.this.mCaller.obtainMessageI(10010, visible ? 1 : 0);
                    Engine.this.mCaller.sendMessage(msg);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispatchWallpaperOffsets(float x, float y, float xStep, float yStep, boolean sync) {
                Object object = Engine.this.mLock;
                synchronized (object) {
                    Engine.this.mPendingXOffset = x;
                    Engine.this.mPendingYOffset = y;
                    Engine.this.mPendingXOffsetStep = xStep;
                    Engine.this.mPendingYOffsetStep = yStep;
                    if (sync) {
                        Engine.this.mPendingSync = true;
                    }
                    if (!Engine.this.mOffsetMessageEnqueued) {
                        Engine.this.mOffsetMessageEnqueued = true;
                        Message msg = Engine.this.mCaller.obtainMessage(10020);
                        Engine.this.mCaller.sendMessage(msg);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispatchWallpaperCommand(String action, int x, int y, int z, Bundle extras, boolean sync) {
                Object object = Engine.this.mLock;
                synchronized (object) {
                    WallpaperCommand cmd = new WallpaperCommand();
                    cmd.action = action;
                    cmd.x = x;
                    cmd.y = y;
                    cmd.z = z;
                    cmd.extras = extras;
                    cmd.sync = sync;
                    Message msg = Engine.this.mCaller.obtainMessage(10025);
                    msg.obj = cmd;
                    Engine.this.mCaller.sendMessage(msg);
                }
            }
        };

        public SurfaceHolder getSurfaceHolder() {
            return this.mSurfaceHolder;
        }

        public int getDesiredMinimumWidth() {
            return this.mIWallpaperEngine.mReqWidth;
        }

        public int getDesiredMinimumHeight() {
            return this.mIWallpaperEngine.mReqHeight;
        }

        public boolean isVisible() {
            return this.mReportedVisible;
        }

        public boolean isPreview() {
            return this.mIWallpaperEngine.mIsPreview;
        }

        public void setTouchEventsEnabled(boolean enabled) {
            int n = this.mWindowFlags = enabled ? this.mWindowFlags & 0xFFFFFFEF : this.mWindowFlags | 0x10;
            if (this.mCreated) {
                this.updateSurface(false, false, false);
            }
        }

        public void onCreate(SurfaceHolder surfaceHolder) {
        }

        public void onDestroy() {
        }

        public void onVisibilityChanged(boolean visible) {
        }

        public void onTouchEvent(MotionEvent event) {
        }

        public void onOffsetsChanged(float xOffset, float yOffset, float xOffsetStep, float yOffsetStep, int xPixelOffset, int yPixelOffset) {
        }

        public Bundle onCommand(String action, int x, int y, int z, Bundle extras, boolean resultRequested) {
            return null;
        }

        public void onDesiredSizeChanged(int desiredWidth, int desiredHeight) {
        }

        public void onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }

        public void onSurfaceRedrawNeeded(SurfaceHolder holder) {
        }

        public void onSurfaceCreated(SurfaceHolder holder) {
        }

        public void onSurfaceDestroyed(SurfaceHolder holder) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchPointer(MotionEvent event) {
            Object object = this.mLock;
            synchronized (object) {
                this.mPendingMove = event.getAction() == 2 ? event : null;
            }
            Message msg = this.mCaller.obtainMessageO(10040, event);
            this.mCaller.sendMessage(msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void updateSurface(boolean forceRelayout, boolean forceReport, boolean redrawNeeded) {
            boolean flagsChanged;
            int myHeight;
            int myWidth;
            if (this.mDestroyed) {
                Log.w(WallpaperService.TAG, "Ignoring updateSurface: destroyed");
            }
            if ((myWidth = this.mSurfaceHolder.getRequestedWidth()) <= 0) {
                myWidth = -1;
            }
            if ((myHeight = this.mSurfaceHolder.getRequestedHeight()) <= 0) {
                myHeight = -1;
            }
            boolean creating = !this.mCreated;
            boolean surfaceCreating = !this.mSurfaceCreated;
            boolean formatChanged = this.mFormat != this.mSurfaceHolder.getRequestedFormat();
            boolean sizeChanged = this.mWidth != myWidth || this.mHeight != myHeight;
            boolean typeChanged = this.mType != this.mSurfaceHolder.getRequestedType();
            boolean bl = flagsChanged = this.mCurWindowFlags != this.mWindowFlags;
            if (!forceRelayout && !creating && !surfaceCreating && !formatChanged && !sizeChanged && !typeChanged && !flagsChanged && !redrawNeeded) return;
            try {
                int h;
                this.mWidth = myWidth;
                this.mHeight = myHeight;
                this.mFormat = this.mSurfaceHolder.getRequestedFormat();
                this.mType = this.mSurfaceHolder.getRequestedType();
                this.mLayout.x = 0;
                this.mLayout.y = 0;
                this.mLayout.width = myWidth;
                this.mLayout.height = myHeight;
                this.mLayout.format = this.mFormat;
                this.mCurWindowFlags = this.mWindowFlags;
                this.mLayout.flags = this.mWindowFlags | 0x200 | 0x100 | 8;
                this.mLayout.memoryType = this.mType;
                this.mLayout.token = this.mWindowToken;
                if (!this.mCreated) {
                    this.mLayout.type = this.mIWallpaperEngine.mWindowType;
                    this.mLayout.gravity = 51;
                    this.mLayout.setTitle(WallpaperService.this.getClass().getName());
                    this.mLayout.windowAnimations = 16973945;
                    this.mInputChannel = new InputChannel();
                    this.mSession.add(this.mWindow, this.mLayout, 0, this.mContentInsets, this.mInputChannel);
                    this.mCreated = true;
                    InputQueue.registerInputChannel(this.mInputChannel, this.mInputHandler, Looper.myQueue());
                }
                this.mSurfaceHolder.mSurfaceLock.lock();
                this.mDrawingAllowed = true;
                int relayoutResult = this.mSession.relayout(this.mWindow, this.mLayout, this.mWidth, this.mHeight, 0, false, this.mWinFrame, this.mContentInsets, this.mVisibleInsets, this.mConfiguration, this.mSurfaceHolder.mSurface);
                int w = this.mWinFrame.width();
                if (this.mCurWidth != w) {
                    sizeChanged = true;
                    this.mCurWidth = w;
                }
                if (this.mCurHeight != (h = this.mWinFrame.height())) {
                    sizeChanged = true;
                    this.mCurHeight = h;
                }
                this.mSurfaceHolder.mSurfaceLock.unlock();
                if (!this.mSurfaceHolder.mSurface.isValid()) {
                    this.reportSurfaceDestroyed();
                    return;
                }
                try {
                    SurfaceHolder.Callback[] callbacks;
                    this.mSurfaceHolder.ungetCallbacks();
                    if (surfaceCreating) {
                        this.mIsCreating = true;
                        this.onSurfaceCreated(this.mSurfaceHolder);
                        callbacks = this.mSurfaceHolder.getCallbacks();
                        if (callbacks != null) {
                            for (SurfaceHolder.Callback c : callbacks) {
                                c.surfaceCreated(this.mSurfaceHolder);
                            }
                        }
                    }
                    redrawNeeded |= creating || (relayoutResult & 2) != 0;
                    if (forceReport || creating || surfaceCreating || formatChanged || sizeChanged) {
                        this.onSurfaceChanged(this.mSurfaceHolder, this.mFormat, this.mCurWidth, this.mCurHeight);
                        callbacks = this.mSurfaceHolder.getCallbacks();
                        if (callbacks != null) {
                            for (SurfaceHolder.Callback c : callbacks) {
                                c.surfaceChanged(this.mSurfaceHolder, this.mFormat, this.mCurWidth, this.mCurHeight);
                            }
                        }
                    }
                    if (redrawNeeded) {
                        this.onSurfaceRedrawNeeded(this.mSurfaceHolder);
                        callbacks = this.mSurfaceHolder.getCallbacks();
                        if (callbacks != null) {
                            for (SurfaceHolder.Callback c : callbacks) {
                                if (!(c instanceof SurfaceHolder.Callback2)) continue;
                                ((SurfaceHolder.Callback2)c).surfaceRedrawNeeded(this.mSurfaceHolder);
                            }
                        }
                    }
                    Object var21_21 = null;
                    this.mIsCreating = false;
                    this.mSurfaceCreated = true;
                    if (!redrawNeeded) return;
                }
                catch (Throwable throwable) {
                    Object var21_22 = null;
                    this.mIsCreating = false;
                    this.mSurfaceCreated = true;
                    if (!redrawNeeded) throw throwable;
                    this.mSession.finishDrawing(this.mWindow);
                    throw throwable;
                }
                this.mSession.finishDrawing(this.mWindow);
                return;
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }

        void attach(IWallpaperEngineWrapper wrapper) {
            if (this.mDestroyed) {
                return;
            }
            this.mIWallpaperEngine = wrapper;
            this.mCaller = wrapper.mCaller;
            this.mConnection = wrapper.mConnection;
            this.mWindowToken = wrapper.mWindowToken;
            this.mSurfaceHolder.setSizeFromLayout();
            this.mInitializing = true;
            this.mSession = ViewRoot.getWindowSession(WallpaperService.this.getMainLooper());
            this.mWindow.setSession(this.mSession);
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.SCREEN_ON");
            filter.addAction("android.intent.action.SCREEN_OFF");
            WallpaperService.this.registerReceiver(this.mReceiver, filter);
            this.onCreate(this.mSurfaceHolder);
            this.mInitializing = false;
            this.updateSurface(false, false, false);
        }

        void doDesiredSizeChanged(int desiredWidth, int desiredHeight) {
            if (!this.mDestroyed) {
                this.mIWallpaperEngine.mReqWidth = desiredWidth;
                this.mIWallpaperEngine.mReqHeight = desiredHeight;
                this.onDesiredSizeChanged(desiredWidth, desiredHeight);
                this.doOffsetsChanged();
            }
        }

        void doVisibilityChanged(boolean visible) {
            if (!this.mDestroyed) {
                this.mVisible = visible;
                this.reportVisibility();
            }
        }

        void reportVisibility() {
            if (!this.mDestroyed) {
                boolean visible;
                boolean bl = visible = this.mVisible && this.mScreenOn;
                if (this.mReportedVisible != visible) {
                    this.mReportedVisible = visible;
                    if (visible) {
                        this.updateSurface(false, false, false);
                    }
                    this.onVisibilityChanged(visible);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doOffsetsChanged() {
            boolean sync;
            float yOffsetStep;
            float xOffsetStep;
            float yOffset;
            float xOffset;
            if (this.mDestroyed) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                xOffset = this.mPendingXOffset;
                yOffset = this.mPendingYOffset;
                xOffsetStep = this.mPendingXOffsetStep;
                yOffsetStep = this.mPendingYOffsetStep;
                sync = this.mPendingSync;
                this.mPendingSync = false;
                this.mOffsetMessageEnqueued = false;
            }
            if (this.mSurfaceCreated) {
                int availw = this.mIWallpaperEngine.mReqWidth - this.mCurWidth;
                int xPixels = availw > 0 ? -((int)((float)availw * xOffset + 0.5f)) : 0;
                int availh = this.mIWallpaperEngine.mReqHeight - this.mCurHeight;
                int yPixels = availh > 0 ? -((int)((float)availh * yOffset + 0.5f)) : 0;
                this.onOffsetsChanged(xOffset, yOffset, xOffsetStep, yOffsetStep, xPixels, yPixels);
            }
            if (sync) {
                try {
                    this.mSession.wallpaperOffsetsComplete(this.mWindow.asBinder());
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }

        void doCommand(WallpaperCommand cmd) {
            Bundle result = !this.mDestroyed ? this.onCommand(cmd.action, cmd.x, cmd.y, cmd.z, cmd.extras, cmd.sync) : null;
            if (cmd.sync) {
                try {
                    this.mSession.wallpaperCommandComplete(this.mWindow.asBinder(), result);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        void reportSurfaceDestroyed() {
            if (this.mSurfaceCreated) {
                this.mSurfaceCreated = false;
                this.mSurfaceHolder.ungetCallbacks();
                SurfaceHolder.Callback[] callbacks = this.mSurfaceHolder.getCallbacks();
                if (callbacks != null) {
                    for (SurfaceHolder.Callback c : callbacks) {
                        c.surfaceDestroyed(this.mSurfaceHolder);
                    }
                }
                this.onSurfaceDestroyed(this.mSurfaceHolder);
            }
        }

        void detach() {
            if (this.mDestroyed) {
                return;
            }
            this.mDestroyed = true;
            if (this.mVisible) {
                this.mVisible = false;
                this.onVisibilityChanged(false);
            }
            this.reportSurfaceDestroyed();
            this.onDestroy();
            WallpaperService.this.unregisterReceiver(this.mReceiver);
            if (this.mCreated) {
                try {
                    if (this.mInputChannel != null) {
                        InputQueue.unregisterInputChannel(this.mInputChannel);
                    }
                    this.mSession.remove(this.mWindow);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                this.mSurfaceHolder.mSurface.release();
                this.mCreated = false;
                if (this.mInputChannel != null) {
                    this.mInputChannel.dispose();
                    this.mInputChannel = null;
                }
            }
        }
    }

    static final class WallpaperCommand {
        String action;
        int x;
        int y;
        int z;
        Bundle extras;
        boolean sync;

        WallpaperCommand() {
        }
    }
}

