/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Dimension;
import android.renderscript.Element;
import android.renderscript.Primitive;
import android.renderscript.RenderScript;
import android.renderscript.Type;

public class SimpleMesh
extends BaseObj {
    Type[] mVertexTypes;
    Type mIndexType;
    Primitive mPrimitive;

    SimpleMesh(int id2, RenderScript rs) {
        super(rs);
        this.mID = id2;
    }

    public void bindVertexAllocation(Allocation a, int slot) {
        this.mRS.validate();
        this.mRS.nSimpleMeshBindVertex(this.mID, a.mID, slot);
    }

    public void bindIndexAllocation(Allocation a) {
        this.mRS.validate();
        this.mRS.nSimpleMeshBindIndex(this.mID, a.mID);
    }

    public Allocation createVertexAllocation(int slot) {
        this.mRS.validate();
        return Allocation.createTyped(this.mRS, this.mVertexTypes[slot]);
    }

    public Allocation createIndexAllocation() {
        this.mRS.validate();
        return Allocation.createTyped(this.mRS, this.mIndexType);
    }

    public Type getVertexType(int slot) {
        return this.mVertexTypes[slot];
    }

    public Type getIndexType() {
        return this.mIndexType;
    }

    public static class TriangleMeshBuilder {
        float[] mVtxData;
        int mVtxCount;
        short[] mIndexData;
        int mIndexCount;
        RenderScript mRS;
        Element mElement;
        float mNX = 0.0f;
        float mNY = 0.0f;
        float mNZ = -1.0f;
        float mS0 = 0.0f;
        float mT0 = 0.0f;
        float mR = 1.0f;
        float mG = 1.0f;
        float mB = 1.0f;
        float mA = 1.0f;
        int mVtxSize;
        int mFlags;
        public static final int COLOR = 1;
        public static final int NORMAL = 2;
        public static final int TEXTURE_0 = 256;

        public TriangleMeshBuilder(RenderScript rs, int vtxSize, int flags) {
            this.mRS = rs;
            this.mVtxCount = 0;
            this.mIndexCount = 0;
            this.mVtxData = new float[128];
            this.mIndexData = new short[128];
            this.mVtxSize = vtxSize;
            this.mFlags = flags;
            if (vtxSize < 2 || vtxSize > 3) {
                throw new IllegalArgumentException("Vertex size out of range.");
            }
        }

        private void makeSpace(int count) {
            if (this.mVtxCount + count >= this.mVtxData.length) {
                float[] t = new float[this.mVtxData.length * 2];
                System.arraycopy(this.mVtxData, 0, t, 0, this.mVtxData.length);
                this.mVtxData = t;
            }
        }

        private void latch() {
            if ((this.mFlags & 1) != 0) {
                this.makeSpace(4);
                this.mVtxData[this.mVtxCount++] = this.mR;
                this.mVtxData[this.mVtxCount++] = this.mG;
                this.mVtxData[this.mVtxCount++] = this.mB;
                this.mVtxData[this.mVtxCount++] = this.mA;
            }
            if ((this.mFlags & 0x100) != 0) {
                this.makeSpace(2);
                this.mVtxData[this.mVtxCount++] = this.mS0;
                this.mVtxData[this.mVtxCount++] = this.mT0;
            }
            if ((this.mFlags & 2) != 0) {
                this.makeSpace(3);
                this.mVtxData[this.mVtxCount++] = this.mNX;
                this.mVtxData[this.mVtxCount++] = this.mNY;
                this.mVtxData[this.mVtxCount++] = this.mNZ;
            }
        }

        public void addVertex(float x, float y) {
            if (this.mVtxSize != 2) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.makeSpace(2);
            this.mVtxData[this.mVtxCount++] = x;
            this.mVtxData[this.mVtxCount++] = y;
            this.latch();
        }

        public void addVertex(float x, float y, float z) {
            if (this.mVtxSize != 3) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.makeSpace(3);
            this.mVtxData[this.mVtxCount++] = x;
            this.mVtxData[this.mVtxCount++] = y;
            this.mVtxData[this.mVtxCount++] = z;
            this.latch();
        }

        public void setTexture(float s, float t) {
            if ((this.mFlags & 0x100) == 0) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.mS0 = s;
            this.mT0 = t;
        }

        public void setNormal(float x, float y, float z) {
            if ((this.mFlags & 2) == 0) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.mNX = x;
            this.mNY = y;
            this.mNZ = z;
        }

        public void setColor(float r, float g, float b, float a) {
            if ((this.mFlags & 1) == 0) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.mR = r;
            this.mG = g;
            this.mB = b;
            this.mA = a;
        }

        public void addTriangle(int idx1, int idx2, int idx3) {
            if (idx1 >= this.mVtxCount || idx1 < 0 || idx2 >= this.mVtxCount || idx2 < 0 || idx3 >= this.mVtxCount || idx3 < 0) {
                throw new IllegalStateException("Index provided greater than vertex count.");
            }
            if (this.mIndexCount + 3 >= this.mIndexData.length) {
                short[] t = new short[this.mIndexData.length * 2];
                System.arraycopy(this.mIndexData, 0, t, 0, this.mIndexData.length);
                this.mIndexData = t;
            }
            this.mIndexData[this.mIndexCount++] = (short)idx1;
            this.mIndexData[this.mIndexCount++] = (short)idx2;
            this.mIndexData[this.mIndexCount++] = (short)idx3;
        }

        public SimpleMesh create() {
            Element.Builder b = new Element.Builder(this.mRS);
            int floatCount = this.mVtxSize;
            b.add(Element.createAttrib(this.mRS, Element.DataType.FLOAT_32, Element.DataKind.POSITION, this.mVtxSize), "position");
            if ((this.mFlags & 1) != 0) {
                floatCount += 4;
                b.add(Element.createAttrib(this.mRS, Element.DataType.FLOAT_32, Element.DataKind.COLOR, 4), "color");
            }
            if ((this.mFlags & 0x100) != 0) {
                floatCount += 2;
                b.add(Element.createAttrib(this.mRS, Element.DataType.FLOAT_32, Element.DataKind.TEXTURE, 2), "texture");
            }
            if ((this.mFlags & 2) != 0) {
                floatCount += 3;
                b.add(Element.createAttrib(this.mRS, Element.DataType.FLOAT_32, Element.DataKind.NORMAL, 3), "normal");
            }
            this.mElement = b.create();
            Builder smb = new Builder(this.mRS);
            smb.addVertexType(this.mElement, this.mVtxCount / floatCount);
            smb.setIndexType(Element.createIndex(this.mRS), this.mIndexCount);
            smb.setPrimitive(Primitive.TRIANGLE);
            SimpleMesh sm = smb.create();
            Allocation vertexAlloc = sm.createVertexAllocation(0);
            Allocation indexAlloc = sm.createIndexAllocation();
            sm.bindVertexAllocation(vertexAlloc, 0);
            sm.bindIndexAllocation(indexAlloc);
            vertexAlloc.data(this.mVtxData);
            vertexAlloc.uploadToBufferObject();
            indexAlloc.data(this.mIndexData);
            indexAlloc.uploadToBufferObject();
            return sm;
        }
    }

    public static class Builder {
        RenderScript mRS;
        int mVertexTypeCount;
        Entry[] mVertexTypes;
        Entry mIndexType;
        Primitive mPrimitive;

        public Builder(RenderScript rs) {
            this.mRS = rs;
            this.mVertexTypeCount = 0;
            this.mVertexTypes = new Entry[16];
            this.mIndexType = new Entry();
        }

        public int addVertexType(Type t) throws IllegalStateException {
            if (this.mVertexTypeCount >= this.mVertexTypes.length) {
                throw new IllegalStateException("Max vertex types exceeded.");
            }
            int addedIndex = this.mVertexTypeCount;
            this.mVertexTypes[this.mVertexTypeCount] = new Entry();
            this.mVertexTypes[this.mVertexTypeCount].t = t;
            ++this.mVertexTypeCount;
            return addedIndex;
        }

        public int addVertexType(Element e, int size) throws IllegalStateException {
            if (this.mVertexTypeCount >= this.mVertexTypes.length) {
                throw new IllegalStateException("Max vertex types exceeded.");
            }
            int addedIndex = this.mVertexTypeCount;
            this.mVertexTypes[this.mVertexTypeCount] = new Entry();
            this.mVertexTypes[this.mVertexTypeCount].e = e;
            this.mVertexTypes[this.mVertexTypeCount].size = size;
            ++this.mVertexTypeCount;
            return addedIndex;
        }

        public void setIndexType(Type t) {
            this.mIndexType.t = t;
            this.mIndexType.e = null;
            this.mIndexType.size = 0;
        }

        public void setIndexType(Element e, int size) {
            this.mIndexType.t = null;
            this.mIndexType.e = e;
            this.mIndexType.size = size;
        }

        public void setPrimitive(Primitive p) {
            this.mPrimitive = p;
        }

        Type newType(Element e, int size) {
            Type.Builder tb = new Type.Builder(this.mRS, e);
            tb.add(Dimension.X, size);
            return tb.create();
        }

        static synchronized SimpleMesh internalCreate(RenderScript rs, Builder b) {
            Type[] toDestroy = new Type[18];
            int toDestroyCount = 0;
            int indexID = 0;
            if (b.mIndexType.t != null) {
                indexID = b.mIndexType.t.mID;
            } else if (b.mIndexType.size != 0) {
                b.mIndexType.t = b.newType(b.mIndexType.e, b.mIndexType.size);
                indexID = b.mIndexType.t.mID;
                toDestroy[toDestroyCount++] = b.mIndexType.t;
            }
            int[] IDs = new int[b.mVertexTypeCount];
            for (int ct = 0; ct < b.mVertexTypeCount; ++ct) {
                if (b.mVertexTypes[ct].t != null) {
                    IDs[ct] = b.mVertexTypes[ct].t.mID;
                    continue;
                }
                b.mVertexTypes[ct].t = b.newType(b.mVertexTypes[ct].e, b.mVertexTypes[ct].size);
                IDs[ct] = b.mVertexTypes[ct].t.mID;
                toDestroy[toDestroyCount++] = b.mVertexTypes[ct].t;
            }
            int id2 = rs.nSimpleMeshCreate(0, indexID, IDs, b.mPrimitive.mID);
            for (int ct = 0; ct < toDestroyCount; ++ct) {
                toDestroy[ct].destroy();
            }
            return new SimpleMesh(id2, rs);
        }

        public SimpleMesh create() {
            this.mRS.validate();
            SimpleMesh sm = Builder.internalCreate(this.mRS, this);
            sm.mVertexTypes = new Type[this.mVertexTypeCount];
            for (int ct = 0; ct < this.mVertexTypeCount; ++ct) {
                sm.mVertexTypes[ct] = this.mVertexTypes[ct].t;
            }
            sm.mIndexType = this.mIndexType.t;
            sm.mPrimitive = this.mPrimitive;
            return sm;
        }

        class Entry {
            Type t;
            Element e;
            int size;

            Entry() {
            }
        }
    }
}

