/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.RenderScript;
import java.lang.reflect.Field;

public class Element
extends BaseObj {
    int mSize;
    Element[] mElements;
    String[] mElementNames;
    DataType mType;
    DataKind mKind;
    boolean mNormalized;
    int mVectorSize;

    int getSizeBytes() {
        return this.mSize;
    }

    public static Element USER_U8(RenderScript rs) {
        if (rs.mElement_USER_U8 == null) {
            rs.mElement_USER_U8 = Element.createUser(rs, DataType.UNSIGNED_8);
        }
        return rs.mElement_USER_U8;
    }

    public static Element USER_I8(RenderScript rs) {
        if (rs.mElement_USER_I8 == null) {
            rs.mElement_USER_I8 = Element.createUser(rs, DataType.SIGNED_8);
        }
        return rs.mElement_USER_I8;
    }

    public static Element USER_U32(RenderScript rs) {
        if (rs.mElement_USER_U32 == null) {
            rs.mElement_USER_U32 = Element.createUser(rs, DataType.UNSIGNED_32);
        }
        return rs.mElement_USER_U32;
    }

    public static Element USER_I32(RenderScript rs) {
        if (rs.mElement_USER_I32 == null) {
            rs.mElement_USER_I32 = Element.createUser(rs, DataType.SIGNED_32);
        }
        return rs.mElement_USER_I32;
    }

    public static Element USER_F32(RenderScript rs) {
        if (rs.mElement_USER_F32 == null) {
            rs.mElement_USER_F32 = Element.createUser(rs, DataType.FLOAT_32);
        }
        return rs.mElement_USER_F32;
    }

    public static Element A_8(RenderScript rs) {
        if (rs.mElement_A_8 == null) {
            rs.mElement_A_8 = Element.createPixel(rs, DataType.UNSIGNED_8, DataKind.PIXEL_A);
        }
        return rs.mElement_A_8;
    }

    public static Element RGB_565(RenderScript rs) {
        if (rs.mElement_RGB_565 == null) {
            rs.mElement_RGB_565 = Element.createPixel(rs, DataType.UNSIGNED_5_6_5, DataKind.PIXEL_RGB);
        }
        return rs.mElement_RGB_565;
    }

    public static Element RGB_888(RenderScript rs) {
        if (rs.mElement_RGB_888 == null) {
            rs.mElement_RGB_888 = Element.createPixel(rs, DataType.UNSIGNED_8, DataKind.PIXEL_RGB);
        }
        return rs.mElement_RGB_888;
    }

    public static Element RGBA_5551(RenderScript rs) {
        if (rs.mElement_RGBA_5551 == null) {
            rs.mElement_RGBA_5551 = Element.createPixel(rs, DataType.UNSIGNED_5_5_5_1, DataKind.PIXEL_RGBA);
        }
        return rs.mElement_RGBA_5551;
    }

    public static Element RGBA_4444(RenderScript rs) {
        if (rs.mElement_RGBA_4444 == null) {
            rs.mElement_RGBA_4444 = Element.createPixel(rs, DataType.UNSIGNED_4_4_4_4, DataKind.PIXEL_RGBA);
        }
        return rs.mElement_RGBA_4444;
    }

    public static Element RGBA_8888(RenderScript rs) {
        if (rs.mElement_RGBA_8888 == null) {
            rs.mElement_RGBA_8888 = Element.createPixel(rs, DataType.UNSIGNED_8, DataKind.PIXEL_RGBA);
        }
        return rs.mElement_RGBA_8888;
    }

    public static Element INDEX_16(RenderScript rs) {
        if (rs.mElement_INDEX_16 == null) {
            rs.mElement_INDEX_16 = Element.createIndex(rs);
        }
        return rs.mElement_INDEX_16;
    }

    public static Element ATTRIB_POSITION_2(RenderScript rs) {
        if (rs.mElement_POSITION_2 == null) {
            rs.mElement_POSITION_2 = Element.createAttrib(rs, DataType.FLOAT_32, DataKind.POSITION, 2);
        }
        return rs.mElement_POSITION_2;
    }

    public static Element ATTRIB_POSITION_3(RenderScript rs) {
        if (rs.mElement_POSITION_3 == null) {
            rs.mElement_POSITION_3 = Element.createAttrib(rs, DataType.FLOAT_32, DataKind.POSITION, 3);
        }
        return rs.mElement_POSITION_3;
    }

    public static Element ATTRIB_TEXTURE_2(RenderScript rs) {
        if (rs.mElement_TEXTURE_2 == null) {
            rs.mElement_TEXTURE_2 = Element.createAttrib(rs, DataType.FLOAT_32, DataKind.TEXTURE, 2);
        }
        return rs.mElement_TEXTURE_2;
    }

    public static Element ATTRIB_NORMAL_3(RenderScript rs) {
        if (rs.mElement_NORMAL_3 == null) {
            rs.mElement_NORMAL_3 = Element.createAttrib(rs, DataType.FLOAT_32, DataKind.NORMAL, 3);
        }
        return rs.mElement_NORMAL_3;
    }

    public static Element ATTRIB_COLOR_U8_4(RenderScript rs) {
        if (rs.mElement_COLOR_U8_4 == null) {
            rs.mElement_COLOR_U8_4 = Element.createAttrib(rs, DataType.UNSIGNED_8, DataKind.COLOR, 4);
        }
        return rs.mElement_COLOR_U8_4;
    }

    public static Element ATTRIB_COLOR_F32_4(RenderScript rs) {
        if (rs.mElement_COLOR_F32_4 == null) {
            rs.mElement_COLOR_F32_4 = Element.createAttrib(rs, DataType.FLOAT_32, DataKind.COLOR, 4);
        }
        return rs.mElement_COLOR_F32_4;
    }

    Element(RenderScript rs, Element[] e, String[] n) {
        super(rs);
        this.mSize = 0;
        this.mElements = e;
        this.mElementNames = n;
        int[] ids = new int[this.mElements.length];
        for (int ct = 0; ct < this.mElements.length; ++ct) {
            this.mSize += this.mElements[ct].mSize;
            ids[ct] = this.mElements[ct].mID;
        }
        this.mID = rs.nElementCreate2(ids, this.mElementNames);
    }

    Element(RenderScript rs, DataType dt, DataKind dk, boolean norm, int size) {
        super(rs);
        this.mSize = dt.mSize * size;
        this.mType = dt;
        this.mKind = dk;
        this.mNormalized = norm;
        this.mVectorSize = size;
        this.mID = rs.nElementCreate(dt.mID, dk.mID, norm, size);
    }

    public void destroy() throws IllegalStateException {
        super.destroy();
    }

    public static Element createFromClass(RenderScript rs, Class c) {
        rs.validate();
        Field[] fields = c.getFields();
        Builder b = new Builder(rs);
        for (Field f : fields) {
            Class<?> fc = f.getType();
            if (fc == Integer.TYPE) {
                b.add(Element.createUser(rs, DataType.SIGNED_32), f.getName());
                continue;
            }
            if (fc == Short.TYPE) {
                b.add(Element.createUser(rs, DataType.SIGNED_16), f.getName());
                continue;
            }
            if (fc == Byte.TYPE) {
                b.add(Element.createUser(rs, DataType.SIGNED_8), f.getName());
                continue;
            }
            if (fc == Float.TYPE) {
                b.add(Element.createUser(rs, DataType.FLOAT_32), f.getName());
                continue;
            }
            throw new IllegalArgumentException("Unkown field type");
        }
        return b.create();
    }

    public static Element createUser(RenderScript rs, DataType dt) {
        return new Element(rs, dt, DataKind.USER, false, 1);
    }

    public static Element createVector(RenderScript rs, DataType dt, int size) {
        if (size < 2 || size > 4) {
            throw new IllegalArgumentException("Bad size");
        }
        return new Element(rs, dt, DataKind.USER, false, size);
    }

    public static Element createIndex(RenderScript rs) {
        return new Element(rs, DataType.UNSIGNED_16, DataKind.INDEX, false, 1);
    }

    public static Element createAttrib(RenderScript rs, DataType dt, DataKind dk, int size) {
        if (dt != DataType.FLOAT_32 && dt != DataType.UNSIGNED_8 && dt != DataType.UNSIGNED_16 && dt != DataType.UNSIGNED_32 && dt != DataType.SIGNED_8 && dt != DataType.SIGNED_16 && dt != DataType.SIGNED_32) {
            throw new IllegalArgumentException("Unsupported DataType");
        }
        if (dk != DataKind.COLOR && dk != DataKind.POSITION && dk != DataKind.TEXTURE && dk != DataKind.NORMAL && dk != DataKind.POINT_SIZE && dk != DataKind.USER) {
            throw new IllegalArgumentException("Unsupported DataKind");
        }
        if (dk == DataKind.COLOR && (dt != DataType.FLOAT_32 && dt != DataType.UNSIGNED_8 || size < 3 || size > 4)) {
            throw new IllegalArgumentException("Bad combo");
        }
        if (dk == DataKind.POSITION && (size < 1 || size > 4)) {
            throw new IllegalArgumentException("Bad combo");
        }
        if (dk == DataKind.TEXTURE && (dt != DataType.FLOAT_32 || size < 1 || size > 4)) {
            throw new IllegalArgumentException("Bad combo");
        }
        if (dk == DataKind.NORMAL && (dt != DataType.FLOAT_32 || size != 3)) {
            throw new IllegalArgumentException("Bad combo");
        }
        if (dk == DataKind.POINT_SIZE && (dt != DataType.FLOAT_32 || size != 1)) {
            throw new IllegalArgumentException("Bad combo");
        }
        boolean norm = false;
        if (dk == DataKind.COLOR && dt == DataType.UNSIGNED_8) {
            norm = true;
        }
        return new Element(rs, dt, dk, norm, size);
    }

    public static Element createPixel(RenderScript rs, DataType dt, DataKind dk) {
        if (dk != DataKind.PIXEL_L && dk != DataKind.PIXEL_A && dk != DataKind.PIXEL_LA && dk != DataKind.PIXEL_RGB && dk != DataKind.PIXEL_RGBA) {
            throw new IllegalArgumentException("Unsupported DataKind");
        }
        if (dt != DataType.UNSIGNED_8 && dt != DataType.UNSIGNED_5_6_5 && dt != DataType.UNSIGNED_4_4_4_4 && dt != DataType.UNSIGNED_5_5_5_1) {
            throw new IllegalArgumentException("Unsupported DataType");
        }
        if (dt == DataType.UNSIGNED_5_6_5 && dk != DataKind.PIXEL_RGB) {
            throw new IllegalArgumentException("Bad kind and type combo");
        }
        if (dt == DataType.UNSIGNED_5_5_5_1 && dk != DataKind.PIXEL_RGBA) {
            throw new IllegalArgumentException("Bad kind and type combo");
        }
        if (dt == DataType.UNSIGNED_4_4_4_4 && dk != DataKind.PIXEL_RGBA) {
            throw new IllegalArgumentException("Bad kind and type combo");
        }
        int size = 1;
        if (dk == DataKind.PIXEL_LA) {
            size = 2;
        }
        if (dk == DataKind.PIXEL_RGB) {
            size = 3;
        }
        if (dk == DataKind.PIXEL_RGBA) {
            size = 4;
        }
        return new Element(rs, dt, dk, true, size);
    }

    static void initPredefined(RenderScript rs) {
        int a8 = rs.nElementCreate(DataType.UNSIGNED_8.mID, DataKind.PIXEL_A.mID, true, 1);
        int rgba4444 = rs.nElementCreate(DataType.UNSIGNED_4_4_4_4.mID, DataKind.PIXEL_RGBA.mID, true, 4);
        int rgba8888 = rs.nElementCreate(DataType.UNSIGNED_8.mID, DataKind.PIXEL_RGBA.mID, true, 4);
        int rgb565 = rs.nElementCreate(DataType.UNSIGNED_5_6_5.mID, DataKind.PIXEL_RGB.mID, true, 3);
        rs.nInitElements(a8, rgba4444, rgba8888, rgb565);
    }

    public static class Builder {
        RenderScript mRS;
        Element[] mElements;
        String[] mElementNames;
        int mCount;

        public Builder(RenderScript rs) {
            this.mRS = rs;
            this.mCount = 0;
            this.mElements = new Element[8];
            this.mElementNames = new String[8];
        }

        public void add(Element element, String name) {
            if (this.mCount == this.mElements.length) {
                Element[] e = new Element[this.mCount + 8];
                String[] s = new String[this.mCount + 8];
                System.arraycopy(this.mElements, 0, e, 0, this.mCount);
                System.arraycopy(this.mElementNames, 0, s, 0, this.mCount);
                this.mElements = e;
                this.mElementNames = s;
            }
            this.mElements[this.mCount] = element;
            this.mElementNames[this.mCount] = name;
            ++this.mCount;
        }

        public Element create() {
            this.mRS.validate();
            Element[] ein = new Element[this.mCount];
            String[] sin = new String[this.mCount];
            System.arraycopy(this.mElements, 0, ein, 0, this.mCount);
            System.arraycopy(this.mElementNames, 0, sin, 0, this.mCount);
            return new Element(this.mRS, ein, sin);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataKind {
        USER(0),
        COLOR(1),
        POSITION(2),
        TEXTURE(3),
        NORMAL(4),
        INDEX(5),
        POINT_SIZE(6),
        PIXEL_L(7),
        PIXEL_A(8),
        PIXEL_LA(9),
        PIXEL_RGB(10),
        PIXEL_RGBA(11);

        int mID;

        private DataKind(int id2) {
            this.mID = id2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataType {
        FLOAT_32(2, 4),
        SIGNED_8(4, 1),
        SIGNED_16(5, 2),
        SIGNED_32(6, 4),
        UNSIGNED_8(8, 1),
        UNSIGNED_16(9, 2),
        UNSIGNED_32(10, 4),
        UNSIGNED_5_6_5(12, 2),
        UNSIGNED_5_5_5_1(13, 2),
        UNSIGNED_4_4_4_4(14, 2),
        RS_ELEMENT(15, 4),
        RS_TYPE(16, 4),
        RS_ALLOCATION(17, 4),
        RS_SAMPLER(18, 4),
        RS_SCRIPT(19, 4),
        RS_MESH(20, 4),
        RS_PROGRAM_FRAGMENT(21, 4),
        RS_PROGRAM_VERTEX(22, 4),
        RS_PROGRAM_RASTER(23, 4),
        RS_PROGRAM_STORE(24, 4);

        int mID;
        int mSize;

        private DataType(int id2, int size) {
            this.mID = id2;
            this.mSize = size;
        }
    }
}

