/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.BaseColumns;
import android.provider.ContactsContract;
import android.text.TextUtils;
import com.android.internal.telephony.CallerInfo;
import com.android.internal.telephony.Connection;

public class CallLog {
    public static final String AUTHORITY = "call_log";
    public static final Uri CONTENT_URI = Uri.parse("content://call_log");

    public static class Calls
    implements BaseColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://call_log/calls");
        public static final Uri CONTENT_FILTER_URI = Uri.parse("content://call_log/calls/filter");
        public static final String DEFAULT_SORT_ORDER = "date DESC";
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/calls";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/calls";
        public static final String TYPE = "type";
        public static final int INCOMING_TYPE = 1;
        public static final int OUTGOING_TYPE = 2;
        public static final int MISSED_TYPE = 3;
        public static final String NUMBER = "number";
        public static final String DATE = "date";
        public static final String DURATION = "duration";
        public static final String NEW = "new";
        public static final String CACHED_NAME = "name";
        public static final String CACHED_NUMBER_TYPE = "numbertype";
        public static final String CACHED_NUMBER_LABEL = "numberlabel";

        public static Uri addCall(CallerInfo ci, Context context, String number, int presentation, int callType, long start, int duration) {
            ContentResolver resolver = context.getContentResolver();
            if (presentation == Connection.PRESENTATION_RESTRICTED) {
                number = "-2";
                if (ci != null) {
                    ci.name = "";
                }
            } else if (presentation == Connection.PRESENTATION_PAYPHONE) {
                number = "-3";
                if (ci != null) {
                    ci.name = "";
                }
            } else if (TextUtils.isEmpty(number) || presentation == Connection.PRESENTATION_UNKNOWN) {
                number = "-1";
                if (ci != null) {
                    ci.name = "";
                }
            }
            ContentValues values = new ContentValues(5);
            values.put(NUMBER, number);
            values.put(TYPE, callType);
            values.put(DATE, start);
            values.put(DURATION, Long.valueOf(duration));
            values.put(NEW, 1);
            if (ci != null) {
                values.put(CACHED_NAME, ci.name);
                values.put(CACHED_NUMBER_TYPE, ci.numberType);
                values.put(CACHED_NUMBER_LABEL, ci.numberLabel);
            }
            if (ci != null && ci.person_id > 0L) {
                ContactsContract.Contacts.markAsContacted(resolver, ci.person_id);
            }
            Uri result = resolver.insert(CONTENT_URI, values);
            Calls.removeExpiredEntries(context);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String getLastOutgoingCall(Context context) {
            ContentResolver resolver = context.getContentResolver();
            Cursor c = null;
            try {
                c = resolver.query(CONTENT_URI, new String[]{NUMBER}, "type = 2", null, "date DESC LIMIT 1");
                if (c == null || !c.moveToFirst()) {
                    String string2 = "";
                    return string2;
                }
                String string3 = c.getString(0);
                return string3;
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
        }

        private static void removeExpiredEntries(Context context) {
            ContentResolver resolver = context.getContentResolver();
            resolver.delete(CONTENT_URI, "_id IN (SELECT _id FROM calls ORDER BY date DESC LIMIT -1 OFFSET 500)", null);
        }
    }
}

