/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.net.Uri;
import android.provider.BaseColumns;
import android.util.Log;
import android.webkit.WebIconDatabase;
import java.util.Date;

public class Browser {
    private static final String LOGTAG = "browser";
    public static final Uri BOOKMARKS_URI = Uri.parse("content://browser/bookmarks");
    public static final String INITIAL_ZOOM_LEVEL = "browser.initialZoomLevel";
    public static final String EXTRA_APPLICATION_ID = "com.android.browser.application_id";
    public static final String EXTRA_HEADERS = "com.android.browser.headers";
    public static final String[] HISTORY_PROJECTION = new String[]{"_id", "url", "visits", "date", "bookmark", "title", "favicon", "thumbnail", "touch_icon", "user_entered"};
    public static final int HISTORY_PROJECTION_ID_INDEX = 0;
    public static final int HISTORY_PROJECTION_URL_INDEX = 1;
    public static final int HISTORY_PROJECTION_VISITS_INDEX = 2;
    public static final int HISTORY_PROJECTION_DATE_INDEX = 3;
    public static final int HISTORY_PROJECTION_BOOKMARK_INDEX = 4;
    public static final int HISTORY_PROJECTION_TITLE_INDEX = 5;
    public static final int HISTORY_PROJECTION_FAVICON_INDEX = 6;
    public static final int HISTORY_PROJECTION_THUMBNAIL_INDEX = 7;
    public static final int HISTORY_PROJECTION_TOUCH_ICON_INDEX = 8;
    public static final String[] TRUNCATE_HISTORY_PROJECTION = new String[]{"_id", "date"};
    public static final int TRUNCATE_HISTORY_PROJECTION_ID_INDEX = 0;
    public static final int TRUNCATE_N_OLDEST = 5;
    public static final Uri SEARCHES_URI = Uri.parse("content://browser/searches");
    public static final String[] SEARCHES_PROJECTION = new String[]{"_id", "search", "date"};
    public static final int SEARCHES_PROJECTION_SEARCH_INDEX = 1;
    public static final int SEARCHES_PROJECTION_DATE_INDEX = 2;
    private static final String SEARCHES_WHERE_CLAUSE = "search = ?";
    private static final int MAX_HISTORY_COUNT = 250;
    public static final String EXTRA_SHARE_SCREENSHOT = "share_screenshot";
    public static final String EXTRA_SHARE_FAVICON = "share_favicon";

    public static final void saveBookmark(Context c, String title, String url) {
        Intent i = new Intent("android.intent.action.INSERT", BOOKMARKS_URI);
        i.putExtra("title", title);
        i.putExtra("url", url);
        c.startActivity(i);
    }

    public static final void sendString(Context c, String s) {
        Browser.sendString(c, s, c.getString(17040146));
    }

    public static final void sendString(Context c, String stringToSend, String chooserDialogTitle) {
        Intent send = new Intent("android.intent.action.SEND");
        send.setType("text/plain");
        send.putExtra("android.intent.extra.TEXT", stringToSend);
        try {
            c.startActivity(Intent.createChooser(send, chooserDialogTitle));
        }
        catch (ActivityNotFoundException ex) {
            // empty catch block
        }
    }

    public static final Cursor getAllBookmarks(ContentResolver cr) throws IllegalStateException {
        return cr.query(BOOKMARKS_URI, new String[]{"url"}, "bookmark = 1", null, null);
    }

    public static final Cursor getAllVisitedUrls(ContentResolver cr) throws IllegalStateException {
        return cr.query(BOOKMARKS_URI, new String[]{"url"}, null, null, null);
    }

    private static final void addOrUrlEquals(StringBuilder sb) {
        sb.append(" OR url = ");
    }

    public static final Cursor getVisitedLike(ContentResolver cr, String url) {
        boolean secure = false;
        String compareString = url;
        if (compareString.startsWith("http://")) {
            compareString = compareString.substring(7);
        } else if (compareString.startsWith("https://")) {
            compareString = compareString.substring(8);
            secure = true;
        }
        if (compareString.startsWith("www.")) {
            compareString = compareString.substring(4);
        }
        StringBuilder whereClause = null;
        if (secure) {
            whereClause = new StringBuilder("url = ");
            DatabaseUtils.appendEscapedSQLString(whereClause, "https://" + compareString);
            Browser.addOrUrlEquals(whereClause);
            DatabaseUtils.appendEscapedSQLString(whereClause, "https://www." + compareString);
        } else {
            whereClause = new StringBuilder("url = ");
            DatabaseUtils.appendEscapedSQLString(whereClause, compareString);
            Browser.addOrUrlEquals(whereClause);
            String wwwString = "www." + compareString;
            DatabaseUtils.appendEscapedSQLString(whereClause, wwwString);
            Browser.addOrUrlEquals(whereClause);
            DatabaseUtils.appendEscapedSQLString(whereClause, "http://" + compareString);
            Browser.addOrUrlEquals(whereClause);
            DatabaseUtils.appendEscapedSQLString(whereClause, "http://" + wwwString);
        }
        return cr.query(BOOKMARKS_URI, HISTORY_PROJECTION, whereClause.toString(), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void updateVisitedHistory(ContentResolver cr, String url, boolean real) {
        long now = new Date().getTime();
        Cursor c = null;
        try {
            c = Browser.getVisitedLike(cr, url);
            if (c.moveToFirst()) {
                ContentValues map = new ContentValues();
                if (real) {
                    map.put("visits", c.getInt(2) + 1);
                } else {
                    map.put("user_entered", 1);
                }
                map.put("date", now);
                String[] projection = new String[]{Integer.valueOf(c.getInt(0)).toString()};
                cr.update(BOOKMARKS_URI, map, "_id = ?", projection);
            } else {
                int user_entered;
                int visits;
                Browser.truncateHistory(cr);
                ContentValues map = new ContentValues();
                if (real) {
                    visits = 1;
                    user_entered = 0;
                } else {
                    visits = 0;
                    user_entered = 1;
                }
                map.put("url", url);
                map.put("visits", visits);
                map.put("date", now);
                map.put("bookmark", 0);
                map.put("title", url);
                map.put("created", 0);
                map.put("user_entered", user_entered);
                cr.insert(BOOKMARKS_URI, map);
            }
        }
        catch (IllegalStateException e) {
            Log.e(LOGTAG, "updateVisitedHistory", e);
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String[] getVisitedHistory(ContentResolver cr) {
        Cursor c = null;
        String[] str = null;
        try {
            String[] projection = new String[]{"url"};
            c = cr.query(BOOKMARKS_URI, projection, "visits > 0", null, null);
            str = new String[c.getCount()];
            int i = 0;
            while (c.moveToNext()) {
                str[i] = c.getString(0);
                ++i;
            }
        }
        catch (IllegalStateException e) {
            Log.e(LOGTAG, "getVisitedHistory", e);
            str = new String[]{};
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void truncateHistory(ContentResolver cr) {
        block7: {
            Cursor c = null;
            try {
                c = cr.query(BOOKMARKS_URI, TRUNCATE_HISTORY_PROJECTION, "bookmark = 0", null, "date");
                if (!c.moveToFirst() || c.getCount() < 250) break block7;
                for (int i = 0; i < 5; ++i) {
                    cr.delete(BOOKMARKS_URI, "_id = " + c.getInt(0), null);
                    if (c.moveToNext()) continue;
                    break;
                }
            }
            catch (IllegalStateException e) {
                Log.e(LOGTAG, "truncateHistory", e);
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean canClearHistory(ContentResolver cr) {
        Cursor c = null;
        boolean ret = false;
        try {
            c = cr.query(BOOKMARKS_URI, new String[]{"_id", "bookmark", "visits"}, "bookmark = 0 OR visits > 0", null, null);
            ret = c.moveToFirst();
        }
        catch (IllegalStateException e) {
            Log.e(LOGTAG, "canClearHistory", e);
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return ret;
    }

    public static final void clearHistory(ContentResolver cr) {
        Browser.deleteHistoryWhere(cr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void deleteHistoryWhere(ContentResolver cr, String whereClause) {
        Cursor c = null;
        try {
            c = cr.query(BOOKMARKS_URI, HISTORY_PROJECTION, whereClause, null, null);
            if (c.moveToFirst()) {
                WebIconDatabase iconDb = WebIconDatabase.getInstance();
                StringBuffer sb = new StringBuffer();
                boolean firstTime = true;
                do {
                    boolean isBookmark;
                    String url = c.getString(1);
                    boolean bl = isBookmark = c.getInt(4) == 1;
                    if (isBookmark) {
                        if (firstTime) {
                            firstTime = false;
                        } else {
                            sb.append(" OR ");
                        }
                        sb.append("( _id = ");
                        sb.append(c.getInt(0));
                        sb.append(" )");
                        continue;
                    }
                    iconDb.releaseIconForPageUrl(url);
                } while (c.moveToNext());
                if (!firstTime) {
                    ContentValues map = new ContentValues();
                    map.put("visits", 0);
                    map.put("date", 0);
                    cr.update(BOOKMARKS_URI, map, sb.toString(), null);
                }
                String deleteWhereClause = "bookmark = 0";
                if (whereClause != null) {
                    deleteWhereClause = deleteWhereClause + " AND " + whereClause;
                }
                cr.delete(BOOKMARKS_URI, deleteWhereClause, null);
            }
        }
        catch (IllegalStateException e) {
            Log.e(LOGTAG, "deleteHistoryWhere", e);
            return;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    public static final void deleteHistoryTimeFrame(ContentResolver cr, long begin, long end) {
        String whereClause;
        String date = "date";
        if (-1L == begin) {
            if (-1L == end) {
                Browser.clearHistory(cr);
                return;
            }
            whereClause = date + " < " + Long.toString(end);
        } else {
            whereClause = -1L == end ? date + " >= " + Long.toString(begin) : date + " >= " + Long.toString(begin) + " AND " + date + " < " + Long.toString(end);
        }
        Browser.deleteHistoryWhere(cr, whereClause);
    }

    public static final void deleteFromHistory(ContentResolver cr, String url) {
        StringBuilder sb = new StringBuilder("url = ");
        DatabaseUtils.appendEscapedSQLString(sb, url);
        String matchesUrl = sb.toString();
        Browser.deleteHistoryWhere(cr, matchesUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addSearchUrl(ContentResolver cr, String search) {
        long now = new Date().getTime();
        Cursor c = null;
        try {
            c = cr.query(SEARCHES_URI, SEARCHES_PROJECTION, SEARCHES_WHERE_CLAUSE, new String[]{search}, null);
            ContentValues map = new ContentValues();
            map.put("search", search);
            map.put("date", now);
            if (c.moveToFirst()) {
                cr.update(SEARCHES_URI, map, "_id = " + c.getInt(0), null);
            } else {
                cr.insert(SEARCHES_URI, map);
            }
        }
        catch (IllegalStateException e) {
            Log.e(LOGTAG, "addSearchUrl", e);
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    public static final void clearSearches(ContentResolver cr) {
        try {
            cr.delete(SEARCHES_URI, null, null);
        }
        catch (IllegalStateException e) {
            Log.e(LOGTAG, "clearSearches", e);
        }
    }

    public static final void requestAllIcons(ContentResolver cr, String where, WebIconDatabase.IconListener listener) {
        WebIconDatabase.getInstance().bulkRequestIconForPageUrl(cr, where, listener);
    }

    public static class SearchColumns
    implements BaseColumns {
        public static final String URL = "url";
        public static final String SEARCH = "search";
        public static final String DATE = "date";
    }

    public static class BookmarkColumns
    implements BaseColumns {
        public static final String URL = "url";
        public static final String VISITS = "visits";
        public static final String DATE = "date";
        public static final String BOOKMARK = "bookmark";
        public static final String TITLE = "title";
        public static final String CREATED = "created";
        public static final String FAVICON = "favicon";
        public static final String THUMBNAIL = "thumbnail";
        public static final String TOUCH_ICON = "touch_icon";
        public static final String USER_ENTERED = "user_entered";
    }
}

