/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.pim.vcard.VCardParserImpl_V21;
import android.pim.vcard.VCardParser_V30;
import android.pim.vcard.exception.VCardException;
import android.util.Log;
import java.io.IOException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VCardParserImpl_V30
extends VCardParserImpl_V21 {
    private static final String LOG_TAG = "VCardParserImpl_V30";
    private String mPreviousLine;
    private boolean mEmittedAgentWarning = false;

    public VCardParserImpl_V30() {
    }

    public VCardParserImpl_V30(int vcardType) {
        super(vcardType);
    }

    @Override
    protected int getVersion() {
        return 1;
    }

    @Override
    protected String getVersionString() {
        return "3.0";
    }

    @Override
    protected String getLine() throws IOException {
        if (this.mPreviousLine != null) {
            String ret = this.mPreviousLine;
            this.mPreviousLine = null;
            return ret;
        }
        return this.mReader.readLine();
    }

    @Override
    protected String getNonEmptyLine() throws IOException, VCardException {
        String line;
        block9: {
            StringBuilder builder = null;
            while (true) {
                if ((line = this.mReader.readLine()) == null) {
                    if (builder != null) {
                        return builder.toString();
                    }
                    if (this.mPreviousLine != null) {
                        String ret = this.mPreviousLine;
                        this.mPreviousLine = null;
                        return ret;
                    }
                    throw new VCardException("Reached end of buffer.");
                }
                if (line.length() == 0) {
                    if (builder != null) {
                        return builder.toString();
                    }
                    if (this.mPreviousLine == null) continue;
                    String ret = this.mPreviousLine;
                    this.mPreviousLine = null;
                    return ret;
                }
                if (line.charAt(0) == ' ' || line.charAt(0) == '\t') {
                    if (builder != null) {
                        builder.append(line.substring(1));
                        continue;
                    }
                    if (this.mPreviousLine != null) {
                        builder = new StringBuilder();
                        builder.append(this.mPreviousLine);
                        this.mPreviousLine = null;
                        builder.append(line.substring(1));
                        continue;
                    }
                    throw new VCardException("Space exists at the beginning of the line");
                }
                if (this.mPreviousLine != null) break block9;
                this.mPreviousLine = line;
                if (builder != null) break;
            }
            return builder.toString();
        }
        String ret = this.mPreviousLine;
        this.mPreviousLine = line;
        return ret;
    }

    @Override
    protected boolean readBeginVCard(boolean allowGarbage) throws IOException, VCardException {
        return super.readBeginVCard(allowGarbage);
    }

    @Override
    protected void readEndVCard(boolean useCache, boolean allowGarbage) throws IOException, VCardException {
        super.readEndVCard(useCache, allowGarbage);
    }

    @Override
    protected void handleParams(String params) throws VCardException {
        try {
            super.handleParams(params);
        }
        catch (VCardException e) {
            String[] strArray = params.split("=", 2);
            if (strArray.length == 2) {
                this.handleAnyParam(strArray[0], strArray[1]);
            }
            throw new VCardException("Unknown params value: " + params);
        }
    }

    @Override
    protected void handleAnyParam(String paramName, String paramValue) {
        this.mInterpreter.propertyParamType(paramName);
        this.splitAndPutParamValue(paramValue);
    }

    @Override
    protected void handleParamWithoutName(String paramValue) {
        this.handleType(paramValue);
    }

    @Override
    protected void handleType(String paramValue) {
        this.mInterpreter.propertyParamType("TYPE");
        this.splitAndPutParamValue(paramValue);
    }

    private void splitAndPutParamValue(String paramValue) {
        StringBuilder builder = null;
        boolean insideDquote = false;
        int length = paramValue.length();
        for (int i = 0; i < length; ++i) {
            char ch = paramValue.charAt(i);
            if (ch == '\"') {
                if (insideDquote) {
                    this.mInterpreter.propertyParamValue(builder.toString());
                    builder = null;
                    insideDquote = false;
                    continue;
                }
                if (builder != null) {
                    if (builder.length() > 0) {
                        Log.w(LOG_TAG, "Unexpected Dquote inside property.");
                    } else {
                        this.mInterpreter.propertyParamValue(builder.toString());
                    }
                }
                insideDquote = true;
                continue;
            }
            if (ch == ',' && !insideDquote) {
                if (builder == null) {
                    Log.w(LOG_TAG, "Comma is used before actual string comes. (" + paramValue + ")");
                    continue;
                }
                this.mInterpreter.propertyParamValue(builder.toString());
                builder = null;
                continue;
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(ch);
        }
        if (insideDquote) {
            Log.d(LOG_TAG, "Dangling Dquote.");
        }
        if (builder != null) {
            if (builder.length() == 0) {
                Log.w(LOG_TAG, "Unintended behavior. We must not see empty StringBuilder at the end of parameter value parsing.");
            } else {
                this.mInterpreter.propertyParamValue(builder.toString());
            }
        }
    }

    @Override
    protected void handleAgent(String propertyValue) {
        if (!this.mEmittedAgentWarning) {
            Log.w(LOG_TAG, "AGENT in vCard 3.0 is not supported yet. Ignore it");
            this.mEmittedAgentWarning = true;
        }
    }

    @Override
    protected String getBase64(String firstString) throws IOException, VCardException {
        StringBuilder builder = new StringBuilder();
        builder.append(firstString);
        while (true) {
            String line;
            if ((line = this.getLine()) == null) {
                throw new VCardException("File ended during parsing BASE64 binary");
            }
            if (line.length() == 0) break;
            if (!line.startsWith(" ") && !line.startsWith("\t")) {
                this.mPreviousLine = line;
                break;
            }
            builder.append(line);
        }
        return builder.toString();
    }

    @Override
    protected String maybeUnescapeText(String text) {
        return VCardParserImpl_V30.unescapeText(text);
    }

    public static String unescapeText(String text) {
        StringBuilder builder = new StringBuilder();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch == '\\' && i < length - 1) {
                char next_ch;
                if ((next_ch = text.charAt(++i)) == 'n' || next_ch == 'N') {
                    builder.append("\n");
                    continue;
                }
                builder.append(next_ch);
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    @Override
    protected String maybeUnescapeCharacter(char ch) {
        return VCardParserImpl_V30.unescapeCharacter(ch);
    }

    public static String unescapeCharacter(char ch) {
        if (ch == 'n' || ch == 'N') {
            return "\n";
        }
        return String.valueOf(ch);
    }

    @Override
    protected Set<String> getKnownPropertyNameSet() {
        return VCardParser_V30.sKnownPropertyNameSet;
    }
}

