/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.pim.vcard.VCardConfig;
import android.pim.vcard.VCardInterpreter;
import android.pim.vcard.VCardParser_V21;
import android.pim.vcard.VCardUtils;
import android.pim.vcard.exception.VCardAgentNotSupportedException;
import android.pim.vcard.exception.VCardException;
import android.pim.vcard.exception.VCardInvalidCommentLineException;
import android.pim.vcard.exception.VCardInvalidLineException;
import android.pim.vcard.exception.VCardNestedException;
import android.pim.vcard.exception.VCardVersionException;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VCardParserImpl_V21 {
    private static final String LOG_TAG = "VCardParserImpl_V21";
    private static final String DEFAULT_ENCODING = "8BIT";
    protected boolean mCanceled;
    protected VCardInterpreter mInterpreter;
    protected final String mIntermediateCharset;
    protected String mCurrentEncoding;
    protected CustomBufferedReader mReader;
    protected final Set<String> mUnknownTypeSet = new HashSet<String>();
    protected final Set<String> mUnknownValueSet = new HashSet<String>();
    private int mNestCount;
    private String mPreviousLine;
    private long mTimeTotal;
    private long mTimeReadStartRecord;
    private long mTimeReadEndRecord;
    private long mTimeStartProperty;
    private long mTimeEndProperty;
    private long mTimeParseItems;
    private long mTimeParseLineAndHandleGroup;
    private long mTimeParsePropertyValues;
    private long mTimeParseAdrOrgN;
    private long mTimeHandleMiscPropertyValue;
    private long mTimeHandleQuotedPrintable;
    private long mTimeHandleBase64;
    private static final int STATE_GROUP_OR_PROPERTY_NAME = 0;
    private static final int STATE_PARAMS = 1;
    private static final int STATE_PARAMS_IN_DQUOTE = 2;

    public VCardParserImpl_V21() {
        this(VCardConfig.VCARD_TYPE_DEFAULT);
    }

    public VCardParserImpl_V21(int vcardType) {
        if ((vcardType & 0x1000000) != 0) {
            this.mNestCount = 1;
        }
        this.mIntermediateCharset = "ISO-8859-1";
    }

    protected void parseVCardFile() throws IOException, VCardException {
        boolean readingFirstFile = true;
        while (!this.mCanceled && this.parseOneVCard(readingFirstFile)) {
            readingFirstFile = false;
        }
        if (this.mNestCount > 0) {
            boolean useCache = true;
            for (int i = 0; i < this.mNestCount; ++i) {
                this.readEndVCard(useCache, true);
                useCache = false;
            }
        }
    }

    protected boolean isValidPropertyName(String propertyName) {
        if (!(this.getKnownPropertyNameSet().contains(propertyName.toUpperCase()) || propertyName.startsWith("X-") || this.mUnknownTypeSet.contains(propertyName))) {
            this.mUnknownTypeSet.add(propertyName);
            Log.w(LOG_TAG, "Property name unsupported by vCard 2.1: " + propertyName);
        }
        return true;
    }

    protected String getLine() throws IOException {
        return this.mReader.readLine();
    }

    protected String peekLine() throws IOException {
        return this.mReader.peekLine();
    }

    protected String getNonEmptyLine() throws IOException, VCardException {
        String line;
        do {
            if ((line = this.getLine()) != null) continue;
            throw new VCardException("Reached end of buffer.");
        } while (line.trim().length() <= 0);
        return line;
    }

    private boolean parseOneVCard(boolean firstRead) throws IOException, VCardException {
        boolean allowGarbage = false;
        if (firstRead && this.mNestCount > 0) {
            for (int i = 0; i < this.mNestCount; ++i) {
                if (!this.readBeginVCard(allowGarbage)) {
                    return false;
                }
                allowGarbage = true;
            }
        }
        if (!this.readBeginVCard(allowGarbage)) {
            return false;
        }
        long beforeStartEntry = System.currentTimeMillis();
        this.mInterpreter.startEntry();
        this.mTimeReadStartRecord += System.currentTimeMillis() - beforeStartEntry;
        long beforeParseItems = System.currentTimeMillis();
        this.parseItems();
        this.mTimeParseItems += System.currentTimeMillis() - beforeParseItems;
        this.readEndVCard(true, false);
        long beforeEndEntry = System.currentTimeMillis();
        this.mInterpreter.endEntry();
        this.mTimeReadEndRecord += System.currentTimeMillis() - beforeEndEntry;
        return true;
    }

    protected boolean readBeginVCard(boolean allowGarbage) throws IOException, VCardException {
        while (true) {
            String line;
            if ((line = this.getLine()) == null) {
                return false;
            }
            if (line.trim().length() <= 0) continue;
            String[] strArray = line.split(":", 2);
            int length = strArray.length;
            if (length == 2 && strArray[0].trim().equalsIgnoreCase("BEGIN") && strArray[1].trim().equalsIgnoreCase("VCARD")) {
                return true;
            }
            if (!allowGarbage) {
                if (this.mNestCount > 0) {
                    this.mPreviousLine = line;
                    return false;
                }
                throw new VCardException("Expected String \"BEGIN:VCARD\" did not come (Instead, \"" + line + "\" came)");
            }
            if (!allowGarbage) break;
        }
        throw new VCardException("Reached where must not be reached.");
    }

    protected void readEndVCard(boolean useCache, boolean allowGarbage) throws IOException, VCardException {
        do {
            String line;
            if (useCache) {
                line = this.mPreviousLine;
            } else {
                do {
                    if ((line = this.getLine()) != null) continue;
                    throw new VCardException("Expected END:VCARD was not found.");
                } while (line.trim().length() <= 0);
            }
            String[] strArray = line.split(":", 2);
            if (strArray.length == 2 && strArray[0].trim().equalsIgnoreCase("END") && strArray[1].trim().equalsIgnoreCase("VCARD")) {
                return;
            }
            if (!allowGarbage) {
                throw new VCardException("END:VCARD != \"" + this.mPreviousLine + "\"");
            }
            useCache = false;
        } while (allowGarbage);
    }

    protected void parseItems() throws IOException, VCardException {
        boolean ended = false;
        long beforeBeginProperty = System.currentTimeMillis();
        this.mInterpreter.startProperty();
        this.mTimeStartProperty += System.currentTimeMillis() - beforeBeginProperty;
        ended = this.parseItem();
        if (!ended) {
            long beforeEndProperty = System.currentTimeMillis();
            this.mInterpreter.endProperty();
            this.mTimeEndProperty += System.currentTimeMillis() - beforeEndProperty;
        }
        while (!ended) {
            long beforeStartProperty = System.currentTimeMillis();
            this.mInterpreter.startProperty();
            this.mTimeStartProperty += System.currentTimeMillis() - beforeStartProperty;
            try {
                ended = this.parseItem();
            }
            catch (VCardInvalidCommentLineException e) {
                Log.e(LOG_TAG, "Invalid line which looks like some comment was found. Ignored.");
                ended = false;
            }
            if (ended) continue;
            long beforeEndProperty = System.currentTimeMillis();
            this.mInterpreter.endProperty();
            this.mTimeEndProperty += System.currentTimeMillis() - beforeEndProperty;
        }
    }

    protected boolean parseItem() throws IOException, VCardException {
        this.mCurrentEncoding = DEFAULT_ENCODING;
        String line = this.getNonEmptyLine();
        long start = System.currentTimeMillis();
        String[] propertyNameAndValue = this.separateLineAndHandleGroup(line);
        if (propertyNameAndValue == null) {
            return true;
        }
        if (propertyNameAndValue.length != 2) {
            throw new VCardInvalidLineException("Invalid line \"" + line + "\"");
        }
        String propertyName = propertyNameAndValue[0].toUpperCase();
        String propertyValue = propertyNameAndValue[1];
        this.mTimeParseLineAndHandleGroup += System.currentTimeMillis() - start;
        if (propertyName.equals("ADR") || propertyName.equals("ORG") || propertyName.equals("N")) {
            start = System.currentTimeMillis();
            this.handleMultiplePropertyValue(propertyName, propertyValue);
            this.mTimeParseAdrOrgN += System.currentTimeMillis() - start;
            return false;
        }
        if (propertyName.equals("AGENT")) {
            this.handleAgent(propertyValue);
            return false;
        }
        if (this.isValidPropertyName(propertyName)) {
            if (propertyName.equals("BEGIN")) {
                if (propertyValue.equals("VCARD")) {
                    throw new VCardNestedException("This vCard has nested vCard data in it.");
                }
                throw new VCardException("Unknown BEGIN type: " + propertyValue);
            }
            if (propertyName.equals("VERSION") && !propertyValue.equals(this.getVersionString())) {
                throw new VCardVersionException("Incompatible version: " + propertyValue + " != " + this.getVersionString());
            }
            start = System.currentTimeMillis();
            this.handlePropertyValue(propertyName, propertyValue);
            this.mTimeParsePropertyValues += System.currentTimeMillis() - start;
            return false;
        }
        throw new VCardException("Unknown property name: \"" + propertyName + "\"");
    }

    protected String[] separateLineAndHandleGroup(String line) throws VCardException {
        String[] propertyNameAndValue = new String[2];
        int length = line.length();
        if (length > 0 && line.charAt(0) == '#') {
            throw new VCardInvalidCommentLineException();
        }
        int state = 0;
        int nameIndex = 0;
        block5: for (int i = 0; i < length; ++i) {
            char ch = line.charAt(i);
            switch (state) {
                case 0: {
                    String propertyName;
                    if (ch == ':') {
                        propertyName = line.substring(nameIndex, i);
                        if (propertyName.equalsIgnoreCase("END")) {
                            this.mPreviousLine = line;
                            return null;
                        }
                        this.mInterpreter.propertyName(propertyName);
                        propertyNameAndValue[0] = propertyName;
                        propertyNameAndValue[1] = i < length - 1 ? line.substring(i + 1) : "";
                        return propertyNameAndValue;
                    }
                    if (ch == '.') {
                        String groupName = line.substring(nameIndex, i);
                        if (groupName.length() == 0) {
                            Log.w(LOG_TAG, "Empty group found. Ignoring.");
                        } else {
                            this.mInterpreter.propertyGroup(groupName);
                        }
                        nameIndex = i + 1;
                        continue block5;
                    }
                    if (ch != ';') continue block5;
                    propertyName = line.substring(nameIndex, i);
                    if (propertyName.equalsIgnoreCase("END")) {
                        this.mPreviousLine = line;
                        return null;
                    }
                    this.mInterpreter.propertyName(propertyName);
                    propertyNameAndValue[0] = propertyName;
                    nameIndex = i + 1;
                    state = 1;
                    continue block5;
                }
                case 1: {
                    if (ch == '\"') {
                        if ("2.1".equalsIgnoreCase(this.getVersionString())) {
                            Log.w(LOG_TAG, "Double-quoted params found in vCard 2.1. Silently allow it");
                        }
                        state = 2;
                        continue block5;
                    }
                    if (ch == ';') {
                        this.handleParams(line.substring(nameIndex, i));
                        nameIndex = i + 1;
                        continue block5;
                    }
                    if (ch != ':') continue block5;
                    this.handleParams(line.substring(nameIndex, i));
                    propertyNameAndValue[1] = i < length - 1 ? line.substring(i + 1) : "";
                    return propertyNameAndValue;
                }
                case 2: {
                    if (ch != '\"') continue block5;
                    if ("2.1".equalsIgnoreCase(this.getVersionString())) {
                        Log.w(LOG_TAG, "Double-quoted params found in vCard 2.1. Silently allow it");
                    }
                    state = 1;
                }
            }
        }
        throw new VCardInvalidLineException("Invalid line: \"" + line + "\"");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleParams(String params) throws VCardException {
        String[] strArray = params.split("=", 2);
        if (strArray.length == 2) {
            String paramName = strArray[0].trim().toUpperCase();
            String paramValue = strArray[1].trim();
            if (paramName.equals("TYPE")) {
                this.handleType(paramValue);
                return;
            } else if (paramName.equals("VALUE")) {
                this.handleValue(paramValue);
                return;
            } else if (paramName.equals("ENCODING")) {
                this.handleEncoding(paramValue);
                return;
            } else if (paramName.equals("CHARSET")) {
                this.handleCharset(paramValue);
                return;
            } else if (paramName.equals("LANGUAGE")) {
                this.handleLanguage(paramValue);
                return;
            } else {
                if (!paramName.startsWith("X-")) throw new VCardException("Unknown type \"" + paramName + "\"");
                this.handleAnyParam(paramName, paramValue);
            }
            return;
        } else {
            this.handleParamWithoutName(strArray[0]);
        }
    }

    protected void handleParamWithoutName(String paramValue) throws VCardException {
        this.handleType(paramValue);
    }

    protected void handleType(String ptypeval) {
        if (!(this.getKnownTypeSet().contains(ptypeval.toUpperCase()) || ptypeval.startsWith("X-") || this.mUnknownTypeSet.contains(ptypeval))) {
            this.mUnknownTypeSet.add(ptypeval);
            Log.w(LOG_TAG, String.format("TYPE unsupported by %s: ", this.getVersion(), ptypeval));
        }
        this.mInterpreter.propertyParamType("TYPE");
        this.mInterpreter.propertyParamValue(ptypeval);
    }

    protected void handleValue(String pvalueval) {
        if (!(this.getKnownValueSet().contains(pvalueval.toUpperCase()) || pvalueval.startsWith("X-") || this.mUnknownValueSet.contains(pvalueval))) {
            this.mUnknownValueSet.add(pvalueval);
            Log.w(LOG_TAG, String.format("The value unsupported by TYPE of %s: ", this.getVersion(), pvalueval));
        }
        this.mInterpreter.propertyParamType("VALUE");
        this.mInterpreter.propertyParamValue(pvalueval);
    }

    protected void handleEncoding(String pencodingval) throws VCardException {
        if (!this.getAvailableEncodingSet().contains(pencodingval) && !pencodingval.startsWith("X-")) {
            throw new VCardException("Unknown encoding \"" + pencodingval + "\"");
        }
        this.mInterpreter.propertyParamType("ENCODING");
        this.mInterpreter.propertyParamValue(pencodingval);
        this.mCurrentEncoding = pencodingval;
    }

    protected void handleCharset(String charsetval) {
        this.mInterpreter.propertyParamType("CHARSET");
        this.mInterpreter.propertyParamValue(charsetval);
    }

    protected void handleLanguage(String langval) throws VCardException {
        int i;
        String[] strArray = langval.split("-");
        if (strArray.length != 2) {
            throw new VCardException("Invalid Language: \"" + langval + "\"");
        }
        String tmp = strArray[0];
        int length = tmp.length();
        for (i = 0; i < length; ++i) {
            if (this.isAsciiLetter(tmp.charAt(i))) continue;
            throw new VCardException("Invalid Language: \"" + langval + "\"");
        }
        tmp = strArray[1];
        length = tmp.length();
        for (i = 0; i < length; ++i) {
            if (this.isAsciiLetter(tmp.charAt(i))) continue;
            throw new VCardException("Invalid Language: \"" + langval + "\"");
        }
        this.mInterpreter.propertyParamType("LANGUAGE");
        this.mInterpreter.propertyParamValue(langval);
    }

    private boolean isAsciiLetter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    protected void handleAnyParam(String paramName, String paramValue) {
        this.mInterpreter.propertyParamType(paramName);
        this.mInterpreter.propertyParamValue(paramValue);
    }

    protected void handlePropertyValue(String propertyName, String propertyValue) throws IOException, VCardException {
        String upperEncoding = this.mCurrentEncoding.toUpperCase();
        if (upperEncoding.equals("QUOTED-PRINTABLE")) {
            long start = System.currentTimeMillis();
            String result = this.getQuotedPrintable(propertyValue);
            ArrayList<String> v = new ArrayList<String>();
            v.add(result);
            this.mInterpreter.propertyValues(v);
            this.mTimeHandleQuotedPrintable += System.currentTimeMillis() - start;
        } else if (upperEncoding.equals("BASE64") || upperEncoding.equals("B")) {
            long start = System.currentTimeMillis();
            try {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(this.getBase64(propertyValue));
                this.mInterpreter.propertyValues(arrayList);
            }
            catch (OutOfMemoryError error) {
                Log.e(LOG_TAG, "OutOfMemoryError happened during parsing BASE64 data!");
                this.mInterpreter.propertyValues(null);
            }
            this.mTimeHandleBase64 += System.currentTimeMillis() - start;
        } else {
            if (!(upperEncoding.equals("7BIT") || upperEncoding.equals(DEFAULT_ENCODING) || upperEncoding.startsWith("X-"))) {
                Log.w(LOG_TAG, String.format("The encoding \"%s\" is unsupported by vCard %s", this.mCurrentEncoding, this.getVersionString()));
            }
            if (this.getVersion() == 0) {
                String nextLine;
                StringBuilder builder = null;
                while (!TextUtils.isEmpty(nextLine = this.peekLine()) && nextLine.charAt(0) == ' ' && !"END:VCARD".contains(nextLine.toUpperCase())) {
                    this.getLine();
                    if (builder == null) {
                        builder = new StringBuilder();
                        builder.append(propertyValue);
                    }
                    builder.append(nextLine.substring(1));
                }
                if (builder != null) {
                    propertyValue = builder.toString();
                }
            }
            long start = System.currentTimeMillis();
            ArrayList<String> v = new ArrayList<String>();
            v.add(this.maybeUnescapeText(propertyValue));
            this.mInterpreter.propertyValues(v);
            this.mTimeHandleMiscPropertyValue += System.currentTimeMillis() - start;
        }
    }

    private String getQuotedPrintable(String firstString) throws IOException, VCardException {
        if (firstString.trim().endsWith("=")) {
            String line;
            int pos = firstString.length() - 1;
            while (firstString.charAt(pos) != '=') {
            }
            StringBuilder builder = new StringBuilder();
            builder.append(firstString.substring(0, pos + 1));
            builder.append("\r\n");
            while (true) {
                if ((line = this.getLine()) == null) {
                    throw new VCardException("File ended during parsing a Quoted-Printable String");
                }
                if (!line.trim().endsWith("=")) break;
                pos = line.length() - 1;
                while (line.charAt(pos) != '=') {
                }
                builder.append(line.substring(0, pos + 1));
                builder.append("\r\n");
            }
            builder.append(line);
            return builder.toString();
        }
        return firstString;
    }

    protected String getBase64(String firstString) throws IOException, VCardException {
        StringBuilder builder = new StringBuilder();
        builder.append(firstString);
        while (true) {
            String line;
            if ((line = this.getLine()) == null) {
                throw new VCardException("File ended during parsing BASE64 binary");
            }
            if (line.length() == 0) break;
            builder.append(line);
        }
        return builder.toString();
    }

    protected void handleMultiplePropertyValue(String propertyName, String propertyValue) throws IOException, VCardException {
        if (this.mCurrentEncoding.equalsIgnoreCase("QUOTED-PRINTABLE")) {
            propertyValue = this.getQuotedPrintable(propertyValue);
        }
        this.mInterpreter.propertyValues(VCardUtils.constructListFromValue(propertyValue, this.getVersion()));
    }

    protected void handleAgent(String propertyValue) throws VCardException {
        if (!propertyValue.toUpperCase().contains("BEGIN:VCARD")) {
            return;
        }
        throw new VCardAgentNotSupportedException("AGENT Property is not supported now.");
    }

    protected String maybeUnescapeText(String text) {
        return text;
    }

    protected String maybeUnescapeCharacter(char ch) {
        return VCardParserImpl_V21.unescapeCharacter(ch);
    }

    static String unescapeCharacter(char ch) {
        if (ch == '\\' || ch == ';' || ch == ':' || ch == ',') {
            return String.valueOf(ch);
        }
        return null;
    }

    private void showPerformanceInfo() {
        Log.d(LOG_TAG, "Total parsing time:  " + this.mTimeTotal + " ms");
        Log.d(LOG_TAG, "Total readLine time: " + this.mReader.getTotalmillisecond() + " ms");
        Log.d(LOG_TAG, "Time for handling the beggining of the record: " + this.mTimeReadStartRecord + " ms");
        Log.d(LOG_TAG, "Time for handling the end of the record: " + this.mTimeReadEndRecord + " ms");
        Log.d(LOG_TAG, "Time for parsing line, and handling group: " + this.mTimeParseLineAndHandleGroup + " ms");
        Log.d(LOG_TAG, "Time for parsing ADR, ORG, and N fields:" + this.mTimeParseAdrOrgN + " ms");
        Log.d(LOG_TAG, "Time for parsing property values: " + this.mTimeParsePropertyValues + " ms");
        Log.d(LOG_TAG, "Time for handling normal property values: " + this.mTimeHandleMiscPropertyValue + " ms");
        Log.d(LOG_TAG, "Time for handling Quoted-Printable: " + this.mTimeHandleQuotedPrintable + " ms");
        Log.d(LOG_TAG, "Time for handling Base64: " + this.mTimeHandleBase64 + " ms");
    }

    protected int getVersion() {
        return 0;
    }

    protected String getVersionString() {
        return "2.1";
    }

    protected Set<String> getKnownPropertyNameSet() {
        return VCardParser_V21.sKnownPropertyNameSet;
    }

    protected Set<String> getKnownTypeSet() {
        return VCardParser_V21.sKnownTypeSet;
    }

    protected Set<String> getKnownValueSet() {
        return VCardParser_V21.sKnownValueSet;
    }

    protected Set<String> getAvailableEncodingSet() {
        return VCardParser_V21.sAvailableEncoding;
    }

    protected String getDefaultEncoding() {
        return DEFAULT_ENCODING;
    }

    public void parse(InputStream is, VCardInterpreter interpreter) throws IOException, VCardException {
        if (is == null) {
            throw new NullPointerException("InputStream must not be null.");
        }
        InputStreamReader tmpReader = new InputStreamReader(is, this.mIntermediateCharset);
        this.mReader = new CustomBufferedReader(tmpReader);
        this.mInterpreter = interpreter != null ? interpreter : new EmptyInterpreter();
        long start = System.currentTimeMillis();
        if (this.mInterpreter != null) {
            this.mInterpreter.start();
        }
        this.parseVCardFile();
        if (this.mInterpreter != null) {
            this.mInterpreter.end();
        }
        this.mTimeTotal += System.currentTimeMillis() - start;
        if (VCardConfig.showPerformanceLog()) {
            this.showPerformanceInfo();
        }
    }

    public final void cancel() {
        this.mCanceled = true;
    }

    protected static final class CustomBufferedReader
    extends BufferedReader {
        private long mTime;
        private boolean mNextLineIsValid;
        private String mNextLine;

        public CustomBufferedReader(Reader in) {
            super(in);
        }

        public String readLine() throws IOException {
            if (this.mNextLineIsValid) {
                String ret = this.mNextLine;
                this.mNextLine = null;
                this.mNextLineIsValid = false;
                return ret;
            }
            long start = System.currentTimeMillis();
            String line = super.readLine();
            long end = System.currentTimeMillis();
            this.mTime += end - start;
            return line;
        }

        public String peekLine() throws IOException {
            if (!this.mNextLineIsValid) {
                long start = System.currentTimeMillis();
                String line = super.readLine();
                long end = System.currentTimeMillis();
                this.mTime += end - start;
                this.mNextLine = line;
                this.mNextLineIsValid = true;
            }
            return this.mNextLine;
        }

        public long getTotalmillisecond() {
            return this.mTime;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyInterpreter
    implements VCardInterpreter {
        private EmptyInterpreter() {
        }

        @Override
        public void end() {
        }

        @Override
        public void endEntry() {
        }

        @Override
        public void endProperty() {
        }

        @Override
        public void propertyGroup(String group) {
        }

        @Override
        public void propertyName(String name) {
        }

        @Override
        public void propertyParamType(String type) {
        }

        @Override
        public void propertyParamValue(String value) {
        }

        @Override
        public void propertyValues(List<String> values) {
        }

        @Override
        public void start() {
        }

        @Override
        public void startEntry() {
        }

        @Override
        public void startProperty() {
        }
    }
}

