/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.accounts.Account;
import android.content.ContentProviderOperation;
import android.content.ContentResolver;
import android.content.OperationApplicationException;
import android.net.Uri;
import android.os.RemoteException;
import android.pim.vcard.VCardConfig;
import android.pim.vcard.VCardUtils;
import android.provider.ContactsContract;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.util.Log;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCardEntry {
    private static final String LOG_TAG = "VCardEntry";
    private static final int DEFAULT_ORGANIZATION_TYPE = 1;
    private static final String ACCOUNT_TYPE_GOOGLE = "com.google";
    private static final String GOOGLE_MY_CONTACTS_GROUP = "System Group: My Contacts";
    private static final Map<String, Integer> sImMap = new HashMap<String, Integer>();
    private String mFamilyName;
    private String mGivenName;
    private String mMiddleName;
    private String mPrefix;
    private String mSuffix;
    private String mFormattedName;
    private String mPhoneticFamilyName;
    private String mPhoneticGivenName;
    private String mPhoneticMiddleName;
    private String mPhoneticFullName;
    private List<String> mNickNameList;
    private String mDisplayName;
    private String mBirthday;
    private String mAnniversary;
    private List<String> mNoteList;
    private List<PhoneData> mPhoneList;
    private List<EmailData> mEmailList;
    private List<PostalData> mPostalList;
    private List<OrganizationData> mOrganizationList;
    private List<ImData> mImList;
    private List<PhotoData> mPhotoList;
    private List<String> mWebsiteList;
    private List<List<String>> mAndroidCustomPropertyList;
    private final int mVCardType;
    private final Account mAccount;
    private static final List<String> sEmptyList;

    public VCardEntry() {
        this(-1073741824);
    }

    public VCardEntry(int vcardType) {
        this(vcardType, null);
    }

    public VCardEntry(int vcardType, Account account) {
        this.mVCardType = vcardType;
        this.mAccount = account;
    }

    private void addPhone(int type, String data, String label, boolean isPrimary) {
        String formattedNumber;
        if (this.mPhoneList == null) {
            this.mPhoneList = new ArrayList<PhoneData>();
        }
        StringBuilder builder = new StringBuilder();
        String trimed = data.trim();
        if (type == 6 || VCardConfig.refrainPhoneNumberFormatting(this.mVCardType)) {
            formattedNumber = trimed;
        } else {
            int length = trimed.length();
            for (int i = 0; i < length; ++i) {
                char ch = trimed.charAt(i);
                if (('0' > ch || ch > '9') && (i != 0 || ch != '+')) continue;
                builder.append(ch);
            }
            int formattingType = VCardUtils.getPhoneNumberFormat(this.mVCardType);
            formattedNumber = PhoneNumberUtils.formatNumber(builder.toString(), formattingType);
        }
        PhoneData phoneData = new PhoneData(type, formattedNumber, label, isPrimary);
        this.mPhoneList.add(phoneData);
    }

    private void addNickName(String nickName) {
        if (this.mNickNameList == null) {
            this.mNickNameList = new ArrayList<String>();
        }
        this.mNickNameList.add(nickName);
    }

    private void addEmail(int type, String data, String label, boolean isPrimary) {
        if (this.mEmailList == null) {
            this.mEmailList = new ArrayList<EmailData>();
        }
        this.mEmailList.add(new EmailData(type, data, label, isPrimary));
    }

    private void addPostal(int type, List<String> propValueList, String label, boolean isPrimary) {
        if (this.mPostalList == null) {
            this.mPostalList = new ArrayList<PostalData>(0);
        }
        this.mPostalList.add(new PostalData(type, propValueList, label, isPrimary));
    }

    private void addNewOrganization(int type, String companyName, String departmentName, String titleName, String phoneticName, boolean isPrimary) {
        if (this.mOrganizationList == null) {
            this.mOrganizationList = new ArrayList<OrganizationData>();
        }
        this.mOrganizationList.add(new OrganizationData(type, companyName, departmentName, titleName, phoneticName, isPrimary));
    }

    private String buildSinglePhoneticNameFromSortAsParam(Map<String, Collection<String>> paramMap) {
        Collection<String> sortAsCollection = paramMap.get("SORT-AS");
        if (sortAsCollection != null && sortAsCollection.size() != 0) {
            if (sortAsCollection.size() > 1) {
                Log.w(LOG_TAG, "Incorrect multiple SORT_AS parameters detected: " + Arrays.toString(sortAsCollection.toArray()));
            }
            List<String> sortNames = VCardUtils.constructListFromValue(sortAsCollection.iterator().next(), this.mVCardType);
            StringBuilder builder = new StringBuilder();
            for (String elem : sortNames) {
                builder.append(elem);
            }
            return builder.toString();
        }
        return null;
    }

    private void handleOrgValue(int type, List<String> orgList, Map<String, Collection<String>> paramMap, boolean isPrimary) {
        String departmentName;
        String companyName;
        String phoneticName = this.buildSinglePhoneticNameFromSortAsParam(paramMap);
        if (orgList == null) {
            orgList = sEmptyList;
        }
        int size = orgList.size();
        switch (size) {
            case 0: {
                companyName = "";
                departmentName = null;
                break;
            }
            case 1: {
                companyName = orgList.get(0);
                departmentName = null;
                break;
            }
            default: {
                companyName = orgList.get(0);
                StringBuilder builder = new StringBuilder();
                for (int i = 1; i < size; ++i) {
                    if (i > 1) {
                        builder.append(' ');
                    }
                    builder.append(orgList.get(i));
                }
                departmentName = builder.toString();
            }
        }
        if (this.mOrganizationList == null) {
            this.addNewOrganization(type, companyName, departmentName, null, phoneticName, isPrimary);
            return;
        }
        for (OrganizationData organizationData : this.mOrganizationList) {
            if (organizationData.companyName != null || organizationData.departmentName != null) continue;
            organizationData.companyName = companyName;
            organizationData.departmentName = departmentName;
            organizationData.isPrimary = isPrimary;
            return;
        }
        this.addNewOrganization(type, companyName, departmentName, null, phoneticName, isPrimary);
    }

    private void handleTitleValue(String title) {
        if (this.mOrganizationList == null) {
            this.addNewOrganization(1, null, null, title, null, false);
            return;
        }
        for (OrganizationData organizationData : this.mOrganizationList) {
            if (organizationData.titleName != null) continue;
            organizationData.titleName = title;
            return;
        }
        this.addNewOrganization(1, null, null, title, null, false);
    }

    private void addIm(int protocol, String customProtocol, int type, String propValue, boolean isPrimary) {
        if (this.mImList == null) {
            this.mImList = new ArrayList<ImData>();
        }
        this.mImList.add(new ImData(protocol, customProtocol, type, propValue, isPrimary));
    }

    private void addNote(String note) {
        if (this.mNoteList == null) {
            this.mNoteList = new ArrayList<String>(1);
        }
        this.mNoteList.add(note);
    }

    private void addPhotoBytes(String formatName, byte[] photoBytes, boolean isPrimary) {
        if (this.mPhotoList == null) {
            this.mPhotoList = new ArrayList<PhotoData>(1);
        }
        PhotoData photoData = new PhotoData(0, null, photoBytes, isPrimary);
        this.mPhotoList.add(photoData);
    }

    private void tryHandleSortAsName(Map<String, Collection<String>> paramMap) {
        if (!(!VCardConfig.isVersion30(this.mVCardType) || TextUtils.isEmpty(this.mPhoneticFamilyName) && TextUtils.isEmpty(this.mPhoneticMiddleName) && TextUtils.isEmpty(this.mPhoneticGivenName))) {
            return;
        }
        Collection<String> sortAsCollection = paramMap.get("SORT-AS");
        if (sortAsCollection != null && sortAsCollection.size() != 0) {
            List<String> sortNames;
            int size;
            if (sortAsCollection.size() > 1) {
                Log.w(LOG_TAG, "Incorrect multiple SORT_AS parameters detected: " + Arrays.toString(sortAsCollection.toArray()));
            }
            if ((size = (sortNames = VCardUtils.constructListFromValue(sortAsCollection.iterator().next(), this.mVCardType)).size()) > 3) {
                size = 3;
            }
            switch (size) {
                case 3: {
                    this.mPhoneticMiddleName = sortNames.get(2);
                }
                case 2: {
                    this.mPhoneticGivenName = sortNames.get(1);
                }
            }
            this.mPhoneticFamilyName = sortNames.get(0);
        }
    }

    private void handleNProperty(List<String> paramValues, Map<String, Collection<String>> paramMap) {
        int size;
        this.tryHandleSortAsName(paramMap);
        if (paramValues == null || (size = paramValues.size()) < 1) {
            return;
        }
        if (size > 5) {
            size = 5;
        }
        switch (size) {
            case 5: {
                this.mSuffix = paramValues.get(4);
            }
            case 4: {
                this.mPrefix = paramValues.get(3);
            }
            case 3: {
                this.mMiddleName = paramValues.get(2);
            }
            case 2: {
                this.mGivenName = paramValues.get(1);
            }
        }
        this.mFamilyName = paramValues.get(0);
    }

    private void handlePhoneticNameFromSound(List<String> elems) {
        int size;
        if (!(TextUtils.isEmpty(this.mPhoneticFamilyName) && TextUtils.isEmpty(this.mPhoneticMiddleName) && TextUtils.isEmpty(this.mPhoneticGivenName))) {
            return;
        }
        if (elems == null || (size = elems.size()) < 1) {
            return;
        }
        if (size > 3) {
            size = 3;
        }
        if (elems.get(0).length() > 0) {
            boolean onlyFirstElemIsNonEmpty = true;
            for (int i = 1; i < size; ++i) {
                if (elems.get(i).length() <= 0) continue;
                onlyFirstElemIsNonEmpty = false;
                break;
            }
            if (onlyFirstElemIsNonEmpty) {
                String[] namesArray = elems.get(0).split(" ");
                int nameArrayLength = namesArray.length;
                if (nameArrayLength == 3) {
                    this.mPhoneticFamilyName = namesArray[0];
                    this.mPhoneticMiddleName = namesArray[1];
                    this.mPhoneticGivenName = namesArray[2];
                } else if (nameArrayLength == 2) {
                    this.mPhoneticFamilyName = namesArray[0];
                    this.mPhoneticGivenName = namesArray[1];
                } else {
                    this.mPhoneticFullName = elems.get(0);
                }
                return;
            }
        }
        switch (size) {
            case 3: {
                this.mPhoneticMiddleName = elems.get(2);
            }
            case 2: {
                this.mPhoneticGivenName = elems.get(1);
            }
        }
        this.mPhoneticFamilyName = elems.get(0);
    }

    public void addProperty(Property property) {
        String propName = property.mPropertyName;
        Map paramMap = property.mParameterMap;
        List propValueList = property.mPropertyValueList;
        byte[] propBytes = property.mPropertyBytes;
        if (propValueList.size() == 0) {
            return;
        }
        String propValue = this.listToString(propValueList).trim();
        if (!propName.equals("VERSION")) {
            if (propName.equals("FN")) {
                this.mFormattedName = propValue;
            } else if (propName.equals("NAME") && this.mFormattedName == null) {
                this.mFormattedName = propValue;
            } else if (propName.equals("N")) {
                this.handleNProperty(propValueList, paramMap);
            } else if (propName.equals("SORT-STRING")) {
                this.mPhoneticFullName = propValue;
            } else if (propName.equals("NICKNAME") || propName.equals("X-NICKNAME")) {
                this.addNickName(propValue);
            } else if (propName.equals("SOUND")) {
                Collection typeCollection = (Collection)paramMap.get("TYPE");
                if (typeCollection != null && typeCollection.contains("X-IRMC-N")) {
                    List<String> phoneticNameList = VCardUtils.constructListFromValue(propValue, this.mVCardType);
                    this.handlePhoneticNameFromSound(phoneticNameList);
                }
            } else if (propName.equals("ADR")) {
                boolean valuesAreAllEmpty = true;
                for (String value : propValueList) {
                    if (value.length() <= 0) continue;
                    valuesAreAllEmpty = false;
                    break;
                }
                if (valuesAreAllEmpty) {
                    return;
                }
                int type = -1;
                String label = "";
                boolean isPrimary = false;
                Collection typeCollection = (Collection)paramMap.get("TYPE");
                if (typeCollection != null) {
                    for (String typeString : typeCollection) {
                        if ((typeString = typeString.toUpperCase()).equals("PREF")) {
                            isPrimary = true;
                            continue;
                        }
                        if (typeString.equals("HOME")) {
                            type = 1;
                            label = "";
                            continue;
                        }
                        if (typeString.equals("WORK") || typeString.equalsIgnoreCase("COMPANY")) {
                            type = 2;
                            label = "";
                            continue;
                        }
                        if (typeString.equals("PARCEL") || typeString.equals("DOM") || typeString.equals("INTL")) continue;
                        if (typeString.startsWith("X-") && type < 0) {
                            typeString = typeString.substring(2);
                        }
                        type = 0;
                        label = typeString;
                    }
                }
                if (type < 0) {
                    type = 1;
                }
                this.addPostal(type, propValueList, label, isPrimary);
            } else if (propName.equals("EMAIL")) {
                int type = -1;
                String label = null;
                boolean isPrimary = false;
                Collection typeCollection = (Collection)paramMap.get("TYPE");
                if (typeCollection != null) {
                    for (String typeString : typeCollection) {
                        if ((typeString = typeString.toUpperCase()).equals("PREF")) {
                            isPrimary = true;
                            continue;
                        }
                        if (typeString.equals("HOME")) {
                            type = 1;
                            continue;
                        }
                        if (typeString.equals("WORK")) {
                            type = 2;
                            continue;
                        }
                        if (typeString.equals("CELL")) {
                            type = 4;
                            continue;
                        }
                        if (typeString.startsWith("X-") && type < 0) {
                            typeString = typeString.substring(2);
                        }
                        type = 0;
                        label = typeString;
                    }
                }
                if (type < 0) {
                    type = 3;
                }
                this.addEmail(type, propValue, label, isPrimary);
            } else if (propName.equals("ORG")) {
                boolean type = true;
                boolean isPrimary = false;
                Collection typeCollection = (Collection)paramMap.get("TYPE");
                if (typeCollection != null) {
                    for (String typeString : typeCollection) {
                        if (!typeString.equals("PREF")) continue;
                        isPrimary = true;
                    }
                }
                this.handleOrgValue(1, propValueList, paramMap, isPrimary);
            } else if (propName.equals("TITLE")) {
                this.handleTitleValue(propValue);
            } else if (!propName.equals("ROLE")) {
                if (propName.equals("PHOTO") || propName.equals("LOGO")) {
                    Collection paramMapValue = (Collection)paramMap.get("VALUE");
                    if (paramMapValue == null || !paramMapValue.contains("URL")) {
                        Collection typeCollection = (Collection)paramMap.get("TYPE");
                        String formatName = null;
                        boolean isPrimary = false;
                        if (typeCollection != null) {
                            for (String typeValue : typeCollection) {
                                if ("PREF".equals(typeValue)) {
                                    isPrimary = true;
                                    continue;
                                }
                                if (formatName != null) continue;
                                formatName = typeValue;
                            }
                        }
                        this.addPhotoBytes(formatName, propBytes, isPrimary);
                    }
                } else if (propName.equals("TEL")) {
                    String label;
                    int type;
                    Collection typeCollection = (Collection)paramMap.get("TYPE");
                    Object typeObject = VCardUtils.getPhoneTypeFromStrings(typeCollection, propValue);
                    if (typeObject instanceof Integer) {
                        type = (Integer)typeObject;
                        label = null;
                    } else {
                        type = 0;
                        label = typeObject.toString();
                    }
                    boolean isPrimary = typeCollection != null && typeCollection.contains("PREF");
                    this.addPhone(type, propValue, label, isPrimary);
                } else if (propName.equals("X-SKYPE-PSTNNUMBER")) {
                    Collection typeCollection = (Collection)paramMap.get("TYPE");
                    int type = 7;
                    boolean isPrimary = typeCollection != null && typeCollection.contains("PREF");
                    this.addPhone(7, propValue, null, isPrimary);
                } else if (sImMap.containsKey(propName)) {
                    int protocol = sImMap.get(propName);
                    boolean isPrimary = false;
                    int type = -1;
                    Collection typeCollection = (Collection)paramMap.get("TYPE");
                    if (typeCollection != null) {
                        for (String typeString : typeCollection) {
                            if (typeString.equals("PREF")) {
                                isPrimary = true;
                                continue;
                            }
                            if (type >= 0) continue;
                            if (typeString.equalsIgnoreCase("HOME")) {
                                type = 1;
                                continue;
                            }
                            if (!typeString.equalsIgnoreCase("WORK")) continue;
                            type = 2;
                        }
                    }
                    if (type < 0) {
                        type = 1;
                    }
                    this.addIm(protocol, null, type, propValue, isPrimary);
                } else if (propName.equals("NOTE")) {
                    this.addNote(propValue);
                } else if (propName.equals("URL")) {
                    if (this.mWebsiteList == null) {
                        this.mWebsiteList = new ArrayList<String>(1);
                    }
                    this.mWebsiteList.add(propValue);
                } else if (propName.equals("BDAY")) {
                    this.mBirthday = propValue;
                } else if (propName.equals("ANNIVERSARY")) {
                    this.mAnniversary = propValue;
                } else if (propName.equals("X-PHONETIC-FIRST-NAME")) {
                    this.mPhoneticGivenName = propValue;
                } else if (propName.equals("X-PHONETIC-MIDDLE-NAME")) {
                    this.mPhoneticMiddleName = propValue;
                } else if (propName.equals("X-PHONETIC-LAST-NAME")) {
                    this.mPhoneticFamilyName = propValue;
                } else if (propName.equals("X-ANDROID-CUSTOM")) {
                    List<String> customPropertyList = VCardUtils.constructListFromValue(propValue, this.mVCardType);
                    this.handleAndroidCustomProperty(customPropertyList);
                }
            }
        }
    }

    private void handleAndroidCustomProperty(List<String> customPropertyList) {
        if (this.mAndroidCustomPropertyList == null) {
            this.mAndroidCustomPropertyList = new ArrayList<List<String>>();
        }
        this.mAndroidCustomPropertyList.add(customPropertyList);
    }

    private void constructDisplayName() {
        if (!TextUtils.isEmpty(this.mFormattedName)) {
            this.mDisplayName = this.mFormattedName;
        } else if (!TextUtils.isEmpty(this.mFamilyName) || !TextUtils.isEmpty(this.mGivenName)) {
            this.mDisplayName = VCardUtils.constructNameFromElements(this.mVCardType, this.mFamilyName, this.mMiddleName, this.mGivenName, this.mPrefix, this.mSuffix);
        } else if (!TextUtils.isEmpty(this.mPhoneticFamilyName) || !TextUtils.isEmpty(this.mPhoneticGivenName)) {
            this.mDisplayName = VCardUtils.constructNameFromElements(this.mVCardType, this.mPhoneticFamilyName, this.mPhoneticMiddleName, this.mPhoneticGivenName);
        } else if (this.mEmailList != null && this.mEmailList.size() > 0) {
            this.mDisplayName = this.mEmailList.get((int)0).data;
        } else if (this.mPhoneList != null && this.mPhoneList.size() > 0) {
            this.mDisplayName = this.mPhoneList.get((int)0).data;
        } else if (this.mPostalList != null && this.mPostalList.size() > 0) {
            this.mDisplayName = this.mPostalList.get(0).getFormattedAddress(this.mVCardType);
        } else if (this.mOrganizationList != null && this.mOrganizationList.size() > 0) {
            this.mDisplayName = this.mOrganizationList.get(0).getFormattedString();
        }
        if (this.mDisplayName == null) {
            this.mDisplayName = "";
        }
    }

    public void consolidateFields() {
        this.constructDisplayName();
        if (this.mPhoneticFullName != null) {
            this.mPhoneticFullName = this.mPhoneticFullName.trim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public Uri pushIntoContentResolver(ContentResolver resolver) {
        operationList = new ArrayList<ContentProviderOperation>();
        builder = ContentProviderOperation.newInsert(ContactsContract.RawContacts.CONTENT_URI);
        myGroupsId = null;
        if (this.mAccount != null) {
            builder.withValue("account_name", this.mAccount.name);
            builder.withValue("account_type", this.mAccount.type);
            if ("com.google".equals(this.mAccount.type)) {
                cursor = resolver.query(ContactsContract.Groups.CONTENT_URI, new String[]{"sourceid"}, "title=?", new String[]{"System Group: My Contacts"}, null);
                try {
                    if (cursor == null || !cursor.moveToFirst()) ** GOTO lbl24
                    myGroupsId = cursor.getString(0);
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        } else {
            builder.withValue("account_name", null);
            builder.withValue("account_type", null);
        }
lbl24:
        // 4 sources

        operationList.add(builder.build());
        if (!this.nameFieldsAreEmpty()) {
            builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
            builder.withValueBackReference("raw_contact_id", 0);
            builder.withValue("mimetype", "vnd.android.cursor.item/name");
            builder.withValue("data2", this.mGivenName);
            builder.withValue("data3", this.mFamilyName);
            builder.withValue("data5", this.mMiddleName);
            builder.withValue("data4", this.mPrefix);
            builder.withValue("data6", this.mSuffix);
            if (!(TextUtils.isEmpty(this.mPhoneticGivenName) && TextUtils.isEmpty(this.mPhoneticFamilyName) && TextUtils.isEmpty(this.mPhoneticMiddleName))) {
                builder.withValue("data7", this.mPhoneticGivenName);
                builder.withValue("data9", this.mPhoneticFamilyName);
                builder.withValue("data8", this.mPhoneticMiddleName);
            } else if (!TextUtils.isEmpty(this.mPhoneticFullName)) {
                builder.withValue("data7", this.mPhoneticFullName);
            }
            builder.withValue("data1", this.getDisplayName());
            operationList.add(builder.build());
        }
        if (this.mNickNameList != null && this.mNickNameList.size() > 0) {
            for (String nickName : this.mNickNameList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                builder.withValueBackReference("raw_contact_id", 0);
                builder.withValue("mimetype", "vnd.android.cursor.item/nickname");
                builder.withValue("data2", 1);
                builder.withValue("data1", nickName);
                operationList.add(builder.build());
            }
        }
        if (this.mPhoneList != null) {
            for (PhoneData phoneData : this.mPhoneList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                builder.withValueBackReference("raw_contact_id", 0);
                builder.withValue("mimetype", "vnd.android.cursor.item/phone_v2");
                builder.withValue("data2", phoneData.type);
                if (phoneData.type == 0) {
                    builder.withValue("data3", phoneData.label);
                }
                builder.withValue("data1", phoneData.data);
                if (phoneData.isPrimary) {
                    builder.withValue("is_primary", 1);
                }
                operationList.add(builder.build());
            }
        }
        if (this.mOrganizationList != null) {
            for (OrganizationData organizationData : this.mOrganizationList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                builder.withValueBackReference("raw_contact_id", 0);
                builder.withValue("mimetype", "vnd.android.cursor.item/organization");
                builder.withValue("data2", organizationData.type);
                if (organizationData.companyName != null) {
                    builder.withValue("data1", organizationData.companyName);
                }
                if (organizationData.departmentName != null) {
                    builder.withValue("data5", organizationData.departmentName);
                }
                if (organizationData.titleName != null) {
                    builder.withValue("data4", organizationData.titleName);
                }
                if (organizationData.phoneticName != null) {
                    builder.withValue("data8", organizationData.phoneticName);
                }
                if (organizationData.isPrimary) {
                    builder.withValue("is_primary", 1);
                }
                operationList.add(builder.build());
            }
        }
        if (this.mEmailList != null) {
            for (EmailData emailData : this.mEmailList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                builder.withValueBackReference("raw_contact_id", 0);
                builder.withValue("mimetype", "vnd.android.cursor.item/email_v2");
                builder.withValue("data2", emailData.type);
                if (emailData.type == 0) {
                    builder.withValue("data3", emailData.label);
                }
                builder.withValue("data1", emailData.data);
                if (emailData.isPrimary) {
                    builder.withValue("is_primary", 1);
                }
                operationList.add(builder.build());
            }
        }
        if (this.mPostalList != null) {
            for (PostalData postalData : this.mPostalList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                VCardUtils.insertStructuredPostalDataUsingContactsStruct(this.mVCardType, builder, postalData);
                operationList.add(builder.build());
            }
        }
        if (this.mImList != null) {
            for (ImData imData : this.mImList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                builder.withValueBackReference("raw_contact_id", 0);
                builder.withValue("mimetype", "vnd.android.cursor.item/im");
                builder.withValue("data2", imData.type);
                builder.withValue("data5", imData.protocol);
                builder.withValue("data1", imData.data);
                if (imData.protocol == -1) {
                    builder.withValue("data6", imData.customProtocol);
                }
                if (imData.isPrimary) {
                    builder.withValue("is_primary", 1);
                }
                operationList.add(builder.build());
            }
        }
        if (this.mNoteList != null) {
            for (String note : this.mNoteList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                builder.withValueBackReference("raw_contact_id", 0);
                builder.withValue("mimetype", "vnd.android.cursor.item/note");
                builder.withValue("data1", note);
                operationList.add(builder.build());
            }
        }
        if (this.mPhotoList != null) {
            for (PhotoData photoData : this.mPhotoList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                builder.withValueBackReference("raw_contact_id", 0);
                builder.withValue("mimetype", "vnd.android.cursor.item/photo");
                builder.withValue("data15", photoData.photoBytes);
                if (photoData.isPrimary) {
                    builder.withValue("is_primary", 1);
                }
                operationList.add(builder.build());
            }
        }
        if (this.mWebsiteList != null) {
            for (String website : this.mWebsiteList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                builder.withValueBackReference("raw_contact_id", 0);
                builder.withValue("mimetype", "vnd.android.cursor.item/website");
                builder.withValue("data1", website);
                builder.withValue("data2", 1);
                operationList.add(builder.build());
            }
        }
        if (!TextUtils.isEmpty(this.mBirthday)) {
            builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
            builder.withValueBackReference("raw_contact_id", 0);
            builder.withValue("mimetype", "vnd.android.cursor.item/contact_event");
            builder.withValue("data1", this.mBirthday);
            builder.withValue("data2", 3);
            operationList.add(builder.build());
        }
        if (!TextUtils.isEmpty(this.mAnniversary)) {
            builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
            builder.withValueBackReference("raw_contact_id", 0);
            builder.withValue("mimetype", "vnd.android.cursor.item/contact_event");
            builder.withValue("data1", this.mAnniversary);
            builder.withValue("data2", 1);
            operationList.add(builder.build());
        }
        if (this.mAndroidCustomPropertyList != null) {
            for (List<E> customPropertyList : this.mAndroidCustomPropertyList) {
                size = customPropertyList.size();
                if (size < 2 || TextUtils.isEmpty((CharSequence)customPropertyList.get(0))) continue;
                if (size > 16) {
                    size = 16;
                    customPropertyList = customPropertyList.subList(0, 17);
                }
                i = 0;
                for (String customPropertyValue : customPropertyList) {
                    if (i == 0) {
                        mimeType = customPropertyValue;
                        builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                        builder.withValueBackReference("raw_contact_id", 0);
                        builder.withValue("mimetype", mimeType);
                    } else if (!TextUtils.isEmpty(customPropertyValue)) {
                        builder.withValue("data" + i, customPropertyValue);
                    }
                    ++i;
                }
                operationList.add(builder.build());
            }
        }
        if (myGroupsId != null) {
            builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
            builder.withValueBackReference("raw_contact_id", 0);
            builder.withValue("mimetype", "vnd.android.cursor.item/group_membership");
            builder.withValue("group_sourceid", myGroupsId);
            operationList.add(builder.build());
        }
        try {
            results = resolver.applyBatch("com.android.contacts", operationList);
            return results == null || results.length == 0 || results[0] == null ? null : results[0].uri;
        }
        catch (RemoteException e) {
            Log.e("VCardEntry", String.format("%s: %s", new Object[]{e.toString(), e.getMessage()}));
            return null;
        }
        catch (OperationApplicationException e) {
            Log.e("VCardEntry", String.format("%s: %s", new Object[]{e.toString(), e.getMessage()}));
            return null;
        }
    }

    public static VCardEntry buildFromResolver(ContentResolver resolver) {
        return VCardEntry.buildFromResolver(resolver, ContactsContract.Contacts.CONTENT_URI);
    }

    public static VCardEntry buildFromResolver(ContentResolver resolver, Uri uri) {
        return null;
    }

    private boolean nameFieldsAreEmpty() {
        return TextUtils.isEmpty(this.mFamilyName) && TextUtils.isEmpty(this.mMiddleName) && TextUtils.isEmpty(this.mGivenName) && TextUtils.isEmpty(this.mPrefix) && TextUtils.isEmpty(this.mSuffix) && TextUtils.isEmpty(this.mFormattedName) && TextUtils.isEmpty(this.mPhoneticFamilyName) && TextUtils.isEmpty(this.mPhoneticMiddleName) && TextUtils.isEmpty(this.mPhoneticGivenName) && TextUtils.isEmpty(this.mPhoneticFullName);
    }

    public boolean isIgnorable() {
        return this.getDisplayName().length() == 0;
    }

    private String listToString(List<String> list) {
        int size = list.size();
        if (size > 1) {
            StringBuilder builder = new StringBuilder();
            int i = 0;
            for (String type : list) {
                builder.append(type);
                if (i >= size - 1) continue;
                builder.append(";");
            }
            return builder.toString();
        }
        if (size == 1) {
            return list.get(0);
        }
        return "";
    }

    public String getFamilyName() {
        return this.mFamilyName;
    }

    public String getGivenName() {
        return this.mGivenName;
    }

    public String getMiddleName() {
        return this.mMiddleName;
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public String getSuffix() {
        return this.mSuffix;
    }

    public String getFullName() {
        return this.mFormattedName;
    }

    public String getPhoneticFamilyName() {
        return this.mPhoneticFamilyName;
    }

    public String getPhoneticGivenName() {
        return this.mPhoneticGivenName;
    }

    public String getPhoneticMiddleName() {
        return this.mPhoneticMiddleName;
    }

    public String getPhoneticFullName() {
        return this.mPhoneticFullName;
    }

    public final List<String> getNickNameList() {
        return this.mNickNameList;
    }

    public String getBirthday() {
        return this.mBirthday;
    }

    public final List<String> getNotes() {
        return this.mNoteList;
    }

    public final List<PhoneData> getPhoneList() {
        return this.mPhoneList;
    }

    public final List<EmailData> getEmailList() {
        return this.mEmailList;
    }

    public final List<PostalData> getPostalList() {
        return this.mPostalList;
    }

    public final List<OrganizationData> getOrganizationList() {
        return this.mOrganizationList;
    }

    public final List<ImData> getImList() {
        return this.mImList;
    }

    public final List<PhotoData> getPhotoList() {
        return this.mPhotoList;
    }

    public final List<String> getWebsiteList() {
        return this.mWebsiteList;
    }

    public String getDisplayName() {
        if (this.mDisplayName == null) {
            this.constructDisplayName();
        }
        return this.mDisplayName;
    }

    static {
        sImMap.put("X-AIM", 0);
        sImMap.put("X-MSN", 1);
        sImMap.put("X-YAHOO", 2);
        sImMap.put("X-ICQ", 6);
        sImMap.put("X-JABBER", 7);
        sImMap.put("X-SKYPE-USERNAME", 3);
        sImMap.put("X-GOOGLE-TALK", 5);
        sImMap.put("X-GOOGLE TALK", 5);
        sEmptyList = Collections.unmodifiableList(new ArrayList(0));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Property {
        private String mPropertyName;
        private Map<String, Collection<String>> mParameterMap = new HashMap<String, Collection<String>>();
        private List<String> mPropertyValueList = new ArrayList<String>();
        private byte[] mPropertyBytes;

        Property() {
        }

        public void setPropertyName(String propertyName) {
            this.mPropertyName = propertyName;
        }

        public void addParameter(String paramName, String paramValue) {
            AbstractCollection values;
            if (!this.mParameterMap.containsKey(paramName)) {
                values = paramName.equals("TYPE") ? new HashSet<String>() : new ArrayList<String>();
                this.mParameterMap.put(paramName, values);
            } else {
                values = this.mParameterMap.get(paramName);
            }
            values.add((String)paramValue);
        }

        public void addToPropertyValueList(String propertyValue) {
            this.mPropertyValueList.add(propertyValue);
        }

        public void setPropertyBytes(byte[] propertyBytes) {
            this.mPropertyBytes = propertyBytes;
        }

        public final Collection<String> getParameters(String type) {
            return this.mParameterMap.get(type);
        }

        public final List<String> getPropertyValueList() {
            return this.mPropertyValueList;
        }

        public void clear() {
            this.mPropertyName = null;
            this.mParameterMap.clear();
            this.mPropertyValueList.clear();
            this.mPropertyBytes = null;
        }
    }

    public static class PhotoData {
        public static final String FORMAT_FLASH = "SWF";
        public final int type;
        public final String formatName;
        public final byte[] photoBytes;
        public final boolean isPrimary;

        public PhotoData(int type, String formatName, byte[] photoBytes, boolean isPrimary) {
            this.type = type;
            this.formatName = formatName;
            this.photoBytes = photoBytes;
            this.isPrimary = isPrimary;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PhotoData)) {
                return false;
            }
            PhotoData photoData = (PhotoData)obj;
            return this.type == photoData.type && (this.formatName == null ? photoData.formatName == null : this.formatName.equals(photoData.formatName)) && Arrays.equals(this.photoBytes, photoData.photoBytes) && this.isPrimary == photoData.isPrimary;
        }

        public String toString() {
            return String.format("type: %d, format: %s: size: %d, isPrimary: %s", this.type, this.formatName, this.photoBytes.length, this.isPrimary);
        }
    }

    public static class ImData {
        public final int protocol;
        public final String customProtocol;
        public final int type;
        public final String data;
        public final boolean isPrimary;

        public ImData(int protocol, String customProtocol, int type, String data, boolean isPrimary) {
            this.protocol = protocol;
            this.customProtocol = customProtocol;
            this.type = type;
            this.data = data;
            this.isPrimary = isPrimary;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ImData)) {
                return false;
            }
            ImData imData = (ImData)obj;
            return this.type == imData.type && this.protocol == imData.protocol && (this.customProtocol != null ? this.customProtocol.equals(imData.customProtocol) : imData.customProtocol == null) && (this.data != null ? this.data.equals(imData.data) : imData.data == null) && this.isPrimary == imData.isPrimary;
        }

        public String toString() {
            return String.format("type: %d, protocol: %d, custom_protcol: %s, data: %s, isPrimary: %s", this.type, this.protocol, this.customProtocol, this.data, this.isPrimary);
        }
    }

    public static class OrganizationData {
        public final int type;
        public String companyName;
        public String departmentName;
        public String titleName;
        public final String phoneticName;
        public boolean isPrimary;

        public OrganizationData(int type, String companyName, String departmentName, String titleName, String phoneticName, boolean isPrimary) {
            this.type = type;
            this.companyName = companyName;
            this.departmentName = departmentName;
            this.titleName = titleName;
            this.phoneticName = phoneticName;
            this.isPrimary = isPrimary;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OrganizationData)) {
                return false;
            }
            OrganizationData organization = (OrganizationData)obj;
            return this.type == organization.type && TextUtils.equals(this.companyName, organization.companyName) && TextUtils.equals(this.departmentName, organization.departmentName) && TextUtils.equals(this.titleName, organization.titleName) && this.isPrimary == organization.isPrimary;
        }

        public String getFormattedString() {
            StringBuilder builder = new StringBuilder();
            if (!TextUtils.isEmpty(this.companyName)) {
                builder.append(this.companyName);
            }
            if (!TextUtils.isEmpty(this.departmentName)) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(this.departmentName);
            }
            if (!TextUtils.isEmpty(this.titleName)) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(this.titleName);
            }
            return builder.toString();
        }

        public String toString() {
            return String.format("type: %d, company: %s, department: %s, title: %s, isPrimary: %s", this.type, this.companyName, this.departmentName, this.titleName, this.isPrimary);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PostalData {
        public static final int ADDR_MAX_DATA_SIZE = 7;
        private final String[] dataArray;
        public final String pobox;
        public final String extendedAddress;
        public final String street;
        public final String localty;
        public final String region;
        public final String postalCode;
        public final String country;
        public final int type;
        public final String label;
        public boolean isPrimary;

        public PostalData(int type, List<String> propValueList, String label, boolean isPrimary) {
            this.type = type;
            this.dataArray = new String[7];
            int size = propValueList.size();
            if (size > 7) {
                size = 7;
            }
            int i = 0;
            Iterator<String> i$ = propValueList.iterator();
            while (i$.hasNext()) {
                String addressElement;
                this.dataArray[i] = addressElement = i$.next();
                if (++i < size) continue;
                break;
            }
            while (i < 7) {
                this.dataArray[i++] = null;
            }
            this.pobox = this.dataArray[0];
            this.extendedAddress = this.dataArray[1];
            this.street = this.dataArray[2];
            this.localty = this.dataArray[3];
            this.region = this.dataArray[4];
            this.postalCode = this.dataArray[5];
            this.country = this.dataArray[6];
            this.label = label;
            this.isPrimary = isPrimary;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PostalData)) {
                return false;
            }
            PostalData postalData = (PostalData)obj;
            return Arrays.equals(this.dataArray, postalData.dataArray) && this.type == postalData.type && (this.type != 0 || this.label == postalData.label) && this.isPrimary == postalData.isPrimary;
        }

        public String getFormattedAddress(int vcardType) {
            StringBuilder builder = new StringBuilder();
            boolean empty = true;
            if (VCardConfig.isJapaneseDevice(vcardType)) {
                for (int i = 6; i >= 0; --i) {
                    String addressPart = this.dataArray[i];
                    if (TextUtils.isEmpty(addressPart)) continue;
                    if (!empty) {
                        builder.append(' ');
                    } else {
                        empty = false;
                    }
                    builder.append(addressPart);
                }
            } else {
                for (int i = 0; i < 7; ++i) {
                    String addressPart = this.dataArray[i];
                    if (TextUtils.isEmpty(addressPart)) continue;
                    if (!empty) {
                        builder.append(' ');
                    } else {
                        empty = false;
                    }
                    builder.append(addressPart);
                }
            }
            return builder.toString().trim();
        }

        public String toString() {
            return String.format("type: %d, label: %s, isPrimary: %s", this.type, this.label, this.isPrimary);
        }
    }

    public static class EmailData {
        public final int type;
        public final String data;
        public final String label;
        public boolean isPrimary;

        public EmailData(int type, String data, String label, boolean isPrimary) {
            this.type = type;
            this.data = data;
            this.label = label;
            this.isPrimary = isPrimary;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EmailData)) {
                return false;
            }
            EmailData emailData = (EmailData)obj;
            return this.type == emailData.type && this.data.equals(emailData.data) && this.label.equals(emailData.label) && this.isPrimary == emailData.isPrimary;
        }

        public String toString() {
            return String.format("type: %d, data: %s, label: %s, isPrimary: %s", this.type, this.data, this.label, this.isPrimary);
        }
    }

    public static class PhoneData {
        public final int type;
        public final String data;
        public final String label;
        public boolean isPrimary;

        public PhoneData(int type, String data, String label, boolean isPrimary) {
            this.type = type;
            this.data = data;
            this.label = label;
            this.isPrimary = isPrimary;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PhoneData)) {
                return false;
            }
            PhoneData phoneData = (PhoneData)obj;
            return this.type == phoneData.type && this.data.equals(phoneData.data) && this.label.equals(phoneData.label) && this.isPrimary == phoneData.isPrimary;
        }

        public String toString() {
            return String.format("type: %d, data: %s, label: %s, isPrimary: %s", this.type, this.data, this.label, this.isPrimary);
        }
    }
}

