/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Entity;
import android.content.EntityIterator;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.pim.vcard.VCardBuilder;
import android.pim.vcard.VCardConfig;
import android.pim.vcard.exception.VCardException;
import android.provider.ContactsContract;
import android.text.TextUtils;
import android.util.CharsetUtils;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCardComposer {
    private static final String LOG_TAG = "VCardComposer";
    public static final String FAILURE_REASON_FAILED_TO_GET_DATABASE_INFO = "Failed to get database information";
    public static final String FAILURE_REASON_NO_ENTRY = "There's no exportable in the database";
    public static final String FAILURE_REASON_NOT_INITIALIZED = "The vCard composer object is not correctly initialized";
    public static final String FAILURE_REASON_UNSUPPORTED_URI = "The Uri vCard composer received is not supported by the composer.";
    public static final String NO_ERROR = "No error";
    public static final String VCARD_TYPE_STRING_DOCOMO = "docomo";
    private static final String SHIFT_JIS = "SHIFT_JIS";
    private static final String UTF_8 = "UTF-8";
    public static final String VCARD_TEST_AUTHORITY = "com.android.unit_tests.vcard";
    public static final Uri VCARD_TEST_AUTHORITY_URI = Uri.parse("content://com.android.unit_tests.vcard");
    public static final Uri CONTACTS_TEST_CONTENT_URI = Uri.withAppendedPath(VCARD_TEST_AUTHORITY_URI, "contacts");
    private static final Map<Integer, String> sImMap = new HashMap<Integer, String>();
    private final Context mContext;
    private final int mVCardType;
    private final boolean mCareHandlerErrors;
    private final ContentResolver mContentResolver;
    private final boolean mIsDoCoMo;
    private Cursor mCursor;
    private int mIdColumn;
    private final String mCharset;
    private boolean mTerminateIsCalled;
    private final List<OneEntryHandler> mHandlerList;
    private String mErrorReason = "No error";
    private static final String[] sContactsProjection;

    public VCardComposer(Context context) {
        this(context, VCardConfig.VCARD_TYPE_DEFAULT, null, true);
    }

    public VCardComposer(Context context, int vcardType) {
        this(context, vcardType, null, true);
    }

    public VCardComposer(Context context, int vcardType, String charset) {
        this(context, vcardType, charset, true);
    }

    public VCardComposer(Context context, int vcardType, boolean careHandlerErrors) {
        this(context, vcardType, null, careHandlerErrors);
    }

    public VCardComposer(Context context, int vcardType, String charset, boolean careHandlerErrors) {
        boolean shouldAppendCharsetParam;
        this.mContext = context;
        this.mVCardType = vcardType;
        this.mCareHandlerErrors = careHandlerErrors;
        this.mContentResolver = context.getContentResolver();
        this.mIsDoCoMo = VCardConfig.isDoCoMo(vcardType);
        this.mHandlerList = new ArrayList<OneEntryHandler>();
        charset = TextUtils.isEmpty(charset) ? UTF_8 : charset;
        boolean bl = shouldAppendCharsetParam = !VCardConfig.isVersion30(vcardType) || !UTF_8.equalsIgnoreCase(charset);
        if (this.mIsDoCoMo || shouldAppendCharsetParam) {
            if (SHIFT_JIS.equalsIgnoreCase(charset)) {
                if (this.mIsDoCoMo) {
                    try {
                        charset = CharsetUtils.charsetForVendor(SHIFT_JIS, VCARD_TYPE_STRING_DOCOMO).name();
                    }
                    catch (UnsupportedCharsetException e) {
                        Log.e(LOG_TAG, "DoCoMo-specific SHIFT_JIS was not found. Use SHIFT_JIS as is.");
                        charset = SHIFT_JIS;
                    }
                } else {
                    try {
                        charset = CharsetUtils.charsetForVendor(SHIFT_JIS).name();
                    }
                    catch (UnsupportedCharsetException e) {
                        Log.e(LOG_TAG, "Career-specific SHIFT_JIS was not found. Use SHIFT_JIS as is.");
                        charset = SHIFT_JIS;
                    }
                }
                this.mCharset = charset;
            } else {
                Log.w(LOG_TAG, "The charset \"" + charset + "\" is used while " + SHIFT_JIS + " is needed to be used.");
                if (TextUtils.isEmpty(charset)) {
                    this.mCharset = SHIFT_JIS;
                } else {
                    try {
                        charset = CharsetUtils.charsetForVendor(charset).name();
                    }
                    catch (UnsupportedCharsetException e) {
                        Log.i(LOG_TAG, "Career-specific \"" + charset + "\" was not found (as usual). " + "Use it as is.");
                    }
                    this.mCharset = charset;
                }
            }
        } else if (TextUtils.isEmpty(charset)) {
            this.mCharset = UTF_8;
        } else {
            try {
                charset = CharsetUtils.charsetForVendor(charset).name();
            }
            catch (UnsupportedCharsetException e) {
                Log.i(LOG_TAG, "Career-specific \"" + charset + "\" was not found (as usual). " + "Use it as is.");
            }
            this.mCharset = charset;
        }
        Log.d(LOG_TAG, "Use the charset \"" + this.mCharset + "\"");
    }

    public void addHandler(OneEntryHandler handler) {
        if (handler != null) {
            this.mHandlerList.add(handler);
        }
    }

    public boolean init() {
        return this.init(null, null);
    }

    public boolean init(String selection, String[] selectionArgs) {
        return this.init(ContactsContract.Contacts.CONTENT_URI, selection, selectionArgs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(Uri contentUri, String selection, String[] selectionArgs, String sortOrder) {
        if (contentUri == null) {
            return false;
        }
        if (this.mCareHandlerErrors) {
            ArrayList finishedList = new ArrayList(this.mHandlerList.size());
            for (OneEntryHandler handler : this.mHandlerList) {
                if (handler.onInit(this.mContext)) continue;
                for (OneEntryHandler finished : finishedList) {
                    finished.onTerminate();
                }
                return false;
            }
        } else {
            for (OneEntryHandler handler : this.mHandlerList) {
                handler.onInit(this.mContext);
            }
        }
        if (!ContactsContract.Contacts.CONTENT_URI.equals(contentUri) && !CONTACTS_TEST_CONTENT_URI.equals(contentUri)) {
            this.mErrorReason = FAILURE_REASON_UNSUPPORTED_URI;
            return false;
        }
        String[] projection = sContactsProjection;
        this.mCursor = this.mContentResolver.query(contentUri, projection, selection, selectionArgs, sortOrder);
        if (this.mCursor == null) {
            this.mErrorReason = FAILURE_REASON_FAILED_TO_GET_DATABASE_INFO;
            return false;
        }
        if (this.getCount() == 0 || !this.mCursor.moveToFirst()) {
            try {
                this.mCursor.close();
            }
            catch (SQLiteException e) {
                Log.e(LOG_TAG, "SQLiteException on Cursor#close(): " + e.getMessage());
            }
            finally {
                this.mCursor = null;
                this.mErrorReason = FAILURE_REASON_NO_ENTRY;
            }
            return false;
        }
        this.mIdColumn = this.mCursor.getColumnIndex("_id");
        return true;
    }

    public boolean createOneEntry() {
        return this.createOneEntry(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createOneEntry(Method getEntityIteratorMethod) {
        String vcard;
        block13: {
            if (this.mCursor == null || this.mCursor.isAfterLast()) {
                this.mErrorReason = FAILURE_REASON_NOT_INITIALIZED;
                return false;
            }
            try {
                if (this.mIdColumn >= 0) {
                    vcard = this.createOneEntryInternal(this.mCursor.getString(this.mIdColumn), getEntityIteratorMethod);
                    break block13;
                }
                Log.e(LOG_TAG, "Incorrect mIdColumn: " + this.mIdColumn);
                boolean bl = true;
                return bl;
            }
            catch (VCardException e) {
                Log.e(LOG_TAG, "VCardException has been thrown: " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            catch (OutOfMemoryError error) {
                Log.e(LOG_TAG, "OutOfMemoryError occured. Ignore the entry.");
                System.gc();
                boolean bl = true;
                return bl;
            }
            finally {
                this.mCursor.moveToNext();
            }
        }
        if (this.mCareHandlerErrors) {
            ArrayList finishedList = new ArrayList(this.mHandlerList.size());
            for (OneEntryHandler handler : this.mHandlerList) {
                if (handler.onEntryCreated(vcard)) continue;
                return false;
            }
        } else {
            for (OneEntryHandler handler : this.mHandlerList) {
                handler.onEntryCreated(vcard);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createOneEntryInternal(String contactId, Method getEntityIteratorMethod) throws VCardException {
        HashMap<String, List<ContentValues>> contentValuesListMap = new HashMap<String, List<ContentValues>>();
        EntityIterator entityIterator = null;
        try {
            String e4;
            Uri uri = ContactsContract.RawContactsEntity.CONTENT_URI.buildUpon().appendQueryParameter("for_export_only", "1").build();
            String selection = "contact_id=?";
            String[] selectionArgs = new String[]{contactId};
            if (getEntityIteratorMethod != null) {
                try {
                    entityIterator = (EntityIterator)getEntityIteratorMethod.invoke(null, this.mContentResolver, uri, "contact_id=?", selectionArgs, null);
                }
                catch (IllegalArgumentException e2) {
                    Log.e(LOG_TAG, "IllegalArgumentException has been thrown: " + e2.getMessage());
                }
                catch (IllegalAccessException e3) {
                    Log.e(LOG_TAG, "IllegalAccessException has been thrown: " + e3.getMessage());
                }
                catch (InvocationTargetException e4) {
                    StackTraceElement[] stackTraceElements;
                    Log.e(LOG_TAG, "InvocationTargetException has been thrown: ");
                    for (StackTraceElement element : stackTraceElements = e4.getCause().getStackTrace()) {
                        Log.e(LOG_TAG, "    at " + element.toString());
                    }
                    throw new VCardException("InvocationTargetException has been thrown: " + e4.getCause().getMessage());
                }
            } else {
                entityIterator = ContactsContract.RawContacts.newEntityIterator(this.mContentResolver.query(uri, null, "contact_id=?", selectionArgs, null));
            }
            if (entityIterator == null) {
                Log.e(LOG_TAG, "EntityIterator is null");
                e4 = "";
                return e4;
            }
            if (!entityIterator.hasNext()) {
                Log.w(LOG_TAG, "Data does not exist. contactId: " + contactId);
                e4 = "";
                return e4;
            }
            while (entityIterator.hasNext()) {
                Entity entity = (Entity)entityIterator.next();
                for (Entity.NamedContentValues namedContentValues : entity.getSubValues()) {
                    ContentValues contentValues = namedContentValues.values;
                    String key = contentValues.getAsString("mimetype");
                    if (key == null) continue;
                    ArrayList<ContentValues> contentValuesList = (ArrayList<ContentValues>)contentValuesListMap.get(key);
                    if (contentValuesList == null) {
                        contentValuesList = new ArrayList<ContentValues>();
                        contentValuesListMap.put(key, contentValuesList);
                    }
                    contentValuesList.add(contentValues);
                }
            }
        }
        finally {
            if (entityIterator != null) {
                entityIterator.close();
            }
        }
        return this.buildVCard(contentValuesListMap);
    }

    public String buildVCard(Map<String, List<ContentValues>> contentValuesListMap) {
        if (contentValuesListMap == null) {
            Log.e(LOG_TAG, "The given map is null. Ignore and return empty String");
            return "";
        }
        VCardBuilder builder = new VCardBuilder(this.mVCardType, this.mCharset);
        builder.appendNameProperties(contentValuesListMap.get("vnd.android.cursor.item/name")).appendNickNames(contentValuesListMap.get("vnd.android.cursor.item/nickname")).appendPhones(contentValuesListMap.get("vnd.android.cursor.item/phone_v2")).appendEmails(contentValuesListMap.get("vnd.android.cursor.item/email_v2")).appendPostals(contentValuesListMap.get("vnd.android.cursor.item/postal-address_v2")).appendOrganizations(contentValuesListMap.get("vnd.android.cursor.item/organization")).appendWebsites(contentValuesListMap.get("vnd.android.cursor.item/website"));
        if ((this.mVCardType & 0x800000) == 0) {
            builder.appendPhotos(contentValuesListMap.get("vnd.android.cursor.item/photo"));
        }
        builder.appendNotes(contentValuesListMap.get("vnd.android.cursor.item/note")).appendEvents(contentValuesListMap.get("vnd.android.cursor.item/contact_event")).appendIms(contentValuesListMap.get("vnd.android.cursor.item/im")).appendRelation(contentValuesListMap.get("vnd.android.cursor.item/relation"));
        return builder.toString();
    }

    public void terminate() {
        for (OneEntryHandler handler : this.mHandlerList) {
            handler.onTerminate();
        }
        if (this.mCursor != null) {
            try {
                this.mCursor.close();
            }
            catch (SQLiteException e) {
                Log.e(LOG_TAG, "SQLiteException on Cursor#close(): " + e.getMessage());
            }
            this.mCursor = null;
        }
        this.mTerminateIsCalled = true;
    }

    public void finalize() {
        if (!this.mTerminateIsCalled) {
            Log.w(LOG_TAG, "terminate() is not called yet. We call it in finalize() step.");
            this.terminate();
        }
    }

    public int getCount() {
        if (this.mCursor == null) {
            Log.w(LOG_TAG, "This object is not ready yet.");
            return 0;
        }
        return this.mCursor.getCount();
    }

    public boolean isAfterLast() {
        if (this.mCursor == null) {
            Log.w(LOG_TAG, "This object is not ready yet.");
            return false;
        }
        return this.mCursor.isAfterLast();
    }

    public String getErrorReason() {
        return this.mErrorReason;
    }

    static {
        sImMap.put(0, "X-AIM");
        sImMap.put(1, "X-MSN");
        sImMap.put(2, "X-YAHOO");
        sImMap.put(6, "X-ICQ");
        sImMap.put(7, "X-JABBER");
        sImMap.put(3, "X-SKYPE-USERNAME");
        sContactsProjection = new String[]{"_id"};
    }

    public final class HandlerForOutputStream
    implements OneEntryHandler {
        private static final String LOG_TAG = "VCardComposer.HandlerForOutputStream";
        private boolean mOnTerminateIsCalled = false;
        private final OutputStream mOutputStream;
        private Writer mWriter;

        public HandlerForOutputStream(OutputStream outputStream) {
            this.mOutputStream = outputStream;
        }

        public boolean onInit(Context context) {
            try {
                this.mWriter = new BufferedWriter(new OutputStreamWriter(this.mOutputStream, VCardComposer.this.mCharset));
            }
            catch (UnsupportedEncodingException e1) {
                Log.e(LOG_TAG, "Unsupported charset: " + VCardComposer.this.mCharset);
                VCardComposer.this.mErrorReason = "Encoding is not supported (usually this does not happen!): " + VCardComposer.this.mCharset;
                return false;
            }
            if (VCardComposer.this.mIsDoCoMo) {
                try {
                    this.mWriter.write(VCardComposer.this.createOneEntryInternal("-1", null));
                }
                catch (VCardException e) {
                    Log.e(LOG_TAG, "VCardException has been thrown during on Init(): " + e.getMessage());
                    return false;
                }
                catch (IOException e) {
                    Log.e(LOG_TAG, "IOException occurred during exportOneContactData: " + e.getMessage());
                    VCardComposer.this.mErrorReason = "IOException occurred: " + e.getMessage();
                    return false;
                }
            }
            return true;
        }

        public boolean onEntryCreated(String vcard) {
            try {
                this.mWriter.write(vcard);
            }
            catch (IOException e) {
                Log.e(LOG_TAG, "IOException occurred during exportOneContactData: " + e.getMessage());
                VCardComposer.this.mErrorReason = "IOException occurred: " + e.getMessage();
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTerminate() {
            this.mOnTerminateIsCalled = true;
            if (this.mWriter != null) {
                try {
                    this.mWriter.flush();
                    if (this.mOutputStream != null && this.mOutputStream instanceof FileOutputStream) {
                        ((FileOutputStream)this.mOutputStream).getFD().sync();
                    }
                }
                catch (IOException e) {
                    Log.d(LOG_TAG, "IOException during closing the output stream: " + e.getMessage());
                }
                finally {
                    this.closeOutputStream();
                }
            }
        }

        public void closeOutputStream() {
            try {
                this.mWriter.close();
            }
            catch (IOException e) {
                Log.w(LOG_TAG, "IOException is thrown during close(). Ignoring.");
            }
        }

        public void finalize() {
            if (!this.mOnTerminateIsCalled) {
                this.onTerminate();
            }
        }
    }

    public static interface OneEntryHandler {
        public boolean onInit(Context var1);

        public boolean onEntryCreated(String var1);

        public void onTerminate();
    }
}

