/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.StrictMode;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Parcel {
    private static final boolean DEBUG_RECYCLE = false;
    private static final String TAG = "Parcel";
    private int mObject;
    private int mOwnObject;
    private RuntimeException mStack;
    private static final int POOL_SIZE = 6;
    private static final Parcel[] sOwnedPool = new Parcel[6];
    private static final Parcel[] sHolderPool = new Parcel[6];
    private static final int VAL_NULL = -1;
    private static final int VAL_STRING = 0;
    private static final int VAL_INTEGER = 1;
    private static final int VAL_MAP = 2;
    private static final int VAL_BUNDLE = 3;
    private static final int VAL_PARCELABLE = 4;
    private static final int VAL_SHORT = 5;
    private static final int VAL_LONG = 6;
    private static final int VAL_FLOAT = 7;
    private static final int VAL_DOUBLE = 8;
    private static final int VAL_BOOLEAN = 9;
    private static final int VAL_CHARSEQUENCE = 10;
    private static final int VAL_LIST = 11;
    private static final int VAL_SPARSEARRAY = 12;
    private static final int VAL_BYTEARRAY = 13;
    private static final int VAL_STRINGARRAY = 14;
    private static final int VAL_IBINDER = 15;
    private static final int VAL_PARCELABLEARRAY = 16;
    private static final int VAL_OBJECTARRAY = 17;
    private static final int VAL_INTARRAY = 18;
    private static final int VAL_LONGARRAY = 19;
    private static final int VAL_BYTE = 20;
    private static final int VAL_SERIALIZABLE = 21;
    private static final int VAL_SPARSEBOOLEANARRAY = 22;
    private static final int VAL_BOOLEANARRAY = 23;
    private static final int VAL_CHARSEQUENCEARRAY = 24;
    private static final int EX_SECURITY = -1;
    private static final int EX_BAD_PARCELABLE = -2;
    private static final int EX_ILLEGAL_ARGUMENT = -3;
    private static final int EX_NULL_POINTER = -4;
    private static final int EX_ILLEGAL_STATE = -5;
    private static final int EX_HAS_REPLY_HEADER = -128;
    public static final Parcelable.Creator<String> STRING_CREATOR = new Parcelable.Creator<String>(){

        @Override
        public String createFromParcel(Parcel source) {
            return source.readString();
        }

        public String[] newArray(int size) {
            return new String[size];
        }
    };
    private static final HashMap<ClassLoader, HashMap<String, Parcelable.Creator>> mCreators = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Parcel obtain() {
        Parcel[] pool;
        Parcel[] parcelArray = pool = sOwnedPool;
        synchronized (pool) {
            for (int i = 0; i < 6; ++i) {
                Parcel p = pool[i];
                if (p == null) continue;
                pool[i] = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return p;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new Parcel(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recycle() {
        Parcel[] pool;
        this.freeBuffer();
        Parcel[] parcelArray = pool = this.mOwnObject != 0 ? sOwnedPool : sHolderPool;
        synchronized (pool) {
            for (int i = 0; i < 6; ++i) {
                if (pool[i] != null) continue;
                pool[i] = this;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public final native int dataSize();

    public final native int dataAvail();

    public final native int dataPosition();

    public final native int dataCapacity();

    public final native void setDataSize(int var1);

    public final native void setDataPosition(int var1);

    public final native void setDataCapacity(int var1);

    public final native byte[] marshall();

    public final native void unmarshall(byte[] var1, int var2, int var3);

    public final native void appendFrom(Parcel var1, int var2, int var3);

    public final native boolean hasFileDescriptors();

    public final native void writeInterfaceToken(String var1);

    public final native void enforceInterface(String var1);

    public final void writeByteArray(byte[] b) {
        this.writeByteArray(b, 0, b != null ? b.length : 0);
    }

    public final void writeByteArray(byte[] b, int offset, int len) {
        if (b == null) {
            this.writeInt(-1);
            return;
        }
        if (b.length < offset + len || len < 0 || offset < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.writeNative(b, offset, len);
    }

    private native void writeNative(byte[] var1, int var2, int var3);

    public final native void writeInt(int var1);

    public final native void writeLong(long var1);

    public final native void writeFloat(float var1);

    public final native void writeDouble(double var1);

    public final native void writeString(String var1);

    public final void writeCharSequence(CharSequence val) {
        TextUtils.writeToParcel(val, this, 0);
    }

    public final native void writeStrongBinder(IBinder var1);

    public final void writeStrongInterface(IInterface val) {
        this.writeStrongBinder(val == null ? null : val.asBinder());
    }

    public final native void writeFileDescriptor(FileDescriptor var1);

    public final void writeByte(byte val) {
        this.writeInt(val);
    }

    public final void writeMap(Map val) {
        this.writeMapInternal(val);
    }

    void writeMapInternal(Map<String, Object> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        Set<Map.Entry<String, Object>> entries = val.entrySet();
        this.writeInt(entries.size());
        for (Map.Entry<String, Object> e : entries) {
            this.writeValue(e.getKey());
            this.writeValue(e.getValue());
        }
    }

    public final void writeBundle(Bundle val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        val.writeToParcel(this, 0);
    }

    public final void writeList(List val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeValue(val.get(i));
        }
    }

    public final void writeArray(Object[] val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.length;
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeValue(val[i]);
        }
    }

    public final void writeSparseArray(SparseArray<Object> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeInt(val.keyAt(i));
            this.writeValue(val.valueAt(i));
        }
    }

    public final void writeSparseBooleanArray(SparseBooleanArray val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeInt(val.keyAt(i));
            this.writeByte((byte)(val.valueAt(i) ? 1 : 0));
        }
    }

    public final void writeBooleanArray(boolean[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeInt(val[i] ? 1 : 0);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public final boolean[] createBooleanArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 2) {
            boolean[] val = new boolean[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt() != 0;
            }
            return val;
        }
        return null;
    }

    public final void readBooleanArray(boolean[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt() != 0;
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public final void writeCharArray(char[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeInt(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public final char[] createCharArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 2) {
            char[] val = new char[N];
            for (int i = 0; i < N; ++i) {
                val[i] = (char)this.readInt();
            }
            return val;
        }
        return null;
    }

    public final void readCharArray(char[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = (char)this.readInt();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public final void writeIntArray(int[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeInt(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public final int[] createIntArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 2) {
            int[] val = new int[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt();
            }
            return val;
        }
        return null;
    }

    public final void readIntArray(int[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public final void writeLongArray(long[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeLong(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public final long[] createLongArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 3) {
            long[] val = new long[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readLong();
            }
            return val;
        }
        return null;
    }

    public final void readLongArray(long[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readLong();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public final void writeFloatArray(float[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeFloat(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public final float[] createFloatArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 2) {
            float[] val = new float[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readFloat();
            }
            return val;
        }
        return null;
    }

    public final void readFloatArray(float[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readFloat();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public final void writeDoubleArray(double[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeDouble(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public final double[] createDoubleArray() {
        int N = this.readInt();
        if (N >= 0 && N <= this.dataAvail() >> 3) {
            double[] val = new double[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readDouble();
            }
            return val;
        }
        return null;
    }

    public final void readDoubleArray(double[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readDouble();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public final void writeStringArray(String[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeString(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public final String[] createStringArray() {
        int N = this.readInt();
        if (N >= 0) {
            String[] val = new String[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readString();
            }
            return val;
        }
        return null;
    }

    public final void readStringArray(String[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readString();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public final void writeBinderArray(IBinder[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeStrongBinder(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public final void writeCharSequenceArray(CharSequence[] val) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeCharSequence(val[i]);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public final IBinder[] createBinderArray() {
        int N = this.readInt();
        if (N >= 0) {
            IBinder[] val = new IBinder[N];
            for (int i = 0; i < N; ++i) {
                val[i] = this.readStrongBinder();
            }
            return val;
        }
        return null;
    }

    public final void readBinderArray(IBinder[] val) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readStrongBinder();
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    public final <T extends Parcelable> void writeTypedList(List<T> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            Parcelable item = (Parcelable)val.get(i);
            if (item != null) {
                this.writeInt(1);
                item.writeToParcel(this, 0);
                continue;
            }
            this.writeInt(0);
        }
    }

    public final void writeStringList(List<String> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeString(val.get(i));
        }
    }

    public final void writeBinderList(List<IBinder> val) {
        if (val == null) {
            this.writeInt(-1);
            return;
        }
        int N = val.size();
        this.writeInt(N);
        for (int i = 0; i < N; ++i) {
            this.writeStrongBinder(val.get(i));
        }
    }

    public final <T extends Parcelable> void writeTypedArray(T[] val, int parcelableFlags) {
        if (val != null) {
            int N = val.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                T item = val[i];
                if (item != null) {
                    this.writeInt(1);
                    item.writeToParcel(this, parcelableFlags);
                    continue;
                }
                this.writeInt(0);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public final void writeValue(Object v) {
        if (v == null) {
            this.writeInt(-1);
        } else if (v instanceof String) {
            this.writeInt(0);
            this.writeString((String)v);
        } else if (v instanceof Integer) {
            this.writeInt(1);
            this.writeInt((Integer)v);
        } else if (v instanceof Map) {
            this.writeInt(2);
            this.writeMap((Map)v);
        } else if (v instanceof Bundle) {
            this.writeInt(3);
            this.writeBundle((Bundle)v);
        } else if (v instanceof Parcelable) {
            this.writeInt(4);
            this.writeParcelable((Parcelable)v, 0);
        } else if (v instanceof Short) {
            this.writeInt(5);
            this.writeInt(((Short)v).intValue());
        } else if (v instanceof Long) {
            this.writeInt(6);
            this.writeLong((Long)v);
        } else if (v instanceof Float) {
            this.writeInt(7);
            this.writeFloat(((Float)v).floatValue());
        } else if (v instanceof Double) {
            this.writeInt(8);
            this.writeDouble((Double)v);
        } else if (v instanceof Boolean) {
            this.writeInt(9);
            this.writeInt((Boolean)v != false ? 1 : 0);
        } else if (v instanceof CharSequence) {
            this.writeInt(10);
            this.writeCharSequence((CharSequence)v);
        } else if (v instanceof List) {
            this.writeInt(11);
            this.writeList((List)v);
        } else if (v instanceof SparseArray) {
            this.writeInt(12);
            this.writeSparseArray((SparseArray)v);
        } else if (v instanceof boolean[]) {
            this.writeInt(23);
            this.writeBooleanArray((boolean[])v);
        } else if (v instanceof byte[]) {
            this.writeInt(13);
            this.writeByteArray((byte[])v);
        } else if (v instanceof String[]) {
            this.writeInt(14);
            this.writeStringArray((String[])v);
        } else if (v instanceof CharSequence[]) {
            this.writeInt(24);
            this.writeCharSequenceArray((CharSequence[])v);
        } else if (v instanceof IBinder) {
            this.writeInt(15);
            this.writeStrongBinder((IBinder)v);
        } else if (v instanceof Parcelable[]) {
            this.writeInt(16);
            this.writeParcelableArray((Parcelable[])v, 0);
        } else if (v instanceof Object[]) {
            this.writeInt(17);
            this.writeArray((Object[])v);
        } else if (v instanceof int[]) {
            this.writeInt(18);
            this.writeIntArray((int[])v);
        } else if (v instanceof long[]) {
            this.writeInt(19);
            this.writeLongArray((long[])v);
        } else if (v instanceof Byte) {
            this.writeInt(20);
            this.writeInt(((Byte)v).byteValue());
        } else if (v instanceof Serializable) {
            this.writeInt(21);
            this.writeSerializable((Serializable)v);
        } else {
            throw new RuntimeException("Parcel: unable to marshal value " + v);
        }
    }

    public final void writeParcelable(Parcelable p, int parcelableFlags) {
        if (p == null) {
            this.writeString(null);
            return;
        }
        String name = p.getClass().getName();
        this.writeString(name);
        p.writeToParcel(this, parcelableFlags);
    }

    public final void writeSerializable(Serializable s) {
        if (s == null) {
            this.writeString(null);
            return;
        }
        String name = s.getClass().getName();
        this.writeString(name);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(s);
            oos.close();
            this.writeByteArray(baos.toByteArray());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Parcelable encountered IOException writing serializable object (name = " + name + ")", ioe);
        }
    }

    public final void writeException(Exception e) {
        int code = 0;
        if (e instanceof SecurityException) {
            code = -1;
        } else if (e instanceof BadParcelableException) {
            code = -2;
        } else if (e instanceof IllegalArgumentException) {
            code = -3;
        } else if (e instanceof NullPointerException) {
            code = -4;
        } else if (e instanceof IllegalStateException) {
            code = -5;
        }
        this.writeInt(code);
        StrictMode.clearGatheredViolations();
        if (code == 0) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        this.writeString(e.getMessage());
    }

    public final void writeNoException() {
        if (StrictMode.hasGatheredViolations()) {
            this.writeInt(-128);
            int sizePosition = this.dataPosition();
            this.writeInt(0);
            StrictMode.writeGatheredViolationsToParcel(this);
            int payloadPosition = this.dataPosition();
            this.setDataPosition(sizePosition);
            this.writeInt(payloadPosition - sizePosition);
            this.setDataPosition(payloadPosition);
        } else {
            this.writeInt(0);
        }
    }

    public final void readException() {
        int code = this.readExceptionCode();
        if (code != 0) {
            String msg = this.readString();
            this.readException(code, msg);
        }
    }

    public final int readExceptionCode() {
        int code = this.readInt();
        if (code == -128) {
            int headerSize = this.readInt();
            if (headerSize == 0) {
                Log.e(TAG, "Unexpected zero-sized Parcel reply header.");
            } else {
                StrictMode.readAndHandleBinderCallViolations(this);
            }
            return 0;
        }
        return code;
    }

    public final void readException(int code, String msg) {
        switch (code) {
            case -1: {
                throw new SecurityException(msg);
            }
            case -2: {
                throw new BadParcelableException(msg);
            }
            case -3: {
                throw new IllegalArgumentException(msg);
            }
            case -4: {
                throw new NullPointerException(msg);
            }
            case -5: {
                throw new IllegalStateException(msg);
            }
        }
        throw new RuntimeException("Unknown exception code: " + code + " msg " + msg);
    }

    public final native int readInt();

    public final native long readLong();

    public final native float readFloat();

    public final native double readDouble();

    public final native String readString();

    public final CharSequence readCharSequence() {
        return TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(this);
    }

    public final native IBinder readStrongBinder();

    public final ParcelFileDescriptor readFileDescriptor() {
        FileDescriptor fd = this.internalReadFileDescriptor();
        return fd != null ? new ParcelFileDescriptor(fd) : null;
    }

    private native FileDescriptor internalReadFileDescriptor();

    static native FileDescriptor openFileDescriptor(String var0, int var1) throws FileNotFoundException;

    static native void closeFileDescriptor(FileDescriptor var0) throws IOException;

    public final byte readByte() {
        return (byte)(this.readInt() & 0xFF);
    }

    public final void readMap(Map outVal, ClassLoader loader) {
        int N = this.readInt();
        this.readMapInternal(outVal, N, loader);
    }

    public final void readList(List outVal, ClassLoader loader) {
        int N = this.readInt();
        this.readListInternal(outVal, N, loader);
    }

    public final HashMap readHashMap(ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        HashMap m = new HashMap(N);
        this.readMapInternal(m, N, loader);
        return m;
    }

    public final Bundle readBundle() {
        return this.readBundle(null);
    }

    public final Bundle readBundle(ClassLoader loader) {
        int length = this.readInt();
        if (length < 0) {
            return null;
        }
        Bundle bundle = new Bundle(this, length);
        if (loader != null) {
            bundle.setClassLoader(loader);
        }
        return bundle;
    }

    public final native byte[] createByteArray();

    public final void readByteArray(byte[] val) {
        byte[] ba = this.createByteArray();
        if (ba.length != val.length) {
            throw new RuntimeException("bad array lengths");
        }
        System.arraycopy(ba, 0, val, 0, ba.length);
    }

    public final String[] readStringArray() {
        String[] array2 = null;
        int length = this.readInt();
        if (length >= 0) {
            array2 = new String[length];
            for (int i = 0; i < length; ++i) {
                array2[i] = this.readString();
            }
        }
        return array2;
    }

    public final CharSequence[] readCharSequenceArray() {
        CharSequence[] array2 = null;
        int length = this.readInt();
        if (length >= 0) {
            array2 = new CharSequence[length];
            for (int i = 0; i < length; ++i) {
                array2[i] = this.readCharSequence();
            }
        }
        return array2;
    }

    public final ArrayList readArrayList(ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        ArrayList l = new ArrayList(N);
        this.readListInternal(l, N, loader);
        return l;
    }

    public final Object[] readArray(ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        Object[] l = new Object[N];
        this.readArrayInternal(l, N, loader);
        return l;
    }

    public final SparseArray readSparseArray(ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        SparseArray sa = new SparseArray(N);
        this.readSparseArrayInternal(sa, N, loader);
        return sa;
    }

    public final SparseBooleanArray readSparseBooleanArray() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        SparseBooleanArray sa = new SparseBooleanArray(N);
        this.readSparseBooleanArrayInternal(sa, N);
        return sa;
    }

    public final <T> ArrayList<T> createTypedArrayList(Parcelable.Creator<T> c) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        ArrayList<T> l = new ArrayList<T>(N);
        while (N > 0) {
            if (this.readInt() != 0) {
                l.add(c.createFromParcel(this));
            } else {
                l.add(null);
            }
            --N;
        }
        return l;
    }

    public final <T> void readTypedList(List<T> list, Parcelable.Creator<T> c) {
        int i;
        int M = list.size();
        int N = this.readInt();
        for (i = 0; i < M && i < N; ++i) {
            if (this.readInt() != 0) {
                list.set(i, c.createFromParcel(this));
                continue;
            }
            list.set(i, null);
        }
        while (i < N) {
            if (this.readInt() != 0) {
                list.add(c.createFromParcel(this));
            } else {
                list.add(null);
            }
            ++i;
        }
        while (i < M) {
            list.remove(N);
            ++i;
        }
    }

    public final ArrayList<String> createStringArrayList() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>(N);
        while (N > 0) {
            l.add(this.readString());
            --N;
        }
        return l;
    }

    public final ArrayList<IBinder> createBinderArrayList() {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        ArrayList<IBinder> l = new ArrayList<IBinder>(N);
        while (N > 0) {
            l.add(this.readStrongBinder());
            --N;
        }
        return l;
    }

    public final void readStringList(List<String> list) {
        int i;
        int M = list.size();
        int N = this.readInt();
        for (i = 0; i < M && i < N; ++i) {
            list.set(i, this.readString());
        }
        while (i < N) {
            list.add(this.readString());
            ++i;
        }
        while (i < M) {
            list.remove(N);
            ++i;
        }
    }

    public final void readBinderList(List<IBinder> list) {
        int i;
        int M = list.size();
        int N = this.readInt();
        for (i = 0; i < M && i < N; ++i) {
            list.set(i, this.readStrongBinder());
        }
        while (i < N) {
            list.add(this.readStrongBinder());
            ++i;
        }
        while (i < M) {
            list.remove(N);
            ++i;
        }
    }

    public final <T> T[] createTypedArray(Parcelable.Creator<T> c) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        T[] l = c.newArray(N);
        for (int i = 0; i < N; ++i) {
            if (this.readInt() == 0) continue;
            l[i] = c.createFromParcel(this);
        }
        return l;
    }

    public final <T> void readTypedArray(T[] val, Parcelable.Creator<T> c) {
        int N = this.readInt();
        if (N == val.length) {
            for (int i = 0; i < N; ++i) {
                val[i] = this.readInt() != 0 ? c.createFromParcel(this) : null;
            }
        } else {
            throw new RuntimeException("bad array lengths");
        }
    }

    @Deprecated
    public final <T> T[] readTypedArray(Parcelable.Creator<T> c) {
        return this.createTypedArray(c);
    }

    public final <T extends Parcelable> void writeParcelableArray(T[] value, int parcelableFlags) {
        if (value != null) {
            int N = value.length;
            this.writeInt(N);
            for (int i = 0; i < N; ++i) {
                this.writeParcelable((Parcelable)value[i], parcelableFlags);
            }
        } else {
            this.writeInt(-1);
        }
    }

    public final Object readValue(ClassLoader loader) {
        int type = this.readInt();
        switch (type) {
            case -1: {
                return null;
            }
            case 0: {
                return this.readString();
            }
            case 1: {
                return this.readInt();
            }
            case 2: {
                return this.readHashMap(loader);
            }
            case 4: {
                return this.readParcelable(loader);
            }
            case 5: {
                return (short)this.readInt();
            }
            case 6: {
                return this.readLong();
            }
            case 7: {
                return Float.valueOf(this.readFloat());
            }
            case 8: {
                return this.readDouble();
            }
            case 9: {
                return this.readInt() == 1;
            }
            case 10: {
                return this.readCharSequence();
            }
            case 11: {
                return this.readArrayList(loader);
            }
            case 23: {
                return this.createBooleanArray();
            }
            case 13: {
                return this.createByteArray();
            }
            case 14: {
                return this.readStringArray();
            }
            case 24: {
                return this.readCharSequenceArray();
            }
            case 15: {
                return this.readStrongBinder();
            }
            case 17: {
                return this.readArray(loader);
            }
            case 18: {
                return this.createIntArray();
            }
            case 19: {
                return this.createLongArray();
            }
            case 20: {
                return this.readByte();
            }
            case 21: {
                return this.readSerializable();
            }
            case 16: {
                return this.readParcelableArray(loader);
            }
            case 12: {
                return this.readSparseArray(loader);
            }
            case 22: {
                return this.readSparseBooleanArray();
            }
            case 3: {
                return this.readBundle(loader);
            }
        }
        int off = this.dataPosition() - 4;
        throw new RuntimeException("Parcel " + this + ": Unmarshalling unknown type code " + type + " at offset " + off);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends Parcelable> T readParcelable(ClassLoader loader) {
        Parcelable.Creator creator;
        String name = this.readString();
        if (name == null) {
            return null;
        }
        HashMap<ClassLoader, HashMap<String, Parcelable.Creator>> hashMap = mCreators;
        synchronized (hashMap) {
            HashMap<String, Parcelable.Creator<Object>> map = mCreators.get(loader);
            if (map == null) {
                map = new HashMap();
                mCreators.put(loader, map);
            }
            if ((creator = map.get(name)) == null) {
                try {
                    Class<?> c = loader == null ? Class.forName(name) : Class.forName(name, true, loader);
                    Field f = c.getField("CREATOR");
                    creator = (Parcelable.Creator)f.get(null);
                }
                catch (IllegalAccessException e) {
                    Log.e(TAG, "Class not found when unmarshalling: " + name + ", e: " + e);
                    throw new BadParcelableException("IllegalAccessException when unmarshalling: " + name);
                }
                catch (ClassNotFoundException e) {
                    Log.e(TAG, "Class not found when unmarshalling: " + name + ", e: " + e);
                    throw new BadParcelableException("ClassNotFoundException when unmarshalling: " + name);
                }
                catch (ClassCastException e) {
                    throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called  CREATOR on class " + name);
                }
                catch (NoSuchFieldException e) {
                    throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called  CREATOR on class " + name);
                }
                if (creator == null) {
                    throw new BadParcelableException("Parcelable protocol requires a Parcelable.Creator object called  CREATOR on class " + name);
                }
                map.put(name, creator);
            }
        }
        return (T)((Parcelable)creator.createFromParcel(this));
    }

    public final Parcelable[] readParcelableArray(ClassLoader loader) {
        int N = this.readInt();
        if (N < 0) {
            return null;
        }
        Parcelable[] p = new Parcelable[N];
        for (int i = 0; i < N; ++i) {
            p[i] = this.readParcelable(loader);
        }
        return p;
    }

    public final Serializable readSerializable() {
        String name = this.readString();
        if (name == null) {
            return null;
        }
        byte[] serializedData = this.createByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(serializedData);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            return (Serializable)ois.readObject();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Parcelable encountered IOException reading a Serializable object (name = " + name + ")", ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Parcelable encounteredClassNotFoundException reading a Serializable object (name = " + name + ")", cnfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final Parcel obtain(int obj) {
        Parcel[] pool;
        Parcel[] parcelArray = pool = sHolderPool;
        synchronized (pool) {
            for (int i = 0; i < 6; ++i) {
                Parcel p = pool[i];
                if (p == null) continue;
                pool[i] = null;
                p.init(obj);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return p;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return new Parcel(obj);
        }
    }

    private Parcel(int obj) {
        this.init(obj);
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    private native void freeBuffer();

    private native void init(int var1);

    private native void destroy();

    void readMapInternal(Map outVal, int N, ClassLoader loader) {
        while (N > 0) {
            Object key = this.readValue(loader);
            Object value = this.readValue(loader);
            outVal.put(key, value);
            --N;
        }
    }

    private void readListInternal(List outVal, int N, ClassLoader loader) {
        while (N > 0) {
            Object value = this.readValue(loader);
            outVal.add(value);
            --N;
        }
    }

    private void readArrayInternal(Object[] outVal, int N, ClassLoader loader) {
        for (int i = 0; i < N; ++i) {
            Object value;
            outVal[i] = value = this.readValue(loader);
        }
    }

    private void readSparseArrayInternal(SparseArray outVal, int N, ClassLoader loader) {
        while (N > 0) {
            int key = this.readInt();
            Object value = this.readValue(loader);
            outVal.append(key, value);
            --N;
        }
    }

    private void readSparseBooleanArrayInternal(SparseBooleanArray outVal, int N) {
        while (N > 0) {
            int key = this.readInt();
            boolean value = this.readByte() == 1;
            outVal.append(key, value);
            --N;
        }
    }
}

