/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.Tag;
import android.nfc.tech.BasicTagTechnology;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public final class IsoDep
extends BasicTagTechnology {
    private static final String TAG = "NFC";
    public static final String EXTRA_HI_LAYER_RESP = "hiresp";
    public static final String EXTRA_HIST_BYTES = "histbytes";
    private byte[] mHiLayerResponse = null;
    private byte[] mHistBytes = null;

    public static IsoDep get(Tag tag) {
        if (!tag.hasTech(3)) {
            return null;
        }
        try {
            return new IsoDep(tag);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public IsoDep(Tag tag) throws RemoteException {
        super(tag, 3);
        Bundle extras = tag.getTechExtras(3);
        if (extras != null) {
            this.mHiLayerResponse = extras.getByteArray(EXTRA_HI_LAYER_RESP);
            this.mHistBytes = extras.getByteArray(EXTRA_HIST_BYTES);
        }
    }

    public void setTimeout(int timeout) {
        try {
            this.mTag.getTagService().setIsoDepTimeout(timeout);
        }
        catch (RemoteException e) {
            Log.e(TAG, "NFC service dead", e);
        }
    }

    public void close() throws IOException {
        try {
            this.mTag.getTagService().resetIsoDepTimeout();
        }
        catch (RemoteException e) {
            Log.e(TAG, "NFC service dead", e);
        }
        super.close();
    }

    public byte[] getHistoricalBytes() {
        return this.mHistBytes;
    }

    public byte[] getHiLayerResponse() {
        return this.mHiLayerResponse;
    }

    public byte[] transceive(byte[] data) throws IOException {
        return this.transceive(data, true);
    }
}

