/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.nfc.FormatException;
import android.nfc.NdefRecord;
import android.os.Parcel;
import android.os.Parcelable;

public final class NdefMessage
implements Parcelable {
    private static final byte FLAG_MB = -128;
    private static final byte FLAG_ME = 64;
    private final NdefRecord[] mRecords;
    public static final Parcelable.Creator<NdefMessage> CREATOR = new Parcelable.Creator<NdefMessage>(){

        @Override
        public NdefMessage createFromParcel(Parcel in) {
            int recordsLength = in.readInt();
            NdefRecord[] records = new NdefRecord[recordsLength];
            in.readTypedArray(records, NdefRecord.CREATOR);
            return new NdefMessage(records);
        }

        public NdefMessage[] newArray(int size) {
            return new NdefMessage[size];
        }
    };

    public NdefMessage(byte[] data) throws FormatException {
        this.mRecords = null;
        if (this.parseNdefMessage(data) == -1) {
            throw new FormatException("Error while parsing NDEF message");
        }
    }

    public NdefMessage(NdefRecord[] records) {
        this.mRecords = new NdefRecord[records.length];
        System.arraycopy(records, 0, this.mRecords, 0, records.length);
    }

    public NdefRecord[] getRecords() {
        return (NdefRecord[])this.mRecords.clone();
    }

    public byte[] toByteArray() {
        if (this.mRecords == null || this.mRecords.length == 0) {
            return new byte[0];
        }
        byte[] msg = new byte[]{};
        for (int i = 0; i < this.mRecords.length; ++i) {
            byte[] record = this.mRecords[i].toByteArray();
            byte[] tmp = new byte[msg.length + record.length];
            record[0] = i == 0 ? (byte)(record[0] | 0xFFFFFF80) : (byte)(record[0] & 0x7F);
            record[0] = i == this.mRecords.length - 1 ? (byte)(record[0] | 0x40) : (byte)(record[0] & 0xFFFFFFBF);
            System.arraycopy(msg, 0, tmp, 0, msg.length);
            System.arraycopy(record, 0, tmp, msg.length, record.length);
            msg = tmp;
        }
        return msg;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mRecords.length);
        dest.writeTypedArray(this.mRecords, flags);
    }

    private native int parseNdefMessage(byte[] var1);
}

