/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.DhcpInfo;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class NetworkUtils {
    public static native int enableInterface(String var0);

    public static native int disableInterface(String var0);

    public static native int addHostRoute(String var0, int var1);

    public static native int setDefaultRoute(String var0, int var1);

    public static native int getDefaultRoute(String var0);

    public static native int removeHostRoutes(String var0);

    public static native int removeDefaultRoute(String var0);

    public static native int resetConnections(String var0);

    public static native boolean runDhcp(String var0, DhcpInfo var1);

    public static native boolean stopDhcp(String var0);

    public static native boolean releaseDhcpLease(String var0);

    public static native String getDhcpError();

    public static boolean configureInterface(String interfaceName, DhcpInfo ipInfo) {
        return NetworkUtils.configureNative(interfaceName, ipInfo.ipAddress, ipInfo.netmask, ipInfo.gateway, ipInfo.dns1, ipInfo.dns2);
    }

    private static native boolean configureNative(String var0, int var1, int var2, int var3, int var4, int var5);

    public static int lookupHost(String hostname) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            return -1;
        }
        byte[] addrBytes = inetAddress.getAddress();
        int addr = (addrBytes[3] & 0xFF) << 24 | (addrBytes[2] & 0xFF) << 16 | (addrBytes[1] & 0xFF) << 8 | addrBytes[0] & 0xFF;
        return addr;
    }

    public static int v4StringToInt(String str) {
        int result = 0;
        String[] array2 = str.split("\\.");
        if (array2.length != 4) {
            return 0;
        }
        try {
            result = Integer.parseInt(array2[3]);
            result = (result << 8) + Integer.parseInt(array2[2]);
            result = (result << 8) + Integer.parseInt(array2[1]);
            result = (result << 8) + Integer.parseInt(array2[0]);
        }
        catch (NumberFormatException e) {
            return 0;
        }
        return result;
    }

    public static native boolean runDhcpRenew(String var0, DhcpInfo var1);
}

