/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;

public class InterfaceConfiguration
implements Parcelable {
    public String hwAddr;
    public int ipAddr;
    public int netmask;
    public String interfaceFlags;
    public static final Parcelable.Creator<InterfaceConfiguration> CREATOR = new Parcelable.Creator<InterfaceConfiguration>(){

        @Override
        public InterfaceConfiguration createFromParcel(Parcel in) {
            InterfaceConfiguration info = new InterfaceConfiguration();
            info.hwAddr = in.readString();
            info.ipAddr = in.readInt();
            info.netmask = in.readInt();
            info.interfaceFlags = in.readString();
            return info;
        }

        public InterfaceConfiguration[] newArray(int size) {
            return new InterfaceConfiguration[size];
        }
    };

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("ipddress ");
        InterfaceConfiguration.putAddress(str, this.ipAddr);
        str.append(" netmask ");
        InterfaceConfiguration.putAddress(str, this.netmask);
        str.append(" flags ").append(this.interfaceFlags);
        str.append(" hwaddr ").append(this.hwAddr);
        return str.toString();
    }

    private static void putAddress(StringBuffer buf, int addr) {
        buf.append(addr >> 24 & 0xFF).append('.').append(addr >> 16 & 0xFF).append('.').append(addr >> 8 & 0xFF).append('.').append(addr & 0xFF);
    }

    public boolean isActive() {
        try {
            if (this.interfaceFlags.contains("up") && this.ipAddr != 0) {
                return true;
            }
        }
        catch (NullPointerException e) {
            return false;
        }
        return false;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.hwAddr);
        dest.writeInt(this.ipAddr);
        dest.writeInt(this.netmask);
        dest.writeString(this.interfaceFlags);
    }
}

