/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.media.audiofx.AudioEffect;
import java.util.StringTokenizer;

public class Virtualizer
extends AudioEffect {
    private static final String TAG = "Virtualizer";
    public static final int PARAM_STRENGTH_SUPPORTED = 0;
    public static final int PARAM_STRENGTH = 1;
    private boolean mStrengthSupported = false;
    private OnParameterChangeListener mParamListener = null;
    private BaseParameterListener mBaseParamListener = null;
    private final Object mParamListenerLock = new Object();

    public Virtualizer(int priority, int audioSession) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        super(EFFECT_TYPE_VIRTUALIZER, EFFECT_TYPE_NULL, priority, audioSession);
        int[] value = new int[1];
        this.checkStatus(this.getParameter(0, value));
        this.mStrengthSupported = value[0] != 0;
    }

    public boolean getStrengthSupported() {
        return this.mStrengthSupported;
    }

    public void setStrength(short strength) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(1, strength));
    }

    public short getRoundedStrength() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        short[] value = new short[1];
        this.checkStatus(this.getParameter(1, value));
        return value[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterListener(OnParameterChangeListener listener) {
        Object object = this.mParamListenerLock;
        synchronized (object) {
            if (this.mParamListener == null) {
                this.mParamListener = listener;
                this.mBaseParamListener = new BaseParameterListener();
                super.setParameterListener(this.mBaseParamListener);
            }
        }
    }

    public Settings getProperties() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        Settings settings = new Settings();
        short[] value = new short[1];
        this.checkStatus(this.getParameter(1, value));
        settings.strength = value[0];
        return settings;
    }

    public void setProperties(Settings settings) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(1, settings.strength));
    }

    public static class Settings {
        public short strength;

        public Settings() {
        }

        public Settings(String settings) {
            StringTokenizer st = new StringTokenizer(settings, "=;");
            int tokens = st.countTokens();
            if (st.countTokens() != 3) {
                throw new IllegalArgumentException("settings: " + settings);
            }
            String key = st.nextToken();
            if (!key.equals(Virtualizer.TAG)) {
                throw new IllegalArgumentException("invalid settings for Virtualizer: " + key);
            }
            try {
                key = st.nextToken();
                if (!key.equals("strength")) {
                    throw new IllegalArgumentException("invalid key name: " + key);
                }
                this.strength = Short.parseShort(st.nextToken());
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("invalid value for key: " + key);
            }
        }

        public String toString() {
            String str = new String("Virtualizer;strength=" + Short.toString(this.strength));
            return str;
        }
    }

    private class BaseParameterListener
    implements AudioEffect.OnParameterChangeListener {
        private BaseParameterListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onParameterChange(AudioEffect effect, int status, byte[] param, byte[] value) {
            OnParameterChangeListener l = null;
            Object object = Virtualizer.this.mParamListenerLock;
            synchronized (object) {
                if (Virtualizer.this.mParamListener != null) {
                    l = Virtualizer.this.mParamListener;
                }
            }
            if (l != null) {
                int p = -1;
                short v = -1;
                if (param.length == 4) {
                    p = Virtualizer.this.byteArrayToInt(param, 0);
                }
                if (value.length == 2) {
                    v = Virtualizer.this.byteArrayToShort(value, 0);
                }
                if (p != -1 && v != -1) {
                    l.onParameterChange(Virtualizer.this, status, p, v);
                }
            }
        }
    }

    public static interface OnParameterChangeListener {
        public void onParameterChange(Virtualizer var1, int var2, int var3, short var4);
    }
}

