/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.DecoderCapabilities;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MediaFile {
    public static final String sFileExtensions;
    public static final int FILE_TYPE_MP3 = 1;
    public static final int FILE_TYPE_M4A = 2;
    public static final int FILE_TYPE_WAV = 3;
    public static final int FILE_TYPE_AMR = 4;
    public static final int FILE_TYPE_AWB = 5;
    public static final int FILE_TYPE_WMA = 6;
    public static final int FILE_TYPE_OGG = 7;
    public static final int FILE_TYPE_AAC = 8;
    public static final int FILE_TYPE_MKA = 9;
    private static final int FIRST_AUDIO_FILE_TYPE = 1;
    private static final int LAST_AUDIO_FILE_TYPE = 9;
    public static final int FILE_TYPE_MID = 11;
    public static final int FILE_TYPE_SMF = 12;
    public static final int FILE_TYPE_IMY = 13;
    private static final int FIRST_MIDI_FILE_TYPE = 11;
    private static final int LAST_MIDI_FILE_TYPE = 13;
    public static final int FILE_TYPE_MP4 = 21;
    public static final int FILE_TYPE_M4V = 22;
    public static final int FILE_TYPE_3GPP = 23;
    public static final int FILE_TYPE_3GPP2 = 24;
    public static final int FILE_TYPE_WMV = 25;
    public static final int FILE_TYPE_ASF = 26;
    public static final int FILE_TYPE_MKV = 27;
    public static final int FILE_TYPE_MP2TS = 28;
    private static final int FIRST_VIDEO_FILE_TYPE = 21;
    private static final int LAST_VIDEO_FILE_TYPE = 28;
    public static final int FILE_TYPE_JPEG = 31;
    public static final int FILE_TYPE_GIF = 32;
    public static final int FILE_TYPE_PNG = 33;
    public static final int FILE_TYPE_BMP = 34;
    public static final int FILE_TYPE_WBMP = 35;
    private static final int FIRST_IMAGE_FILE_TYPE = 31;
    private static final int LAST_IMAGE_FILE_TYPE = 35;
    public static final int FILE_TYPE_M3U = 41;
    public static final int FILE_TYPE_PLS = 42;
    public static final int FILE_TYPE_WPL = 43;
    private static final int FIRST_PLAYLIST_FILE_TYPE = 41;
    private static final int LAST_PLAYLIST_FILE_TYPE = 43;
    private static HashMap<String, MediaFileType> sFileTypeMap;
    private static HashMap<String, Integer> sMimeTypeMap;

    static void addFileType(String extension, int fileType, String mimeType) {
        sFileTypeMap.put(extension, new MediaFileType(fileType, mimeType));
        sMimeTypeMap.put(mimeType, fileType);
    }

    private static boolean isWMAEnabled() {
        List<DecoderCapabilities.AudioDecoder> decoders = DecoderCapabilities.getAudioDecoders();
        for (DecoderCapabilities.AudioDecoder decoder : decoders) {
            if (decoder != DecoderCapabilities.AudioDecoder.AUDIO_DECODER_WMA) continue;
            return true;
        }
        return false;
    }

    private static boolean isWMVEnabled() {
        List<DecoderCapabilities.VideoDecoder> decoders = DecoderCapabilities.getVideoDecoders();
        for (DecoderCapabilities.VideoDecoder decoder : decoders) {
            if (decoder != DecoderCapabilities.VideoDecoder.VIDEO_DECODER_WMV) continue;
            return true;
        }
        return false;
    }

    public static boolean isAudioFileType(int fileType) {
        return fileType >= 1 && fileType <= 9 || fileType >= 11 && fileType <= 13;
    }

    public static boolean isVideoFileType(int fileType) {
        return fileType >= 21 && fileType <= 28;
    }

    public static boolean isImageFileType(int fileType) {
        return fileType >= 31 && fileType <= 35;
    }

    public static boolean isPlayListFileType(int fileType) {
        return fileType >= 41 && fileType <= 43;
    }

    public static MediaFileType getFileType(String path) {
        int lastDot = path.lastIndexOf(".");
        if (lastDot < 0) {
            return null;
        }
        return sFileTypeMap.get(path.substring(lastDot + 1).toUpperCase());
    }

    public static int getFileTypeForMimeType(String mimeType) {
        Integer value = sMimeTypeMap.get(mimeType);
        return value == null ? 0 : value;
    }

    static {
        sFileTypeMap = new HashMap();
        sMimeTypeMap = new HashMap();
        MediaFile.addFileType("MP3", 1, "audio/mpeg");
        MediaFile.addFileType("M4A", 2, "audio/mp4");
        MediaFile.addFileType("WAV", 3, "audio/x-wav");
        MediaFile.addFileType("AMR", 4, "audio/amr");
        MediaFile.addFileType("AWB", 5, "audio/amr-wb");
        if (MediaFile.isWMAEnabled()) {
            MediaFile.addFileType("WMA", 6, "audio/x-ms-wma");
        }
        MediaFile.addFileType("OGG", 7, "application/ogg");
        MediaFile.addFileType("OGA", 7, "application/ogg");
        MediaFile.addFileType("AAC", 8, "audio/aac");
        MediaFile.addFileType("MKA", 9, "audio/x-matroska");
        MediaFile.addFileType("MID", 11, "audio/midi");
        MediaFile.addFileType("MIDI", 11, "audio/midi");
        MediaFile.addFileType("XMF", 11, "audio/midi");
        MediaFile.addFileType("RTTTL", 11, "audio/midi");
        MediaFile.addFileType("SMF", 12, "audio/sp-midi");
        MediaFile.addFileType("IMY", 13, "audio/imelody");
        MediaFile.addFileType("RTX", 11, "audio/midi");
        MediaFile.addFileType("OTA", 11, "audio/midi");
        MediaFile.addFileType("MPEG", 21, "video/mpeg");
        MediaFile.addFileType("MP4", 21, "video/mp4");
        MediaFile.addFileType("M4V", 22, "video/mp4");
        MediaFile.addFileType("3GP", 23, "video/3gpp");
        MediaFile.addFileType("3GPP", 23, "video/3gpp");
        MediaFile.addFileType("3G2", 24, "video/3gpp2");
        MediaFile.addFileType("3GPP2", 24, "video/3gpp2");
        MediaFile.addFileType("MKV", 27, "video/x-matroska");
        MediaFile.addFileType("WEBM", 27, "video/x-matroska");
        MediaFile.addFileType("TS", 28, "video/mp2ts");
        if (MediaFile.isWMVEnabled()) {
            MediaFile.addFileType("WMV", 25, "video/x-ms-wmv");
            MediaFile.addFileType("ASF", 26, "video/x-ms-asf");
        }
        MediaFile.addFileType("JPG", 31, "image/jpeg");
        MediaFile.addFileType("JPEG", 31, "image/jpeg");
        MediaFile.addFileType("GIF", 32, "image/gif");
        MediaFile.addFileType("PNG", 33, "image/png");
        MediaFile.addFileType("BMP", 34, "image/x-ms-bmp");
        MediaFile.addFileType("WBMP", 35, "image/vnd.wap.wbmp");
        MediaFile.addFileType("M3U", 41, "audio/x-mpegurl");
        MediaFile.addFileType("PLS", 42, "audio/x-scpls");
        MediaFile.addFileType("WPL", 43, "application/vnd.ms-wpl");
        StringBuilder builder = new StringBuilder();
        Iterator<String> iterator = sFileTypeMap.keySet().iterator();
        while (iterator.hasNext()) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(iterator.next());
        }
        sFileExtensions = builder.toString();
    }

    static class MediaFileType {
        int fileType;
        String mimeType;

        MediaFileType(int fileType, String mimeType) {
            this.fileType = fileType;
            this.mimeType = mimeType;
        }
    }
}

