/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.InputMethodSession;
import com.android.internal.os.HandlerCaller;
import com.android.internal.view.IInputMethodCallback;
import com.android.internal.view.IInputMethodSession;

class IInputMethodSessionWrapper
extends IInputMethodSession.Stub
implements HandlerCaller.Callback {
    private static final String TAG = "InputMethodWrapper";
    private static final boolean DEBUG = false;
    private static final int DO_FINISH_INPUT = 60;
    private static final int DO_DISPLAY_COMPLETIONS = 65;
    private static final int DO_UPDATE_EXTRACTED_TEXT = 67;
    private static final int DO_DISPATCH_KEY_EVENT = 70;
    private static final int DO_DISPATCH_TRACKBALL_EVENT = 80;
    private static final int DO_UPDATE_SELECTION = 90;
    private static final int DO_UPDATE_CURSOR = 95;
    private static final int DO_APP_PRIVATE_COMMAND = 100;
    private static final int DO_TOGGLE_SOFT_INPUT = 105;
    private static final int DO_FINISH_SESSION = 110;
    HandlerCaller mCaller;
    InputMethodSession mInputMethodSession;

    public IInputMethodSessionWrapper(Context context, InputMethodSession inputMethodSession) {
        this.mCaller = new HandlerCaller(context, this);
        this.mInputMethodSession = inputMethodSession;
    }

    public InputMethodSession getInternalInputMethodSession() {
        return this.mInputMethodSession;
    }

    public void executeMessage(Message msg) {
        switch (msg.what) {
            case 60: {
                this.mInputMethodSession.finishInput();
                return;
            }
            case 65: {
                this.mInputMethodSession.displayCompletions((CompletionInfo[])msg.obj);
                return;
            }
            case 67: {
                this.mInputMethodSession.updateExtractedText(msg.arg1, (ExtractedText)msg.obj);
                return;
            }
            case 70: {
                HandlerCaller.SomeArgs args = (HandlerCaller.SomeArgs)msg.obj;
                this.mInputMethodSession.dispatchKeyEvent(msg.arg1, (KeyEvent)args.arg1, new InputMethodEventCallbackWrapper((IInputMethodCallback)args.arg2));
                this.mCaller.recycleArgs(args);
                return;
            }
            case 80: {
                HandlerCaller.SomeArgs args = (HandlerCaller.SomeArgs)msg.obj;
                this.mInputMethodSession.dispatchTrackballEvent(msg.arg1, (MotionEvent)args.arg1, new InputMethodEventCallbackWrapper((IInputMethodCallback)args.arg2));
                this.mCaller.recycleArgs(args);
                return;
            }
            case 90: {
                HandlerCaller.SomeArgs args = (HandlerCaller.SomeArgs)msg.obj;
                this.mInputMethodSession.updateSelection(args.argi1, args.argi2, args.argi3, args.argi4, args.argi5, args.argi6);
                this.mCaller.recycleArgs(args);
                return;
            }
            case 95: {
                this.mInputMethodSession.updateCursor((Rect)msg.obj);
                return;
            }
            case 100: {
                HandlerCaller.SomeArgs args = (HandlerCaller.SomeArgs)msg.obj;
                this.mInputMethodSession.appPrivateCommand((String)args.arg1, (Bundle)args.arg2);
                this.mCaller.recycleArgs(args);
                return;
            }
            case 105: {
                this.mInputMethodSession.toggleSoftInput(msg.arg1, msg.arg2);
                return;
            }
            case 110: {
                this.mInputMethodSession = null;
                return;
            }
        }
        Log.w(TAG, "Unhandled message code: " + msg.what);
    }

    public void finishInput() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(60));
    }

    public void displayCompletions(CompletionInfo[] completions) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(65, completions));
    }

    public void updateExtractedText(int token, ExtractedText text) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIO(67, token, text));
    }

    public void dispatchKeyEvent(int seq, KeyEvent event, IInputMethodCallback callback) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIOO(70, seq, event, callback));
    }

    public void dispatchTrackballEvent(int seq, MotionEvent event, IInputMethodCallback callback) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIOO(80, seq, event, callback));
    }

    public void updateSelection(int oldSelStart, int oldSelEnd, int newSelStart, int newSelEnd, int candidatesStart, int candidatesEnd) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIIIIII(90, oldSelStart, oldSelEnd, newSelStart, newSelEnd, candidatesStart, candidatesEnd));
    }

    public void updateCursor(Rect newCursor) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(95, newCursor));
    }

    public void appPrivateCommand(String action, Bundle data) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(100, action, data));
    }

    public void toggleSoftInput(int showFlags, int hideFlags) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageII(105, showFlags, hideFlags));
    }

    public void finishSession() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(110));
    }

    static class InputMethodEventCallbackWrapper
    implements InputMethodSession.EventCallback {
        final IInputMethodCallback mCb;

        InputMethodEventCallbackWrapper(IInputMethodCallback cb) {
            this.mCb = cb;
        }

        public void finishedEvent(int seq, boolean handled) {
            try {
                this.mCb.finishedEvent(seq, handled);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

