/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.TemporaryBuffer;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import javax.microedition.khronos.opengles.GL;

public class Canvas {
    final int mNativeCanvas;
    private Bitmap mBitmap;
    private GL mGL;
    private DrawFilter mDrawFilter;
    int mDensity = 0;
    private int mScreenDensity = 0;
    private int mSurfaceFormat;
    public static final int MATRIX_SAVE_FLAG = 1;
    public static final int CLIP_SAVE_FLAG = 2;
    public static final int HAS_ALPHA_LAYER_SAVE_FLAG = 4;
    public static final int FULL_COLOR_LAYER_SAVE_FLAG = 8;
    public static final int CLIP_TO_LAYER_SAVE_FLAG = 16;
    public static final int ALL_SAVE_FLAG = 31;

    public Canvas() {
        this.mNativeCanvas = Canvas.initRaster(0);
    }

    public Canvas(Bitmap bitmap) {
        if (!bitmap.isMutable()) {
            throw new IllegalStateException("Immutable bitmap passed to Canvas constructor");
        }
        Canvas.throwIfRecycled(bitmap);
        this.mNativeCanvas = Canvas.initRaster(bitmap.ni());
        this.mBitmap = bitmap;
        this.mDensity = bitmap.mDensity;
    }

    Canvas(int nativeCanvas) {
        if (nativeCanvas == 0) {
            throw new IllegalStateException();
        }
        this.mNativeCanvas = nativeCanvas;
        this.mDensity = Bitmap.getDefaultDensity();
    }

    public Canvas(GL gl) {
        this.mNativeCanvas = Canvas.initGL();
        this.mGL = gl;
        this.mDensity = Bitmap.getDefaultDensity();
    }

    public GL getGL() {
        return this.mGL;
    }

    public static void freeGlCaches() {
        Canvas.freeCaches();
    }

    public void setBitmap(Bitmap bitmap) {
        if (!bitmap.isMutable()) {
            throw new IllegalStateException();
        }
        if (this.mGL != null) {
            throw new RuntimeException("Can't set a bitmap device on a GL canvas");
        }
        Canvas.throwIfRecycled(bitmap);
        Canvas.native_setBitmap(this.mNativeCanvas, bitmap.ni());
        this.mBitmap = bitmap;
        this.mDensity = bitmap.mDensity;
    }

    public void setViewport(int width, int height) {
        if (this.mGL != null) {
            Canvas.nativeSetViewport(this.mNativeCanvas, width, height);
        }
    }

    public native boolean isOpaque();

    public native int getWidth();

    public native int getHeight();

    public int getDensity() {
        return this.mDensity;
    }

    public void setDensity(int density) {
        if (this.mBitmap != null) {
            this.mBitmap.setDensity(density);
        }
        this.mDensity = density;
    }

    public void setScreenDensity(int density) {
        this.mScreenDensity = density;
    }

    public native int save();

    public native int save(int var1);

    public int saveLayer(RectF bounds, Paint paint, int saveFlags) {
        return Canvas.native_saveLayer(this.mNativeCanvas, bounds, paint != null ? paint.mNativePaint : 0, saveFlags);
    }

    public int saveLayer(float left, float top, float right, float bottom, Paint paint, int saveFlags) {
        return Canvas.native_saveLayer(this.mNativeCanvas, left, top, right, bottom, paint != null ? paint.mNativePaint : 0, saveFlags);
    }

    public int saveLayerAlpha(RectF bounds, int alpha, int saveFlags) {
        alpha = Math.min(255, Math.max(0, alpha));
        return Canvas.native_saveLayerAlpha(this.mNativeCanvas, bounds, alpha, saveFlags);
    }

    public int saveLayerAlpha(float left, float top, float right, float bottom, int alpha, int saveFlags) {
        return Canvas.native_saveLayerAlpha(this.mNativeCanvas, left, top, right, bottom, alpha, saveFlags);
    }

    public native void restore();

    public native int getSaveCount();

    public native void restoreToCount(int var1);

    public native void translate(float var1, float var2);

    public native void scale(float var1, float var2);

    public final void scale(float sx, float sy, float px, float py) {
        this.translate(px, py);
        this.scale(sx, sy);
        this.translate(-px, -py);
    }

    public native void rotate(float var1);

    public final void rotate(float degrees, float px, float py) {
        this.translate(px, py);
        this.rotate(degrees);
        this.translate(-px, -py);
    }

    public native void skew(float var1, float var2);

    public void concat(Matrix matrix) {
        Canvas.native_concat(this.mNativeCanvas, matrix.native_instance);
    }

    public void setMatrix(Matrix matrix) {
        Canvas.native_setMatrix(this.mNativeCanvas, matrix == null ? 0 : matrix.native_instance);
    }

    public void getMatrix(Matrix ctm) {
        Canvas.native_getCTM(this.mNativeCanvas, ctm.native_instance);
    }

    public final Matrix getMatrix() {
        Matrix m = new Matrix();
        this.getMatrix(m);
        return m;
    }

    public boolean clipRect(RectF rect, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvas, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRect(Rect rect, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvas, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public native boolean clipRect(RectF var1);

    public native boolean clipRect(Rect var1);

    public boolean clipRect(float left, float top, float right, float bottom, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvas, left, top, right, bottom, op.nativeInt);
    }

    public native boolean clipRect(float var1, float var2, float var3, float var4);

    public native boolean clipRect(int var1, int var2, int var3, int var4);

    public boolean clipPath(Path path, Region.Op op) {
        return Canvas.native_clipPath(this.mNativeCanvas, path.ni(), op.nativeInt);
    }

    public boolean clipPath(Path path) {
        return this.clipPath(path, Region.Op.INTERSECT);
    }

    public boolean clipRegion(Region region, Region.Op op) {
        return Canvas.native_clipRegion(this.mNativeCanvas, region.ni(), op.nativeInt);
    }

    public boolean clipRegion(Region region) {
        return this.clipRegion(region, Region.Op.INTERSECT);
    }

    public DrawFilter getDrawFilter() {
        return this.mDrawFilter;
    }

    public void setDrawFilter(DrawFilter filter) {
        int nativeFilter = 0;
        if (filter != null) {
            nativeFilter = filter.mNativeInt;
        }
        this.mDrawFilter = filter;
        Canvas.nativeSetDrawFilter(this.mNativeCanvas, nativeFilter);
    }

    public boolean quickReject(RectF rect, EdgeType type) {
        return Canvas.native_quickReject(this.mNativeCanvas, rect, type.nativeInt);
    }

    public boolean quickReject(Path path, EdgeType type) {
        return Canvas.native_quickReject(this.mNativeCanvas, path.ni(), type.nativeInt);
    }

    public boolean quickReject(float left, float top, float right, float bottom, EdgeType type) {
        return Canvas.native_quickReject(this.mNativeCanvas, left, top, right, bottom, type.nativeInt);
    }

    public boolean getClipBounds(Rect bounds) {
        return Canvas.native_getClipBounds(this.mNativeCanvas, bounds);
    }

    public final Rect getClipBounds() {
        Rect r = new Rect();
        this.getClipBounds(r);
        return r;
    }

    public void drawRGB(int r, int g, int b) {
        Canvas.native_drawRGB(this.mNativeCanvas, r, g, b);
    }

    public void drawARGB(int a, int r, int g, int b) {
        Canvas.native_drawARGB(this.mNativeCanvas, a, r, g, b);
    }

    public void drawColor(int color2) {
        Canvas.native_drawColor(this.mNativeCanvas, color2);
    }

    public void drawColor(int color2, PorterDuff.Mode mode) {
        Canvas.native_drawColor(this.mNativeCanvas, color2, mode.nativeInt);
    }

    public void drawPaint(Paint paint) {
        Canvas.native_drawPaint(this.mNativeCanvas, paint.mNativePaint);
    }

    public native void drawPoints(float[] var1, int var2, int var3, Paint var4);

    public void drawPoints(float[] pts, Paint paint) {
        this.drawPoints(pts, 0, pts.length, paint);
    }

    public native void drawPoint(float var1, float var2, Paint var3);

    public void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        Canvas.native_drawLine(this.mNativeCanvas, startX, startY, stopX, stopY, paint.mNativePaint);
    }

    public native void drawLines(float[] var1, int var2, int var3, Paint var4);

    public void drawLines(float[] pts, Paint paint) {
        this.drawLines(pts, 0, pts.length, paint);
    }

    public void drawRect(RectF rect, Paint paint) {
        Canvas.native_drawRect(this.mNativeCanvas, rect, paint.mNativePaint);
    }

    public void drawRect(Rect r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    public void drawRect(float left, float top, float right, float bottom, Paint paint) {
        Canvas.native_drawRect(this.mNativeCanvas, left, top, right, bottom, paint.mNativePaint);
    }

    public void drawOval(RectF oval, Paint paint) {
        if (oval == null) {
            throw new NullPointerException();
        }
        Canvas.native_drawOval(this.mNativeCanvas, oval, paint.mNativePaint);
    }

    public void drawCircle(float cx, float cy, float radius, Paint paint) {
        Canvas.native_drawCircle(this.mNativeCanvas, cx, cy, radius, paint.mNativePaint);
    }

    public void drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        if (oval == null) {
            throw new NullPointerException();
        }
        Canvas.native_drawArc(this.mNativeCanvas, oval, startAngle, sweepAngle, useCenter, paint.mNativePaint);
    }

    public void drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        if (rect == null) {
            throw new NullPointerException();
        }
        Canvas.native_drawRoundRect(this.mNativeCanvas, rect, rx, ry, paint.mNativePaint);
    }

    public void drawPath(Path path, Paint paint) {
        Canvas.native_drawPath(this.mNativeCanvas, path.ni(), paint.mNativePaint);
    }

    private static void throwIfRecycled(Bitmap bitmap) {
        if (bitmap.isRecycled()) {
            throw new RuntimeException("Canvas: trying to use a recycled bitmap " + bitmap);
        }
    }

    public void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        Canvas.throwIfRecycled(bitmap);
        this.native_drawBitmap(this.mNativeCanvas, bitmap.ni(), left, top, paint != null ? paint.mNativePaint : 0, this.mDensity, this.mScreenDensity, bitmap.mDensity);
    }

    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        if (dst == null) {
            throw new NullPointerException();
        }
        Canvas.throwIfRecycled(bitmap);
        this.native_drawBitmap(this.mNativeCanvas, bitmap.ni(), src, dst, paint != null ? paint.mNativePaint : 0, this.mScreenDensity, bitmap.mDensity);
    }

    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        if (dst == null) {
            throw new NullPointerException();
        }
        Canvas.throwIfRecycled(bitmap);
        Canvas.native_drawBitmap(this.mNativeCanvas, bitmap.ni(), src, dst, paint != null ? paint.mNativePaint : 0, this.mScreenDensity, bitmap.mDensity);
    }

    public void drawBitmap(int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, Paint paint) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (width == 0 || height == 0) {
            return;
        }
        Canvas.native_drawBitmap(this.mNativeCanvas, colors, offset, stride, x, y, width, height, hasAlpha, paint != null ? paint.mNativePaint : 0);
    }

    public void drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        this.drawBitmap(colors, offset, stride, (float)x, (float)y, width, height, hasAlpha, paint);
    }

    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        Canvas.nativeDrawBitmapMatrix(this.mNativeCanvas, bitmap.ni(), matrix.ni(), paint != null ? paint.mNativePaint : 0);
    }

    private static void checkRange(int length, int offset, int count) {
        if ((offset | count) < 0 || offset + count > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public void drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        if ((meshWidth | meshHeight | vertOffset | colorOffset) < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (meshWidth == 0 || meshHeight == 0) {
            return;
        }
        int count = (meshWidth + 1) * (meshHeight + 1);
        Canvas.checkRange(verts.length, vertOffset, count * 2);
        if (colors != null) {
            Canvas.checkRange(colors.length, colorOffset, count);
        }
        Canvas.nativeDrawBitmapMesh(this.mNativeCanvas, bitmap.ni(), meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, paint != null ? paint.mNativePaint : 0);
    }

    public void drawVertices(VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
        Canvas.checkRange(verts.length, vertOffset, vertexCount);
        if (texs != null) {
            Canvas.checkRange(texs.length, texOffset, vertexCount);
        }
        if (colors != null) {
            Canvas.checkRange(colors.length, colorOffset, vertexCount);
        }
        if (indices != null) {
            Canvas.checkRange(indices.length, indexOffset, indexCount);
        }
        Canvas.nativeDrawVertices(this.mNativeCanvas, mode.nativeInt, vertexCount, verts, vertOffset, texs, texOffset, colors, colorOffset, indices, indexOffset, indexCount, paint.mNativePaint);
    }

    public void drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        if ((index | count | index + count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Canvas.native_drawText(this.mNativeCanvas, text, index, count, x, y, paint.mNativePaint);
    }

    public native void drawText(String var1, float var2, float var3, Paint var4);

    public void drawText(String text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Canvas.native_drawText(this.mNativeCanvas, text, start, end, x, y, paint.mNativePaint);
    }

    public void drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            Canvas.native_drawText(this.mNativeCanvas, ((Object)text).toString(), start, end, x, y, paint.mNativePaint);
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawText(this, start, end, x, y, paint);
        } else {
            char[] buf = TemporaryBuffer.obtain(end - start);
            TextUtils.getChars(text, start, end, buf, 0);
            this.drawText(buf, 0, end - start, x, y, paint);
            TemporaryBuffer.recycle(buf);
        }
    }

    public void drawPosText(char[] text, int index, int count, float[] pos, Paint paint) {
        if (index < 0 || index + count > text.length || count * 2 > pos.length) {
            throw new IndexOutOfBoundsException();
        }
        Canvas.native_drawPosText(this.mNativeCanvas, text, index, count, pos, paint.mNativePaint);
    }

    public void drawPosText(String text, float[] pos, Paint paint) {
        if (text.length() * 2 > pos.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Canvas.native_drawPosText(this.mNativeCanvas, text, pos, paint.mNativePaint);
    }

    public void drawTextOnPath(char[] text, int index, int count, Path path, float hOffset, float vOffset, Paint paint) {
        if (index < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Canvas.native_drawTextOnPath(this.mNativeCanvas, text, index, count, path.ni(), hOffset, vOffset, paint.mNativePaint);
    }

    public void drawTextOnPath(String text, Path path, float hOffset, float vOffset, Paint paint) {
        if (text.length() > 0) {
            Canvas.native_drawTextOnPath(this.mNativeCanvas, text, path.ni(), hOffset, vOffset, paint.mNativePaint);
        }
    }

    public void drawPicture(Picture picture) {
        picture.endRecording();
        Canvas.native_drawPicture(this.mNativeCanvas, picture.ni());
    }

    public void drawPicture(Picture picture, RectF dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale(dst.width() / (float)picture.getWidth(), dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void drawPicture(Picture picture, Rect dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale((float)dst.width() / (float)picture.getWidth(), (float)dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mNativeCanvas != 0) {
            Canvas.finalizer(this.mNativeCanvas);
        }
    }

    public static native void freeCaches();

    private static native int initRaster(int var0);

    private static native int initGL();

    private static native void native_setBitmap(int var0, int var1);

    private static native void nativeSetViewport(int var0, int var1, int var2);

    private static native int native_saveLayer(int var0, RectF var1, int var2, int var3);

    private static native int native_saveLayer(int var0, float var1, float var2, float var3, float var4, int var5, int var6);

    private static native int native_saveLayerAlpha(int var0, RectF var1, int var2, int var3);

    private static native int native_saveLayerAlpha(int var0, float var1, float var2, float var3, float var4, int var5, int var6);

    private static native void native_concat(int var0, int var1);

    private static native void native_setMatrix(int var0, int var1);

    private static native boolean native_clipRect(int var0, float var1, float var2, float var3, float var4, int var5);

    private static native boolean native_clipPath(int var0, int var1, int var2);

    private static native boolean native_clipRegion(int var0, int var1, int var2);

    private static native void nativeSetDrawFilter(int var0, int var1);

    private static native boolean native_getClipBounds(int var0, Rect var1);

    private static native void native_getCTM(int var0, int var1);

    private static native boolean native_quickReject(int var0, RectF var1, int var2);

    private static native boolean native_quickReject(int var0, int var1, int var2);

    private static native boolean native_quickReject(int var0, float var1, float var2, float var3, float var4, int var5);

    private static native void native_drawRGB(int var0, int var1, int var2, int var3);

    private static native void native_drawARGB(int var0, int var1, int var2, int var3, int var4);

    private static native void native_drawColor(int var0, int var1);

    private static native void native_drawColor(int var0, int var1, int var2);

    private static native void native_drawPaint(int var0, int var1);

    private static native void native_drawLine(int var0, float var1, float var2, float var3, float var4, int var5);

    private static native void native_drawRect(int var0, RectF var1, int var2);

    private static native void native_drawRect(int var0, float var1, float var2, float var3, float var4, int var5);

    private static native void native_drawOval(int var0, RectF var1, int var2);

    private static native void native_drawCircle(int var0, float var1, float var2, float var3, int var4);

    private static native void native_drawArc(int var0, RectF var1, float var2, float var3, boolean var4, int var5);

    private static native void native_drawRoundRect(int var0, RectF var1, float var2, float var3, int var4);

    private static native void native_drawPath(int var0, int var1, int var2);

    private native void native_drawBitmap(int var1, int var2, float var3, float var4, int var5, int var6, int var7, int var8);

    private native void native_drawBitmap(int var1, int var2, Rect var3, RectF var4, int var5, int var6, int var7);

    private static native void native_drawBitmap(int var0, int var1, Rect var2, Rect var3, int var4, int var5, int var6);

    private static native void native_drawBitmap(int var0, int[] var1, int var2, int var3, float var4, float var5, int var6, int var7, boolean var8, int var9);

    private static native void nativeDrawBitmapMatrix(int var0, int var1, int var2, int var3);

    private static native void nativeDrawBitmapMesh(int var0, int var1, int var2, int var3, float[] var4, int var5, int[] var6, int var7, int var8);

    private static native void nativeDrawVertices(int var0, int var1, int var2, float[] var3, int var4, float[] var5, int var6, int[] var7, int var8, short[] var9, int var10, int var11, int var12);

    private static native void native_drawText(int var0, char[] var1, int var2, int var3, float var4, float var5, int var6);

    private static native void native_drawText(int var0, String var1, int var2, int var3, float var4, float var5, int var6);

    private static native void native_drawPosText(int var0, char[] var1, int var2, int var3, float[] var4, int var5);

    private static native void native_drawPosText(int var0, String var1, float[] var2, int var3);

    private static native void native_drawTextOnPath(int var0, char[] var1, int var2, int var3, int var4, float var5, float var6, int var7);

    private static native void native_drawTextOnPath(int var0, String var1, int var2, float var3, float var4, int var5);

    private static native void native_drawPicture(int var0, int var1);

    private static native void finalizer(int var0);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VertexMode {
        TRIANGLES(0),
        TRIANGLE_STRIP(1),
        TRIANGLE_FAN(2);

        final int nativeInt;

        private VertexMode(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EdgeType {
        BW(0),
        AA(1);

        final int nativeInt;

        private EdgeType(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }
}

