/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.util.Log;

public abstract class SQLiteOpenHelper {
    private static final String TAG = SQLiteOpenHelper.class.getSimpleName();
    private final Context mContext;
    private final String mName;
    private final SQLiteDatabase.CursorFactory mFactory;
    private final int mNewVersion;
    private SQLiteDatabase mDatabase = null;
    private boolean mIsInitializing = false;

    public SQLiteOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        if (version < 1) {
            throw new IllegalArgumentException("Version must be >= 1, was " + version);
        }
        this.mContext = context;
        this.mName = name;
        this.mFactory = factory;
        this.mNewVersion = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SQLiteDatabase getWritableDatabase() {
        if (this.mDatabase != null && this.mDatabase.isOpen() && !this.mDatabase.isReadOnly()) {
            return this.mDatabase;
        }
        if (this.mIsInitializing) {
            throw new IllegalStateException("getWritableDatabase called recursively");
        }
        boolean success = false;
        SQLiteDatabase db = null;
        if (this.mDatabase != null) {
            this.mDatabase.lock();
        }
        try {
            this.mIsInitializing = true;
            db = this.mName == null ? SQLiteDatabase.create(null) : this.mContext.openOrCreateDatabase(this.mName, 0, this.mFactory);
            int version = db.getVersion();
            if (version != this.mNewVersion) {
                db.beginTransaction();
                try {
                    if (version == 0) {
                        this.onCreate(db);
                    } else {
                        if (version > this.mNewVersion) {
                            Log.wtf(TAG, "Can't downgrade read-only database from version " + version + " to " + this.mNewVersion + ": " + db.getPath());
                        }
                        this.onUpgrade(db, version, this.mNewVersion);
                    }
                    db.setVersion(this.mNewVersion);
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
            }
            this.onOpen(db);
            success = true;
            SQLiteDatabase sQLiteDatabase = db;
            return sQLiteDatabase;
        }
        finally {
            this.mIsInitializing = false;
            if (success) {
                if (this.mDatabase != null) {
                    try {
                        this.mDatabase.close();
                    }
                    catch (Exception e) {}
                    this.mDatabase.unlock();
                }
                this.mDatabase = db;
            } else {
                if (this.mDatabase != null) {
                    this.mDatabase.unlock();
                }
                if (db != null) {
                    db.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SQLiteDatabase getReadableDatabase() {
        if (this.mDatabase != null && this.mDatabase.isOpen()) {
            return this.mDatabase;
        }
        if (this.mIsInitializing) {
            throw new IllegalStateException("getReadableDatabase called recursively");
        }
        try {
            return this.getWritableDatabase();
        }
        catch (SQLiteException e) {
            if (this.mName == null) {
                throw e;
            }
            Log.e(TAG, "Couldn't open " + this.mName + " for writing (will try read-only):", e);
            SQLiteDatabase db = null;
            try {
                this.mIsInitializing = true;
                String path = this.mContext.getDatabasePath(this.mName).getPath();
                db = SQLiteDatabase.openDatabase(path, this.mFactory, 1);
                if (db.getVersion() != this.mNewVersion) {
                    throw new SQLiteException("Can't upgrade read-only database from version " + db.getVersion() + " to " + this.mNewVersion + ": " + path);
                }
                this.onOpen(db);
                Log.w(TAG, "Opened " + this.mName + " in read-only mode");
                SQLiteDatabase sQLiteDatabase = this.mDatabase = db;
                return sQLiteDatabase;
            }
            finally {
                this.mIsInitializing = false;
                if (db != null && db != this.mDatabase) {
                    db.close();
                }
            }
        }
    }

    public synchronized void close() {
        if (this.mIsInitializing) {
            throw new IllegalStateException("Closed during initialization");
        }
        if (this.mDatabase != null && this.mDatabase.isOpen()) {
            this.mDatabase.close();
            this.mDatabase = null;
        }
    }

    public abstract void onCreate(SQLiteDatabase var1);

    public abstract void onUpgrade(SQLiteDatabase var1, int var2, int var3);

    public void onOpen(SQLiteDatabase db) {
    }
}

