/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import java.util.Locale;

abstract class PluralRules {
    static final int QUANTITY_OTHER = 0;
    static final int QUANTITY_ZERO = 1;
    static final int QUANTITY_ONE = 2;
    static final int QUANTITY_TWO = 4;
    static final int QUANTITY_FEW = 8;
    static final int QUANTITY_MANY = 16;
    static final int ID_OTHER = 0x1000004;
    private static PluralRules cs;
    private static PluralRules en;

    PluralRules() {
    }

    abstract int quantityForNumber(int var1);

    final int attrForNumber(int n) {
        return PluralRules.attrForQuantity(this.quantityForNumber(n));
    }

    static final int attrForQuantity(int quantity) {
        switch (quantity) {
            case 1: {
                return 0x1000005;
            }
            case 2: {
                return 0x1000006;
            }
            case 4: {
                return 0x1000007;
            }
            case 8: {
                return 0x1000008;
            }
            case 16: {
                return 0x1000009;
            }
        }
        return 0x1000004;
    }

    static final String stringForQuantity(int quantity) {
        switch (quantity) {
            case 1: {
                return "zero";
            }
            case 2: {
                return "one";
            }
            case 4: {
                return "two";
            }
            case 8: {
                return "few";
            }
            case 16: {
                return "many";
            }
        }
        return "other";
    }

    static final PluralRules ruleForLocale(Locale locale) {
        String lang = locale.getLanguage();
        if ("cs".equals(lang)) {
            if (cs == null) {
                cs = new cs();
            }
            return cs;
        }
        if (en == null) {
            en = new en();
        }
        return en;
    }

    private static class en
    extends PluralRules {
        private en() {
        }

        int quantityForNumber(int n) {
            if (n == 1) {
                return 2;
            }
            return 0;
        }
    }

    private static class cs
    extends PluralRules {
        private cs() {
        }

        int quantityForNumber(int n) {
            if (n == 1) {
                return 2;
            }
            if (n >= 2 && n <= 4) {
                return 8;
            }
            return 0;
        }
    }
}

