/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.ObbInfo;
import java.io.File;
import java.io.IOException;

public class ObbScanner {
    private ObbScanner() {
    }

    public static ObbInfo getObbInfo(String filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("file path cannot be null");
        }
        File obbFile = new File(filePath);
        if (!obbFile.exists()) {
            throw new IllegalArgumentException("OBB file does not exist: " + filePath);
        }
        String canonicalFilePath = obbFile.getCanonicalPath();
        ObbInfo obbInfo = new ObbInfo();
        obbInfo.filename = canonicalFilePath;
        ObbScanner.getObbInfo_native(canonicalFilePath, obbInfo);
        return obbInfo;
    }

    private static native void getObbInfo_native(String var0, ObbInfo var1) throws IOException;
}

