/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Printer;
import java.text.Collator;
import java.util.Comparator;

public class ResolveInfo
implements Parcelable {
    public ActivityInfo activityInfo;
    public ServiceInfo serviceInfo;
    public IntentFilter filter;
    public int priority;
    public int preferredOrder;
    public int match;
    public int specificIndex = -1;
    public boolean isDefault;
    public int labelRes;
    public CharSequence nonLocalizedLabel;
    public int icon;
    public String resolvePackageName;
    public static final Parcelable.Creator<ResolveInfo> CREATOR = new Parcelable.Creator<ResolveInfo>(){

        @Override
        public ResolveInfo createFromParcel(Parcel source) {
            return new ResolveInfo(source);
        }

        public ResolveInfo[] newArray(int size) {
            return new ResolveInfo[size];
        }
    };

    public CharSequence loadLabel(PackageManager pm) {
        CharSequence label;
        if (this.nonLocalizedLabel != null) {
            return this.nonLocalizedLabel;
        }
        if (this.resolvePackageName != null && this.labelRes != 0 && (label = pm.getText(this.resolvePackageName, this.labelRes, null)) != null) {
            return ((Object)label).toString().trim();
        }
        ComponentInfo ci = this.activityInfo != null ? this.activityInfo : this.serviceInfo;
        ApplicationInfo ai = ci.applicationInfo;
        if (this.labelRes != 0 && (label = pm.getText(ci.packageName, this.labelRes, ai)) != null) {
            return ((Object)label).toString().trim();
        }
        CharSequence data = ci.loadLabel(pm);
        if (data != null) {
            data = ((Object)data).toString().trim();
        }
        return data;
    }

    public Drawable loadIcon(PackageManager pm) {
        Drawable dr;
        if (this.resolvePackageName != null && this.icon != 0 && (dr = pm.getDrawable(this.resolvePackageName, this.icon, null)) != null) {
            return dr;
        }
        ComponentInfo ci = this.activityInfo != null ? this.activityInfo : this.serviceInfo;
        ApplicationInfo ai = ci.applicationInfo;
        if (this.icon != 0 && (dr = pm.getDrawable(ci.packageName, this.icon, ai)) != null) {
            return dr;
        }
        return ci.loadIcon(pm);
    }

    public final int getIconResource() {
        if (this.icon != 0) {
            return this.icon;
        }
        if (this.activityInfo != null) {
            return this.activityInfo.getIconResource();
        }
        if (this.serviceInfo != null) {
            return this.serviceInfo.getIconResource();
        }
        return 0;
    }

    public void dump(Printer pw, String prefix) {
        if (this.filter != null) {
            pw.println(prefix + "Filter:");
            this.filter.dump(pw, prefix + "  ");
        }
        pw.println(prefix + "priority=" + this.priority + " preferredOrder=" + this.preferredOrder + " match=0x" + Integer.toHexString(this.match) + " specificIndex=" + this.specificIndex + " isDefault=" + this.isDefault);
        if (this.resolvePackageName != null) {
            pw.println(prefix + "resolvePackageName=" + this.resolvePackageName);
        }
        if (this.labelRes != 0 || this.nonLocalizedLabel != null || this.icon != 0) {
            pw.println(prefix + "labelRes=0x" + Integer.toHexString(this.labelRes) + " nonLocalizedLabel=" + this.nonLocalizedLabel + " icon=0x" + Integer.toHexString(this.icon));
        }
        if (this.activityInfo != null) {
            pw.println(prefix + "ActivityInfo:");
            this.activityInfo.dump(pw, prefix + "  ");
        } else if (this.serviceInfo != null) {
            pw.println(prefix + "ServiceInfo:");
            this.serviceInfo.dump(pw, prefix + "  ");
        }
    }

    public ResolveInfo() {
    }

    public String toString() {
        ComponentInfo ci = this.activityInfo != null ? this.activityInfo : this.serviceInfo;
        return "ResolveInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + ci.name + " p=" + this.priority + " o=" + this.preferredOrder + " m=0x" + Integer.toHexString(this.match) + "}";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int parcelableFlags) {
        if (this.activityInfo != null) {
            dest.writeInt(1);
            this.activityInfo.writeToParcel(dest, parcelableFlags);
        } else if (this.serviceInfo != null) {
            dest.writeInt(2);
            this.serviceInfo.writeToParcel(dest, parcelableFlags);
        } else {
            dest.writeInt(0);
        }
        if (this.filter != null) {
            dest.writeInt(1);
            this.filter.writeToParcel(dest, parcelableFlags);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.priority);
        dest.writeInt(this.preferredOrder);
        dest.writeInt(this.match);
        dest.writeInt(this.specificIndex);
        dest.writeInt(this.labelRes);
        TextUtils.writeToParcel(this.nonLocalizedLabel, dest, parcelableFlags);
        dest.writeInt(this.icon);
        dest.writeString(this.resolvePackageName);
    }

    private ResolveInfo(Parcel source) {
        switch (source.readInt()) {
            case 1: {
                this.activityInfo = ActivityInfo.CREATOR.createFromParcel(source);
                this.serviceInfo = null;
                break;
            }
            case 2: {
                this.serviceInfo = ServiceInfo.CREATOR.createFromParcel(source);
                this.activityInfo = null;
                break;
            }
            default: {
                this.activityInfo = null;
                this.serviceInfo = null;
            }
        }
        if (source.readInt() != 0) {
            this.filter = IntentFilter.CREATOR.createFromParcel(source);
        }
        this.priority = source.readInt();
        this.preferredOrder = source.readInt();
        this.match = source.readInt();
        this.specificIndex = source.readInt();
        this.labelRes = source.readInt();
        this.nonLocalizedLabel = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
        this.icon = source.readInt();
        this.resolvePackageName = source.readString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DisplayNameComparator
    implements Comparator<ResolveInfo> {
        private final Collator sCollator = Collator.getInstance();
        private PackageManager mPM;

        public DisplayNameComparator(PackageManager pm) {
            this.mPM = pm;
        }

        @Override
        public final int compare(ResolveInfo a, ResolveInfo b) {
            CharSequence sb;
            CharSequence sa = a.loadLabel(this.mPM);
            if (sa == null) {
                sa = a.activityInfo.name;
            }
            if ((sb = b.loadLabel(this.mPM)) == null) {
                sb = b.activityInfo.name;
            }
            return this.sCollator.compare(((Object)sa).toString(), ((Object)sb).toString());
        }
    }
}

