/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ISyncAdapter;
import android.content.ISyncContext;
import android.content.SyncContext;
import android.content.SyncResult;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractThreadedSyncAdapter {
    @Deprecated
    public static final int LOG_SYNC_DETAILS = 2743;
    private final Context mContext;
    private final AtomicInteger mNumSyncStarts;
    private final ISyncAdapterImpl mISyncAdapterImpl;
    private SyncThread mSyncThread;
    private final Object mSyncThreadLock = new Object();
    private final boolean mAutoInitialize;

    public AbstractThreadedSyncAdapter(Context context, boolean autoInitialize) {
        this.mContext = context;
        this.mISyncAdapterImpl = new ISyncAdapterImpl();
        this.mNumSyncStarts = new AtomicInteger(0);
        this.mSyncThread = null;
        this.mAutoInitialize = autoInitialize;
    }

    public Context getContext() {
        return this.mContext;
    }

    public final IBinder getSyncAdapterBinder() {
        return this.mISyncAdapterImpl.asBinder();
    }

    public abstract void onPerformSync(Account var1, Bundle var2, String var3, ContentProviderClient var4, SyncResult var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSyncCanceled() {
        SyncThread syncThread;
        Object object = this.mSyncThreadLock;
        synchronized (object) {
            syncThread = this.mSyncThread;
        }
        if (syncThread != null) {
            syncThread.interrupt();
        }
    }

    private class SyncThread
    extends Thread {
        private final SyncContext mSyncContext;
        private final String mAuthority;
        private final Account mAccount;
        private final Bundle mExtras;

        private SyncThread(String name, SyncContext syncContext, String authority, Account account, Bundle extras) {
            super(name);
            this.mSyncContext = syncContext;
            this.mAuthority = authority;
            this.mAccount = account;
            this.mExtras = extras;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SyncResult syncResult;
            block13: {
                Process.setThreadPriority(10);
                if (this.isCanceled()) {
                    return;
                }
                syncResult = new SyncResult();
                ContentProviderClient provider = null;
                try {
                    provider = AbstractThreadedSyncAdapter.this.mContext.getContentResolver().acquireContentProviderClient(this.mAuthority);
                    if (provider != null) {
                        AbstractThreadedSyncAdapter.this.onPerformSync(this.mAccount, this.mExtras, this.mAuthority, provider, syncResult);
                    } else {
                        syncResult.databaseError = true;
                    }
                    Object var4_3 = null;
                    if (provider == null) break block13;
                    provider.release();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (provider != null) {
                        provider.release();
                    }
                    if (!this.isCanceled()) {
                        this.mSyncContext.onFinished(syncResult);
                    }
                    Object object = AbstractThreadedSyncAdapter.this.mSyncThreadLock;
                    synchronized (object) {
                        AbstractThreadedSyncAdapter.this.mSyncThread = null;
                    }
                    throw throwable;
                }
            }
            if (!this.isCanceled()) {
                this.mSyncContext.onFinished(syncResult);
            }
            Object object = AbstractThreadedSyncAdapter.this.mSyncThreadLock;
            synchronized (object) {
                AbstractThreadedSyncAdapter.this.mSyncThread = null;
            }
        }

        private boolean isCanceled() {
            return Thread.currentThread().isInterrupted();
        }
    }

    private class ISyncAdapterImpl
    extends ISyncAdapter.Stub {
        private ISyncAdapterImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startSync(ISyncContext syncContext, String authority, Account account, Bundle extras) {
            boolean alreadyInProgress;
            SyncContext syncContextClient = new SyncContext(syncContext);
            Object object = AbstractThreadedSyncAdapter.this.mSyncThreadLock;
            synchronized (object) {
                if (AbstractThreadedSyncAdapter.this.mSyncThread == null) {
                    if (AbstractThreadedSyncAdapter.this.mAutoInitialize && extras != null && extras.getBoolean("initialize", false)) {
                        if (ContentResolver.getIsSyncable(account, authority) < 0) {
                            ContentResolver.setIsSyncable(account, authority, 1);
                        }
                        syncContextClient.onFinished(new SyncResult());
                        return;
                    }
                    AbstractThreadedSyncAdapter.this.mSyncThread = new SyncThread("SyncAdapterThread-" + AbstractThreadedSyncAdapter.this.mNumSyncStarts.incrementAndGet(), syncContextClient, authority, account, extras);
                    AbstractThreadedSyncAdapter.this.mSyncThread.start();
                    alreadyInProgress = false;
                } else {
                    alreadyInProgress = true;
                }
            }
            if (alreadyInProgress) {
                syncContextClient.onFinished(SyncResult.ALREADY_IN_PROGRESS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelSync(ISyncContext syncContext) {
            SyncThread syncThread;
            Object object = AbstractThreadedSyncAdapter.this.mSyncThreadLock;
            synchronized (object) {
                syncThread = AbstractThreadedSyncAdapter.this.mSyncThread;
            }
            if (syncThread != null && syncThread.mSyncContext.getSyncContextBinder() == syncContext.asBinder()) {
                AbstractThreadedSyncAdapter.this.onSyncCanceled();
            }
        }

        public void initialize(Account account, String authority) throws RemoteException {
            Bundle extras = new Bundle();
            extras.putBoolean("initialize", true);
            this.startSync(null, authority, account, extras);
        }
    }
}

