/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.os.Handler;
import android.os.PowerManager;
import android.util.Log;

public class ScoSocket {
    private static final String TAG = "ScoSocket";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    public static final int STATE_READY = 1;
    public static final int STATE_ACCEPT = 2;
    public static final int STATE_CONNECTING = 3;
    public static final int STATE_CONNECTED = 4;
    public static final int STATE_CLOSED = 5;
    private int mState;
    private int mNativeData;
    private Handler mHandler;
    private int mAcceptedCode;
    private int mConnectedCode;
    private int mClosedCode;
    private PowerManager.WakeLock mWakeLock;

    private static native void classInitNative();

    public ScoSocket(PowerManager pm, Handler handler, int acceptedCode, int connectedCode, int closedCode) {
        this.initNative();
        this.mState = 1;
        this.mHandler = handler;
        this.mAcceptedCode = acceptedCode;
        this.mConnectedCode = connectedCode;
        this.mClosedCode = closedCode;
        this.mWakeLock = pm.newWakeLock(1, TAG);
        this.mWakeLock.setReferenceCounted(false);
    }

    private native void initNative();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destroyNative();
            this.releaseWakeLockNow();
        }
        finally {
            super.finalize();
        }
    }

    private native void destroyNative();

    public synchronized boolean connect(String address, String name) {
        this.log("connect() " + this);
        if (this.mState != 1) {
            this.log("connect(): Bad state");
            return false;
        }
        this.acquireWakeLock();
        if (this.connectNative(address, name)) {
            this.mState = 3;
            return true;
        }
        this.mState = 5;
        this.releaseWakeLockNow();
        return false;
    }

    private native boolean connectNative(String var1, String var2);

    public synchronized boolean accept() {
        if (this.mState != 1) {
            this.log("Bad state");
            return false;
        }
        if (this.acceptNative()) {
            this.mState = 2;
            return true;
        }
        this.mState = 5;
        return false;
    }

    private native boolean acceptNative();

    public synchronized void close() {
        this.log(this + " SCO OBJECT close() mState = " + this.mState);
        this.acquireWakeLock();
        this.mState = 5;
        this.closeNative();
        this.releaseWakeLock();
    }

    private native void closeNative();

    public synchronized int getState() {
        return this.mState;
    }

    private synchronized void onConnected(int result) {
        if (this.mState != 3) {
            this.log("Strange state, closing " + this.mState + " " + this);
            return;
        }
        this.mState = result >= 0 ? 4 : 5;
        this.mHandler.obtainMessage(this.mConnectedCode, this.mState, -1, this).sendToTarget();
        this.releaseWakeLockNow();
    }

    private synchronized void onAccepted(int result) {
        if (this.mState != 2) {
            this.log("Strange state " + this);
            return;
        }
        this.mState = result >= 0 ? 4 : 5;
        this.mHandler.obtainMessage(this.mAcceptedCode, this.mState, -1, this).sendToTarget();
    }

    private synchronized void onClosed() {
        this.log("onClosed() " + this);
        if (this.mState != 5) {
            this.mState = 5;
            this.mHandler.obtainMessage(this.mClosedCode, this.mState, -1, this).sendToTarget();
            this.releaseWakeLock();
        }
    }

    private void acquireWakeLock() {
        if (!this.mWakeLock.isHeld()) {
            this.mWakeLock.acquire();
        }
    }

    private void releaseWakeLock() {
        if (this.mWakeLock.isHeld()) {
            this.mWakeLock.acquire(2000L);
        }
    }

    private void releaseWakeLockNow() {
        if (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
    }

    private void log(String msg) {
        Log.d(TAG, msg);
    }

    static {
        ScoSocket.classInitNative();
    }
}

