/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothDeviceProfileState;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Message;
import android.util.Log;
import com.android.internal.util.HierarchicalState;
import com.android.internal.util.HierarchicalStateMachine;

public class BluetoothProfileState
extends HierarchicalStateMachine {
    private static final boolean DBG = true;
    private static final String TAG = "BluetoothProfileState";
    public static final int HFP = 0;
    public static final int A2DP = 1;
    static final int TRANSITION_TO_STABLE = 100;
    private int mProfile;
    private BluetoothDevice mPendingDevice;
    private PendingCommandState mPendingCommandState = new PendingCommandState();
    private StableState mStableState = new StableState();
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if (action.equals("android.bluetooth.headset.action.STATE_CHANGED")) {
                int newState = intent.getIntExtra("android.bluetooth.headset.extra.STATE", 0);
                if (BluetoothProfileState.this.mProfile == 0 && (newState == 2 || newState == 0)) {
                    BluetoothProfileState.this.sendMessage(100);
                }
            } else if (action.equals("android.bluetooth.a2dp.action.SINK_STATE_CHANGED")) {
                int newState = intent.getIntExtra("android.bluetooth.a2dp.extra.SINK_STATE", 0);
                if (BluetoothProfileState.this.mProfile == 1 && (newState == 2 || newState == 0)) {
                    BluetoothProfileState.this.sendMessage(100);
                }
            } else if (action.equals("android.bluetooth.device.action.ACL_DISCONNECTED") && device.equals(BluetoothProfileState.this.mPendingDevice)) {
                BluetoothProfileState.this.sendMessage(100);
            }
        }
    };

    public BluetoothProfileState(Context context, int profile) {
        super("BluetoothProfileState:" + profile);
        this.mProfile = profile;
        this.addState(this.mStableState);
        this.addState(this.mPendingCommandState);
        this.setInitialState(this.mStableState);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.a2dp.action.SINK_STATE_CHANGED");
        filter.addAction("android.bluetooth.headset.action.STATE_CHANGED");
        filter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
        context.registerReceiver(this.mBroadcastReceiver, filter);
    }

    private void log(String message) {
        Log.i(TAG, "Message:" + message);
    }

    private class PendingCommandState
    extends HierarchicalState {
        private PendingCommandState() {
        }

        protected void enter() {
            BluetoothProfileState.this.log("Entering PendingCommandState State");
            this.dispatchMessage(BluetoothProfileState.this.getCurrentMessage());
        }

        protected boolean processMessage(Message msg) {
            if (msg.what == 100) {
                BluetoothProfileState.this.transitionTo(BluetoothProfileState.this.mStableState);
            } else {
                this.dispatchMessage(msg);
            }
            return true;
        }

        private void dispatchMessage(Message msg) {
            BluetoothDeviceProfileState deviceProfileMgr = (BluetoothDeviceProfileState)msg.obj;
            int cmd = msg.arg1;
            if (BluetoothProfileState.this.mPendingDevice == null || BluetoothProfileState.this.mPendingDevice.equals(deviceProfileMgr.getDevice())) {
                BluetoothProfileState.this.mPendingDevice = deviceProfileMgr.getDevice();
                deviceProfileMgr.sendMessage(cmd);
            } else {
                Message deferMsg = new Message();
                deferMsg.arg1 = cmd;
                deferMsg.obj = deviceProfileMgr;
                BluetoothProfileState.this.deferMessage(deferMsg);
            }
        }
    }

    private class StableState
    extends HierarchicalState {
        private StableState() {
        }

        protected void enter() {
            BluetoothProfileState.this.log("Entering Stable State");
            BluetoothProfileState.this.mPendingDevice = null;
        }

        protected boolean processMessage(Message msg) {
            if (msg.what != 100) {
                BluetoothProfileState.this.transitionTo(BluetoothProfileState.this.mPendingCommandState);
            }
            return true;
        }
    }
}

