/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothA2dp;
import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BluetoothA2dp {
    private static final String TAG = "BluetoothA2dp";
    private static final boolean DBG = false;
    public static final String EXTRA_SINK_STATE = "android.bluetooth.a2dp.extra.SINK_STATE";
    public static final String EXTRA_PREVIOUS_SINK_STATE = "android.bluetooth.a2dp.extra.PREVIOUS_SINK_STATE";
    public static final String ACTION_SINK_STATE_CHANGED = "android.bluetooth.a2dp.action.SINK_STATE_CHANGED";
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_DISCONNECTING = 3;
    public static final int STATE_PLAYING = 4;
    public static final int PRIORITY_AUTO_CONNECT = 1000;
    public static final int PRIORITY_ON = 100;
    public static final int PRIORITY_OFF = 0;
    public static final int PRIORITY_UNDEFINED = -1;
    private final IBluetoothA2dp mService;
    private final Context mContext;

    public BluetoothA2dp(Context c) {
        this.mContext = c;
        IBinder b = ServiceManager.getService("bluetooth_a2dp");
        if (b != null) {
            this.mService = IBluetoothA2dp.Stub.asInterface(b);
        } else {
            Log.w(TAG, "Bluetooth A2DP service not available!");
            this.mService = null;
        }
    }

    public boolean connectSink(BluetoothDevice device) {
        try {
            return this.mService.connectSink(device);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean disconnectSink(BluetoothDevice device) {
        try {
            return this.mService.disconnectSink(device);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean suspendSink(BluetoothDevice device) {
        try {
            return this.mService.suspendSink(device);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean resumeSink(BluetoothDevice device) {
        try {
            return this.mService.resumeSink(device);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public boolean isSinkConnected(BluetoothDevice device) {
        int state = this.getSinkState(device);
        return state == 2 || state == 4;
    }

    public Set<BluetoothDevice> getConnectedSinks() {
        try {
            return Collections.unmodifiableSet(new HashSet<BluetoothDevice>(Arrays.asList(this.mService.getConnectedSinks())));
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public Set<BluetoothDevice> getNonDisconnectedSinks() {
        try {
            return Collections.unmodifiableSet(new HashSet<BluetoothDevice>(Arrays.asList(this.mService.getNonDisconnectedSinks())));
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return null;
        }
    }

    public int getSinkState(BluetoothDevice device) {
        try {
            return this.mService.getSinkState(device);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return 0;
        }
    }

    public boolean setSinkPriority(BluetoothDevice device, int priority) {
        try {
            return this.mService.setSinkPriority(device, priority);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public int getSinkPriority(BluetoothDevice device) {
        try {
            return this.mService.getSinkPriority(device);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return 0;
        }
    }

    public boolean allowIncomingConnect(BluetoothDevice device, boolean value) {
        try {
            return this.mService.allowIncomingConnect(device, value);
        }
        catch (RemoteException e) {
            Log.e(TAG, "", e);
            return false;
        }
    }

    public static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "disconnected";
            }
            case 1: {
                return "connecting";
            }
            case 2: {
                return "connected";
            }
            case 3: {
                return "disconnecting";
            }
            case 4: {
                return "playing";
            }
        }
        return "<unknown state " + state + ">";
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }
}

