/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.AtCommandHandler;
import android.bluetooth.AtCommandResult;
import java.util.ArrayList;
import java.util.HashMap;

public class AtParser {
    private static final int TYPE_ACTION = 0;
    private static final int TYPE_READ = 1;
    private static final int TYPE_SET = 2;
    private static final int TYPE_TEST = 3;
    private HashMap<String, AtCommandHandler> mExtHandlers;
    private HashMap<Character, AtCommandHandler> mBasicHandlers = new HashMap();
    private String mLastInput = "";

    public AtParser() {
        this.mExtHandlers = new HashMap();
    }

    public void register(Character command, AtCommandHandler handler) {
        this.mBasicHandlers.put(command, handler);
    }

    public void register(String command, AtCommandHandler handler) {
        this.mExtHandlers.put(command, handler);
    }

    private static String clean(String input) {
        StringBuilder out = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\"') {
                int j = input.indexOf(34, i + 1);
                if (j == -1) {
                    out.append(input.substring(i, input.length()));
                    out.append('\"');
                    break;
                }
                out.append(input.substring(i, j + 1));
                i = j;
                continue;
            }
            if (c == ' ') continue;
            out.append(Character.toUpperCase(c));
        }
        return out.toString();
    }

    private static boolean isAtoZ(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static int findChar(char ch, String input, int fromIndex) {
        for (int i = fromIndex; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\"') {
                if ((i = input.indexOf(34, i + 1)) != -1) continue;
                return input.length();
            }
            if (c != ch) continue;
            return i;
        }
        return input.length();
    }

    private static Object[] generateArgs(String input) {
        int i = 0;
        ArrayList<Object> out = new ArrayList<Object>();
        while (i <= input.length()) {
            int j = AtParser.findChar(',', input, i);
            String arg = input.substring(i, j);
            try {
                out.add(new Integer(arg));
            }
            catch (NumberFormatException e) {
                out.add(arg);
            }
            i = j + 1;
        }
        return out.toArray();
    }

    private static int findEndExtendedName(String input, int index) {
        block3: for (int i = index; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (AtParser.isAtoZ(c) || c >= '0' && c <= '9') continue;
            switch (c) {
                case '!': 
                case '%': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '_': {
                    continue block3;
                }
                default: {
                    return i;
                }
            }
        }
        return input.length();
    }

    public AtCommandResult process(String raw_input) {
        String input = AtParser.clean(raw_input);
        if (input.regionMatches(0, "A/", 0, 2)) {
            input = new String(this.mLastInput);
        } else {
            this.mLastInput = new String(input);
        }
        if (input.equals("")) {
            return new AtCommandResult(2);
        }
        if (!input.regionMatches(0, "AT", 0, 2)) {
            return new AtCommandResult(1);
        }
        int index = 2;
        AtCommandResult result = new AtCommandResult(2);
        while (index < input.length()) {
            char c = input.charAt(index);
            if (AtParser.isAtoZ(c)) {
                String args = input.substring(index + 1);
                if (this.mBasicHandlers.containsKey(Character.valueOf(c))) {
                    result.addResult(this.mBasicHandlers.get(Character.valueOf(c)).handleBasicCommand(args));
                    return result;
                }
                result.addResult(new AtCommandResult(1));
                return result;
            }
            if (c == '+') {
                int i = AtParser.findEndExtendedName(input, index + 1);
                String commandName = input.substring(index, i);
                if (!this.mExtHandlers.containsKey(commandName)) {
                    result.addResult(new AtCommandResult(1));
                    return result;
                }
                AtCommandHandler handler = this.mExtHandlers.get(commandName);
                int endIndex = AtParser.findChar(';', input, index);
                int type = i >= endIndex ? 0 : (input.charAt(i) == '?' ? 1 : (input.charAt(i) == '=' ? (i + 1 < endIndex ? (input.charAt(i + 1) == '?' ? 3 : 2) : 2) : 0));
                switch (type) {
                    case 0: {
                        result.addResult(handler.handleActionCommand());
                        break;
                    }
                    case 1: {
                        result.addResult(handler.handleReadCommand());
                        break;
                    }
                    case 3: {
                        result.addResult(handler.handleTestCommand());
                        break;
                    }
                    case 2: {
                        Object[] args = AtParser.generateArgs(input.substring(i + 1, endIndex));
                        result.addResult(handler.handleSetCommand(args));
                    }
                }
                if (result.getResultCode() != 0) {
                    return result;
                }
                index = endIndex;
                continue;
            }
            ++index;
        }
        return result;
    }
}

