/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

public class AtCommandResult {
    public static final int OK = 0;
    public static final int ERROR = 1;
    public static final int UNSOLICITED = 2;
    private static final String OK_STRING = "OK";
    private static final String ERROR_STRING = "ERROR";
    private int mResultCode;
    private StringBuilder mResponse;

    public AtCommandResult(int resultCode) {
        this.mResultCode = resultCode;
        this.mResponse = new StringBuilder();
    }

    public AtCommandResult(String response) {
        this(0);
        this.addResponse(response);
    }

    public int getResultCode() {
        return this.mResultCode;
    }

    public void addResponse(String response) {
        AtCommandResult.appendWithCrlf(this.mResponse, response);
    }

    public void addResult(AtCommandResult result) {
        if (result != null) {
            AtCommandResult.appendWithCrlf(this.mResponse, result.mResponse.toString());
            this.mResultCode = result.mResultCode;
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.mResponse.toString());
        switch (this.mResultCode) {
            case 0: {
                AtCommandResult.appendWithCrlf(result, OK_STRING);
                break;
            }
            case 1: {
                AtCommandResult.appendWithCrlf(result, ERROR_STRING);
            }
        }
        return result.toString();
    }

    public static void appendWithCrlf(StringBuilder str1, String str2) {
        if (str1.length() > 0 && str2.length() > 0) {
            str1.append("\r\n\r\n");
        }
        str1.append(str2);
    }
}

