/*
 * Decompiled with CFR 0.152.
 */
package android.appwidget;

import android.appwidget.AppWidgetProviderInfo;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RemoteViews;
import android.widget.TextView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppWidgetHostView
extends FrameLayout {
    static final String TAG = "AppWidgetHostView";
    static final boolean LOGD = false;
    static final boolean CROSSFADE = false;
    static final int VIEW_MODE_NOINIT = 0;
    static final int VIEW_MODE_CONTENT = 1;
    static final int VIEW_MODE_ERROR = 2;
    static final int VIEW_MODE_DEFAULT = 3;
    static final int FADE_DURATION = 1000;
    static final LayoutInflater.Filter sInflaterFilter = new LayoutInflater.Filter(){

        public boolean onLoadClass(Class clazz) {
            return clazz.isAnnotationPresent(RemoteViews.RemoteView.class);
        }
    };
    Context mContext;
    Context mRemoteContext;
    int mAppWidgetId;
    AppWidgetProviderInfo mInfo;
    View mView;
    int mViewMode = 0;
    int mLayoutId = -1;
    long mFadeStartTime = -1L;
    Bitmap mOld;
    Paint mOldPaint = new Paint();

    public AppWidgetHostView(Context context) {
        this(context, 0x10A0000, 0x10A0001);
    }

    public AppWidgetHostView(Context context, int animationIn, int animationOut) {
        super(context);
        this.mContext = context;
    }

    public void setAppWidget(int appWidgetId, AppWidgetProviderInfo info) {
        this.mAppWidgetId = appWidgetId;
        this.mInfo = info;
    }

    public int getAppWidgetId() {
        return this.mAppWidgetId;
    }

    public AppWidgetProviderInfo getAppWidgetInfo() {
        return this.mInfo;
    }

    @Override
    protected void dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        ParcelableSparseArray jail = new ParcelableSparseArray();
        super.dispatchSaveInstanceState(jail);
        container.put(this.generateId(), jail);
    }

    private int generateId() {
        int id2 = this.getId();
        return id2 == -1 ? this.mAppWidgetId : id2;
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        Parcelable parcelable = container.get(this.generateId());
        ParcelableSparseArray jail = null;
        if (parcelable != null && parcelable instanceof ParcelableSparseArray) {
            jail = (ParcelableSparseArray)parcelable;
        }
        if (jail == null) {
            jail = new ParcelableSparseArray();
        }
        super.dispatchRestoreInstanceState(jail);
    }

    @Override
    public FrameLayout.LayoutParams generateLayoutParams(AttributeSet attrs) {
        Context context = this.mRemoteContext != null ? this.mRemoteContext : this.mContext;
        return new FrameLayout.LayoutParams(context, attrs);
    }

    void resetAppWidget(AppWidgetProviderInfo info) {
        this.mInfo = info;
        this.mViewMode = 0;
        this.updateAppWidget(null);
    }

    public void updateAppWidget(RemoteViews remoteViews) {
        boolean recycled = false;
        View content = null;
        RuntimeException exception = null;
        if (remoteViews == null) {
            if (this.mViewMode == 3) {
                return;
            }
            content = this.getDefaultView();
            this.mLayoutId = -1;
            this.mViewMode = 3;
        } else {
            this.mRemoteContext = this.getRemoteContext(remoteViews);
            int layoutId = remoteViews.getLayoutId();
            if (content == null && layoutId == this.mLayoutId) {
                try {
                    remoteViews.reapply(this.mContext, this.mView);
                    content = this.mView;
                    recycled = true;
                }
                catch (RuntimeException e) {
                    exception = e;
                }
            }
            if (content == null) {
                try {
                    content = remoteViews.apply(this.mContext, this);
                }
                catch (RuntimeException e) {
                    exception = e;
                }
            }
            this.mLayoutId = layoutId;
            this.mViewMode = 1;
        }
        if (content == null) {
            if (this.mViewMode == 2) {
                return;
            }
            Log.w(TAG, "updateAppWidget couldn't find any view, using error view", exception);
            content = this.getErrorView();
            this.mViewMode = 2;
        }
        if (!recycled) {
            this.prepareView(content);
            this.addView(content);
        }
        if (this.mView != content) {
            this.removeView(this.mView);
            this.mView = content;
        }
    }

    private Context getRemoteContext(RemoteViews views) {
        String packageName = views.getPackage();
        if (packageName == null) {
            return this.mContext;
        }
        try {
            return this.mContext.createPackageContext(packageName, 4);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(TAG, "Package name " + packageName + " not found");
            return this.mContext;
        }
    }

    @Override
    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        return super.drawChild(canvas, child, drawingTime);
    }

    protected void prepareView(View view) {
        FrameLayout.LayoutParams requested = (FrameLayout.LayoutParams)view.getLayoutParams();
        if (requested == null) {
            requested = new FrameLayout.LayoutParams(-1, -1);
        }
        requested.gravity = 17;
        view.setLayoutParams(requested);
    }

    protected View getDefaultView() {
        View defaultView = null;
        Exception exception = null;
        try {
            if (this.mInfo != null) {
                Context theirContext;
                this.mRemoteContext = theirContext = this.mContext.createPackageContext(this.mInfo.provider.getPackageName(), 4);
                LayoutInflater inflater = (LayoutInflater)theirContext.getSystemService("layout_inflater");
                inflater = inflater.cloneInContext(theirContext);
                inflater.setFilter(sInflaterFilter);
                defaultView = inflater.inflate(this.mInfo.initialLayout, (ViewGroup)this, false);
            } else {
                Log.w(TAG, "can't inflate defaultView because mInfo is missing");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            exception = e;
        }
        catch (RuntimeException e) {
            exception = e;
        }
        if (exception != null) {
            Log.w(TAG, "Error inflating AppWidget " + this.mInfo + ": " + exception.toString());
        }
        if (defaultView == null) {
            defaultView = this.getErrorView();
        }
        return defaultView;
    }

    protected View getErrorView() {
        TextView tv = new TextView(this.mContext);
        tv.setText(17040219);
        tv.setBackgroundColor(Color.argb(127, 0, 0, 0));
        return tv;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParcelableSparseArray
    extends SparseArray<Parcelable>
    implements Parcelable {
        public static final Parcelable.Creator<ParcelableSparseArray> CREATOR = new Parcelable.Creator<ParcelableSparseArray>(){

            @Override
            public ParcelableSparseArray createFromParcel(Parcel source) {
                ParcelableSparseArray array2 = new ParcelableSparseArray();
                ClassLoader loader = array2.getClass().getClassLoader();
                int count = source.readInt();
                for (int i = 0; i < count; ++i) {
                    array2.put(source.readInt(), source.readParcelable(loader));
                }
                return array2;
            }

            public ParcelableSparseArray[] newArray(int size) {
                return new ParcelableSparseArray[size];
            }
        };

        private ParcelableSparseArray() {
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            int count = this.size();
            dest.writeInt(count);
            for (int i = 0; i < count; ++i) {
                dest.writeInt(this.keyAt(i));
                dest.writeParcelable((Parcelable)this.valueAt(i), 0);
            }
        }
    }
}

