/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.DatePicker;
import android.widget.TextView;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Calendar;

public class DatePickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
DatePicker.OnDateChangedListener {
    private static final String YEAR = "year";
    private static final String MONTH = "month";
    private static final String DAY = "day";
    private final DatePicker mDatePicker;
    private final OnDateSetListener mCallBack;
    private final Calendar mCalendar;
    private final DateFormat mTitleDateFormat;
    private final String[] mWeekDays;
    private int mInitialYear;
    private int mInitialMonth;
    private int mInitialDay;

    public DatePickerDialog(Context context, OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth) {
        this(context, 16973987, callBack, year, monthOfYear, dayOfMonth);
    }

    public DatePickerDialog(Context context, int theme, OnDateSetListener callBack, int year, int monthOfYear, int dayOfMonth) {
        super(context, theme);
        this.mCallBack = callBack;
        this.mInitialYear = year;
        this.mInitialMonth = monthOfYear;
        this.mInitialDay = dayOfMonth;
        DateFormatSymbols symbols = new DateFormatSymbols();
        this.mWeekDays = symbols.getShortWeekdays();
        this.mTitleDateFormat = DateFormat.getDateInstance(0);
        this.mCalendar = Calendar.getInstance();
        this.updateTitle(this.mInitialYear, this.mInitialMonth, this.mInitialDay);
        this.setButton(context.getText(17040168), this);
        this.setButton2(context.getText(0x1040000), (DialogInterface.OnClickListener)null);
        this.setIcon(17301908);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = inflater.inflate(17367072, null);
        this.setView(view);
        this.mDatePicker = (DatePicker)view.findViewById(16908705);
        this.mDatePicker.init(this.mInitialYear, this.mInitialMonth, this.mInitialDay, this);
    }

    public void show() {
        super.show();
        TextView title = (TextView)this.findViewById(16908669);
        title.setSingleLine();
        title.setEllipsize(TextUtils.TruncateAt.END);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (this.mCallBack != null) {
            this.mDatePicker.clearFocus();
            this.mCallBack.onDateSet(this.mDatePicker, this.mDatePicker.getYear(), this.mDatePicker.getMonth(), this.mDatePicker.getDayOfMonth());
        }
    }

    public void onDateChanged(DatePicker view, int year, int month, int day) {
        this.updateTitle(year, month, day);
    }

    public void updateDate(int year, int monthOfYear, int dayOfMonth) {
        this.mInitialYear = year;
        this.mInitialMonth = monthOfYear;
        this.mInitialDay = dayOfMonth;
        this.mDatePicker.updateDate(year, monthOfYear, dayOfMonth);
    }

    private void updateTitle(int year, int month, int day) {
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, month);
        this.mCalendar.set(5, day);
        this.setTitle(this.mTitleDateFormat.format(this.mCalendar.getTime()));
    }

    public Bundle onSaveInstanceState() {
        Bundle state = super.onSaveInstanceState();
        state.putInt(YEAR, this.mDatePicker.getYear());
        state.putInt(MONTH, this.mDatePicker.getMonth());
        state.putInt(DAY, this.mDatePicker.getDayOfMonth());
        return state;
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        int year = savedInstanceState.getInt(YEAR);
        int month = savedInstanceState.getInt(MONTH);
        int day = savedInstanceState.getInt(DAY);
        this.mDatePicker.init(year, month, day, this);
        this.updateTitle(year, month, day);
    }

    public static interface OnDateSetListener {
        public void onDateSet(DatePicker var1, int var2, int var3, int var4);
    }
}

