/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountManagerResponse;
import android.app.ListActivity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListView;

public class ChooseAccountActivity
extends ListActivity {
    private static final String TAG = "AccountManager";
    private Parcelable[] mAccounts = null;
    private AccountManagerResponse mAccountManagerResponse = null;
    private Bundle mResult;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mAccounts = this.getIntent().getParcelableArrayExtra("accounts");
        this.mAccountManagerResponse = (AccountManagerResponse)this.getIntent().getParcelableExtra("accountManagerResponse");
        if (this.mAccounts == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        String[] mAccountNames = new String[this.mAccounts.length];
        for (int i = 0; i < this.mAccounts.length; ++i) {
            mAccountNames[i] = ((Account)this.mAccounts[i]).name;
        }
        this.setListAdapter(new ArrayAdapter<String>((Context)this, 17367043, mAccountNames));
        this.getListView().setTextFilterEnabled(true);
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        Account account = (Account)this.mAccounts[position];
        Log.d(TAG, "selected account " + account);
        Bundle bundle = new Bundle();
        bundle.putString("authAccount", account.name);
        bundle.putString("accountType", account.type);
        this.mResult = bundle;
        this.finish();
    }

    public void finish() {
        if (this.mAccountManagerResponse != null) {
            if (this.mResult != null) {
                this.mAccountManagerResponse.onResult(this.mResult);
            } else {
                this.mAccountManagerResponse.onError(4, "canceled");
            }
        }
        super.finish();
    }
}

