/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.AuthenticatorDescription;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.RegisteredServicesCache;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.XmlSerializerAndParser;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import com.android.internal.R;
import java.io.IOException;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AccountAuthenticatorCache
extends RegisteredServicesCache<AuthenticatorDescription> {
    private static final String TAG = "Account";
    private static final MySerializer sSerializer = new MySerializer();

    public AccountAuthenticatorCache(Context context) {
        super(context, "android.accounts.AccountAuthenticator", "android.accounts.AccountAuthenticator", "account-authenticator", sSerializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthenticatorDescription parseServiceAttributes(Resources res, String packageName, AttributeSet attrs) {
        AuthenticatorDescription authenticatorDescription;
        boolean customTokens;
        int prefId;
        int smallIconId;
        int iconId;
        int labelId;
        String accountType;
        TypedArray sa;
        block6: {
            sa = res.obtainAttributes(attrs, R.styleable.AccountAuthenticator);
            try {
                accountType = sa.getString(2);
                labelId = sa.getResourceId(0, 0);
                iconId = sa.getResourceId(1, 0);
                smallIconId = sa.getResourceId(3, 0);
                prefId = sa.getResourceId(4, 0);
                customTokens = false;
                try {
                    PackageManager pm = this.mContext.getPackageManager();
                    List<ResolveInfo> resolveInfos = pm.queryIntentServices(new Intent("android.accounts.AccountAuthenticator"), 128);
                    for (ResolveInfo resolveInfo : resolveInfos) {
                        Object ctString;
                        ServiceInfo si = resolveInfo.serviceInfo;
                        if (!packageName.equals(si.packageName) || (ctString = si.metaData.get("android.accounts.AccountAuthenticator.customTokens")) == null) continue;
                        customTokens = true;
                    }
                }
                catch (Throwable t) {
                    Log.e(TAG, "Error getting customTokens metadata " + t);
                }
                if (!TextUtils.isEmpty(accountType)) break block6;
                authenticatorDescription = null;
                Object var18_18 = null;
                sa.recycle();
                return authenticatorDescription;
            }
            catch (Throwable throwable) {
                Object var18_20 = null;
                sa.recycle();
                throw throwable;
            }
        }
        authenticatorDescription = new AuthenticatorDescription(accountType, packageName, labelId, iconId, smallIconId, prefId, customTokens);
        Object var18_19 = null;
        sa.recycle();
        return authenticatorDescription;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MySerializer
    implements XmlSerializerAndParser<AuthenticatorDescription> {
        private MySerializer() {
        }

        @Override
        public void writeAsXml(AuthenticatorDescription item, XmlSerializer out) throws IOException {
            out.attribute(null, "type", item.type);
        }

        @Override
        public AuthenticatorDescription createFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
            return AuthenticatorDescription.newKey(parser.getAttributeValue(null, "type"));
        }
    }
}

