/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.mms.pdu;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.net.Uri;
import android.provider.Telephony;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.mms.ContentType;
import com.google.android.mms.InvalidHeaderValueException;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.AcknowledgeInd;
import com.google.android.mms.pdu.DeliveryInd;
import com.google.android.mms.pdu.EncodedStringValue;
import com.google.android.mms.pdu.GenericPdu;
import com.google.android.mms.pdu.MultimediaMessagePdu;
import com.google.android.mms.pdu.NotificationInd;
import com.google.android.mms.pdu.NotifyRespInd;
import com.google.android.mms.pdu.PduBody;
import com.google.android.mms.pdu.PduHeaders;
import com.google.android.mms.pdu.PduPart;
import com.google.android.mms.pdu.ReadOrigInd;
import com.google.android.mms.pdu.ReadRecInd;
import com.google.android.mms.pdu.RetrieveConf;
import com.google.android.mms.pdu.SendReq;
import com.google.android.mms.util.PduCache;
import com.google.android.mms.util.PduCacheEntry;
import com.google.android.mms.util.SqliteWrapper;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PduPersister {
    private static final String TAG = "PduPersister";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final long DUMMY_THREAD_ID = Long.MAX_VALUE;
    public static final String TEMPORARY_DRM_OBJECT_URI = "content://mms/9223372036854775807/part";
    public static final int PROC_STATUS_TRANSIENT_FAILURE = 1;
    public static final int PROC_STATUS_PERMANENTLY_FAILURE = 2;
    public static final int PROC_STATUS_COMPLETED = 3;
    private static PduPersister sPersister;
    private static final PduCache PDU_CACHE_INSTANCE;
    private static final int[] ADDRESS_FIELDS;
    private static final String[] PDU_PROJECTION;
    private static final int PDU_COLUMN_ID = 0;
    private static final int PDU_COLUMN_MESSAGE_BOX = 1;
    private static final int PDU_COLUMN_THREAD_ID = 2;
    private static final int PDU_COLUMN_RETRIEVE_TEXT = 3;
    private static final int PDU_COLUMN_SUBJECT = 4;
    private static final int PDU_COLUMN_CONTENT_LOCATION = 5;
    private static final int PDU_COLUMN_CONTENT_TYPE = 6;
    private static final int PDU_COLUMN_MESSAGE_CLASS = 7;
    private static final int PDU_COLUMN_MESSAGE_ID = 8;
    private static final int PDU_COLUMN_RESPONSE_TEXT = 9;
    private static final int PDU_COLUMN_TRANSACTION_ID = 10;
    private static final int PDU_COLUMN_CONTENT_CLASS = 11;
    private static final int PDU_COLUMN_DELIVERY_REPORT = 12;
    private static final int PDU_COLUMN_MESSAGE_TYPE = 13;
    private static final int PDU_COLUMN_MMS_VERSION = 14;
    private static final int PDU_COLUMN_PRIORITY = 15;
    private static final int PDU_COLUMN_READ_REPORT = 16;
    private static final int PDU_COLUMN_READ_STATUS = 17;
    private static final int PDU_COLUMN_REPORT_ALLOWED = 18;
    private static final int PDU_COLUMN_RETRIEVE_STATUS = 19;
    private static final int PDU_COLUMN_STATUS = 20;
    private static final int PDU_COLUMN_DATE = 21;
    private static final int PDU_COLUMN_DELIVERY_TIME = 22;
    private static final int PDU_COLUMN_EXPIRY = 23;
    private static final int PDU_COLUMN_MESSAGE_SIZE = 24;
    private static final int PDU_COLUMN_SUBJECT_CHARSET = 25;
    private static final int PDU_COLUMN_RETRIEVE_TEXT_CHARSET = 26;
    private static final String[] PART_PROJECTION;
    private static final int PART_COLUMN_ID = 0;
    private static final int PART_COLUMN_CHARSET = 1;
    private static final int PART_COLUMN_CONTENT_DISPOSITION = 2;
    private static final int PART_COLUMN_CONTENT_ID = 3;
    private static final int PART_COLUMN_CONTENT_LOCATION = 4;
    private static final int PART_COLUMN_CONTENT_TYPE = 5;
    private static final int PART_COLUMN_FILENAME = 6;
    private static final int PART_COLUMN_NAME = 7;
    private static final int PART_COLUMN_TEXT = 8;
    private static final HashMap<Uri, Integer> MESSAGE_BOX_MAP;
    private static final HashMap<Integer, Integer> CHARSET_COLUMN_INDEX_MAP;
    private static final HashMap<Integer, Integer> ENCODED_STRING_COLUMN_INDEX_MAP;
    private static final HashMap<Integer, Integer> TEXT_STRING_COLUMN_INDEX_MAP;
    private static final HashMap<Integer, Integer> OCTET_COLUMN_INDEX_MAP;
    private static final HashMap<Integer, Integer> LONG_COLUMN_INDEX_MAP;
    private static final HashMap<Integer, String> CHARSET_COLUMN_NAME_MAP;
    private static final HashMap<Integer, String> ENCODED_STRING_COLUMN_NAME_MAP;
    private static final HashMap<Integer, String> TEXT_STRING_COLUMN_NAME_MAP;
    private static final HashMap<Integer, String> OCTET_COLUMN_NAME_MAP;
    private static final HashMap<Integer, String> LONG_COLUMN_NAME_MAP;
    private final Context mContext;
    private final ContentResolver mContentResolver;

    private PduPersister(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
    }

    public static PduPersister getPduPersister(Context context) {
        if (sPersister == null || !context.equals(PduPersister.sPersister.mContext)) {
            sPersister = new PduPersister(context);
        }
        return sPersister;
    }

    private void setEncodedStringValueToHeaders(Cursor c, int columnIndex, PduHeaders headers, int mapColumn) {
        String s = c.getString(columnIndex);
        if (s != null && s.length() > 0) {
            int charsetColumnIndex = CHARSET_COLUMN_INDEX_MAP.get(mapColumn);
            int charset = c.getInt(charsetColumnIndex);
            EncodedStringValue value = new EncodedStringValue(charset, PduPersister.getBytes(s));
            headers.setEncodedStringValue(value, mapColumn);
        }
    }

    private void setTextStringToHeaders(Cursor c, int columnIndex, PduHeaders headers, int mapColumn) {
        String s = c.getString(columnIndex);
        if (s != null) {
            headers.setTextString(PduPersister.getBytes(s), mapColumn);
        }
    }

    private void setOctetToHeaders(Cursor c, int columnIndex, PduHeaders headers, int mapColumn) throws InvalidHeaderValueException {
        if (!c.isNull(columnIndex)) {
            int b = c.getInt(columnIndex);
            headers.setOctet(b, mapColumn);
        }
    }

    private void setLongToHeaders(Cursor c, int columnIndex, PduHeaders headers, int mapColumn) {
        if (!c.isNull(columnIndex)) {
            long l = c.getLong(columnIndex);
            headers.setLongInteger(l, mapColumn);
        }
    }

    private Integer getIntegerFromPartColumn(Cursor c, int columnIndex) {
        if (!c.isNull(columnIndex)) {
            return c.getInt(columnIndex);
        }
        return null;
    }

    private byte[] getByteArrayFromPartColumn(Cursor c, int columnIndex) {
        if (!c.isNull(columnIndex)) {
            return PduPersister.getBytes(c.getString(columnIndex));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PduPart[] loadParts(long msgId) throws MmsException {
        Cursor c = SqliteWrapper.query(this.mContext, this.mContentResolver, Uri.parse("content://mms/" + msgId + "/part"), PART_PROJECTION, null, null, null);
        PduPart[] parts = null;
        try {
            if (c == null || c.getCount() == 0) {
                PduPart[] pduPartArray = null;
                return pduPartArray;
            }
            int partCount = c.getCount();
            int partIdx = 0;
            parts = new PduPart[partCount];
            while (c.moveToNext()) {
                byte[] name;
                byte[] contentType;
                byte[] contentLocation;
                byte[] contentId;
                byte[] contentDisposition;
                PduPart part = new PduPart();
                Integer charset = this.getIntegerFromPartColumn(c, 1);
                if (charset != null) {
                    part.setCharset(charset);
                }
                if ((contentDisposition = this.getByteArrayFromPartColumn(c, 2)) != null) {
                    part.setContentDisposition(contentDisposition);
                }
                if ((contentId = this.getByteArrayFromPartColumn(c, 3)) != null) {
                    part.setContentId(contentId);
                }
                if ((contentLocation = this.getByteArrayFromPartColumn(c, 4)) != null) {
                    part.setContentLocation(contentLocation);
                }
                if ((contentType = this.getByteArrayFromPartColumn(c, 5)) == null) {
                    throw new MmsException("Content-Type must be set.");
                }
                part.setContentType(contentType);
                byte[] fileName = this.getByteArrayFromPartColumn(c, 6);
                if (fileName != null) {
                    part.setFilename(fileName);
                }
                if ((name = this.getByteArrayFromPartColumn(c, 7)) != null) {
                    part.setName(name);
                }
                long partId = c.getLong(0);
                Uri partURI = Uri.parse("content://mms/part/" + partId);
                part.setDataUri(partURI);
                String type = PduPersister.toIsoString(contentType);
                if (!(ContentType.isImageType(type) || ContentType.isAudioType(type) || ContentType.isVideoType(type))) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    InputStream is = null;
                    if ("text/plain".equals(type) || "application/smil".equals(type) || "text/html".equals(type)) {
                        String text = c.getString(8);
                        byte[] blob = new EncodedStringValue(text != null ? text : "").getTextString();
                        baos.write(blob, 0, blob.length);
                    } else {
                        try {
                            is = this.mContentResolver.openInputStream(partURI);
                            byte[] buffer = new byte[256];
                            int len = is.read(buffer);
                            while (len >= 0) {
                                baos.write(buffer, 0, len);
                                len = is.read(buffer);
                            }
                        }
                        catch (IOException e) {
                            Log.e(TAG, "Failed to load part data", e);
                            c.close();
                            throw new MmsException(e);
                        }
                        finally {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {
                                    Log.e(TAG, "Failed to close stream", e);
                                }
                            }
                        }
                    }
                    part.setData(baos.toByteArray());
                }
                parts[partIdx++] = part;
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return parts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadAddress(long msgId, PduHeaders headers) {
        Cursor c = SqliteWrapper.query(this.mContext, this.mContentResolver, Uri.parse("content://mms/" + msgId + "/addr"), new String[]{"address", "charset", "type"}, null, null, null);
        if (c == null) return;
        try {
            block7: while (c.moveToNext()) {
                String addr = c.getString(0);
                if (TextUtils.isEmpty(addr)) continue;
                int addrType = c.getInt(2);
                switch (addrType) {
                    case 137: {
                        headers.setEncodedStringValue(new EncodedStringValue(c.getInt(1), PduPersister.getBytes(addr)), addrType);
                        continue block7;
                    }
                    case 129: 
                    case 130: 
                    case 151: {
                        headers.appendEncodedStringValue(new EncodedStringValue(c.getInt(1), PduPersister.getBytes(addr)), addrType);
                        continue block7;
                    }
                }
                Log.e(TAG, "Unknown address type: " + addrType);
            }
            return;
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericPdu load(Uri uri) throws MmsException {
        PduPart[] parts;
        long threadId;
        int msgBox;
        PduCacheEntry cacheEntry = (PduCacheEntry)PDU_CACHE_INSTANCE.get(uri);
        if (cacheEntry != null) {
            return cacheEntry.getPdu();
        }
        Cursor c = SqliteWrapper.query(this.mContext, this.mContentResolver, uri, PDU_PROJECTION, null, null, null);
        PduHeaders headers = new PduHeaders();
        long msgId = ContentUris.parseId(uri);
        try {
            if (c == null || c.getCount() != 1 || !c.moveToFirst()) {
                throw new MmsException("Bad uri: " + uri);
            }
            msgBox = c.getInt(1);
            threadId = c.getLong(2);
            Set<Map.Entry<Integer, Integer>> set = ENCODED_STRING_COLUMN_INDEX_MAP.entrySet();
            for (Map.Entry<Integer, Integer> e : set) {
                this.setEncodedStringValueToHeaders(c, e.getValue(), headers, e.getKey());
            }
            set = TEXT_STRING_COLUMN_INDEX_MAP.entrySet();
            for (Map.Entry<Integer, Integer> e : set) {
                this.setTextStringToHeaders(c, e.getValue(), headers, e.getKey());
            }
            set = OCTET_COLUMN_INDEX_MAP.entrySet();
            for (Map.Entry<Integer, Integer> e : set) {
                this.setOctetToHeaders(c, e.getValue(), headers, e.getKey());
            }
            set = LONG_COLUMN_INDEX_MAP.entrySet();
            for (Map.Entry<Integer, Integer> e : set) {
                this.setLongToHeaders(c, e.getValue(), headers, e.getKey());
            }
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        if (msgId == -1L) {
            throw new MmsException("Error! ID of the message: -1.");
        }
        this.loadAddress(msgId, headers);
        int msgType = headers.getOctet(140);
        PduBody body = new PduBody();
        if ((msgType == 132 || msgType == 128) && (parts = this.loadParts(msgId)) != null) {
            int partsNum = parts.length;
            for (int i = 0; i < partsNum; ++i) {
                body.addPart(parts[i]);
            }
        }
        GenericPdu pdu = null;
        switch (msgType) {
            case 130: {
                pdu = new NotificationInd(headers);
                break;
            }
            case 134: {
                pdu = new DeliveryInd(headers);
                break;
            }
            case 136: {
                pdu = new ReadOrigInd(headers);
                break;
            }
            case 132: {
                pdu = new RetrieveConf(headers, body);
                break;
            }
            case 128: {
                pdu = new SendReq(headers, body);
                break;
            }
            case 133: {
                pdu = new AcknowledgeInd(headers);
                break;
            }
            case 131: {
                pdu = new NotifyRespInd(headers);
                break;
            }
            case 135: {
                pdu = new ReadRecInd(headers);
                break;
            }
            case 129: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: {
                throw new MmsException("Unsupported PDU type: " + Integer.toHexString(msgType));
            }
            default: {
                throw new MmsException("Unrecognized PDU type: " + Integer.toHexString(msgType));
            }
        }
        cacheEntry = new PduCacheEntry(pdu, msgBox, threadId);
        PDU_CACHE_INSTANCE.put(uri, cacheEntry);
        return pdu;
    }

    private void persistAddress(long msgId, int type, EncodedStringValue[] array2) {
        ContentValues values = new ContentValues(3);
        for (EncodedStringValue addr : array2) {
            values.clear();
            values.put("address", PduPersister.toIsoString(addr.getTextString()));
            values.put("charset", addr.getCharacterSet());
            values.put("type", type);
            Uri uri = Uri.parse("content://mms/" + msgId + "/addr");
            SqliteWrapper.insert(this.mContext, this.mContentResolver, uri, values);
        }
    }

    public Uri persistPart(PduPart part, long msgId) throws MmsException {
        Uri res;
        Uri uri = Uri.parse("content://mms/" + msgId + "/part");
        ContentValues values = new ContentValues(8);
        int charset = part.getCharset();
        if (charset != 0) {
            values.put("chset", charset);
        }
        String contentType = null;
        if (part.getContentType() != null) {
            contentType = PduPersister.toIsoString(part.getContentType());
            values.put("ct", contentType);
            if ("application/smil".equals(contentType)) {
                values.put("seq", -1);
            }
        } else {
            throw new MmsException("MIME type of the part must be set.");
        }
        if (part.getFilename() != null) {
            String fileName = new String(part.getFilename());
            values.put("fn", fileName);
        }
        if (part.getName() != null) {
            String name = new String(part.getName());
            values.put("name", name);
        }
        String value = null;
        if (part.getContentDisposition() != null) {
            value = PduPersister.toIsoString(part.getContentDisposition());
            values.put("cd", value);
        }
        if (part.getContentId() != null) {
            value = PduPersister.toIsoString(part.getContentId());
            values.put("cid", value);
        }
        if (part.getContentLocation() != null) {
            value = PduPersister.toIsoString(part.getContentLocation());
            values.put("cl", value);
        }
        if ((res = SqliteWrapper.insert(this.mContext, this.mContentResolver, uri, values)) == null) {
            throw new MmsException("Failed to persist part, return null.");
        }
        this.persistData(part, res, contentType);
        part.setDataUri(res);
        return res;
    }

    private void persistData(PduPart part, Uri uri, String contentType) throws MmsException {
        OutputStream os = null;
        InputStream is = null;
        try {
            byte[] data = part.getData();
            if ("text/plain".equals(contentType) || "application/smil".equals(contentType) || "text/html".equals(contentType)) {
                ContentValues cv = new ContentValues();
                cv.put("text", new EncodedStringValue(data).getString());
                if (this.mContentResolver.update(uri, cv, null, null) != 1) {
                    throw new MmsException("unable to update " + uri.toString());
                }
            } else {
                os = this.mContentResolver.openOutputStream(uri);
                if (data == null) {
                    Uri dataUri = part.getDataUri();
                    if (dataUri == null || dataUri == uri) {
                        Log.w(TAG, "Can't find data for this part.");
                        return;
                    }
                    is = this.mContentResolver.openInputStream(dataUri);
                    byte[] buffer = new byte[256];
                    int len = 0;
                    while ((len = is.read(buffer)) != -1) {
                        os.write(buffer, 0, len);
                    }
                } else {
                    os.write(data);
                }
            }
        }
        catch (FileNotFoundException e) {
            Log.e(TAG, "Failed to open Input/Output stream.", e);
            throw new MmsException(e);
        }
        catch (IOException e) {
            Log.e(TAG, "Failed to read/write data.", e);
            throw new MmsException(e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    Log.e(TAG, "IOException while closing: " + os, e);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Log.e(TAG, "IOException while closing: " + is, e);
                }
            }
        }
    }

    private void updateAddress(long msgId, int type, EncodedStringValue[] array2) {
        SqliteWrapper.delete(this.mContext, this.mContentResolver, Uri.parse("content://mms/" + msgId + "/addr"), "type=" + type, null);
        this.persistAddress(msgId, type, array2);
    }

    public void updateHeaders(Uri uri, SendReq sendReq) {
        EncodedStringValue subject;
        byte[] transId;
        int readReport;
        int priority;
        byte[] msgClass;
        long expiry;
        int deliveryReport;
        long date;
        PDU_CACHE_INSTANCE.purge(uri);
        ContentValues values = new ContentValues(10);
        byte[] contentType = sendReq.getContentType();
        if (contentType != null) {
            values.put("ct_t", PduPersister.toIsoString(contentType));
        }
        if ((date = sendReq.getDate()) != -1L) {
            values.put("date", date);
        }
        if ((deliveryReport = sendReq.getDeliveryReport()) != 0) {
            values.put("d_rpt", deliveryReport);
        }
        if ((expiry = sendReq.getExpiry()) != -1L) {
            values.put("exp", expiry);
        }
        if ((msgClass = sendReq.getMessageClass()) != null) {
            values.put("m_cls", PduPersister.toIsoString(msgClass));
        }
        if ((priority = sendReq.getPriority()) != 0) {
            values.put("pri", priority);
        }
        if ((readReport = sendReq.getReadReport()) != 0) {
            values.put("rr", readReport);
        }
        if ((transId = sendReq.getTransactionId()) != null) {
            values.put("tr_id", PduPersister.toIsoString(transId));
        }
        if ((subject = sendReq.getSubject()) != null) {
            values.put("sub", PduPersister.toIsoString(subject.getTextString()));
            values.put("sub_cs", subject.getCharacterSet());
        } else {
            values.put("sub", "");
        }
        long messageSize = sendReq.getMessageSize();
        if (messageSize > 0L) {
            values.put("m_size", messageSize);
        }
        PduHeaders headers = sendReq.getPduHeaders();
        HashSet<String> recipients = new HashSet<String>();
        for (int addrType : ADDRESS_FIELDS) {
            EncodedStringValue[] array2 = null;
            if (addrType == 137) {
                EncodedStringValue v = headers.getEncodedStringValue(addrType);
                if (v != null) {
                    array2 = new EncodedStringValue[]{v};
                }
            } else {
                array2 = headers.getEncodedStringValues(addrType);
            }
            if (array2 == null) continue;
            long msgId = ContentUris.parseId(uri);
            this.updateAddress(msgId, addrType, array2);
            if (addrType != 151) continue;
            for (EncodedStringValue v : array2) {
                if (v == null) continue;
                recipients.add(v.getString());
            }
        }
        long threadId = Telephony.Threads.getOrCreateThreadId(this.mContext, recipients);
        values.put("thread_id", threadId);
        SqliteWrapper.update(this.mContext, this.mContentResolver, uri, values, null, null);
    }

    private void updatePart(Uri uri, PduPart part) throws MmsException {
        ContentValues values = new ContentValues(7);
        int charset = part.getCharset();
        if (charset != 0) {
            values.put("chset", charset);
        }
        String contentType = null;
        if (part.getContentType() == null) {
            throw new MmsException("MIME type of the part must be set.");
        }
        contentType = PduPersister.toIsoString(part.getContentType());
        values.put("ct", contentType);
        if (part.getFilename() != null) {
            String fileName = new String(part.getFilename());
            values.put("fn", fileName);
        }
        if (part.getName() != null) {
            String name = new String(part.getName());
            values.put("name", name);
        }
        String value = null;
        if (part.getContentDisposition() != null) {
            value = PduPersister.toIsoString(part.getContentDisposition());
            values.put("cd", value);
        }
        if (part.getContentId() != null) {
            value = PduPersister.toIsoString(part.getContentId());
            values.put("cid", value);
        }
        if (part.getContentLocation() != null) {
            value = PduPersister.toIsoString(part.getContentLocation());
            values.put("cl", value);
        }
        SqliteWrapper.update(this.mContext, this.mContentResolver, uri, values, null, null);
        if (part.getData() != null || uri != part.getDataUri()) {
            this.persistData(part, uri, contentType);
        }
    }

    public void updateParts(Uri uri, PduBody body) throws MmsException {
        PduCacheEntry cacheEntry = (PduCacheEntry)PDU_CACHE_INSTANCE.get(uri);
        if (cacheEntry != null) {
            ((MultimediaMessagePdu)cacheEntry.getPdu()).setBody(body);
        }
        ArrayList<PduPart> toBeCreated = new ArrayList<PduPart>();
        HashMap<Uri, PduPart> toBeUpdated = new HashMap<Uri, PduPart>();
        int partsNum = body.getPartsNum();
        StringBuilder filter = new StringBuilder().append('(');
        for (int i = 0; i < partsNum; ++i) {
            PduPart part = body.getPart(i);
            Uri partUri = part.getDataUri();
            if (partUri == null || !partUri.getAuthority().startsWith("mms")) {
                toBeCreated.add(part);
                continue;
            }
            toBeUpdated.put(partUri, part);
            if (filter.length() > 1) {
                filter.append(" AND ");
            }
            filter.append("_id");
            filter.append("!=");
            DatabaseUtils.appendEscapedSQLString(filter, partUri.getLastPathSegment());
        }
        filter.append(')');
        long msgId = ContentUris.parseId(uri);
        SqliteWrapper.delete(this.mContext, this.mContentResolver, Uri.parse(Telephony.Mms.CONTENT_URI + "/" + msgId + "/part"), filter.length() > 2 ? filter.toString() : null, null);
        for (PduPart pduPart : toBeCreated) {
            this.persistPart(pduPart, msgId);
        }
        for (Map.Entry entry : toBeUpdated.entrySet()) {
            this.updatePart((Uri)entry.getKey(), (PduPart)entry.getValue());
        }
    }

    public Uri persist(GenericPdu pdu, Uri uri) throws MmsException {
        Uri res;
        EncodedStringValue[] array2;
        if (uri == null) {
            throw new MmsException("Uri may not be null.");
        }
        Integer msgBox = MESSAGE_BOX_MAP.get(uri);
        if (msgBox == null) {
            throw new MmsException("Bad destination, must be one of content://mms/inbox, content://mms/sent, content://mms/drafts, content://mms/outbox, content://mms/temp.");
        }
        PDU_CACHE_INSTANCE.purge(uri);
        PduHeaders header = pdu.getPduHeaders();
        PduBody body = null;
        ContentValues values = new ContentValues();
        Set<Map.Entry<Integer, String>> set = ENCODED_STRING_COLUMN_NAME_MAP.entrySet();
        for (Map.Entry<Integer, String> e : set) {
            int field = e.getKey();
            EncodedStringValue encodedString = header.getEncodedStringValue(field);
            if (encodedString == null) continue;
            String charsetColumn = CHARSET_COLUMN_NAME_MAP.get(field);
            values.put(e.getValue(), PduPersister.toIsoString(encodedString.getTextString()));
            values.put(charsetColumn, encodedString.getCharacterSet());
        }
        set = TEXT_STRING_COLUMN_NAME_MAP.entrySet();
        for (Map.Entry<Integer, String> e : set) {
            byte[] text = header.getTextString(e.getKey());
            if (text == null) continue;
            values.put(e.getValue(), PduPersister.toIsoString(text));
        }
        set = OCTET_COLUMN_NAME_MAP.entrySet();
        for (Map.Entry<Integer, String> e : set) {
            int b = header.getOctet(e.getKey());
            if (b == 0) continue;
            values.put(e.getValue(), b);
        }
        set = LONG_COLUMN_NAME_MAP.entrySet();
        for (Map.Entry<Integer, String> e : set) {
            long l = header.getLongInteger(e.getKey());
            if (l == -1L) continue;
            values.put(e.getValue(), l);
        }
        HashMap<Integer, EncodedStringValue[]> addressMap = new HashMap<Integer, EncodedStringValue[]>(ADDRESS_FIELDS.length);
        for (int addrType : ADDRESS_FIELDS) {
            array2 = null;
            if (addrType == 137) {
                EncodedStringValue v = header.getEncodedStringValue(addrType);
                if (v != null) {
                    array2 = new EncodedStringValue[]{v};
                }
            } else {
                array2 = header.getEncodedStringValues(addrType);
            }
            addressMap.put(addrType, array2);
        }
        HashSet<String> recipients = new HashSet<String>();
        long threadId = Long.MAX_VALUE;
        int msgType = pdu.getMessageType();
        if (msgType == 130 || msgType == 132 || msgType == 128) {
            array2 = null;
            switch (msgType) {
                case 130: 
                case 132: {
                    array2 = (EncodedStringValue[])addressMap.get(137);
                    break;
                }
                case 128: {
                    array2 = (EncodedStringValue[])addressMap.get(151);
                }
            }
            if (array2 != null) {
                for (EncodedStringValue v : array2) {
                    if (v == null) continue;
                    recipients.add(v.getString());
                }
            }
            threadId = Telephony.Threads.getOrCreateThreadId(this.mContext, recipients);
        }
        values.put("thread_id", threadId);
        long dummyId = System.currentTimeMillis();
        if (pdu instanceof MultimediaMessagePdu && (body = ((MultimediaMessagePdu)pdu).getBody()) != null) {
            int partsNum = body.getPartsNum();
            for (int i = 0; i < partsNum; ++i) {
                PduPart part = body.getPart(i);
                this.persistPart(part, dummyId);
            }
        }
        if ((res = SqliteWrapper.insert(this.mContext, this.mContentResolver, uri, values)) == null) {
            throw new MmsException("persist() failed: return null.");
        }
        long msgId = ContentUris.parseId(res);
        values = new ContentValues(1);
        values.put("mid", msgId);
        SqliteWrapper.update(this.mContext, this.mContentResolver, Uri.parse("content://mms/" + dummyId + "/part"), values, null, null);
        res = Uri.parse(uri + "/" + msgId);
        for (int addrType : ADDRESS_FIELDS) {
            EncodedStringValue[] array3 = (EncodedStringValue[])addressMap.get(addrType);
            if (array3 == null) continue;
            this.persistAddress(msgId, addrType, array3);
        }
        return res;
    }

    public Uri move(Uri from, Uri to) throws MmsException {
        long msgId = ContentUris.parseId(from);
        if (msgId == -1L) {
            throw new MmsException("Error! ID of the message: -1.");
        }
        Integer msgBox = MESSAGE_BOX_MAP.get(to);
        if (msgBox == null) {
            throw new MmsException("Bad destination, must be one of content://mms/inbox, content://mms/sent, content://mms/drafts, content://mms/outbox, content://mms/temp.");
        }
        ContentValues values = new ContentValues(1);
        values.put("msg_box", msgBox);
        SqliteWrapper.update(this.mContext, this.mContentResolver, from, values, null, null);
        return ContentUris.withAppendedId(to, msgId);
    }

    public static String toIsoString(byte[] bytes) {
        try {
            return new String(bytes, "iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            Log.e(TAG, "ISO_8859_1 must be supported!", e);
            return "";
        }
    }

    public static byte[] getBytes(String data) {
        try {
            return data.getBytes("iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            Log.e(TAG, "ISO_8859_1 must be supported!", e);
            return new byte[0];
        }
    }

    public void release() {
        Uri uri = Uri.parse(TEMPORARY_DRM_OBJECT_URI);
        SqliteWrapper.delete(this.mContext, this.mContentResolver, uri, null, null);
    }

    public Cursor getPendingMessages(long dueTime) {
        Uri.Builder uriBuilder = Telephony.MmsSms.PendingMessages.CONTENT_URI.buildUpon();
        uriBuilder.appendQueryParameter("protocol", "mms");
        String selection = "err_type < ? AND due_time <= ?";
        String[] selectionArgs = new String[]{String.valueOf(10), String.valueOf(dueTime)};
        return SqliteWrapper.query(this.mContext, this.mContentResolver, uriBuilder.build(), null, selection, selectionArgs, "due_time");
    }

    static {
        ADDRESS_FIELDS = new int[]{129, 130, 137, 151};
        PDU_PROJECTION = new String[]{"_id", "msg_box", "thread_id", "retr_txt", "sub", "ct_l", "ct_t", "m_cls", "m_id", "resp_txt", "tr_id", "ct_cls", "d_rpt", "m_type", "v", "pri", "rr", "read_status", "rpt_a", "retr_st", "st", "date", "d_tm", "exp", "m_size", "sub_cs", "retr_txt_cs"};
        PART_PROJECTION = new String[]{"_id", "chset", "cd", "cid", "cl", "ct", "fn", "name", "text"};
        MESSAGE_BOX_MAP = new HashMap();
        MESSAGE_BOX_MAP.put(Telephony.Mms.Inbox.CONTENT_URI, 1);
        MESSAGE_BOX_MAP.put(Telephony.Mms.Sent.CONTENT_URI, 2);
        MESSAGE_BOX_MAP.put(Telephony.Mms.Draft.CONTENT_URI, 3);
        MESSAGE_BOX_MAP.put(Telephony.Mms.Outbox.CONTENT_URI, 4);
        CHARSET_COLUMN_INDEX_MAP = new HashMap();
        CHARSET_COLUMN_INDEX_MAP.put(150, 25);
        CHARSET_COLUMN_INDEX_MAP.put(154, 26);
        CHARSET_COLUMN_NAME_MAP = new HashMap();
        CHARSET_COLUMN_NAME_MAP.put(150, "sub_cs");
        CHARSET_COLUMN_NAME_MAP.put(154, "retr_txt_cs");
        ENCODED_STRING_COLUMN_INDEX_MAP = new HashMap();
        ENCODED_STRING_COLUMN_INDEX_MAP.put(154, 3);
        ENCODED_STRING_COLUMN_INDEX_MAP.put(150, 4);
        ENCODED_STRING_COLUMN_NAME_MAP = new HashMap();
        ENCODED_STRING_COLUMN_NAME_MAP.put(154, "retr_txt");
        ENCODED_STRING_COLUMN_NAME_MAP.put(150, "sub");
        TEXT_STRING_COLUMN_INDEX_MAP = new HashMap();
        TEXT_STRING_COLUMN_INDEX_MAP.put(131, 5);
        TEXT_STRING_COLUMN_INDEX_MAP.put(132, 6);
        TEXT_STRING_COLUMN_INDEX_MAP.put(138, 7);
        TEXT_STRING_COLUMN_INDEX_MAP.put(139, 8);
        TEXT_STRING_COLUMN_INDEX_MAP.put(147, 9);
        TEXT_STRING_COLUMN_INDEX_MAP.put(152, 10);
        TEXT_STRING_COLUMN_NAME_MAP = new HashMap();
        TEXT_STRING_COLUMN_NAME_MAP.put(131, "ct_l");
        TEXT_STRING_COLUMN_NAME_MAP.put(132, "ct_t");
        TEXT_STRING_COLUMN_NAME_MAP.put(138, "m_cls");
        TEXT_STRING_COLUMN_NAME_MAP.put(139, "m_id");
        TEXT_STRING_COLUMN_NAME_MAP.put(147, "resp_txt");
        TEXT_STRING_COLUMN_NAME_MAP.put(152, "tr_id");
        OCTET_COLUMN_INDEX_MAP = new HashMap();
        OCTET_COLUMN_INDEX_MAP.put(186, 11);
        OCTET_COLUMN_INDEX_MAP.put(134, 12);
        OCTET_COLUMN_INDEX_MAP.put(140, 13);
        OCTET_COLUMN_INDEX_MAP.put(141, 14);
        OCTET_COLUMN_INDEX_MAP.put(143, 15);
        OCTET_COLUMN_INDEX_MAP.put(144, 16);
        OCTET_COLUMN_INDEX_MAP.put(155, 17);
        OCTET_COLUMN_INDEX_MAP.put(145, 18);
        OCTET_COLUMN_INDEX_MAP.put(153, 19);
        OCTET_COLUMN_INDEX_MAP.put(149, 20);
        OCTET_COLUMN_NAME_MAP = new HashMap();
        OCTET_COLUMN_NAME_MAP.put(186, "ct_cls");
        OCTET_COLUMN_NAME_MAP.put(134, "d_rpt");
        OCTET_COLUMN_NAME_MAP.put(140, "m_type");
        OCTET_COLUMN_NAME_MAP.put(141, "v");
        OCTET_COLUMN_NAME_MAP.put(143, "pri");
        OCTET_COLUMN_NAME_MAP.put(144, "rr");
        OCTET_COLUMN_NAME_MAP.put(155, "read_status");
        OCTET_COLUMN_NAME_MAP.put(145, "rpt_a");
        OCTET_COLUMN_NAME_MAP.put(153, "retr_st");
        OCTET_COLUMN_NAME_MAP.put(149, "st");
        LONG_COLUMN_INDEX_MAP = new HashMap();
        LONG_COLUMN_INDEX_MAP.put(133, 21);
        LONG_COLUMN_INDEX_MAP.put(135, 22);
        LONG_COLUMN_INDEX_MAP.put(136, 23);
        LONG_COLUMN_INDEX_MAP.put(142, 24);
        LONG_COLUMN_NAME_MAP = new HashMap();
        LONG_COLUMN_NAME_MAP.put(133, "date");
        LONG_COLUMN_NAME_MAP.put(135, "d_tm");
        LONG_COLUMN_NAME_MAP.put(136, "exp");
        LONG_COLUMN_NAME_MAP.put(142, "m_size");
        PDU_CACHE_INSTANCE = PduCache.getInstance();
    }
}

