/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.sip;

import android.net.sip.SipProfile;
import android.util.Log;
import gov.nist.javax.sip.SipStackExt;
import gov.nist.javax.sip.clientauthutils.AccountManager;
import gov.nist.javax.sip.clientauthutils.AuthenticationHelper;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.PeerUnavailableException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SipHelper {
    private static final String TAG = SipHelper.class.getSimpleName();
    private static final boolean DEBUG = true;
    private SipStack mSipStack;
    private SipProvider mSipProvider;
    private AddressFactory mAddressFactory;
    private HeaderFactory mHeaderFactory;
    private MessageFactory mMessageFactory;

    public SipHelper(SipStack sipStack, SipProvider sipProvider) throws PeerUnavailableException {
        this.mSipStack = sipStack;
        this.mSipProvider = sipProvider;
        SipFactory sipFactory = SipFactory.getInstance();
        this.mAddressFactory = sipFactory.createAddressFactory();
        this.mHeaderFactory = sipFactory.createHeaderFactory();
        this.mMessageFactory = sipFactory.createMessageFactory();
    }

    private FromHeader createFromHeader(SipProfile profile, String tag) throws ParseException {
        return this.mHeaderFactory.createFromHeader(profile.getSipAddress(), tag);
    }

    private ToHeader createToHeader(SipProfile profile) throws ParseException {
        return this.createToHeader(profile, null);
    }

    private ToHeader createToHeader(SipProfile profile, String tag) throws ParseException {
        return this.mHeaderFactory.createToHeader(profile.getSipAddress(), tag);
    }

    private CallIdHeader createCallIdHeader() {
        return this.mSipProvider.getNewCallId();
    }

    private CSeqHeader createCSeqHeader(String method) throws ParseException, InvalidArgumentException {
        long sequence = (long)(Math.random() * 10000.0);
        return this.mHeaderFactory.createCSeqHeader(sequence, method);
    }

    private MaxForwardsHeader createMaxForwardsHeader() throws InvalidArgumentException {
        return this.mHeaderFactory.createMaxForwardsHeader(70);
    }

    private MaxForwardsHeader createMaxForwardsHeader(int max) throws InvalidArgumentException {
        return this.mHeaderFactory.createMaxForwardsHeader(max);
    }

    private ListeningPoint getListeningPoint() throws SipException {
        ListeningPoint[] lps;
        ListeningPoint lp = this.mSipProvider.getListeningPoint("UDP");
        if (lp == null) {
            lp = this.mSipProvider.getListeningPoint("TCP");
        }
        if (lp == null && (lps = this.mSipProvider.getListeningPoints()) != null && lps.length > 0) {
            lp = lps[0];
        }
        if (lp == null) {
            throw new SipException("no listening point is available");
        }
        return lp;
    }

    private List<ViaHeader> createViaHeaders() throws ParseException, SipException {
        ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>(1);
        ListeningPoint lp = this.getListeningPoint();
        ViaHeader viaHeader = this.mHeaderFactory.createViaHeader(lp.getIPAddress(), lp.getPort(), lp.getTransport(), null);
        viaHeader.setRPort();
        viaHeaders.add(viaHeader);
        return viaHeaders;
    }

    private ContactHeader createContactHeader(SipProfile profile) throws ParseException, SipException {
        ListeningPoint lp = this.getListeningPoint();
        SipURI contactURI = this.createSipUri(profile.getUserName(), profile.getProtocol(), lp);
        Address contactAddress = this.mAddressFactory.createAddress((URI)contactURI);
        contactAddress.setDisplayName(profile.getDisplayName());
        return this.mHeaderFactory.createContactHeader(contactAddress);
    }

    private ContactHeader createWildcardContactHeader() {
        ContactHeader contactHeader = this.mHeaderFactory.createContactHeader();
        contactHeader.setWildCard();
        return contactHeader;
    }

    private SipURI createSipUri(String username, String transport, ListeningPoint lp) throws ParseException {
        SipURI uri = this.mAddressFactory.createSipURI(username, lp.getIPAddress());
        try {
            uri.setPort(lp.getPort());
            uri.setTransportParam(transport);
        }
        catch (InvalidArgumentException e) {
            throw new RuntimeException(e);
        }
        return uri;
    }

    public ClientTransaction sendKeepAlive(SipProfile userProfile, String tag) throws SipException {
        try {
            Request request = this.createRequest("OPTIONS", userProfile, tag);
            ClientTransaction clientTransaction = this.mSipProvider.getNewClientTransaction(request);
            clientTransaction.sendRequest();
            return clientTransaction;
        }
        catch (Exception e) {
            throw new SipException("sendKeepAlive()", (Throwable)e);
        }
    }

    public ClientTransaction sendRegister(SipProfile userProfile, String tag, int expiry) throws SipException {
        try {
            Request request = this.createRequest("REGISTER", userProfile, tag);
            if (expiry == 0) {
                request.addHeader((Header)this.createWildcardContactHeader());
            } else {
                request.addHeader((Header)this.createContactHeader(userProfile));
            }
            request.addHeader((Header)this.mHeaderFactory.createExpiresHeader(expiry));
            ClientTransaction clientTransaction = this.mSipProvider.getNewClientTransaction(request);
            clientTransaction.sendRequest();
            return clientTransaction;
        }
        catch (ParseException e) {
            throw new SipException("sendRegister()", (Throwable)e);
        }
    }

    private Request createRequest(String requestType, SipProfile userProfile, String tag) throws ParseException, SipException {
        FromHeader fromHeader = this.createFromHeader(userProfile, tag);
        ToHeader toHeader = this.createToHeader(userProfile);
        SipURI requestURI = this.mAddressFactory.createSipURI(userProfile.getUriString().replaceFirst(userProfile.getUserName() + "@", ""));
        List<ViaHeader> viaHeaders = this.createViaHeaders();
        CallIdHeader callIdHeader = this.createCallIdHeader();
        CSeqHeader cSeqHeader = this.createCSeqHeader(requestType);
        MaxForwardsHeader maxForwards = this.createMaxForwardsHeader();
        Request request = this.mMessageFactory.createRequest((URI)requestURI, requestType, callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
        Header userAgentHeader = this.mHeaderFactory.createHeader("User-Agent", "SIPAUA/0.1.001");
        request.addHeader(userAgentHeader);
        return request;
    }

    public ClientTransaction handleChallenge(ResponseEvent responseEvent, AccountManager accountManager) throws SipException {
        AuthenticationHelper authenticationHelper = ((SipStackExt)this.mSipStack).getAuthenticationHelper(accountManager, this.mHeaderFactory);
        ClientTransaction tid = responseEvent.getClientTransaction();
        ClientTransaction ct = authenticationHelper.handleChallenge(responseEvent.getResponse(), tid, this.mSipProvider, 5);
        Log.d(TAG, "send request with challenge response: " + ct.getRequest());
        ct.sendRequest();
        return ct;
    }

    public ClientTransaction sendInvite(SipProfile caller, SipProfile callee, String sessionDescription, String tag) throws SipException {
        try {
            FromHeader fromHeader = this.createFromHeader(caller, tag);
            ToHeader toHeader = this.createToHeader(callee);
            SipURI requestURI = callee.getUri();
            List<ViaHeader> viaHeaders = this.createViaHeaders();
            CallIdHeader callIdHeader = this.createCallIdHeader();
            CSeqHeader cSeqHeader = this.createCSeqHeader("INVITE");
            MaxForwardsHeader maxForwards = this.createMaxForwardsHeader();
            Request request = this.mMessageFactory.createRequest((URI)requestURI, "INVITE", callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
            request.addHeader((Header)this.createContactHeader(caller));
            request.setContent((Object)sessionDescription, this.mHeaderFactory.createContentTypeHeader("application", "sdp"));
            ClientTransaction clientTransaction = this.mSipProvider.getNewClientTransaction(request);
            Log.d(TAG, "send INVITE: " + request);
            clientTransaction.sendRequest();
            return clientTransaction;
        }
        catch (ParseException e) {
            throw new SipException("sendInvite()", (Throwable)e);
        }
    }

    public ClientTransaction sendReinvite(Dialog dialog, String sessionDescription) throws SipException {
        try {
            Request request = dialog.createRequest("INVITE");
            request.setContent((Object)sessionDescription, this.mHeaderFactory.createContentTypeHeader("application", "sdp"));
            ClientTransaction clientTransaction = this.mSipProvider.getNewClientTransaction(request);
            Log.d(TAG, "send RE-INVITE: " + request);
            dialog.sendRequest(clientTransaction);
            return clientTransaction;
        }
        catch (ParseException e) {
            throw new SipException("sendReinvite()", (Throwable)e);
        }
    }

    private ServerTransaction getServerTransaction(RequestEvent event) throws SipException {
        ServerTransaction transaction = event.getServerTransaction();
        if (transaction == null) {
            Request request = event.getRequest();
            return this.mSipProvider.getNewServerTransaction(request);
        }
        return transaction;
    }

    public ServerTransaction sendRinging(RequestEvent event, String tag) throws SipException {
        try {
            Request request = event.getRequest();
            ServerTransaction transaction = this.getServerTransaction(event);
            Response response = this.mMessageFactory.createResponse(180, request);
            ToHeader toHeader = (ToHeader)response.getHeader("To");
            toHeader.setTag(tag);
            response.addHeader((Header)toHeader);
            Log.d(TAG, "send RINGING: " + response);
            transaction.sendResponse(response);
            return transaction;
        }
        catch (ParseException e) {
            throw new SipException("sendRinging()", (Throwable)e);
        }
    }

    public ServerTransaction sendInviteOk(RequestEvent event, SipProfile localProfile, String sessionDescription, ServerTransaction inviteTransaction) throws SipException {
        try {
            Request request = event.getRequest();
            Response response = this.mMessageFactory.createResponse(200, request);
            response.addHeader((Header)this.createContactHeader(localProfile));
            response.setContent((Object)sessionDescription, this.mHeaderFactory.createContentTypeHeader("application", "sdp"));
            if (inviteTransaction == null) {
                inviteTransaction = this.getServerTransaction(event);
            }
            if (inviteTransaction.getState() != TransactionState.COMPLETED) {
                Log.d(TAG, "send OK: " + response);
                inviteTransaction.sendResponse(response);
            }
            return inviteTransaction;
        }
        catch (ParseException e) {
            throw new SipException("sendInviteOk()", (Throwable)e);
        }
    }

    public void sendInviteBusyHere(RequestEvent event, ServerTransaction inviteTransaction) throws SipException {
        try {
            Request request = event.getRequest();
            Response response = this.mMessageFactory.createResponse(486, request);
            if (inviteTransaction == null) {
                inviteTransaction = this.getServerTransaction(event);
            }
            if (inviteTransaction.getState() != TransactionState.COMPLETED) {
                Log.d(TAG, "send BUSY HERE: " + response);
                inviteTransaction.sendResponse(response);
            }
        }
        catch (ParseException e) {
            throw new SipException("sendInviteBusyHere()", (Throwable)e);
        }
    }

    public void sendInviteAck(ResponseEvent event, Dialog dialog) throws SipException {
        Response response = event.getResponse();
        long cseq = ((CSeqHeader)response.getHeader("CSeq")).getSeqNumber();
        Request ack = dialog.createAck(cseq);
        Log.d(TAG, "send ACK: " + ack);
        dialog.sendAck(ack);
    }

    public void sendBye(Dialog dialog) throws SipException {
        Request byeRequest = dialog.createRequest("BYE");
        Log.d(TAG, "send BYE: " + byeRequest);
        dialog.sendRequest(this.mSipProvider.getNewClientTransaction(byeRequest));
    }

    public void sendCancel(ClientTransaction inviteTransaction) throws SipException {
        Request cancelRequest = inviteTransaction.createCancel();
        Log.d(TAG, "send CANCEL: " + cancelRequest);
        this.mSipProvider.getNewClientTransaction(cancelRequest).sendRequest();
    }

    public void sendResponse(RequestEvent event, int responseCode) throws SipException {
        try {
            Response response = this.mMessageFactory.createResponse(responseCode, event.getRequest());
            Log.d(TAG, "send response: " + response);
            this.getServerTransaction(event).sendResponse(response);
        }
        catch (ParseException e) {
            throw new SipException("sendResponse()", (Throwable)e);
        }
    }

    public void sendInviteRequestTerminated(Request inviteRequest, ServerTransaction inviteTransaction) throws SipException {
        try {
            Response response = this.mMessageFactory.createResponse(487, inviteRequest);
            Log.d(TAG, "send response: " + response);
            inviteTransaction.sendResponse(response);
        }
        catch (ParseException e) {
            throw new SipException("sendInviteRequestTerminated()", (Throwable)e);
        }
    }

    public static String getCallId(EventObject event) {
        if (event == null) {
            return null;
        }
        if (event instanceof RequestEvent) {
            return SipHelper.getCallId((Message)((RequestEvent)event).getRequest());
        }
        if (event instanceof ResponseEvent) {
            return SipHelper.getCallId((Message)((ResponseEvent)event).getResponse());
        }
        if (event instanceof DialogTerminatedEvent) {
            Dialog dialog = ((DialogTerminatedEvent)event).getDialog();
            return SipHelper.getCallId(((DialogTerminatedEvent)event).getDialog());
        }
        if (event instanceof TransactionTerminatedEvent) {
            TransactionTerminatedEvent e = (TransactionTerminatedEvent)event;
            return SipHelper.getCallId((Transaction)(e.isServerTransaction() ? e.getServerTransaction() : e.getClientTransaction()));
        }
        Object source = event.getSource();
        if (source instanceof Transaction) {
            return SipHelper.getCallId((Transaction)source);
        }
        if (source instanceof Dialog) {
            return SipHelper.getCallId((Dialog)source);
        }
        return "";
    }

    public static String getCallId(Transaction transaction) {
        return transaction != null ? SipHelper.getCallId((Message)transaction.getRequest()) : "";
    }

    private static String getCallId(Message message) {
        CallIdHeader callIdHeader = (CallIdHeader)message.getHeader("Call-ID");
        return callIdHeader.getCallId();
    }

    private static String getCallId(Dialog dialog) {
        return dialog.getCallId().getCallId();
    }
}

