/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.Log;
import android.view.InputDevice;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import java.util.ArrayList;

public class PointerLocationView
extends View {
    private static final String TAG = "Pointer";
    private final ViewConfiguration mVC;
    private final Paint mTextPaint;
    private final Paint mTextBackgroundPaint;
    private final Paint mTextLevelPaint;
    private final Paint mPaint;
    private final Paint mTargetPaint;
    private final Paint mPathPaint;
    private final Paint.FontMetricsInt mTextMetrics = new Paint.FontMetricsInt();
    private int mHeaderBottom;
    private boolean mCurDown;
    private int mCurNumPointers;
    private int mMaxNumPointers;
    private int mActivePointerId;
    private final ArrayList<PointerState> mPointers = new ArrayList();
    private final VelocityTracker mVelocity;
    private final FasterStringBuilder mText = new FasterStringBuilder();
    private boolean mPrintCoords = true;
    private RectF mReusableOvalRect = new RectF();

    public PointerLocationView(Context c) {
        super(c);
        this.setFocusable(true);
        this.mVC = ViewConfiguration.get(c);
        this.mTextPaint = new Paint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextSize(10.0f * this.getResources().getDisplayMetrics().density);
        this.mTextPaint.setARGB(255, 0, 0, 0);
        this.mTextBackgroundPaint = new Paint();
        this.mTextBackgroundPaint.setAntiAlias(false);
        this.mTextBackgroundPaint.setARGB(128, 255, 255, 255);
        this.mTextLevelPaint = new Paint();
        this.mTextLevelPaint.setAntiAlias(false);
        this.mTextLevelPaint.setARGB(192, 255, 0, 0);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setARGB(255, 255, 255, 255);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(2.0f);
        this.mTargetPaint = new Paint();
        this.mTargetPaint.setAntiAlias(false);
        this.mTargetPaint.setARGB(255, 0, 0, 192);
        this.mPathPaint = new Paint();
        this.mPathPaint.setAntiAlias(false);
        this.mPathPaint.setARGB(255, 0, 96, 255);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(1.0f);
        PointerState ps = new PointerState();
        this.mPointers.add(ps);
        this.mActivePointerId = 0;
        this.mVelocity = VelocityTracker.obtain();
        this.logInputDeviceCapabilities();
    }

    private void logInputDeviceCapabilities() {
        int[] deviceIds = InputDevice.getDeviceIds();
        for (int i = 0; i < deviceIds.length; ++i) {
            InputDevice device = InputDevice.getDevice(deviceIds[i]);
            if (device == null) continue;
            Log.i(TAG, device.toString());
        }
    }

    public void setPrintCoords(boolean state) {
        this.mPrintCoords = state;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mTextPaint.getFontMetricsInt(this.mTextMetrics);
        this.mHeaderBottom = -this.mTextMetrics.ascent + this.mTextMetrics.descent + 2;
    }

    private void drawOval(Canvas canvas, float x, float y, float major, float minor, float angle, Paint paint) {
        canvas.save(1);
        canvas.rotate((float)((double)(angle * 180.0f) / Math.PI), x, y);
        this.mReusableOvalRect.left = x - minor / 2.0f;
        this.mReusableOvalRect.right = x + minor / 2.0f;
        this.mReusableOvalRect.top = y - major / 2.0f;
        this.mReusableOvalRect.bottom = y + major / 2.0f;
        canvas.drawOval(this.mReusableOvalRect, paint);
        canvas.restore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDraw(Canvas canvas) {
        ArrayList<PointerState> arrayList = this.mPointers;
        synchronized (arrayList) {
            int w = this.getWidth();
            int itemW = w / 7;
            int base = -this.mTextMetrics.ascent + 1;
            int bottom = this.mHeaderBottom;
            int NP = this.mPointers.size();
            if (this.mActivePointerId >= 0) {
                PointerState ps = this.mPointers.get(this.mActivePointerId);
                canvas.drawRect(0.0f, 0.0f, itemW - 1, bottom, this.mTextBackgroundPaint);
                canvas.drawText(this.mText.clear().append("P: ").append(this.mCurNumPointers).append(" / ").append(this.mMaxNumPointers).toString(), 1.0f, base, this.mTextPaint);
                int N = ps.mTraceCount;
                if (this.mCurDown && ps.mCurDown || N == 0) {
                    canvas.drawRect(itemW, 0.0f, itemW * 2 - 1, bottom, this.mTextBackgroundPaint);
                    canvas.drawText(this.mText.clear().append("X: ").append(((PointerState)ps).mCoords.x, 1).toString(), 1 + itemW, base, this.mTextPaint);
                    canvas.drawRect(itemW * 2, 0.0f, itemW * 3 - 1, bottom, this.mTextBackgroundPaint);
                    canvas.drawText(this.mText.clear().append("Y: ").append(((PointerState)ps).mCoords.y, 1).toString(), 1 + itemW * 2, base, this.mTextPaint);
                } else {
                    float dx = ps.mTraceX[N - 1] - ps.mTraceX[0];
                    float dy = ps.mTraceY[N - 1] - ps.mTraceY[0];
                    canvas.drawRect(itemW, 0.0f, itemW * 2 - 1, bottom, Math.abs(dx) < (float)this.mVC.getScaledTouchSlop() ? this.mTextBackgroundPaint : this.mTextLevelPaint);
                    canvas.drawText(this.mText.clear().append("dX: ").append(dx, 1).toString(), 1 + itemW, base, this.mTextPaint);
                    canvas.drawRect(itemW * 2, 0.0f, itemW * 3 - 1, bottom, Math.abs(dy) < (float)this.mVC.getScaledTouchSlop() ? this.mTextBackgroundPaint : this.mTextLevelPaint);
                    canvas.drawText(this.mText.clear().append("dY: ").append(dy, 1).toString(), 1 + itemW * 2, base, this.mTextPaint);
                }
                canvas.drawRect(itemW * 3, 0.0f, itemW * 4 - 1, bottom, this.mTextBackgroundPaint);
                canvas.drawText(this.mText.clear().append("Xv: ").append(ps.mXVelocity, 3).toString(), 1 + itemW * 3, base, this.mTextPaint);
                canvas.drawRect(itemW * 4, 0.0f, itemW * 5 - 1, bottom, this.mTextBackgroundPaint);
                canvas.drawText(this.mText.clear().append("Yv: ").append(ps.mYVelocity, 3).toString(), 1 + itemW * 4, base, this.mTextPaint);
                canvas.drawRect(itemW * 5, 0.0f, itemW * 6 - 1, bottom, this.mTextBackgroundPaint);
                canvas.drawRect(itemW * 5, 0.0f, (float)(itemW * 5) + ((PointerState)ps).mCoords.pressure * (float)itemW - 1.0f, bottom, this.mTextLevelPaint);
                canvas.drawText(this.mText.clear().append("Prs: ").append(((PointerState)ps).mCoords.pressure, 2).toString(), 1 + itemW * 5, base, this.mTextPaint);
                canvas.drawRect(itemW * 6, 0.0f, w, bottom, this.mTextBackgroundPaint);
                canvas.drawRect(itemW * 6, 0.0f, (float)(itemW * 6) + ((PointerState)ps).mCoords.size * (float)itemW - 1.0f, bottom, this.mTextLevelPaint);
                canvas.drawText(this.mText.clear().append("Size: ").append(((PointerState)ps).mCoords.size, 2).toString(), 1 + itemW * 6, base, this.mTextPaint);
            }
            for (int p = 0; p < NP; ++p) {
                PointerState ps = this.mPointers.get(p);
                int N = ps.mTraceCount;
                float lastX = 0.0f;
                float lastY = 0.0f;
                boolean haveLast = false;
                boolean drawn = false;
                this.mPaint.setARGB(255, 128, 255, 255);
                for (int i = 0; i < N; ++i) {
                    float x = ps.mTraceX[i];
                    float y = ps.mTraceY[i];
                    if (Float.isNaN(x)) {
                        haveLast = false;
                        continue;
                    }
                    if (haveLast) {
                        canvas.drawLine(lastX, lastY, x, y, this.mPathPaint);
                        canvas.drawPoint(lastX, lastY, this.mPaint);
                        drawn = true;
                    }
                    lastX = x;
                    lastY = y;
                    haveLast = true;
                }
                if (drawn) {
                    this.mPaint.setARGB(255, 255, 64, 128);
                    float xVel = ps.mXVelocity * 16.0f;
                    float yVel = ps.mYVelocity * 16.0f;
                    canvas.drawLine(lastX, lastY, lastX + xVel, lastY + yVel, this.mPaint);
                }
                if (!this.mCurDown || !ps.mCurDown) continue;
                canvas.drawLine(0.0f, ((PointerState)ps).mCoords.y, this.getWidth(), ((PointerState)ps).mCoords.y, this.mTargetPaint);
                canvas.drawLine(((PointerState)ps).mCoords.x, 0.0f, ((PointerState)ps).mCoords.x, this.getHeight(), this.mTargetPaint);
                int pressureLevel = (int)(((PointerState)ps).mCoords.pressure * 255.0f);
                this.mPaint.setARGB(255, pressureLevel, 255, 255 - pressureLevel);
                canvas.drawPoint(((PointerState)ps).mCoords.x, ((PointerState)ps).mCoords.y, this.mPaint);
                this.mPaint.setARGB(255, pressureLevel, 255 - pressureLevel, 128);
                this.drawOval(canvas, ((PointerState)ps).mCoords.x, ((PointerState)ps).mCoords.y, ((PointerState)ps).mCoords.touchMajor, ((PointerState)ps).mCoords.touchMinor, ((PointerState)ps).mCoords.orientation, this.mPaint);
                this.mPaint.setARGB(255, pressureLevel, 128, 255 - pressureLevel);
                this.drawOval(canvas, ((PointerState)ps).mCoords.x, ((PointerState)ps).mCoords.y, ((PointerState)ps).mCoords.toolMajor, ((PointerState)ps).mCoords.toolMinor, ((PointerState)ps).mCoords.orientation, this.mPaint);
            }
        }
    }

    private void logPointerCoords(MotionEvent.PointerCoords coords, int id2) {
        Log.i(TAG, this.mText.clear().append("Pointer ").append(id2 + 1).append(": (").append(coords.x, 3).append(", ").append(coords.y, 3).append(") Pressure=").append(coords.pressure, 3).append(" Size=").append(coords.size, 3).append(" TouchMajor=").append(coords.touchMajor, 3).append(" TouchMinor=").append(coords.touchMinor, 3).append(" ToolMajor=").append(coords.toolMajor, 3).append(" ToolMinor=").append(coords.toolMinor, 3).append(" Orientation=").append((float)((double)(coords.orientation * 180.0f) / Math.PI), 1).append("deg").toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTouchEvent(MotionEvent event) {
        ArrayList<PointerState> arrayList = this.mPointers;
        synchronized (arrayList) {
            PointerState ps;
            int action = event.getAction();
            int NP = this.mPointers.size();
            if (action == 0 || (action & 0xFF) == 5) {
                PointerState ps2;
                int index = (action & 0xFF00) >> 8;
                if (action == 0) {
                    for (int p = 0; p < NP; ++p) {
                        ps2 = this.mPointers.get(p);
                        ps2.clearTrace();
                        ps2.mCurDown = false;
                    }
                    this.mCurDown = true;
                    this.mMaxNumPointers = 0;
                    this.mVelocity.clear();
                }
                int id2 = event.getPointerId(index);
                while (NP <= id2) {
                    ps2 = new PointerState();
                    this.mPointers.add(ps2);
                    ++NP;
                }
                if (this.mActivePointerId < 0 || !this.mPointers.get(this.mActivePointerId).mCurDown) {
                    this.mActivePointerId = id2;
                }
                ps2 = this.mPointers.get(id2);
                ps2.mCurDown = true;
                if (this.mPrintCoords) {
                    Log.i(TAG, this.mText.clear().append("Pointer ").append(id2 + 1).append(": DOWN").toString());
                }
            }
            int NI = event.getPointerCount();
            this.mCurDown = action != 1 && action != 3;
            int n = this.mCurNumPointers = this.mCurDown ? NI : 0;
            if (this.mMaxNumPointers < this.mCurNumPointers) {
                this.mMaxNumPointers = this.mCurNumPointers;
            }
            this.mVelocity.addMovement(event);
            this.mVelocity.computeCurrentVelocity(1);
            for (int i = 0; i < NI; ++i) {
                int id3 = event.getPointerId(i);
                ps = this.mPointers.get(id3);
                int N = event.getHistorySize();
                for (int j = 0; j < N; ++j) {
                    event.getHistoricalPointerCoords(i, j, ps.mCoords);
                    if (this.mPrintCoords) {
                        this.logPointerCoords(ps.mCoords, id3);
                    }
                    ps.addTrace(event.getHistoricalX(i, j), event.getHistoricalY(i, j));
                }
                event.getPointerCoords(i, ps.mCoords);
                if (this.mPrintCoords) {
                    this.logPointerCoords(ps.mCoords, id3);
                }
                ps.addTrace(((PointerState)ps).mCoords.x, ((PointerState)ps).mCoords.y);
                ps.mXVelocity = this.mVelocity.getXVelocity(id3);
                ps.mYVelocity = this.mVelocity.getYVelocity(id3);
            }
            if (action == 1 || action == 3 || (action & 0xFF) == 6) {
                int index = (action & 0xFF00) >> 8;
                int id4 = event.getPointerId(index);
                ps = this.mPointers.get(id4);
                ps.mCurDown = false;
                if (this.mPrintCoords) {
                    Log.i(TAG, this.mText.clear().append("Pointer ").append(id4 + 1).append(": UP").toString());
                }
                if (action == 1 || action == 3) {
                    this.mCurDown = false;
                } else {
                    if (this.mActivePointerId == id4) {
                        this.mActivePointerId = event.getPointerId(index == 0 ? 1 : 0);
                    }
                    ps.addTrace(Float.NaN, Float.NaN);
                }
            }
            this.postInvalidate();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.addTouchEvent(event);
        return true;
    }

    public boolean onTrackballEvent(MotionEvent event) {
        Log.i(TAG, "Trackball: " + event);
        return super.onTrackballEvent(event);
    }

    private static final class FasterStringBuilder {
        private char[] mChars = new char[64];
        private int mLength;

        public FasterStringBuilder clear() {
            this.mLength = 0;
            return this;
        }

        public FasterStringBuilder append(String value) {
            int valueLength = value.length();
            int index = this.reserve(valueLength);
            value.getChars(0, valueLength, this.mChars, index);
            this.mLength += valueLength;
            return this;
        }

        public FasterStringBuilder append(int value) {
            return this.append(value, 0);
        }

        public FasterStringBuilder append(int value, int zeroPadWidth) {
            int divisor;
            boolean negative;
            boolean bl = negative = value < 0;
            if (negative && (value = -value) < 0) {
                this.append("-2147483648");
                return this;
            }
            int index = this.reserve(11);
            char[] chars = this.mChars;
            if (value == 0) {
                chars[index++] = 48;
                ++this.mLength;
                return this;
            }
            if (negative) {
                chars[index++] = 45;
            }
            int numberWidth = 10;
            for (divisor = 1000000000; value < divisor; divisor /= 10) {
                if (--numberWidth >= zeroPadWidth) continue;
                chars[index++] = 48;
            }
            do {
                int digit = value / divisor;
                value -= digit * divisor;
                chars[index++] = (char)(digit + 48);
            } while ((divisor /= 10) != 0);
            this.mLength = index;
            return this;
        }

        public FasterStringBuilder append(float value, int precision) {
            int scale = 1;
            for (int i = 0; i < precision; ++i) {
                scale *= 10;
            }
            value = (float)(Math.rint(value * (float)scale) / (double)scale);
            this.append((int)value);
            if (precision != 0) {
                this.append(".");
                value = Math.abs(value);
                value = (float)((double)value - Math.floor(value));
                this.append((int)(value * (float)scale), precision);
            }
            return this;
        }

        public String toString() {
            return new String(this.mChars, 0, this.mLength);
        }

        private int reserve(int length) {
            int oldLength = this.mLength;
            int newLength = this.mLength + length;
            char[] oldChars = this.mChars;
            int oldCapacity = oldChars.length;
            if (newLength > oldCapacity) {
                int newCapacity = oldCapacity * 2;
                char[] newChars = new char[newCapacity];
                System.arraycopy(oldChars, 0, newChars, 0, oldLength);
                this.mChars = newChars;
            }
            return oldLength;
        }
    }

    public static class PointerState {
        private float[] mTraceX = new float[32];
        private float[] mTraceY = new float[32];
        private int mTraceCount;
        private boolean mCurDown;
        private MotionEvent.PointerCoords mCoords = new MotionEvent.PointerCoords();
        private float mXVelocity;
        private float mYVelocity;

        public void clearTrace() {
            this.mTraceCount = 0;
        }

        public void addTrace(float x, float y) {
            int traceCapacity = this.mTraceX.length;
            if (this.mTraceCount == traceCapacity) {
                float[] newTraceX = new float[traceCapacity *= 2];
                System.arraycopy(this.mTraceX, 0, newTraceX, 0, this.mTraceCount);
                this.mTraceX = newTraceX;
                float[] newTraceY = new float[traceCapacity];
                System.arraycopy(this.mTraceY, 0, newTraceY, 0, this.mTraceCount);
                this.mTraceY = newTraceY;
            }
            this.mTraceX[this.mTraceCount] = x;
            this.mTraceY[this.mTraceCount] = y;
            ++this.mTraceCount;
        }
    }
}

