/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.Message;
import com.android.internal.util.HierarchicalState;
import java.util.Vector;

public class ProcessedMessages {
    public static final int DEFAULT_SIZE = 20;
    private Vector<Info> mMessages = new Vector();
    private int mMaxSize = 20;
    private int mOldestIndex = 0;
    private int mCount = 0;

    ProcessedMessages() {
    }

    ProcessedMessages(int maxSize) {
        this.setSize(maxSize);
    }

    void setSize(int maxSize) {
        this.mMaxSize = maxSize;
        this.mCount = 0;
        this.mMessages.clear();
    }

    int size() {
        return this.mMessages.size();
    }

    int count() {
        return this.mCount;
    }

    Info get(int index) {
        int nextIndex = this.mOldestIndex + index;
        if (nextIndex >= this.mMaxSize) {
            nextIndex -= this.mMaxSize;
        }
        if (nextIndex >= this.size()) {
            return null;
        }
        return this.mMessages.get(nextIndex);
    }

    void add(Message message, HierarchicalState state, HierarchicalState orgState) {
        ++this.mCount;
        if (this.mMessages.size() < this.mMaxSize) {
            this.mMessages.add(new Info(message, state, orgState));
        } else {
            Info info = this.mMessages.get(this.mOldestIndex);
            ++this.mOldestIndex;
            if (this.mOldestIndex >= this.mMaxSize) {
                this.mOldestIndex = 0;
            }
            info.update(message, state, orgState);
        }
    }

    public class Info {
        private int what;
        private HierarchicalState state;
        private HierarchicalState orgState;

        Info(Message message, HierarchicalState state, HierarchicalState orgState) {
            this.update(message, state, orgState);
        }

        public void update(Message message, HierarchicalState state, HierarchicalState orgState) {
            this.what = message.what;
            this.state = state;
            this.orgState = orgState;
        }

        public int getWhat() {
            return this.what;
        }

        public HierarchicalState getState() {
            return this.state;
        }

        public HierarchicalState getOriginalState() {
            return this.orgState;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("what=");
            sb.append(this.what);
            sb.append(" state=");
            sb.append(this.cn(this.state));
            sb.append(" orgState=");
            sb.append(this.cn(this.orgState));
            return sb.toString();
        }

        private String cn(Object n) {
            if (n == null) {
                return "null";
            }
            String name = n.getClass().getName();
            int lastDollar = name.lastIndexOf(36);
            return name.substring(lastDollar + 1);
        }
    }
}

