/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.sip;

import android.net.sip.SipAudioCall;
import android.os.SystemClock;
import android.telephony.PhoneNumberUtils;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;

abstract class SipConnectionBase
extends Connection {
    private static final String LOG_TAG = "SIP_CONN";
    private SipAudioCall mSipAudioCall;
    private String dialString;
    private String postDialString;
    private int nextPostDialChar;
    private boolean isIncoming;
    private long createTime;
    private long connectTime;
    private long disconnectTime;
    private long connectTimeReal;
    private long duration = -1L;
    private long holdingStartTime;
    private Connection.DisconnectCause mCause = Connection.DisconnectCause.NOT_DISCONNECTED;
    private Connection.PostDialState postDialState = Connection.PostDialState.NOT_STARTED;

    SipConnectionBase(String dialString) {
        this.dialString = dialString;
        this.postDialString = PhoneNumberUtils.extractPostDialPortion(dialString);
        this.isIncoming = false;
        this.createTime = System.currentTimeMillis();
    }

    protected void setState(Call.State state) {
        switch (state) {
            case ACTIVE: {
                if (this.connectTime != 0L) break;
                this.connectTimeReal = SystemClock.elapsedRealtime();
                this.connectTime = System.currentTimeMillis();
                break;
            }
            case DISCONNECTED: {
                this.duration = this.getDurationMillis();
                this.disconnectTime = System.currentTimeMillis();
                break;
            }
            case HOLDING: {
                this.holdingStartTime = SystemClock.elapsedRealtime();
            }
        }
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public long getDisconnectTime() {
        return this.disconnectTime;
    }

    public long getDurationMillis() {
        if (this.connectTimeReal == 0L) {
            return 0L;
        }
        if (this.duration < 0L) {
            return SystemClock.elapsedRealtime() - this.connectTimeReal;
        }
        return this.duration;
    }

    public long getHoldDurationMillis() {
        if (this.getState() != Call.State.HOLDING) {
            return 0L;
        }
        return SystemClock.elapsedRealtime() - this.holdingStartTime;
    }

    public Connection.DisconnectCause getDisconnectCause() {
        return this.mCause;
    }

    void setDisconnectCause(Connection.DisconnectCause cause) {
        this.mCause = cause;
    }

    public Connection.PostDialState getPostDialState() {
        return this.postDialState;
    }

    public void proceedAfterWaitChar() {
    }

    public void proceedAfterWildChar(String str) {
    }

    public void cancelPostDial() {
    }

    protected abstract Phone getPhone();

    public String getRemainingPostDialString() {
        if (this.postDialState == Connection.PostDialState.CANCELLED || this.postDialState == Connection.PostDialState.COMPLETE || this.postDialString == null || this.postDialString.length() <= this.nextPostDialChar) {
            return "";
        }
        return this.postDialString.substring(this.nextPostDialChar);
    }

    private void log(String msg) {
        Log.d(LOG_TAG, "[SipConn] " + msg);
    }

    public int getNumberPresentation() {
        return Connection.PRESENTATION_ALLOWED;
    }
}

