/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.SystemClock;
import android.telephony.PhoneNumberUtils;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.GsmCall;
import com.android.internal.telephony.gsm.GsmCallTracker;

public class GsmConnection
extends Connection {
    static final String LOG_TAG = "GSM";
    GsmCallTracker owner;
    GsmCall parent;
    String address;
    String dialString;
    String postDialString;
    boolean isIncoming;
    boolean disconnected;
    int index;
    long createTime;
    long connectTime;
    long disconnectTime;
    long connectTimeReal;
    long duration;
    long holdingStartTime;
    int nextPostDialChar;
    Connection.DisconnectCause cause = Connection.DisconnectCause.NOT_DISCONNECTED;
    Connection.PostDialState postDialState = Connection.PostDialState.NOT_STARTED;
    int numberPresentation = Connection.PRESENTATION_ALLOWED;
    UUSInfo uusInfo;
    Handler h;
    private PowerManager.WakeLock mPartialWakeLock;
    static final int EVENT_DTMF_DONE = 1;
    static final int EVENT_PAUSE_DONE = 2;
    static final int EVENT_NEXT_POST_DIAL = 3;
    static final int EVENT_WAKE_LOCK_TIMEOUT = 4;
    static final int PAUSE_DELAY_FIRST_MILLIS = 100;
    static final int PAUSE_DELAY_MILLIS = 3000;
    static final int WAKE_LOCK_TIMEOUT_MILLIS = 60000;

    GsmConnection(Context context, DriverCall dc, GsmCallTracker ct, int index) {
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.owner = ct;
        this.h = new MyHandler(this.owner.getLooper());
        this.address = dc.number;
        this.isIncoming = dc.isMT;
        this.createTime = System.currentTimeMillis();
        this.numberPresentation = dc.numberPresentation;
        this.uusInfo = dc.uusInfo;
        this.index = index;
        this.parent = this.parentFromDCState(dc.state);
        this.parent.attach(this, dc);
    }

    GsmConnection(Context context, String dialString, GsmCallTracker ct, GsmCall parent) {
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.owner = ct;
        this.h = new MyHandler(this.owner.getLooper());
        this.dialString = dialString;
        this.address = PhoneNumberUtils.extractNetworkPortionAlt(dialString);
        this.postDialString = PhoneNumberUtils.extractPostDialPortion(dialString);
        this.index = -1;
        this.isIncoming = false;
        this.createTime = System.currentTimeMillis();
        this.parent = parent;
        parent.attachFake(this, Call.State.DIALING);
    }

    public void dispose() {
    }

    static boolean equalsHandlesNulls(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    boolean compareTo(DriverCall c) {
        if (!this.isIncoming && !c.isMT) {
            return true;
        }
        String cAddress = PhoneNumberUtils.stringFromStringAndTOA(c.number, c.TOA);
        return this.isIncoming == c.isMT && GsmConnection.equalsHandlesNulls(this.address, cAddress);
    }

    public String getAddress() {
        return this.address;
    }

    public GsmCall getCall() {
        return this.parent;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public long getDisconnectTime() {
        return this.disconnectTime;
    }

    public long getDurationMillis() {
        if (this.connectTimeReal == 0L) {
            return 0L;
        }
        if (this.duration == 0L) {
            return SystemClock.elapsedRealtime() - this.connectTimeReal;
        }
        return this.duration;
    }

    public long getHoldDurationMillis() {
        if (this.getState() != Call.State.HOLDING) {
            return 0L;
        }
        return SystemClock.elapsedRealtime() - this.holdingStartTime;
    }

    public Connection.DisconnectCause getDisconnectCause() {
        return this.cause;
    }

    public boolean isIncoming() {
        return this.isIncoming;
    }

    public Call.State getState() {
        if (this.disconnected) {
            return Call.State.DISCONNECTED;
        }
        return super.getState();
    }

    public void hangup() throws CallStateException {
        if (this.disconnected) {
            throw new CallStateException("disconnected");
        }
        this.owner.hangup(this);
    }

    public void separate() throws CallStateException {
        if (this.disconnected) {
            throw new CallStateException("disconnected");
        }
        this.owner.separate(this);
    }

    public Connection.PostDialState getPostDialState() {
        return this.postDialState;
    }

    public void proceedAfterWaitChar() {
        if (this.postDialState != Connection.PostDialState.WAIT) {
            Log.w(LOG_TAG, "GsmConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WAIT but was " + (Object)((Object)this.postDialState));
            return;
        }
        this.setPostDialState(Connection.PostDialState.STARTED);
        this.processNextPostDialChar();
    }

    public void proceedAfterWildChar(String str) {
        if (this.postDialState != Connection.PostDialState.WILD) {
            Log.w(LOG_TAG, "GsmConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WILD but was " + (Object)((Object)this.postDialState));
            return;
        }
        this.setPostDialState(Connection.PostDialState.STARTED);
        StringBuilder buf = new StringBuilder(str);
        buf.append(this.postDialString.substring(this.nextPostDialChar));
        this.postDialString = buf.toString();
        this.nextPostDialChar = 0;
        this.log("proceedAfterWildChar: new postDialString is " + this.postDialString);
        this.processNextPostDialChar();
    }

    public void cancelPostDial() {
        this.setPostDialState(Connection.PostDialState.CANCELLED);
    }

    void onHangupLocal() {
        this.cause = Connection.DisconnectCause.LOCAL;
    }

    Connection.DisconnectCause disconnectCauseFromCode(int causeCode) {
        switch (causeCode) {
            case 17: {
                return Connection.DisconnectCause.BUSY;
            }
            case 34: 
            case 41: 
            case 42: 
            case 44: 
            case 49: 
            case 58: {
                return Connection.DisconnectCause.CONGESTION;
            }
            case 68: {
                return Connection.DisconnectCause.LIMIT_EXCEEDED;
            }
            case 240: {
                return Connection.DisconnectCause.CALL_BARRED;
            }
            case 241: {
                return Connection.DisconnectCause.FDN_BLOCKED;
            }
            case 1: {
                return Connection.DisconnectCause.UNOBTAINABLE_NUMBER;
            }
        }
        GSMPhone phone = this.owner.phone;
        int serviceState = phone.getServiceState().getState();
        if (serviceState == 3) {
            return Connection.DisconnectCause.POWER_OFF;
        }
        if (serviceState == 1 || serviceState == 2) {
            return Connection.DisconnectCause.OUT_OF_SERVICE;
        }
        if (phone.getIccCard().getState() != IccCard.State.READY) {
            return Connection.DisconnectCause.ICC_ERROR;
        }
        if (causeCode == 65535) {
            if (phone.mSST.rs.isCsRestricted()) {
                return Connection.DisconnectCause.CS_RESTRICTED;
            }
            if (phone.mSST.rs.isCsEmergencyRestricted()) {
                return Connection.DisconnectCause.CS_RESTRICTED_EMERGENCY;
            }
            if (phone.mSST.rs.isCsNormalRestricted()) {
                return Connection.DisconnectCause.CS_RESTRICTED_NORMAL;
            }
            return Connection.DisconnectCause.ERROR_UNSPECIFIED;
        }
        if (causeCode == 16) {
            return Connection.DisconnectCause.NORMAL;
        }
        return Connection.DisconnectCause.ERROR_UNSPECIFIED;
    }

    void onRemoteDisconnect(int causeCode) {
        this.onDisconnect(this.disconnectCauseFromCode(causeCode));
    }

    void onDisconnect(Connection.DisconnectCause cause) {
        this.cause = cause;
        if (!this.disconnected) {
            this.index = -1;
            this.disconnectTime = System.currentTimeMillis();
            this.duration = SystemClock.elapsedRealtime() - this.connectTimeReal;
            this.disconnected = true;
            Log.d(LOG_TAG, "[GSMConn] onDisconnect: cause=" + (Object)((Object)cause));
            this.owner.phone.notifyDisconnect(this);
            if (this.parent != null) {
                this.parent.connectionDisconnected(this);
            }
        }
        this.releaseWakeLock();
    }

    boolean update(DriverCall dc) {
        boolean changed = false;
        boolean wasConnectingInOrOut = this.isConnectingInOrOut();
        boolean wasHolding = this.getState() == Call.State.HOLDING;
        GsmCall newParent = this.parentFromDCState(dc.state);
        if (!GsmConnection.equalsHandlesNulls(this.address, dc.number)) {
            this.log("update: phone # changed!");
            this.address = dc.number;
            changed = true;
        }
        if (newParent != this.parent) {
            if (this.parent != null) {
                this.parent.detach(this);
            }
            newParent.attach(this, dc);
            this.parent = newParent;
            changed = true;
        } else {
            boolean parentStateChange = this.parent.update(this, dc);
            changed = changed || parentStateChange;
        }
        this.log("update: parent=" + this.parent + ", hasNewParent=" + (newParent != this.parent) + ", wasConnectingInOrOut=" + wasConnectingInOrOut + ", wasHolding=" + wasHolding + ", isConnectingInOrOut=" + this.isConnectingInOrOut() + ", changed=" + changed);
        if (wasConnectingInOrOut && !this.isConnectingInOrOut()) {
            this.onConnectedInOrOut();
        }
        if (changed && !wasHolding && this.getState() == Call.State.HOLDING) {
            this.onStartedHolding();
        }
        return changed;
    }

    void fakeHoldBeforeDial() {
        if (this.parent != null) {
            this.parent.detach(this);
        }
        this.parent = this.owner.backgroundCall;
        this.parent.attachFake(this, Call.State.HOLDING);
        this.onStartedHolding();
    }

    int getGSMIndex() throws CallStateException {
        if (this.index >= 0) {
            return this.index + 1;
        }
        throw new CallStateException("GSM index not yet assigned");
    }

    void onConnectedInOrOut() {
        this.connectTime = System.currentTimeMillis();
        this.connectTimeReal = SystemClock.elapsedRealtime();
        this.duration = 0L;
        this.log("onConnectedInOrOut: connectTime=" + this.connectTime);
        if (!this.isIncoming) {
            this.processNextPostDialChar();
        }
        this.releaseWakeLock();
    }

    private void onStartedHolding() {
        this.holdingStartTime = SystemClock.elapsedRealtime();
    }

    private boolean processPostDialChar(char c) {
        if (PhoneNumberUtils.is12Key(c)) {
            this.owner.cm.sendDtmf(c, this.h.obtainMessage(1));
        } else if (c == ',') {
            if (this.nextPostDialChar == 1) {
                this.h.sendMessageDelayed(this.h.obtainMessage(2), 100L);
            } else {
                this.h.sendMessageDelayed(this.h.obtainMessage(2), 3000L);
            }
        } else if (c == ';') {
            this.setPostDialState(Connection.PostDialState.WAIT);
        } else if (c == 'N') {
            this.setPostDialState(Connection.PostDialState.WILD);
        } else {
            return false;
        }
        return true;
    }

    public String getRemainingPostDialString() {
        if (this.postDialState == Connection.PostDialState.CANCELLED || this.postDialState == Connection.PostDialState.COMPLETE || this.postDialString == null || this.postDialString.length() <= this.nextPostDialChar) {
            return "";
        }
        return this.postDialString.substring(this.nextPostDialChar);
    }

    protected void finalize() {
        if (this.mPartialWakeLock.isHeld()) {
            Log.e(LOG_TAG, "[GSMConn] UNEXPECTED; mPartialWakeLock is held when finalizing.");
        }
        this.releaseWakeLock();
    }

    private void processNextPostDialChar() {
        Message notifyMessage;
        char c = '\u0000';
        if (this.postDialState == Connection.PostDialState.CANCELLED) {
            return;
        }
        if (this.postDialString == null || this.postDialString.length() <= this.nextPostDialChar) {
            this.setPostDialState(Connection.PostDialState.COMPLETE);
            c = '\u0000';
        } else {
            this.setPostDialState(Connection.PostDialState.STARTED);
            c = this.postDialString.charAt(this.nextPostDialChar++);
            boolean isValid = this.processPostDialChar(c);
            if (!isValid) {
                this.h.obtainMessage(3).sendToTarget();
                Log.e(LOG_TAG, "processNextPostDialChar: c=" + c + " isn't valid!");
                return;
            }
        }
        Registrant postDialHandler = this.owner.phone.mPostDialHandler;
        if (postDialHandler != null && (notifyMessage = postDialHandler.messageForRegistrant()) != null) {
            Connection.PostDialState state = this.postDialState;
            AsyncResult ar = AsyncResult.forMessage(notifyMessage);
            ar.result = this;
            ar.userObj = state;
            notifyMessage.arg1 = c;
            notifyMessage.sendToTarget();
        }
    }

    private boolean isConnectingInOrOut() {
        return this.parent == null || this.parent == this.owner.ringingCall || this.parent.state == Call.State.DIALING || this.parent.state == Call.State.ALERTING;
    }

    private GsmCall parentFromDCState(DriverCall.State state) {
        switch (state) {
            case ACTIVE: 
            case DIALING: 
            case ALERTING: {
                return this.owner.foregroundCall;
            }
            case HOLDING: {
                return this.owner.backgroundCall;
            }
            case INCOMING: 
            case WAITING: {
                return this.owner.ringingCall;
            }
        }
        throw new RuntimeException("illegal call state: " + (Object)((Object)state));
    }

    private void setPostDialState(Connection.PostDialState s) {
        if (this.postDialState != Connection.PostDialState.STARTED && s == Connection.PostDialState.STARTED) {
            this.acquireWakeLock();
            Message msg = this.h.obtainMessage(4);
            this.h.sendMessageDelayed(msg, 60000L);
        } else if (this.postDialState == Connection.PostDialState.STARTED && s != Connection.PostDialState.STARTED) {
            this.h.removeMessages(4);
            this.releaseWakeLock();
        }
        this.postDialState = s;
    }

    private void createWakeLock(Context context) {
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mPartialWakeLock = pm.newWakeLock(1, LOG_TAG);
    }

    private void acquireWakeLock() {
        this.log("acquireWakeLock");
        this.mPartialWakeLock.acquire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWakeLock() {
        PowerManager.WakeLock wakeLock = this.mPartialWakeLock;
        synchronized (wakeLock) {
            if (this.mPartialWakeLock.isHeld()) {
                this.log("releaseWakeLock");
                this.mPartialWakeLock.release();
            }
        }
    }

    private void log(String msg) {
        Log.d(LOG_TAG, "[GSMConn] " + msg);
    }

    public int getNumberPresentation() {
        return this.numberPresentation;
    }

    public UUSInfo getUUSInfo() {
        return this.uusInfo;
    }

    class MyHandler
    extends Handler {
        MyHandler(Looper l) {
            super(l);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: 
                case 2: 
                case 3: {
                    GsmConnection.this.processNextPostDialChar();
                    break;
                }
                case 4: {
                    GsmConnection.this.releaseWakeLock();
                }
            }
        }
    }
}

