/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.SystemClock;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CDMAPhone;
import com.android.internal.telephony.cdma.CdmaCall;
import com.android.internal.telephony.cdma.CdmaCallTracker;
import com.android.internal.telephony.cdma.CdmaCallWaitingNotification;

public class CdmaConnection
extends Connection {
    static final String LOG_TAG = "CDMA";
    CdmaCallTracker owner;
    CdmaCall parent;
    String address;
    String dialString;
    String postDialString;
    boolean isIncoming;
    boolean disconnected;
    String cnapName;
    int index;
    long createTime;
    long connectTime;
    long disconnectTime;
    long connectTimeReal;
    long duration;
    long holdingStartTime;
    int nextPostDialChar;
    Connection.DisconnectCause cause = Connection.DisconnectCause.NOT_DISCONNECTED;
    Connection.PostDialState postDialState = Connection.PostDialState.NOT_STARTED;
    int numberPresentation = Connection.PRESENTATION_ALLOWED;
    int cnapNamePresentation = Connection.PRESENTATION_ALLOWED;
    Handler h;
    private PowerManager.WakeLock mPartialWakeLock;
    static final int EVENT_DTMF_DONE = 1;
    static final int EVENT_PAUSE_DONE = 2;
    static final int EVENT_NEXT_POST_DIAL = 3;
    static final int EVENT_WAKE_LOCK_TIMEOUT = 4;
    static final int WAKE_LOCK_TIMEOUT_MILLIS = 60000;
    static final int PAUSE_DELAY_MILLIS = 2000;

    CdmaConnection(Context context, DriverCall dc, CdmaCallTracker ct, int index) {
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.owner = ct;
        this.h = new MyHandler(this.owner.getLooper());
        this.address = dc.number;
        this.isIncoming = dc.isMT;
        this.createTime = System.currentTimeMillis();
        this.cnapName = dc.name;
        this.cnapNamePresentation = dc.namePresentation;
        this.numberPresentation = dc.numberPresentation;
        this.index = index;
        this.parent = this.parentFromDCState(dc.state);
        this.parent.attach(this, dc);
    }

    CdmaConnection(Context context, String dialString, CdmaCallTracker ct, CdmaCall parent) {
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.owner = ct;
        this.h = new MyHandler(this.owner.getLooper());
        this.dialString = dialString;
        Log.d(LOG_TAG, "[CDMAConn] CdmaConnection: dialString=" + dialString);
        dialString = CdmaConnection.formatDialString(dialString);
        Log.d(LOG_TAG, "[CDMAConn] CdmaConnection:formated dialString=" + dialString);
        this.address = PhoneNumberUtils.extractNetworkPortionAlt(dialString);
        this.postDialString = PhoneNumberUtils.extractPostDialPortion(dialString);
        this.index = -1;
        this.isIncoming = false;
        this.cnapName = null;
        this.cnapNamePresentation = Connection.PRESENTATION_ALLOWED;
        this.numberPresentation = Connection.PRESENTATION_ALLOWED;
        this.createTime = System.currentTimeMillis();
        if (parent != null) {
            this.parent = parent;
            if (parent.state == Call.State.ACTIVE) {
                parent.attachFake(this, Call.State.ACTIVE);
            } else {
                parent.attachFake(this, Call.State.DIALING);
            }
        }
    }

    CdmaConnection(Context context, CdmaCallWaitingNotification cw, CdmaCallTracker ct, CdmaCall parent) {
        this.createWakeLock(context);
        this.acquireWakeLock();
        this.owner = ct;
        this.h = new MyHandler(this.owner.getLooper());
        this.address = cw.number;
        this.numberPresentation = cw.numberPresentation;
        this.cnapName = cw.name;
        this.cnapNamePresentation = cw.namePresentation;
        this.index = -1;
        this.isIncoming = true;
        this.createTime = System.currentTimeMillis();
        this.connectTime = 0L;
        this.parent = parent;
        parent.attachFake(this, Call.State.WAITING);
    }

    public void dispose() {
    }

    static boolean equalsHandlesNulls(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    boolean compareTo(DriverCall c) {
        if (!this.isIncoming && !c.isMT) {
            return true;
        }
        String cAddress = PhoneNumberUtils.stringFromStringAndTOA(c.number, c.TOA);
        return this.isIncoming == c.isMT && CdmaConnection.equalsHandlesNulls(this.address, cAddress);
    }

    public String getOrigDialString() {
        return this.dialString;
    }

    public String getAddress() {
        return this.address;
    }

    public String getCnapName() {
        return this.cnapName;
    }

    public int getCnapNamePresentation() {
        return this.cnapNamePresentation;
    }

    public CdmaCall getCall() {
        return this.parent;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public long getDisconnectTime() {
        return this.disconnectTime;
    }

    public long getDurationMillis() {
        if (this.connectTimeReal == 0L) {
            return 0L;
        }
        if (this.duration == 0L) {
            return SystemClock.elapsedRealtime() - this.connectTimeReal;
        }
        return this.duration;
    }

    public long getHoldDurationMillis() {
        if (this.getState() != Call.State.HOLDING) {
            return 0L;
        }
        return SystemClock.elapsedRealtime() - this.holdingStartTime;
    }

    public Connection.DisconnectCause getDisconnectCause() {
        return this.cause;
    }

    public boolean isIncoming() {
        return this.isIncoming;
    }

    public Call.State getState() {
        if (this.disconnected) {
            return Call.State.DISCONNECTED;
        }
        return super.getState();
    }

    public void hangup() throws CallStateException {
        if (this.disconnected) {
            throw new CallStateException("disconnected");
        }
        this.owner.hangup(this);
    }

    public void separate() throws CallStateException {
        if (this.disconnected) {
            throw new CallStateException("disconnected");
        }
        this.owner.separate(this);
    }

    public Connection.PostDialState getPostDialState() {
        return this.postDialState;
    }

    public void proceedAfterWaitChar() {
        if (this.postDialState != Connection.PostDialState.WAIT) {
            Log.w(LOG_TAG, "CdmaConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WAIT but was " + (Object)((Object)this.postDialState));
            return;
        }
        this.setPostDialState(Connection.PostDialState.STARTED);
        this.processNextPostDialChar();
    }

    public void proceedAfterWildChar(String str) {
        if (this.postDialState != Connection.PostDialState.WILD) {
            Log.w(LOG_TAG, "CdmaConnection.proceedAfterWaitChar(): Expected getPostDialState() to be WILD but was " + (Object)((Object)this.postDialState));
            return;
        }
        this.setPostDialState(Connection.PostDialState.STARTED);
        StringBuilder buf = new StringBuilder(str);
        buf.append(this.postDialString.substring(this.nextPostDialChar));
        this.postDialString = buf.toString();
        this.nextPostDialChar = 0;
        this.log("proceedAfterWildChar: new postDialString is " + this.postDialString);
        this.processNextPostDialChar();
    }

    public void cancelPostDial() {
        this.setPostDialState(Connection.PostDialState.CANCELLED);
    }

    void onHangupLocal() {
        this.cause = Connection.DisconnectCause.LOCAL;
    }

    Connection.DisconnectCause disconnectCauseFromCode(int causeCode) {
        switch (causeCode) {
            case 17: {
                return Connection.DisconnectCause.BUSY;
            }
            case 34: {
                return Connection.DisconnectCause.CONGESTION;
            }
            case 68: {
                return Connection.DisconnectCause.LIMIT_EXCEEDED;
            }
            case 240: {
                return Connection.DisconnectCause.CALL_BARRED;
            }
            case 241: {
                return Connection.DisconnectCause.FDN_BLOCKED;
            }
            case 1000: {
                return Connection.DisconnectCause.CDMA_LOCKED_UNTIL_POWER_CYCLE;
            }
            case 1001: {
                return Connection.DisconnectCause.CDMA_DROP;
            }
            case 1002: {
                return Connection.DisconnectCause.CDMA_INTERCEPT;
            }
            case 1003: {
                return Connection.DisconnectCause.CDMA_REORDER;
            }
            case 1004: {
                return Connection.DisconnectCause.CDMA_SO_REJECT;
            }
            case 1005: {
                return Connection.DisconnectCause.CDMA_RETRY_ORDER;
            }
            case 1006: {
                return Connection.DisconnectCause.CDMA_ACCESS_FAILURE;
            }
            case 1007: {
                return Connection.DisconnectCause.CDMA_PREEMPTED;
            }
            case 1008: {
                return Connection.DisconnectCause.CDMA_NOT_EMERGENCY;
            }
            case 1009: {
                return Connection.DisconnectCause.CDMA_ACCESS_BLOCKED;
            }
        }
        CDMAPhone phone = this.owner.phone;
        int serviceState = phone.getServiceState().getState();
        if (serviceState == 3) {
            return Connection.DisconnectCause.POWER_OFF;
        }
        if (serviceState == 1 || serviceState == 2) {
            return Connection.DisconnectCause.OUT_OF_SERVICE;
        }
        if (phone.mCM.getRadioState() != CommandsInterface.RadioState.NV_READY && phone.getIccCard().getState() != IccCard.State.READY) {
            return Connection.DisconnectCause.ICC_ERROR;
        }
        if (causeCode == 16) {
            return Connection.DisconnectCause.NORMAL;
        }
        return Connection.DisconnectCause.ERROR_UNSPECIFIED;
    }

    void onRemoteDisconnect(int causeCode) {
        this.onDisconnect(this.disconnectCauseFromCode(causeCode));
    }

    void onDisconnect(Connection.DisconnectCause cause) {
        this.cause = cause;
        if (!this.disconnected) {
            this.doDisconnect();
            Log.d(LOG_TAG, "[CDMAConn] onDisconnect: cause=" + (Object)((Object)cause));
            this.owner.phone.notifyDisconnect(this);
            if (this.parent != null) {
                this.parent.connectionDisconnected(this);
            }
        }
        this.releaseWakeLock();
    }

    void onLocalDisconnect() {
        if (!this.disconnected) {
            this.doDisconnect();
            Log.d(LOG_TAG, "[CDMAConn] onLoalDisconnect");
            if (this.parent != null) {
                this.parent.detach(this);
            }
        }
        this.releaseWakeLock();
    }

    boolean update(DriverCall dc) {
        boolean changed = false;
        boolean wasConnectingInOrOut = this.isConnectingInOrOut();
        boolean wasHolding = this.getState() == Call.State.HOLDING;
        CdmaCall newParent = this.parentFromDCState(dc.state);
        this.log("parent= " + this.parent + ", newParent= " + newParent);
        if (!CdmaConnection.equalsHandlesNulls(this.address, dc.number)) {
            this.log("update: phone # changed!");
            this.address = dc.number;
            changed = true;
        }
        if (TextUtils.isEmpty(dc.name)) {
            if (!TextUtils.isEmpty(this.cnapName)) {
                changed = true;
                this.cnapName = "";
            }
        } else if (!dc.name.equals(this.cnapName)) {
            changed = true;
            this.cnapName = dc.name;
        }
        this.log("--dssds----" + this.cnapName);
        this.cnapNamePresentation = dc.namePresentation;
        this.numberPresentation = dc.numberPresentation;
        if (newParent != this.parent) {
            if (this.parent != null) {
                this.parent.detach(this);
            }
            newParent.attach(this, dc);
            this.parent = newParent;
            changed = true;
        } else {
            boolean parentStateChange = this.parent.update(this, dc);
            changed = changed || parentStateChange;
        }
        this.log("Update, wasConnectingInOrOut=" + wasConnectingInOrOut + ", wasHolding=" + wasHolding + ", isConnectingInOrOut=" + this.isConnectingInOrOut() + ", changed=" + changed);
        if (wasConnectingInOrOut && !this.isConnectingInOrOut()) {
            this.onConnectedInOrOut();
        }
        if (changed && !wasHolding && this.getState() == Call.State.HOLDING) {
            this.onStartedHolding();
        }
        return changed;
    }

    void fakeHoldBeforeDial() {
        if (this.parent != null) {
            this.parent.detach(this);
        }
        this.parent = this.owner.backgroundCall;
        this.parent.attachFake(this, Call.State.HOLDING);
        this.onStartedHolding();
    }

    int getCDMAIndex() throws CallStateException {
        if (this.index >= 0) {
            return this.index + 1;
        }
        throw new CallStateException("CDMA connection index not assigned");
    }

    void onConnectedInOrOut() {
        this.connectTime = System.currentTimeMillis();
        this.connectTimeReal = SystemClock.elapsedRealtime();
        this.duration = 0L;
        this.log("onConnectedInOrOut: connectTime=" + this.connectTime);
        if (!this.isIncoming) {
            this.processNextPostDialChar();
        } else {
            this.releaseWakeLock();
        }
    }

    private void doDisconnect() {
        this.index = -1;
        this.disconnectTime = System.currentTimeMillis();
        this.duration = SystemClock.elapsedRealtime() - this.connectTimeReal;
        this.disconnected = true;
    }

    private void onStartedHolding() {
        this.holdingStartTime = SystemClock.elapsedRealtime();
    }

    private boolean processPostDialChar(char c) {
        if (PhoneNumberUtils.is12Key(c)) {
            this.owner.cm.sendDtmf(c, this.h.obtainMessage(1));
        } else if (c == ',') {
            this.setPostDialState(Connection.PostDialState.PAUSE);
            this.h.sendMessageDelayed(this.h.obtainMessage(2), 2000L);
        } else if (c == ';') {
            this.setPostDialState(Connection.PostDialState.WAIT);
        } else if (c == 'N') {
            this.setPostDialState(Connection.PostDialState.WILD);
        } else {
            return false;
        }
        return true;
    }

    public String getRemainingPostDialString() {
        if (this.postDialState == Connection.PostDialState.CANCELLED || this.postDialState == Connection.PostDialState.COMPLETE || this.postDialString == null || this.postDialString.length() <= this.nextPostDialChar) {
            return "";
        }
        String subStr = this.postDialString.substring(this.nextPostDialChar);
        if (subStr != null) {
            int wIndex = subStr.indexOf(59);
            int pIndex = subStr.indexOf(44);
            if (wIndex > 0 && (wIndex < pIndex || pIndex <= 0)) {
                subStr = subStr.substring(0, wIndex);
            } else if (pIndex > 0) {
                subStr = subStr.substring(0, pIndex);
            }
        }
        return subStr;
    }

    public void updateParent(CdmaCall oldParent, CdmaCall newParent) {
        if (newParent != oldParent) {
            if (oldParent != null) {
                oldParent.detach(this);
            }
            newParent.attachFake(this, Call.State.ACTIVE);
            this.parent = newParent;
        }
    }

    protected void finalize() {
        if (this.mPartialWakeLock.isHeld()) {
            Log.e(LOG_TAG, "[CdmaConn] UNEXPECTED; mPartialWakeLock is held when finalizing.");
        }
        this.releaseWakeLock();
    }

    void processNextPostDialChar() {
        Message notifyMessage;
        char c = '\u0000';
        if (this.postDialState == Connection.PostDialState.CANCELLED) {
            this.releaseWakeLock();
            return;
        }
        if (this.postDialString == null || this.postDialString.length() <= this.nextPostDialChar) {
            this.setPostDialState(Connection.PostDialState.COMPLETE);
            this.releaseWakeLock();
            c = '\u0000';
        } else {
            this.setPostDialState(Connection.PostDialState.STARTED);
            c = this.postDialString.charAt(this.nextPostDialChar++);
            boolean isValid = this.processPostDialChar(c);
            if (!isValid) {
                this.h.obtainMessage(3).sendToTarget();
                Log.e(LOG_TAG, "processNextPostDialChar: c=" + c + " isn't valid!");
                return;
            }
        }
        Registrant postDialHandler = this.owner.phone.mPostDialHandler;
        if (postDialHandler != null && (notifyMessage = postDialHandler.messageForRegistrant()) != null) {
            Connection.PostDialState state = this.postDialState;
            AsyncResult ar = AsyncResult.forMessage(notifyMessage);
            ar.result = this;
            ar.userObj = state;
            notifyMessage.arg1 = c;
            notifyMessage.sendToTarget();
        }
    }

    private boolean isConnectingInOrOut() {
        return this.parent == null || this.parent == this.owner.ringingCall || this.parent.state == Call.State.DIALING || this.parent.state == Call.State.ALERTING;
    }

    private CdmaCall parentFromDCState(DriverCall.State state) {
        switch (state) {
            case ACTIVE: 
            case DIALING: 
            case ALERTING: {
                return this.owner.foregroundCall;
            }
            case HOLDING: {
                return this.owner.backgroundCall;
            }
            case INCOMING: 
            case WAITING: {
                return this.owner.ringingCall;
            }
        }
        throw new RuntimeException("illegal call state: " + (Object)((Object)state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPostDialState(Connection.PostDialState s) {
        if (s == Connection.PostDialState.STARTED || s == Connection.PostDialState.PAUSE) {
            PowerManager.WakeLock wakeLock = this.mPartialWakeLock;
            synchronized (wakeLock) {
                if (this.mPartialWakeLock.isHeld()) {
                    this.h.removeMessages(4);
                } else {
                    this.acquireWakeLock();
                }
                Message msg = this.h.obtainMessage(4);
                this.h.sendMessageDelayed(msg, 60000L);
            }
        } else {
            this.h.removeMessages(4);
            this.releaseWakeLock();
        }
        this.postDialState = s;
    }

    private void createWakeLock(Context context) {
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mPartialWakeLock = pm.newWakeLock(1, LOG_TAG);
    }

    private void acquireWakeLock() {
        this.log("acquireWakeLock");
        this.mPartialWakeLock.acquire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWakeLock() {
        PowerManager.WakeLock wakeLock = this.mPartialWakeLock;
        synchronized (wakeLock) {
            if (this.mPartialWakeLock.isHeld()) {
                this.log("releaseWakeLock");
                this.mPartialWakeLock.release();
            }
        }
    }

    private static boolean isPause(char c) {
        return c == ',';
    }

    private static boolean isWait(char c) {
        return c == ';';
    }

    private static int findNextPCharOrNonPOrNonWCharIndex(String phoneNumber, int currIndex) {
        int index;
        boolean wMatched = CdmaConnection.isWait(phoneNumber.charAt(currIndex));
        int length = phoneNumber.length();
        for (index = currIndex + 1; index < length; ++index) {
            char cNext = phoneNumber.charAt(index);
            if (CdmaConnection.isWait(cNext)) {
                wMatched = true;
            }
            if (!CdmaConnection.isWait(cNext) && !CdmaConnection.isPause(cNext)) break;
        }
        if (index < length && index > currIndex + 1 && !wMatched && CdmaConnection.isPause(phoneNumber.charAt(currIndex))) {
            return currIndex + 1;
        }
        return index;
    }

    private static char findPOrWCharToAppend(String phoneNumber, int currPwIndex, int nextNonPwCharIndex) {
        char ret;
        char c = phoneNumber.charAt(currPwIndex);
        char c2 = ret = CdmaConnection.isPause(c) ? (char)',' : ';';
        if (nextNonPwCharIndex > currPwIndex + 1) {
            ret = ';';
        }
        return ret;
    }

    public static String formatDialString(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        int length = phoneNumber.length();
        StringBuilder ret = new StringBuilder();
        for (int currIndex = 0; currIndex < length; ++currIndex) {
            char c = phoneNumber.charAt(currIndex);
            if (CdmaConnection.isPause(c) || CdmaConnection.isWait(c)) {
                if (currIndex >= length - 1) continue;
                int nextIndex = CdmaConnection.findNextPCharOrNonPOrNonWCharIndex(phoneNumber, currIndex);
                if (nextIndex < length) {
                    char pC = CdmaConnection.findPOrWCharToAppend(phoneNumber, currIndex, nextIndex);
                    ret.append(pC);
                    if (nextIndex <= currIndex + 1) continue;
                    currIndex = nextIndex - 1;
                    continue;
                }
                if (nextIndex != length) continue;
                currIndex = length - 1;
                continue;
            }
            ret.append(c);
        }
        return PhoneNumberUtils.cdmaCheckAndProcessPlusCode(ret.toString());
    }

    private void log(String msg) {
        Log.d(LOG_TAG, "[CDMAConn] " + msg);
    }

    public int getNumberPresentation() {
        return this.numberPresentation;
    }

    public UUSInfo getUUSInfo() {
        return null;
    }

    class MyHandler
    extends Handler {
        MyHandler(Looper l) {
            super(l);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: 
                case 2: 
                case 3: {
                    CdmaConnection.this.processNextPostDialChar();
                    break;
                }
                case 4: {
                    CdmaConnection.this.releaseWakeLock();
                }
            }
        }
    }
}

