/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.nfc;

import android.nfc.ErrorCodes;
import android.nfc.IP2pTarget;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.nfc.NfcException;
import com.android.internal.nfc.P2pDevice;
import java.io.IOException;

public class P2pTarget
extends P2pDevice {
    private static final String TAG = "P2pTarget";
    private final IP2pTarget mService;
    private final boolean isClosed = false;
    private boolean isConnected = false;

    public void checkState() throws NfcException {
    }

    P2pTarget(IP2pTarget service, int handle) {
        this.mService = service;
        this.mHandle = handle;
    }

    public void connect() throws NfcException {
        this.checkState();
        if (this.isConnected) {
            throw new NfcException("Already connected");
        }
        try {
            int result = this.mService.connect(this.mHandle);
            if (ErrorCodes.isError(result) && result == -1) {
                throw new NfcException("Failed to connect");
            }
            this.isConnected = true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in connect(): ", e);
        }
    }

    public void disconnect() throws NfcException {
        this.checkState();
        try {
            this.mService.disconnect(this.mHandle);
            this.isConnected = true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in disconnect(): ", e);
        }
    }

    public byte[] transceive(byte[] data) throws IOException, NfcException {
        this.checkState();
        try {
            byte[] response = this.mService.transceive(this.mHandle, data);
            if (response == null) {
                throw new IOException("Transceive failed");
            }
            return response;
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in transceive(): ", e);
            return null;
        }
    }

    public byte[] getGeneralBytes() throws IOException {
        try {
            if (this.isConnected) {
                return this.mService.getGeneralBytes(this.mHandle);
            }
            throw new IOException("Target not in connected state");
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in getGeneralBytes(): ", e);
            return null;
        }
    }

    public int getMode() {
        return 0;
    }
}

